/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.android.builder.core.VariantConfiguration;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.jayway.maven.plugins.android.AndroidNdk;
import com.jayway.maven.plugins.android.AndroidSdk;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.AaptCommandBuilder;
import com.jayway.maven.plugins.android.common.ArtifactResolverHelper;
import com.jayway.maven.plugins.android.common.DependencyResolver;
import com.jayway.maven.plugins.android.common.DeviceHelper;
import com.jayway.maven.plugins.android.common.MavenToPlexusLogAdapter;
import com.jayway.maven.plugins.android.common.NativeHelper;
import com.jayway.maven.plugins.android.common.UnpackedLibHelper;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.configuration.Ndk;
import com.jayway.maven.plugins.android.configuration.Sdk;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.xml.DocumentContainer;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;

public abstract class AbstractAndroidMojo
extends AbstractMojo {
    public static final List<String> SUPPORTED_PACKAGING_TYPES = new ArrayList<String>();
    private static final long ADB_TIMEOUT_MS = 60000L;
    public static final String ENV_ANDROID_NDK_HOME = "ANDROID_NDK_HOME";
    @ConfigPojo(prefix="ndk")
    @Parameter
    private Ndk ndk;
    @Component
    protected MavenProject project;
    @Component
    protected MavenSession session;
    @Component
    protected MojoExecution execution;
    @Parameter(defaultValue="${project.build.sourceDirectory}", readonly=true)
    protected File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected File targetDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    protected File projectOutputDirectory;
    @Parameter(defaultValue="${project.build.resources}", readonly=true)
    protected List<Resource> resources;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    protected String finalName;
    @Parameter(defaultValue="${project.basedir}/src/main/res")
    protected File resourceDirectory;
    @Parameter(property="android.genDirectory", defaultValue="${project.build.directory}/generated-sources/r")
    protected File genDirectory;
    @Parameter(property="android.nativeLibrariesDirectory", defaultValue="${project.basedir}/src/main/libs")
    protected File nativeLibrariesDirectory;
    @Parameter(defaultValue="${project.build.directory}/ndk-libs", readonly=true)
    protected File ndkOutputDirectory;
    @Parameter(defaultValue="${project.basedir}/res-overlay")
    protected File resourceOverlayDirectory;
    @Parameter
    protected File[] resourceOverlayDirectories;
    @Parameter(defaultValue="${project.basedir}/src/main/assets")
    protected File assetsDirectory;
    @Parameter(property="source.manifestFile")
    protected File sourceManifestFile;
    @Parameter(property="android.manifestFile", defaultValue="${project.basedir}/src/main/AndroidManifest.xml")
    protected File androidManifestFile;
    @Parameter(property="android.renameManifestPackage")
    protected String renameManifestPackage;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/extracted-dependencies", readonly=true)
    protected File extractedDependenciesDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/extracted-dependencies/src/main/java", readonly=true)
    protected File extractedDependenciesJavaSources;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/extracted-dependencies/src/main/resources", readonly=true)
    protected File extractedDependenciesJavaResources;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/combined-assets", readonly=true)
    protected File combinedAssets;
    @Parameter(defaultValue="false")
    private boolean includeLibsJarsFromApklib;
    @Parameter(defaultValue="false")
    private boolean includeLibsJarsFromAar;
    @Parameter(property="android.device")
    protected String device;
    @Parameter(property="android.devices")
    protected String[] devices;
    @Parameter(property="android.deviceThreads")
    protected int deviceThreads;
    @Parameter(property="android.ips")
    protected String[] ips;
    @Parameter(property="android.configurations")
    protected String configurations;
    @Parameter(property="android.aaptExtraArgs")
    protected String[] aaptExtraArgs;
    @Parameter(property="android.aaptVerbose")
    protected boolean aaptVerbose;
    @Parameter(property="android.proguardFile")
    protected File proguardFile;
    @Parameter(property="android.generateApk", defaultValue="true")
    protected boolean generateApk;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactHandler artifactHandler;
    @Parameter(property="android.customPackage")
    protected String customPackage;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter
    private Sdk sdk;
    @Parameter(property="android.sdk.path", readonly=true)
    private File sdkPath;
    @Parameter(defaultValue="${env.ANDROID_HOME}", readonly=true)
    private String envAndroidHome;
    public static final String ENV_ANDROID_HOME = "ANDROID_HOME";
    @Parameter(property="android.sdk.platform", readonly=true)
    private String sdkPlatform;
    @Parameter(property="android.undeployBeforeDeploy", defaultValue="false")
    protected boolean undeployBeforeDeploy;
    @Parameter(property="android.attachJar", defaultValue="true")
    protected boolean attachJar;
    @Parameter(property="android.attachSources", defaultValue="false")
    protected boolean attachSources;
    @Parameter(property="android.ndk.path", readonly=true)
    private File ndkPath;
    @Parameter(property="android.release", defaultValue="false")
    protected boolean release;
    @Parameter(property="android.adb.connectionTimeout", defaultValue="5000")
    protected int adbConnectionTimeout;
    private UnpackedLibHelper unpackedLibHelper;
    private ArtifactResolverHelper artifactResolverHelper;
    private NativeHelper nativeHelper;
    private static final Object ADB_LOCK;
    private static boolean adbInitialized;
    @Component(hint="default")
    protected DependencyGraphBuilder dependencyGraphBuilder;

    protected final DependencyResolver getDependencyResolver() {
        return new DependencyResolver(new MavenToPlexusLogAdapter(this.getLog()), this.dependencyGraphBuilder);
    }

    protected Set<Artifact> getRelevantCompileArtifacts() {
        List allArtifacts = this.project.getCompileArtifacts();
        return this.getArtifactResolverHelper().getFilteredArtifacts(allArtifacts, new String[0]);
    }

    protected Set<Artifact> getDirectDependencyArtifacts() {
        Set allArtifacts = this.project.getDependencyArtifacts();
        return this.getArtifactResolverHelper().getFilteredArtifacts(allArtifacts, new String[0]);
    }

    protected Set<Artifact> getTransitiveDependencyArtifacts(String ... types) {
        return this.getArtifactResolverHelper().getFilteredArtifacts(this.project.getArtifacts(), types);
    }

    protected Set<Artifact> getTransitiveDependencyArtifacts(List<String> filteredScopes, String ... types) {
        return this.getArtifactResolverHelper().getFilteredArtifacts(filteredScopes, this.project.getArtifacts(), types);
    }

    protected File resolveArtifactToFile(Artifact artifact) throws MojoExecutionException {
        return this.getArtifactResolverHelper().resolveArtifactToFile(artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AndroidDebugBridge initAndroidDebugBridge() throws MojoExecutionException {
        Object object = ADB_LOCK;
        synchronized (object) {
            if (!adbInitialized) {
                DdmPreferences.setTimeOut((int)this.adbConnectionTimeout);
                AndroidDebugBridge.init((boolean)false);
                adbInitialized = true;
            }
            AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.createBridge((String)this.getAndroidSdk().getAdbPath(), (boolean)false);
            this.waitUntilConnected(androidDebugBridge);
            return androidDebugBridge;
        }
    }

    private void waitUntilConnected(AndroidDebugBridge adb) {
        int connectionWaitTime = 50;
        for (int trials = 10; trials > 0; --trials) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (adb.isConnected()) break;
        }
    }

    protected void waitForInitialDeviceList(AndroidDebugBridge androidDebugBridge) throws MojoExecutionException {
        if (!androidDebugBridge.hasInitialDeviceList()) {
            this.getLog().info((CharSequence)"Waiting for initial device list from the Android Debug Bridge");
            long limitTime = System.currentTimeMillis() + 60000L;
            while (!androidDebugBridge.hasInitialDeviceList() && System.currentTimeMillis() < limitTime) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new MojoExecutionException("Interrupted waiting for initial device list from Android Debug Bridge");
                }
            }
            if (!androidDebugBridge.hasInitialDeviceList()) {
                this.getLog().error((CharSequence)"Did not receive initial device list from the Android Debug Bridge.");
            }
        }
    }

    protected void deployApk(final File apkFile) throws MojoExecutionException, MojoFailureException {
        if (this.undeployBeforeDeploy) {
            this.undeployApk(apkFile);
        }
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException {
                String deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
                try {
                    String result = device.installPackage(apkFile.getAbsolutePath(), true, new String[0]);
                    if (result != null) {
                        throw new MojoExecutionException(deviceLogLinePrefix + "Install of " + apkFile.getAbsolutePath() + " failed - [" + result + "]");
                    }
                    AbstractAndroidMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Successfully installed " + apkFile.getAbsolutePath()));
                    AbstractAndroidMojo.this.getLog().debug((CharSequence)(" to " + DeviceHelper.getDescriptiveName(device)));
                }
                catch (InstallException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "Install of " + apkFile.getAbsolutePath() + " failed.", (Exception)((Object)e));
                }
            }
        });
    }

    protected void deployDependencies() throws MojoExecutionException, MojoFailureException {
        Set directDependentArtifacts = this.project.getDependencyArtifacts();
        if (directDependentArtifacts != null) {
            for (Artifact artifact : directDependentArtifacts) {
                String type = artifact.getType();
                if (!type.equals("apk")) continue;
                this.getLog().debug((CharSequence)("Detected apk dependency " + artifact + ". Will resolve and deploy to device..."));
                File targetApkFile = this.resolveArtifactToFile(artifact);
                this.getLog().debug((CharSequence)("Deploying " + targetApkFile + " to device..."));
                this.deployApk(targetApkFile);
            }
        }
    }

    protected void deployBuiltApk() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("apk")) {
            File apkFile = new File(this.targetDirectory, this.finalName + "." + "apk");
            this.deployApk(apkFile);
        } else {
            this.getLog().info((CharSequence)"Project packaging is not apk, skipping deployment.");
        }
    }

    protected void doWithDevices(final DeviceCallback deviceCallback) throws MojoExecutionException, MojoFailureException {
        boolean shouldRunOnAllDevices;
        AndroidDebugBridge androidDebugBridge = this.initAndroidDebugBridge();
        if (!androidDebugBridge.isConnected()) {
            throw new MojoExecutionException("Android Debug Bridge is not connected.");
        }
        this.waitForInitialDeviceList(androidDebugBridge);
        List<IDevice> devices = Arrays.asList(androidDebugBridge.getDevices());
        int numberOfDevices = devices.size();
        this.getLog().debug((CharSequence)("Found " + numberOfDevices + " devices connected with the Android Debug Bridge"));
        if (devices.size() == 0) {
            throw new MojoExecutionException("No online devices attached.");
        }
        int threadCount = this.getDeviceThreads();
        if (this.getDeviceThreads() == 0) {
            this.getLog().info((CharSequence)"android.devicesThreads parameter not set, using a thread for each attached device");
            threadCount = numberOfDevices;
        } else {
            this.getLog().info((CharSequence)("android.devicesThreads parameter set to " + this.getDeviceThreads()));
        }
        boolean bl = shouldRunOnAllDevices = this.getDevices().size() == 0;
        if (shouldRunOnAllDevices) {
            this.getLog().info((CharSequence)"android.devices parameter not set, using all attached devices");
        } else {
            this.getLog().info((CharSequence)("android.devices parameter set to " + this.getDevices().toString()));
        }
        ArrayList<DoThread> doThreads = new ArrayList<DoThread>();
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        for (final IDevice idevice : devices) {
            if (shouldRunOnAllDevices) {
                String deviceType = idevice.isEmulator() ? "Emulator " : "Device ";
                this.getLog().info((CharSequence)(deviceType + DeviceHelper.getDescriptiveName(idevice) + " found."));
            }
            if (!shouldRunOnAllDevices && !this.shouldDoWithThisDevice(idevice)) continue;
            DoThread deviceDoThread = new DoThread(){

                @Override
                public void runDo() throws MojoFailureException, MojoExecutionException {
                    deviceCallback.doWithDevice(idevice);
                }
            };
            doThreads.add(deviceDoThread);
            executor.execute(deviceDoThread);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        this.throwAnyDoThreadErrors(doThreads);
        if (!shouldRunOnAllDevices && doThreads.isEmpty()) {
            throw new MojoExecutionException("No device found for android.device=" + this.getDevices().toString());
        }
    }

    private void throwAnyDoThreadErrors(ArrayList<DoThread> doThreads) throws MojoExecutionException, MojoFailureException {
        for (DoThread deviceDoThread : doThreads) {
            if (deviceDoThread.failure != null) {
                throw deviceDoThread.failure;
            }
            if (deviceDoThread.execution == null) continue;
            throw deviceDoThread.execution;
        }
    }

    private boolean shouldDoWithThisDevice(IDevice idevice) throws MojoExecutionException, MojoFailureException {
        for (String device : this.getDevices()) {
            if ("emulator".equals(device) && idevice.isEmulator()) {
                return true;
            }
            if ("usb".equals(device) && !idevice.isEmulator()) {
                return true;
            }
            if (idevice.isEmulator() && (device.equalsIgnoreCase(idevice.getAvdName()) || device.equalsIgnoreCase(idevice.getSerialNumber()))) {
                return true;
            }
            if (idevice.isEmulator() || !device.equals(idevice.getSerialNumber())) continue;
            return true;
        }
        return false;
    }

    protected boolean undeployApk(File apkFile) throws MojoExecutionException, MojoFailureException {
        String packageName = this.extractPackageNameFromApk(apkFile);
        return this.undeployApk(packageName);
    }

    protected boolean undeployApk(final String packageName) throws MojoExecutionException, MojoFailureException {
        final AtomicBoolean result = new AtomicBoolean(true);
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException {
                String deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
                try {
                    device.uninstallPackage(packageName);
                    AbstractAndroidMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Successfully uninstalled " + packageName));
                    AbstractAndroidMojo.this.getLog().debug((CharSequence)(" from " + DeviceHelper.getDescriptiveName(device)));
                    result.set(true);
                }
                catch (InstallException e) {
                    result.set(false);
                    throw new MojoExecutionException(deviceLogLinePrefix + "Uninstall of " + packageName + " failed.", (Exception)((Object)e));
                }
            }
        });
        return result.get();
    }

    protected String extractPackageNameFromApk(File apkFile) throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        executor.setCaptureStdOut(true);
        executor.setCaptureStdErr(true);
        AaptCommandBuilder.AaptDumpCommandBuilder commandBuilder = AaptCommandBuilder.dump(this.getLog()).xmlTree().setPathToApk(apkFile.getAbsolutePath()).addAssetFile("AndroidManifest.xml");
        this.getLog().info((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + commandBuilder.toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commandBuilder.build(), false);
            String xmlTree = executor.getStandardOut();
            String string = this.extractPackageNameFromAndroidManifestXmlTree(xmlTree);
            return string;
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("Error while trying to figure out package name from inside apk file " + apkFile);
        }
        finally {
            String errout = executor.getStandardError();
            if (errout != null && errout.trim().length() > 0) {
                this.getLog().error((CharSequence)errout);
            }
        }
    }

    protected String extractPackageNameFromAndroidManifestXmlTree(String aaptDumpXmlTree) {
        Scanner scanner = new Scanner(aaptDumpXmlTree);
        scanner.findWithinHorizon("^E: manifest", 0);
        scanner.findWithinHorizon("  A: package=\"", 0);
        String packageName = scanner.next(".*?\"");
        packageName = packageName.substring(0, packageName.length() - 1);
        return packageName;
    }

    protected String extractPackageNameFromAndroidArtifact(Artifact artifact) throws MojoExecutionException {
        File unpackedLibFolder = this.getUnpackedLibFolder(artifact);
        File manifest = new File(unpackedLibFolder, "AndroidManifest.xml");
        if (!manifest.exists()) {
            throw new MojoExecutionException("AndroidManifest.xml file wasn't found in next place: " + unpackedLibFolder);
        }
        return this.extractPackageNameFromAndroidManifest(manifest);
    }

    protected String extractPackageNameFromAndroidManifest(File manifestFile) {
        return VariantConfiguration.getManifestPackage((File)manifestFile);
    }

    protected final String getAndroidManifestPackageName() {
        return this.extractPackageNameFromAndroidManifest(this.androidManifestFile);
    }

    protected String extractInstrumentationRunnerFromAndroidManifest(File manifestFile) throws MojoExecutionException {
        Object instrumentationRunner;
        URL xmlURL;
        try {
            xmlURL = manifestFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error while trying to figure out instrumentation runner from inside AndroidManifest.xml file " + manifestFile, (Exception)e);
        }
        DocumentContainer documentContainer = new DocumentContainer(xmlURL);
        try {
            instrumentationRunner = JXPathContext.newContext((Object)documentContainer).getValue("manifest//instrumentation/@android:name", String.class);
        }
        catch (JXPathNotFoundException e) {
            return null;
        }
        return (String)instrumentationRunner;
    }

    protected final boolean isInstrumentationTest() throws MojoExecutionException {
        return this.extractInstrumentationRunnerFromAndroidManifest(this.androidManifestFile) != null;
    }

    protected AndroidSdk getAndroidSdk() throws MojoExecutionException {
        String chosenSdkPlatform;
        File chosenSdkPath;
        if (this.sdk != null) {
            chosenSdkPath = this.sdk.getPath() != null ? this.sdk.getPath() : (this.sdkPath != null ? this.sdkPath : new File(this.getAndroidHomeOrThrow()));
            chosenSdkPlatform = !StringUtils.isBlank((String)this.sdk.getPlatform()) ? this.sdk.getPlatform() : this.sdkPlatform;
        } else {
            chosenSdkPath = this.sdkPath != null ? this.sdkPath : new File(this.getAndroidHomeOrThrow());
            chosenSdkPlatform = this.sdkPlatform;
        }
        return new AndroidSdk(chosenSdkPath, chosenSdkPlatform);
    }

    private String getAndroidHomeOrThrow() throws MojoExecutionException {
        String androidHome = System.getenv(ENV_ANDROID_HOME);
        if (StringUtils.isBlank((String)androidHome)) {
            throw new MojoExecutionException("No Android SDK path could be found. You may configure it in the plugin configuration section in the pom file using <sdk><path>...</path></sdk> or <properties><android.sdk.path>...</android.sdk.path></properties> or on command-line using -Dandroid.sdk.path=... or by setting environment variable ANDROID_HOME");
        }
        return androidHome;
    }

    protected final File getUnpackedLibsDirectory() {
        return this.getUnpackedLibHelper().getUnpackedLibsFolder();
    }

    public final File getUnpackedLibFolder(Artifact artifact) {
        return this.getUnpackedLibHelper().getUnpackedLibFolder(artifact);
    }

    protected final File getUnpackedAarClassesJar(Artifact artifact) {
        return this.getUnpackedLibHelper().getUnpackedClassesJar(artifact);
    }

    protected final File getUnpackedApkLibSourceFolder(Artifact artifact) {
        return this.getUnpackedLibHelper().getUnpackedApkLibSourceFolder(artifact);
    }

    protected final File getUnpackedLibResourceFolder(Artifact artifact) {
        return this.getUnpackedLibHelper().getUnpackedLibResourceFolder(artifact);
    }

    protected final File getUnpackedLibAssetsFolder(Artifact artifact) {
        return this.getUnpackedLibHelper().getUnpackedLibAssetsFolder(artifact);
    }

    public final File getUnpackedLibNativesFolder(Artifact artifact) {
        return this.getUnpackedLibHelper().getUnpackedLibNativesFolder(artifact);
    }

    public static File getLibraryUnpackDirectory(File unpackedApkLibsDirectory, Artifact artifact) {
        return new File(unpackedApkLibsDirectory.getAbsolutePath(), artifact.getArtifactId());
    }

    protected AndroidNdk getAndroidNdk() throws MojoExecutionException {
        File chosenNdkPath = this.ndkPath != null ? this.ndkPath : (this.ndk != null && this.ndk.getPath() != null ? this.ndk.getPath() : new File(this.getAndroidNdkHomeOrThrow()));
        return new AndroidNdk(chosenNdkPath);
    }

    private String getAndroidNdkHomeOrThrow() throws MojoExecutionException {
        String androidHome = System.getenv(ENV_ANDROID_NDK_HOME);
        if (StringUtils.isBlank((String)androidHome)) {
            throw new MojoExecutionException("No Android NDK path could be found. You may configure it in the pom using <ndk><path>...</path></ndk> or <properties><ndk.path>...</ndk.path></properties> or on command-line using -Dandroid.ndk.path=... or by setting environment variable ANDROID_NDK_HOME");
        }
        return androidHome;
    }

    public File[] getResourceOverlayDirectories() {
        File[] overlayDirectories = this.resourceOverlayDirectories == null || this.resourceOverlayDirectories.length == 0 ? new File[]{this.resourceOverlayDirectory} : this.resourceOverlayDirectories;
        return overlayDirectories;
    }

    private Set<String> getDevices() {
        HashSet<String> list = new HashSet<String>();
        if (StringUtils.isNotBlank((String)this.device)) {
            list.add(this.device);
        }
        list.addAll(Arrays.asList(this.devices));
        list.addAll(Arrays.asList(this.ips));
        return list;
    }

    private int getDeviceThreads() {
        return this.deviceThreads;
    }

    protected final boolean isAPKBuild() {
        return this.getUnpackedLibHelper().isAPKBuild(this.project);
    }

    protected final void copyFolder(File sourceFolder, File targetFolder) throws MojoExecutionException {
        this.copyFolder(sourceFolder, targetFolder, (FileFilter)TrueFileFilter.TRUE);
    }

    private void copyFolder(File sourceFolder, File targetFolder, FileFilter filter) throws MojoExecutionException {
        if (!sourceFolder.exists()) {
            return;
        }
        try {
            this.getLog().debug((CharSequence)("Copying " + sourceFolder + " to " + targetFolder));
            if (!targetFolder.exists() && !targetFolder.mkdirs()) {
                throw new MojoExecutionException("Could not create target directory " + targetFolder);
            }
            FileUtils.copyDirectory((File)sourceFolder, (File)targetFolder, (FileFilter)filter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy source folder to target folder", (Exception)e);
        }
    }

    protected final UnpackedLibHelper getUnpackedLibHelper() {
        if (this.unpackedLibHelper == null) {
            this.unpackedLibHelper = new UnpackedLibHelper(this.getArtifactResolverHelper(), this.project, new MavenToPlexusLogAdapter(this.getLog()));
        }
        return this.unpackedLibHelper;
    }

    protected final ArtifactResolverHelper getArtifactResolverHelper() {
        if (this.artifactResolverHelper == null) {
            this.artifactResolverHelper = new ArtifactResolverHelper(this.artifactResolver, new MavenToPlexusLogAdapter(this.getLog()), this.project.getRemoteArtifactRepositories());
        }
        return this.artifactResolverHelper;
    }

    protected final NativeHelper getNativeHelper() {
        if (this.nativeHelper == null) {
            this.nativeHelper = new NativeHelper(this.project, this.dependencyGraphBuilder, this.getLog());
        }
        return this.nativeHelper;
    }

    static {
        SUPPORTED_PACKAGING_TYPES.add("apk");
        ADB_LOCK = new Object();
        adbInitialized = false;
    }

    private abstract class DoThread
    extends Thread {
        private MojoFailureException failure;
        private MojoExecutionException execution;

        private DoThread() {
        }

        @Override
        public final void run() {
            try {
                this.runDo();
            }
            catch (MojoFailureException e) {
                this.failure = e;
            }
            catch (MojoExecutionException e) {
                this.execution = e;
            }
        }

        protected abstract void runDo() throws MojoFailureException, MojoExecutionException;
    }
}

