/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.asm;

import com.jayway.maven.plugins.android.asm.DescendantFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryWalkListener;
import org.codehaus.plexus.util.DirectoryWalker;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class AndroidTestFinder {
    private static final String[] TEST_PACKAGES = new String[]{"junit/framework/", "android/test/"};

    public static boolean containsAndroidTests(File classesBaseDirectory) throws MojoExecutionException {
        if (classesBaseDirectory == null || !classesBaseDirectory.isDirectory()) {
            throw new IllegalArgumentException("classesBaseDirectory must be a valid directory!");
        }
        List<File> classFiles = AndroidTestFinder.findEligebleClassFiles(classesBaseDirectory);
        DescendantFinder descendantFinder = new DescendantFinder(TEST_PACKAGES);
        for (File classFile : classFiles) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(classFile);
                ClassReader classReader = new ClassReader((InputStream)inputStream);
                classReader.accept((ClassVisitor)descendantFinder, 7);
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Error reading " + classFile + ".\nCould not determine whether it " + "contains tests. Please specify with plugin config parameter " + "<enableIntegrationTest>true|false</enableIntegrationTest>.", (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return descendantFinder.isDescendantFound();
    }

    private static List<File> findEligebleClassFiles(File classesBaseDirectory) {
        final LinkedList<File> classFiles = new LinkedList<File>();
        DirectoryWalker walker = new DirectoryWalker();
        walker.setBaseDir(classesBaseDirectory);
        walker.addSCMExcludes();
        walker.addInclude("**/*.class");
        walker.addDirectoryWalkListener(new DirectoryWalkListener(){

            public void directoryWalkStarting(File basedir) {
            }

            public void directoryWalkStep(int percentage, File file) {
                classFiles.add(file);
            }

            public void directoryWalkFinished() {
            }

            public void debug(String message) {
            }
        });
        walker.scan();
        return classFiles;
    }
}

