/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.common;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.androidpublisher.AndroidPublisher;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AndroidPublisherHelper {
    private static final Log LOG = LogFactory.getLog(AndroidPublisherHelper.class);
    public static final String MIME_TYPE_APK = "application/vnd.android.package-archive";
    public static final String MIME_TYPE_IMAGE = "image/*";
    private static final String SRC_RESOURCES_KEY_P12 = "resources/key.p12";
    private static final String RESOURCES_CLIENT_SECRETS_JSON = "/resources/client_secrets.json";
    private static final String DATA_STORE_SYSTEM_PROPERTY = "user.home";
    private static final String DATA_STORE_FILE = ".store/android_publisher_api";
    private static final File DATA_STORE_DIR = new File(System.getProperty("user.home"), ".store/android_publisher_api");
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static HttpTransport httpTransport;
    private static final String INST_APP_USER_ID = "user";

    private static Credential authorizeWithServiceAccount(String serviceAccountEmail) throws GeneralSecurityException, IOException {
        LOG.info((Object)String.format("Authorizing using Service Account: %s", serviceAccountEmail));
        return AndroidPublisherHelper.authorizeWithServiceAccount(serviceAccountEmail, null);
    }

    private static Credential authorizeWithServiceAccount(String serviceAccountEmail, File pk12File) throws GeneralSecurityException, IOException {
        LOG.info((Object)String.format("Authorizing using Service Account: %s", serviceAccountEmail));
        GoogleCredential credential = new GoogleCredential.Builder().setTransport(httpTransport).setJsonFactory(JSON_FACTORY).setServiceAccountId(serviceAccountEmail).setServiceAccountScopes(Collections.singleton("https://www.googleapis.com/auth/androidpublisher")).setServiceAccountPrivateKeyFromP12File(pk12File == null ? new File(SRC_RESOURCES_KEY_P12) : pk12File).build();
        return credential;
    }

    private static void checkClientSecretsFile(GoogleClientSecrets clientSecrets) {
        if (clientSecrets.getDetails().getClientId().startsWith("[[INSERT") || clientSecrets.getDetails().getClientSecret().startsWith("[[INSERT")) {
            LOG.error((Object)"Enter Client ID and Secret from APIs console into resources/client_secrets.json.");
            System.exit(1);
        }
    }

    public static AndroidPublisher init(String applicationName) throws Exception {
        return AndroidPublisherHelper.init(applicationName, null);
    }

    public static AndroidPublisher init(String applicationName, @Nullable String serviceAccountEmail) throws IOException, GeneralSecurityException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)applicationName) ? 1 : 0) != 0, (Object)"applicationName cannot be null or empty!");
        AndroidPublisherHelper.newTrustedTransport();
        Credential credential = AndroidPublisherHelper.authorizeWithServiceAccount(serviceAccountEmail);
        return new AndroidPublisher.Builder(httpTransport, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
    }

    public static AndroidPublisher init(String applicationName, String serviceAccountEmail, File pk12File) throws IOException, GeneralSecurityException {
        AndroidPublisherHelper.newTrustedTransport();
        Credential credential = AndroidPublisherHelper.authorizeWithServiceAccount(serviceAccountEmail, pk12File);
        return new AndroidPublisher.Builder(httpTransport, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
    }

    private static void newTrustedTransport() throws GeneralSecurityException, IOException {
        if (null == httpTransport) {
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
    }
}

