/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.android.annotations.NonNull;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.AppEdit;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.common.AndroidPublisherHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractPublisherMojo
extends AbstractAndroidMojo {
    private static final String WHATSNEW = "whatsnew.txt";
    @Parameter(property="android.publisher.google.email", required=true)
    private String publisherEmail;
    @Parameter(property="android.publisher.google.p12", required=true)
    private File p12File;
    @Parameter(property="android.publisher.project.name")
    protected String projectName;
    @Parameter(property="android.publisher.listing.directory", defaultValue="${project.basedir}/src/main/play/")
    protected File listingDirectory;
    protected AndroidPublisher.Edits edits;
    protected String editId;
    protected static final String LOCALE_DIR_PATTERN = "^[a-z]{2}(-([A-Z]{2}|419))?";

    protected void initializePublisher(@NonNull String packageName) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Initializing publisher");
        if (this.projectName == null || this.projectName.equals("")) {
            this.projectName = this.session.getCurrentProject().getName();
        }
        try {
            AndroidPublisher publisher = AndroidPublisherHelper.init(this.projectName, this.publisherEmail, this.p12File);
            this.edits = publisher.edits();
            AndroidPublisher.Edits.Insert editRequest = this.edits.insert(packageName, null);
            AppEdit edit = (AppEdit)editRequest.execute();
            this.editId = edit.getId();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(File file, int maxChars) throws IOException {
        String everything;
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            everything = sb.toString();
        }
        finally {
            br.close();
        }
        if (everything.length() > maxChars) {
            String message = "Too many characters in file " + file.getName() + " max allowed is " + maxChars;
            this.getLog().error((CharSequence)message);
            throw new IOException(message);
        }
        return everything;
    }

    public File[] getLocaleDirs() {
        if (!this.listingDirectory.exists()) {
            this.getLog().warn((CharSequence)"Play directory is missing.");
            return null;
        }
        File[] localeDirs = this.listingDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Pattern pattern = Pattern.compile(AbstractPublisherMojo.LOCALE_DIR_PATTERN);
                Matcher matcher = pattern.matcher(name);
                return matcher.matches();
            }
        });
        if (localeDirs == null || localeDirs.length == 0) {
            this.getLog().warn((CharSequence)"No locale directories found.");
            return null;
        }
        return localeDirs;
    }

    public String readFileWithChecks(File dir, String fileName, int maxChars, String errorMessage) throws IOException {
        File file = new File(dir, fileName);
        if (file.exists()) {
            return this.readFile(file, maxChars);
        }
        this.getLog().warn((CharSequence)(errorMessage + " - Filename: " + fileName));
        return null;
    }
}

