/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.common;

import com.google.common.io.PatternFilenameFilter;
import com.jayway.maven.plugins.android.common.ArtifactResolverHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public final class UnpackedLibHelper {
    private final ArtifactResolverHelper artifactResolverHelper;
    private final Logger log;
    private final File unpackedLibsDirectory;

    public UnpackedLibHelper(ArtifactResolverHelper artifactResolverHelper, MavenProject project, Logger log, File unpackedLibsFolder) {
        this.artifactResolverHelper = artifactResolverHelper;
        if (unpackedLibsFolder != null) {
            this.unpackedLibsDirectory = unpackedLibsFolder.isAbsolute() ? unpackedLibsFolder : new File(project.getBasedir(), unpackedLibsFolder.getPath());
        } else {
            File targetFolder = new File(project.getBuild().getDirectory());
            this.unpackedLibsDirectory = new File(targetFolder, "unpacked-libs");
        }
        this.log = log;
    }

    public void extractApklib(Artifact apklibArtifact) throws MojoExecutionException {
        File apkLibFile = this.artifactResolverHelper.resolveArtifactToFile(apklibArtifact);
        if (apkLibFile.isDirectory()) {
            this.log.warn("The apklib artifact points to '" + apkLibFile + "' which is a directory; skipping unpacking it.");
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(apkLibFile){

            protected Logger getLogger() {
                return new ConsoleLogger(UnpackedLibHelper.this.log.getThreshold(), "dependencies-unarchiver");
            }
        };
        File apklibDirectory = this.getUnpackedLibFolder(apklibArtifact);
        apklibDirectory.mkdirs();
        unArchiver.setDestDirectory(apklibDirectory);
        this.log.debug("Extracting APKLIB to " + apklibDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + apklibDirectory + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public void extractAarLib(Artifact aarArtifact) throws MojoExecutionException {
        String[] natives;
        File aarFile = this.artifactResolverHelper.resolveArtifactToFile(aarArtifact);
        if (aarFile.isDirectory()) {
            this.log.warn("The aar artifact points to '" + aarFile + "' which is a directory; skipping unpacking it.");
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(aarFile){

            protected Logger getLogger() {
                return new ConsoleLogger(UnpackedLibHelper.this.log.getThreshold(), "dependencies-unarchiver");
            }
        };
        File aarDirectory = this.getUnpackedLibFolder(aarArtifact);
        aarDirectory.mkdirs();
        unArchiver.setDestDirectory(aarDirectory);
        this.log.debug("Extracting AAR to " + aarDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + aarDirectory.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        File jniFolder = new File(aarDirectory, "jni");
        File libsFolder = new File(aarDirectory, "libs");
        if (!jniFolder.exists() && libsFolder.isDirectory() && libsFolder.exists() && (natives = libsFolder.list((FilenameFilter)new PatternFilenameFilter("^.*(?<!(?i)\\.jar)$"))).length > 0) {
            this.log.debug("Moving AAR native libraries from libs to jni folder");
            for (String nativeLibPath : natives) {
                try {
                    FileUtils.moveToDirectory((File)new File(libsFolder, nativeLibPath), (File)jniFolder, (boolean)true);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not move native libraries from " + libsFolder, (Exception)e);
                }
            }
        }
    }

    public File getArtifactToFile(Artifact artifact) throws MojoExecutionException {
        File artifactFile = this.artifactResolverHelper.resolveArtifactToFile(artifact);
        return artifactFile;
    }

    public File getUnpackedLibsFolder() {
        return this.unpackedLibsDirectory;
    }

    public File getUnpackedLibFolder(Artifact artifact) {
        return new File(this.unpackedLibsDirectory.getAbsolutePath(), this.getShortenedGroupId(artifact.getGroupId()) + "_" + artifact.getArtifactId() + "_" + artifact.getVersion());
    }

    public File getUnpackedClassesJar(Artifact artifact) {
        return new File(this.getUnpackedLibFolder(artifact), "classes.jar");
    }

    public File getUnpackedApkLibSourceFolder(Artifact artifact) {
        return new File(this.getUnpackedLibFolder(artifact), "src");
    }

    public File getUnpackedLibResourceFolder(Artifact artifact) {
        return new File(this.getUnpackedLibFolder(artifact), "res");
    }

    public File getUnpackedLibAssetsFolder(Artifact artifact) {
        return new File(this.getUnpackedLibFolder(artifact), "assets");
    }

    public File getUnpackedLibNativesFolder(Artifact artifact) {
        if ("aar".equals(artifact.getType())) {
            return new File(this.getUnpackedLibFolder(artifact), "jni");
        }
        return new File(this.getUnpackedLibFolder(artifact), "libs");
    }

    public File getJarFileForApk(Artifact artifact) {
        String fileName = artifact.getFile().getName();
        String modifiedFileName = fileName.substring(0, fileName.lastIndexOf(".")) + ".jar";
        return new File(artifact.getFile().getParentFile(), modifiedFileName);
    }

    private String getShortenedGroupId(String groupId) {
        String[] parts = groupId.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part.charAt(0));
        }
        return sb.toString();
    }

    public boolean isAPKBuild(MavenProject project) {
        return "apk".equals(project.getPackaging());
    }
}

