/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase01generatesources;

import com.android.manifmerger.ManifestMerger;
import com.android.manifmerger.MergerLog;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.AaptCommandBuilder;
import com.jayway.maven.plugins.android.common.DependencyResolver;
import com.jayway.maven.plugins.android.common.FileRetriever;
import com.jayway.maven.plugins.android.configuration.BuildConfigConstant;
import com.jayway.maven.plugins.android.phase01generatesources.ConflictingLayout;
import com.jayway.maven.plugins.android.phase01generatesources.ConflictingLayoutDetector;
import com.jayway.maven.plugins.android.phase01generatesources.ResourceClassGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.w3c.dom.Document;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateSourcesMojo
extends AbstractAndroidMojo {
    @Deprecated
    @Parameter(property="android.mergeManifests", defaultValue="false")
    protected boolean mergeManifests;
    @Parameter(defaultValue="true")
    protected boolean warnOnApklibDependencies;
    @Parameter(defaultValue="true")
    private boolean failOnConflictingLayouts;
    @Parameter(defaultValue="true")
    private boolean failOnDuplicatePackages;
    @Parameter(property="android.genDirectoryAidl", defaultValue="${project.build.directory}/generated-sources/aidl")
    protected File genDirectoryAidl;
    @Parameter(property="android.aidlSourceDirectory", defaultValue="${project.basedir}/src/main/aidl")
    protected File aidlSourceDirectory;
    @Parameter(property="android.buildConfigConstants", readonly=true)
    protected BuildConfigConstant[] buildConfigConstants;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(readonly=true, defaultValue="${project.basedir}/AndroidManifest.xml")
    private File androidManifestFilePre4;
    @Parameter(readonly=true, defaultValue="${project.basedir}/res")
    private File resourceDirectoryPre4;
    @Parameter(readonly=true, defaultValue="${project.basedir}/assets")
    private File assetsDirectoryPre4;
    @Parameter(readonly=true, defaultValue="${project.basedir}/libs")
    private File nativeLibrariesDirectoryPre4;
    @Parameter(defaultValue="true")
    private boolean failOnNonStandardStructure;
    protected static final List<String> EXCLUDED_DEPENDENCY_SCOPES_FOR_EXTRACTION = Arrays.asList("system", "import");

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isCurrentProjectAndroid()) {
            return;
        }
        this.validateStandardLocations();
        try {
            this.targetDirectory.mkdirs();
            this.copyManifest();
            if (this.warnOnApklibDependencies) {
                this.checkForApklibDependencies();
            }
            this.extractSourceDependencies();
            this.extractLibraryDependencies();
            this.copyFolder(this.assetsDirectory, this.combinedAssets);
            String[] relativeAidlFileNames1 = this.findRelativeAidlFileNames(this.aidlSourceDirectory);
            String[] relativeAidlFileNames2 = this.findRelativeAidlFileNames(this.extractedDependenciesJavaSources);
            HashMap<String, String[]> relativeApklibAidlFileNames = new HashMap<String, String[]>();
            if (!this.isInstrumentationTest()) {
                for (Artifact artifact : this.getTransitiveDependencyArtifacts("apklib")) {
                    File libSourceFolder = this.getUnpackedApkLibSourceFolder(artifact);
                    String[] apklibAidlFiles = this.findRelativeAidlFileNames(libSourceFolder);
                    relativeApklibAidlFileNames.put(artifact.getId(), apklibAidlFiles);
                }
            }
            this.mergeManifests();
            this.checkPackagesForDuplicates();
            this.checkForConflictingLayouts();
            this.generateR();
            this.generateBuildConfig();
            HashMap<File, String[]> files = new HashMap<File, String[]>();
            files.put(this.aidlSourceDirectory, relativeAidlFileNames1);
            files.put(this.extractedDependenciesJavaSources, relativeAidlFileNames2);
            if (!this.isInstrumentationTest()) {
                for (Artifact artifact : this.getTransitiveDependencyArtifacts("apklib")) {
                    File unpackedLibSourceFolder = this.getUnpackedApkLibSourceFolder(artifact);
                    files.put(unpackedLibSourceFolder, (String[])relativeApklibAidlFileNames.get(artifact.getId()));
                }
            }
            this.generateAidlFiles(files);
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Error when generating sources.", (Throwable)e);
            throw e;
        }
    }

    private void validateStandardLocations() throws MojoExecutionException {
        boolean hasNonStandardStructure = false;
        if (this.androidManifestFilePre4.exists() && !this.androidManifestFilePre4.equals(this.androidManifestFile)) {
            this.getLog().warn((CharSequence)("Non-standard location of AndroidManifest.xml file found, but not configured:\n " + this.androidManifestFilePre4 + "\nMove to the standard location src/main/AndroidManifest.xml\n" + "Or configure androidManifestFile. \n"));
            hasNonStandardStructure = true;
        }
        if (this.resourceDirectoryPre4.exists() && !this.resourceDirectoryPre4.equals(this.resourceDirectory)) {
            this.getLog().warn((CharSequence)("Non-standard location of Android res folder found, but not configured:\n " + this.resourceDirectoryPre4 + "\nMove to the standard location src/main/res/\n" + "Or configure resourceDirectory. \n"));
            hasNonStandardStructure = true;
        }
        if (this.assetsDirectoryPre4.exists() && !this.assetsDirectoryPre4.equals(this.assetsDirectory)) {
            this.getLog().warn((CharSequence)("Non-standard location assets folder found, but not configured:\n " + this.assetsDirectoryPre4 + "\nMove to the standard location src/main/assets/\n" + "Or configure assetsDirectory. \n"));
            hasNonStandardStructure = true;
        }
        if (this.nativeLibrariesDirectoryPre4.exists() && !this.nativeLibrariesDirectoryPre4.equals(this.nativeLibrariesDirectory)) {
            this.getLog().warn((CharSequence)("Non-standard location native libs folder found, but not configured:\n " + this.nativeLibrariesDirectoryPre4 + "\nMove to the standard location src/main/libs/\n" + "Or configure nativeLibrariesDirectory. \n"));
            hasNonStandardStructure = true;
        }
        if (hasNonStandardStructure && this.failOnNonStandardStructure) {
            throw new MojoExecutionException("\n\nFound files or folders in non-standard locations in the project!\n....This might be a side-effect of a migration to Android Maven Plugin 4+.\n....Please observe the warnings for specific files and folders above.\n....Ideally you should restructure your project.\n....Alternatively add explicit configuration overrides for files or folders.\n....Finally you could set failOnNonStandardStructure to false, potentially resulting in other failures.\n\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyManifest() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("copyManifest: " + this.androidManifestFile + " -> " + this.destinationManifestFile));
        if (this.androidManifestFile == null) {
            this.getLog().debug((CharSequence)"Manifest copying disabled. Using default manifest only");
            return;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.androidManifestFile);
            DOMSource source = new DOMSource(doc);
            TransformerFactory xfactory = TransformerFactory.newInstance();
            Transformer xformer = xfactory.newTransformer();
            xformer.setOutputProperty("omit-xml-declaration", "yes");
            FileWriter writer = null;
            try {
                this.destinationManifestFile.getParentFile().mkdirs();
                writer = new FileWriter(this.destinationManifestFile, false);
                if (doc.getXmlEncoding() != null && doc.getXmlVersion() != null) {
                    String xmldecl = String.format("<?xml version=\"%s\" encoding=\"%s\"?>%n", doc.getXmlVersion(), doc.getXmlEncoding());
                    writer.write(xmldecl);
                }
                StreamResult result = new StreamResult(writer);
                xformer.transform(source, result);
                this.getLog().info((CharSequence)("Manifest copied from " + this.androidManifestFile + " to " + this.destinationManifestFile));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error during copyManifest");
            throw new MojoExecutionException("Error during copyManifest", e);
        }
    }

    protected void extractSourceDependencies() throws MojoExecutionException {
        for (Artifact artifact : this.getDirectDependencyArtifacts()) {
            String type = artifact.getType();
            if (!type.equals("apksources")) continue;
            this.getLog().debug((CharSequence)("Detected apksources dependency " + artifact + " with file " + artifact.getFile() + ". Will resolve and extract..."));
            File apksourcesFile = this.resolveArtifactToFile(artifact);
            this.getLog().debug((CharSequence)("Extracting " + apksourcesFile + "..."));
            this.extractApksources(apksourcesFile);
        }
        if (this.extractedDependenciesJavaResources.exists()) {
            this.projectHelper.addResource(this.project, this.extractedDependenciesJavaResources.getAbsolutePath(), null, null);
            this.project.addCompileSourceRoot(this.extractedDependenciesJavaSources.getAbsolutePath());
        }
    }

    @Deprecated
    private void extractApksources(File apksourcesFile) throws MojoExecutionException {
        if (apksourcesFile.isDirectory()) {
            this.getLog().warn((CharSequence)("The apksources artifact points to '" + apksourcesFile + "' which is a directory; skipping unpacking it."));
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(apksourcesFile){

            protected Logger getLogger() {
                return new ConsoleLogger(0, "dependencies-unarchiver");
            }
        };
        this.extractedDependenciesDirectory.mkdirs();
        unArchiver.setDestDirectory(this.extractedDependenciesDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + apksourcesFile.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private void extractLibraryDependencies() throws MojoExecutionException {
        Set<Artifact> artifacts = this.getTransitiveDependencyArtifacts(EXCLUDED_DEPENDENCY_SCOPES_FOR_EXTRACTION, new String[0]);
        this.getLog().info((CharSequence)"Extracting libs");
        boolean instrumentationTest = this.isInstrumentationTest();
        for (Artifact artifact : artifacts) {
            String type = artifact.getType();
            if (type.equals("apklib") && !instrumentationTest) {
                this.getLog().info((CharSequence)("Extracting apklib " + artifact.getArtifactId() + "..."));
                this.extractApklib(artifact);
                continue;
            }
            if (type.equals("aar")) {
                this.getLog().info((CharSequence)("Extracting aar " + artifact.getArtifactId() + "..."));
                this.extractAarLib(artifact);
                continue;
            }
            if (type.equals("apk")) {
                this.getLog().info((CharSequence)("Extracting apk " + artifact.getArtifactId() + "..."));
                this.extractApkClassesJar(artifact);
                continue;
            }
            this.getLog().debug((CharSequence)("Not extracting " + artifact.getArtifactId() + "..."));
        }
    }

    private void extractApklib(Artifact apklibArtifact) throws MojoExecutionException {
        this.getUnpackedLibHelper().extractApklib(apklibArtifact);
        this.copyFolder(this.getUnpackedLibAssetsFolder(apklibArtifact), this.combinedAssets);
        File apklibSourceFolder = this.getUnpackedApkLibSourceFolder(apklibArtifact);
        List<String> resourceExclusions = Arrays.asList("**/*.java", "**/*.aidl");
        this.projectHelper.addResource(this.project, apklibSourceFolder.getAbsolutePath(), null, resourceExclusions);
        this.project.addCompileSourceRoot(apklibSourceFolder.getAbsolutePath());
    }

    private void extractAarLib(Artifact aarArtifact) throws MojoExecutionException {
        this.getUnpackedLibHelper().extractAarLib(aarArtifact);
        if (this.isAPKBuild()) {
            this.copyFolder(this.getUnpackedLibAssetsFolder(aarArtifact), this.combinedAssets);
        }
        if (this.isAPKBuild()) {
            this.getLog().debug((CharSequence)("Not adding AAR resources to resource classpath : " + aarArtifact));
        }
    }

    private void extractApkClassesJar(Artifact artifact) throws MojoExecutionException {
        File apkClassesJar = this.getUnpackedLibHelper().getJarFileForApk(artifact);
        File unpackedClassesJar = this.getUnpackedLibHelper().getUnpackedClassesJar(artifact);
        try {
            FileUtils.copyFile((File)apkClassesJar, (File)unpackedClassesJar);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy APK classes jar " + apkClassesJar + " to " + unpackedClassesJar, (Exception)e);
        }
        this.getLog().debug((CharSequence)("Copied APK classes jar into compile classpath : " + unpackedClassesJar));
    }

    private void checkForApklibDependencies() throws MojoExecutionException {
        boolean isAarBuild = this.project.getPackaging().equals("aar");
        DependencyResolver dependencyResolver = this.getDependencyResolver();
        Set allArtifacts = this.project.getArtifacts();
        Set<Artifact> dependencyArtifacts = this.getArtifactResolverHelper().getFilteredArtifacts(allArtifacts, new String[0]);
        boolean foundApklib = false;
        for (Artifact artifact : dependencyArtifacts) {
            String type = artifact.getType();
            if (type.equals("apklib") && isAarBuild) {
                this.getLog().warn((CharSequence)("Detected APKLIB transitive dependency: " + artifact.getId()));
                foundApklib = true;
                continue;
            }
            if (!type.equals("aar")) continue;
            Set<Artifact> dependencies = dependencyResolver.getLibraryDependenciesFor(this.session, this.repositorySystem, artifact);
            for (Artifact dependency : dependencies) {
                if (!dependency.getType().equals("apklib")) continue;
                this.getLog().warn((CharSequence)("Detected " + artifact.getId() + " that depends on APKLIB: " + dependency.getId()));
                foundApklib = true;
            }
        }
        if (foundApklib) {
            this.getLog().warn((CharSequence)"AAR libraries should not depend or include APKLIB artifacts.\nAPKLIBs have been deprecated and the combination of the two may yield unexpected results.\nCheck the problematic AAR libraries for newer versions that use AAR packaging.");
        }
    }

    private void checkPackagesForDuplicates() throws MojoExecutionException {
        Set<Artifact> dependencyArtifacts = this.getTransitiveDependencyArtifacts("aar", "apklib");
        if (dependencyArtifacts.isEmpty()) {
            return;
        }
        Map<String, Set<Artifact>> packageCompareMap = this.getPackageCompareMap(dependencyArtifacts);
        ArrayList<String> duplicatesMessageList = new ArrayList<String>();
        for (Map.Entry<String, Set<Artifact>> entry : packageCompareMap.entrySet()) {
            Set<Artifact> artifacts = entry.getValue();
            if (artifacts == null || artifacts.size() <= 1) continue;
            StringBuilder messageBuilder = new StringBuilder();
            for (Artifact item : artifacts) {
                messageBuilder.append(messageBuilder.length() > 0 ? ", " : "    [").append(item.getArtifactId());
            }
            messageBuilder.append("] have similar package='").append(entry.getKey()).append("'");
            duplicatesMessageList.add(messageBuilder.toString());
        }
        if (!duplicatesMessageList.isEmpty()) {
            ArrayList<String> messageList = new ArrayList<String>();
            messageList.add("");
            messageList.add("Duplicate packages detected in AndroidManifest.xml files");
            messageList.add("");
            messageList.add("Such scenario generally means that the build will fail with a compilation error due to missing resources in R file.");
            messageList.add("You should consider renaming some of the duplicate packages listed below to avoid the conflict.");
            messageList.add("");
            messageList.add("Conflicting artifacts:");
            messageList.addAll(duplicatesMessageList);
            messageList.add("");
            if (this.failOnDuplicatePackages) {
                StringBuilder builder = new StringBuilder();
                for (String line : messageList) {
                    builder.append(line);
                    builder.append("\n");
                }
                builder.append("\n");
                builder.append("You can downgrade the failure to a warning ");
                builder.append("by setting the 'failOnDuplicatePackages' plugin property to false.");
                throw new MojoExecutionException(builder.toString());
            }
            for (String messageLine : messageList) {
                this.getLog().warn((CharSequence)messageLine);
            }
        }
    }

    private void checkForConflictingLayouts() throws MojoExecutionException {
        ConflictingLayoutDetector detector = new ConflictingLayoutDetector();
        FileRetriever retriever = new FileRetriever("layout*/*.xml");
        detector.addLayoutFiles(this.getAndroidManifestPackageName(), retriever.getFileNames(this.resourceDirectory));
        for (Artifact dependency : this.getTransitiveDependencyArtifacts("aar", "apklib")) {
            String packageName = this.extractPackageNameFromAndroidArtifact(dependency);
            String[] layoutFiles = retriever.getFileNames(this.getUnpackedLibResourceFolder(dependency));
            detector.addLayoutFiles(packageName, layoutFiles);
        }
        Collection<ConflictingLayout> conflictingLayouts = detector.getConflictingLayouts();
        this.getLog().debug((CharSequence)("checkConflictingLayouts - conflicts : " + conflictingLayouts));
        if (!conflictingLayouts.isEmpty()) {
            ArrayList<String> sb = new ArrayList<String>();
            sb.add("");
            sb.add("");
            sb.add("Duplicate layout files have been detected across more than one Android package.");
            sb.add("");
            sb.add("Such a scenario generally means that the build will fail with a compilation error due to");
            sb.add("missing resource files. You should consider renaming some of the layout files listed below");
            sb.add("to avoid the conflict.");
            sb.add("");
            sb.add("However, if you believe you know better, then you can downgrade the failure to a warning");
            sb.add("by setting the failOnConflictingLayouts plugin property to false.");
            sb.add("But you really don't want to do that.");
            sb.add("");
            sb.add("Conflicting Layouts:");
            for (ConflictingLayout layout : conflictingLayouts) {
                sb.add("    " + layout.getLayoutFileName() + "  packages=" + layout.getPackageNames().toString());
            }
            sb.add("");
            if (this.failOnConflictingLayouts) {
                StringBuilder builder = new StringBuilder();
                for (String line : sb) {
                    builder.append(line);
                    builder.append("\n");
                }
                throw new MojoExecutionException(builder.toString());
            }
            for (String line : sb) {
                this.getLog().warn((CharSequence)line);
            }
        }
    }

    Map<String, Set<Artifact>> getPackageCompareMap(Set<Artifact> dependencyArtifacts) throws MojoExecutionException {
        if (dependencyArtifacts == null) {
            throw new IllegalArgumentException("dependencies must be initialized");
        }
        HashMap<String, Set<Artifact>> packageCompareMap = new HashMap<String, Set<Artifact>>();
        HashSet<Artifact> artifactSet = new HashSet<Artifact>();
        artifactSet.add(this.project.getArtifact());
        packageCompareMap.put(this.getAndroidManifestPackageName(), artifactSet);
        for (Artifact artifact : dependencyArtifacts) {
            String libPackage = this.extractPackageNameFromAndroidArtifact(artifact);
            HashSet<Artifact> artifacts = (HashSet<Artifact>)packageCompareMap.get(libPackage);
            if (artifacts == null) {
                artifacts = new HashSet<Artifact>();
                packageCompareMap.put(libPackage, artifacts);
            }
            artifacts.add(artifact);
        }
        return packageCompareMap;
    }

    private void generateR() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Generating R file for " + this.project.getArtifact()));
        this.genDirectory.mkdirs();
        AaptCommandBuilder.AaptPackageCommandBuilder commandBuilder = AaptCommandBuilder.packageResources(this.getLog()).makePackageDirectories().setResourceConstantsFolder(this.genDirectory).forceOverwriteExistingFiles().disablePngCrunching().generateRIntoPackage(this.customPackage).setPathToAndroidManifest(this.destinationManifestFile).addResourceDirectoryIfExists(this.resourceDirectory).addResourceDirectoriesIfExists(this.getResourceOverlayDirectories()).addResourceDirectoriesIfExists(this.getLibraryResourceFolders()).autoAddOverlay().addRawAssetsDirectoryIfExists(this.combinedAssets).addExistingPackageToBaseIncludeSet(this.getAndroidSdk().getAndroidJar()).addConfigurations(this.configurations).addExtraArguments(this.aaptExtraArgs).setVerbose(this.aaptVerbose).generateRTextFile(this.targetDirectory).setProguardOptionsOutputFile(this.proguardFile).makeResourcesNonConstant("aar".equals(this.project.getArtifact().getType()));
        this.getLog().debug((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + commandBuilder.toString()));
        try {
            CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
            executor.setLogger(this.getLog());
            executor.setCaptureStdOut(true);
            List<String> commands = commandBuilder.build();
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        ResourceClassGenerator resGenerator = new ResourceClassGenerator(this, this.targetDirectory, this.genDirectory);
        this.generateCorrectRJavaForApklibDependencies(resGenerator);
        this.generateCorrectRJavaForAarDependencies(resGenerator);
        this.getLog().info((CharSequence)("Adding R gen folder to compile classpath: " + this.genDirectory));
        this.project.addCompileSourceRoot(this.genDirectory.getAbsolutePath());
    }

    private void generateCorrectRJavaForApklibDependencies(ResourceClassGenerator resourceGenerator) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"");
        this.getLog().debug((CharSequence)"#generateCorrectRJavaFoApklibDeps");
        this.getLog().debug((CharSequence)("Generating Rs for apklib deps of project " + this.project.getArtifact()));
        Set<Artifact> apklibDependencies = this.getTransitiveDependencyArtifacts("apklib");
        for (Artifact artifact : apklibDependencies) {
            this.getLog().debug((CharSequence)("Generating apklib R.java for " + artifact.getArtifactId() + "..."));
            this.generateRForApkLibDependency(artifact);
        }
        if (!apklibDependencies.isEmpty() && "apk".equals(this.project.getArtifact().getType())) {
            this.getLog().debug((CharSequence)"");
            this.getLog().debug((CharSequence)("Rewriting R files for APKLIB dependencies : " + apklibDependencies));
            resourceGenerator.generateLibraryRs(apklibDependencies, "apklib");
        }
    }

    private void generateCorrectRJavaForAarDependencies(ResourceClassGenerator resourceGenerator) throws MojoExecutionException {
        Set<Artifact> aarLibraries = this.getTransitiveDependencyArtifacts("aar");
        if (!aarLibraries.isEmpty()) {
            this.getLog().debug((CharSequence)"Generating R file for AAR dependencies");
            resourceGenerator.generateLibraryRs(aarLibraries, "aar");
        }
    }

    private List<File> getLibraryResourceFolders() {
        ArrayList<File> resourceFolders = new ArrayList<File>();
        for (Artifact artifact : this.getTransitiveDependencyArtifacts("aar", "apklib")) {
            this.getLog().debug((CharSequence)("Considering dep artifact : " + artifact));
            File resourceFolder = this.getUnpackedLibResourceFolder(artifact);
            if (!resourceFolder.exists()) continue;
            this.getLog().debug((CharSequence)("Adding apklib or aar resource folder : " + resourceFolder));
            resourceFolders.add(resourceFolder);
        }
        return resourceFolders;
    }

    private void generateRForApkLibDependency(Artifact apklibArtifact) throws MojoExecutionException {
        File unpackDir = this.getUnpackedLibFolder(apklibArtifact);
        this.getLog().debug((CharSequence)("Generating incomplete R file for apklib: " + apklibArtifact.getGroupId() + ":" + apklibArtifact.getArtifactId()));
        File apklibManifest = new File(unpackDir, "AndroidManifest.xml");
        File apklibResDir = new File(unpackDir, "res");
        ArrayList<File> dependenciesResDirectories = new ArrayList<File>();
        Set<Artifact> apklibDeps = this.getDependencyResolver().getLibraryDependenciesFor(this.session, this.repositorySystem, apklibArtifact);
        this.getLog().debug((CharSequence)("apklib=" + apklibArtifact + "  dependencies=" + apklibDeps));
        for (Artifact dependency : apklibDeps) {
            String extension = dependency.getType();
            File dependencyResDir = this.getUnpackedLibResourceFolder(dependency);
            if (!extension.equals("apklib") && !extension.equals("aar") || !dependencyResDir.exists()) continue;
            dependenciesResDirectories.add(dependencyResDir);
        }
        File apklibCombAssets = new File(this.getUnpackedLibFolder(apklibArtifact), "combined-assets");
        for (Artifact dependency : apklibDeps) {
            String extension = dependency.getType();
            File dependencyAssetsDir = this.getUnpackedLibAssetsFolder(dependency);
            if (!extension.equals("apklib") && !extension.equals("aar")) continue;
            this.copyFolder(dependencyAssetsDir, apklibCombAssets);
        }
        File apkLibAssetsDir = this.getUnpackedLibAssetsFolder(apklibArtifact);
        this.copyFolder(apkLibAssetsDir, apklibCombAssets);
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        AaptCommandBuilder.AaptPackageCommandBuilder commandBuilder = AaptCommandBuilder.packageResources(this.getLog()).makeResourcesNonConstant().makePackageDirectories().setResourceConstantsFolder(this.genDirectory).generateRIntoPackage(this.extractPackageNameFromAndroidManifest(apklibManifest)).setPathToAndroidManifest(apklibManifest).addResourceDirectoryIfExists(apklibResDir).addResourceDirectoriesIfExists(dependenciesResDirectories).autoAddOverlay().addRawAssetsDirectoryIfExists(apklibCombAssets).addExistingPackageToBaseIncludeSet(this.getAndroidSdk().getAndroidJar()).addConfigurations(this.configurations).addExtraArguments(this.aaptExtraArgs).setVerbose(this.aaptVerbose).generateRTextFile(unpackDir);
        this.getLog().debug((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + commandBuilder.toString()));
        try {
            executor.setCaptureStdOut(true);
            List<String> commands = commandBuilder.build();
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    private void mergeManifests() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("mergeManifests: " + this.mergeManifests));
        if (!this.mergeManifests) {
            this.getLog().debug((CharSequence)"Manifest merging disabled. Using project manifest only");
            return;
        }
        this.getLog().info((CharSequence)"Getting manifests of dependent apklibs");
        ArrayList<File> libManifests = new ArrayList<File>();
        for (Artifact artifact : this.getTransitiveDependencyArtifacts("apklib", "aar")) {
            File libManifest = new File(this.getUnpackedLibFolder(artifact), "AndroidManifest.xml");
            if (!libManifest.exists()) {
                throw new MojoExecutionException(artifact.getArtifactId() + " is missing AndroidManifest.xml");
            }
            libManifests.add(libManifest);
        }
        if (libManifests.isEmpty()) {
            this.getLog().info((CharSequence)"No APKLIB manifests found. Using project manifest only.");
            return;
        }
        File mergedManifest = new File(this.destinationManifestFile.getParent(), "AndroidManifest-merged.xml");
        StdLogger stdLogger = new StdLogger(StdLogger.Level.VERBOSE);
        ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)stdLogger), null);
        this.getLog().info((CharSequence)"Merging manifests of dependent apklibs");
        boolean mergeSuccess = merger.process(mergedManifest, this.destinationManifestFile, libManifests.toArray(new File[libManifests.size()]), null, null);
        if (mergeSuccess) {
            this.destinationManifestFile.delete();
            mergedManifest.renameTo(this.destinationManifestFile);
            this.getLog().info((CharSequence)"Done Merging Manifests of APKLIBs");
            return;
        }
        this.getLog().error((CharSequence)"Manifests were not merged!");
        throw new MojoExecutionException("Manifests were not merged!");
    }

    private void generateBuildConfig() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating BuildConfig file");
        String packageName = this.extractPackageNameFromAndroidManifest(this.destinationManifestFile);
        if (StringUtils.isNotBlank((String)this.customPackage)) {
            packageName = this.customPackage;
        }
        this.generateBuildConfigForPackage(packageName);
        if (this.project.getPackaging().equals("aar")) {
            return;
        }
        for (Artifact artifact : this.getTransitiveDependencyArtifacts("apklib", "aar")) {
            if (this.skipBuildConfigGeneration(artifact)) {
                this.getLog().info((CharSequence)("Skip BuildConfig.java generation for " + artifact.getGroupId() + " " + artifact.getArtifactId()));
                continue;
            }
            String depPackageName = this.extractPackageNameFromAndroidArtifact(artifact);
            this.generateBuildConfigForPackage(depPackageName);
        }
    }

    private boolean skipBuildConfigGeneration(Artifact artifact) throws MojoExecutionException {
        if (artifact.getType().equals("aar")) {
            String depPackageName = this.extractPackageNameFromAndroidArtifact(artifact);
            if (this.isBuildConfigPresent(artifact, depPackageName)) {
                return true;
            }
            Set<Artifact> transitiveDep = this.getArtifactResolverHelper().getFilteredArtifacts(this.project.getArtifacts(), "aar");
            for (Artifact transitiveArtifact : transitiveDep) {
                if (!this.isBuildConfigPresent(transitiveArtifact, depPackageName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBuildConfigPresent(Artifact artifact) throws MojoExecutionException {
        String depPackageName = this.extractPackageNameFromAndroidArtifact(artifact);
        return this.isBuildConfigPresent(artifact, depPackageName);
    }

    private boolean isBuildConfigPresent(Artifact artifact, String packageName) throws MojoExecutionException {
        try {
            JarFile jar = new JarFile(this.getUnpackedAarClassesJar(artifact));
            JarEntry entry = jar.getJarEntry(packageName.replace('.', '/') + "/BuildConfig.class");
            return entry != null;
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error generating BuildConfig ", (Throwable)e);
            throw new MojoExecutionException("Error generating BuildConfig", (Exception)e);
        }
    }

    private void generateBuildConfigForPackage(String packageName) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Creating BuildConfig for " + packageName));
        File outputFolder = new File(this.genDirectory, packageName.replace(".", File.separator));
        outputFolder.mkdirs();
        StringBuilder buildConfig = new StringBuilder();
        buildConfig.append("package ").append(packageName).append(";\n\n");
        buildConfig.append("public final class BuildConfig {\n");
        buildConfig.append("  public static final boolean DEBUG = ").append(!this.release).append(";\n");
        for (BuildConfigConstant constant : this.buildConfigConstants) {
            String value = constant.getValue();
            if ("String".equals(constant.getType())) {
                value = "\"" + value + "\"";
            }
            buildConfig.append("  public static final ").append(constant.getType()).append(" ").append(constant.getName()).append(" = ").append(value).append(";\n");
        }
        buildConfig.append("}\n");
        File outputFile = new File(outputFolder, "BuildConfig.java");
        try {
            FileUtils.writeStringToFile((File)outputFile, (String)buildConfig.toString());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error generating BuildConfig ", (Throwable)e);
            throw new MojoExecutionException("Error generating BuildConfig", (Exception)e);
        }
    }

    private void generateAidlFiles(Map<File, String[]> files) throws MojoExecutionException {
        ArrayList<String> protoCommands = new ArrayList<String>();
        protoCommands.add("-p" + this.getAndroidSdk().getPathForFrameworkAidl());
        this.genDirectoryAidl.mkdirs();
        this.getLog().info((CharSequence)("Adding AIDL gen folder to compile classpath: " + this.genDirectoryAidl));
        this.project.addCompileSourceRoot(this.genDirectoryAidl.getPath());
        Set<File> sourceDirs = files.keySet();
        for (File sourceDir : sourceDirs) {
            protoCommands.add("-I" + sourceDir);
        }
        for (File sourceDir : sourceDirs) {
            for (String relativeAidlFileName : files.get(sourceDir)) {
                File targetDirectory = new File(this.genDirectoryAidl, new File(relativeAidlFileName).getParent());
                targetDirectory.mkdirs();
                String shortAidlFileName = new File(relativeAidlFileName).getName();
                String shortJavaFileName = shortAidlFileName.substring(0, shortAidlFileName.lastIndexOf(".")) + ".java";
                File aidlFileInSourceDirectory = new File(sourceDir, relativeAidlFileName);
                ArrayList<String> commands = new ArrayList<String>(protoCommands);
                commands.add(aidlFileInSourceDirectory.getAbsolutePath());
                commands.add(new File(targetDirectory, shortJavaFileName).getAbsolutePath());
                try {
                    CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
                    executor.setLogger(this.getLog());
                    executor.setCaptureStdOut(true);
                    executor.executeCommand(this.getAndroidSdk().getAidlPath(), commands, this.project.getBasedir(), false);
                }
                catch (ExecutionException e) {
                    throw new MojoExecutionException("", (Exception)e);
                }
            }
        }
    }

    private String[] findRelativeAidlFileNames(File sourceDirectory) {
        FileRetriever retriever = new FileRetriever("**/*.aidl");
        String[] relativeAidlFileNames = retriever.getFileNames(sourceDirectory);
        if (relativeAidlFileNames.length == 0) {
            this.getLog().debug((CharSequence)"ANDROID-904-002: No aidl files found");
        } else {
            this.getLog().info((CharSequence)("ANDROID-904-002: Found aidl files: Count = " + relativeAidlFileNames.length));
        }
        return relativeAidlFileNames;
    }

    private boolean isCurrentProjectAndroid() {
        HashSet<String> androidArtifacts = new HashSet<String>(){
            {
                this.addAll(Arrays.asList("apk", "apklib", "apksources", "aar"));
            }
        };
        return androidArtifacts.contains(this.project.getArtifact().getType());
    }
}

