/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.android.builder.core.AndroidBuilder;
import com.android.manifmerger.ManifestMerger2;
import com.android.utils.ILogger;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.common.AndroidExtension;
import com.jayway.maven.plugins.android.common.MavenManifestDependency;
import com.jayway.maven.plugins.android.configuration.ManifestMerger;
import com.jayway.maven.plugins.android.configuration.UsesSdk;
import com.jayway.maven.plugins.android.configuration.VersionGenerator;
import com.jayway.maven.plugins.android.phase01generatesources.MavenILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="manifest-merger", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ManifestMergerMojo
extends AbstractAndroidMojo {
    @Parameter
    private ManifestMerger manifestMerger;
    @Parameter(property="android.manifestMerger.versionName", defaultValue="${project.version}")
    protected String manifestVersionName;
    @Parameter(property="android.manifestMerger.versionCode", defaultValue="1")
    protected Integer manifestVersionCode;
    @Parameter(property="android.manifest.versionCodeUpdateFromVersion", defaultValue="false")
    protected Boolean manifestVersionCodeUpdateFromVersion = false;
    @Parameter(property="android.manifestMerger.versionDigits", defaultValue="4,3,3")
    protected String manifestVersionDigits;
    @Parameter(property="android.manifestMerger.mergeLibraries", defaultValue="false")
    protected Boolean manifestMergeLibraries;
    @Parameter(property="android.manifestMerger.mergeReportFile")
    protected File manifestMergeReportFile;
    protected UsesSdk manifestUsesSdk;
    private Boolean parsedVersionCodeUpdateFromVersion;
    private String parsedVersionDigits;
    private Boolean parsedMergeLibraries;
    private String parsedVersionName;
    private Integer parsedVersionCode;
    private UsesSdk parsedUsesSdk;
    private File parsedMergeReportFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!AndroidExtension.isAndroidPackaging(this.project.getPackaging())) {
            return;
        }
        if (this.androidManifestFile == null) {
            this.getLog().debug((CharSequence)"skip, no androidmanifest.xml defined (androidManifestFile rare case)");
            return;
        }
        this.parseConfiguration();
        this.getLog().info((CharSequence)("Attempting to update manifest " + this.androidManifestFile));
        this.getLog().debug((CharSequence)("    usesSdk=" + this.parsedUsesSdk));
        this.getLog().debug((CharSequence)("    versionName=" + this.parsedVersionName));
        this.getLog().debug((CharSequence)("    versionCode=" + this.parsedVersionCode));
        this.getLog().debug((CharSequence)("    usesSdk=" + this.parsedUsesSdk));
        this.getLog().debug((CharSequence)("    versionCodeUpdateFromVersion=" + this.parsedVersionCodeUpdateFromVersion));
        this.getLog().debug((CharSequence)("    versionDigits=" + this.parsedVersionDigits));
        this.getLog().debug((CharSequence)("    mergeLibraries=" + this.parsedMergeLibraries));
        this.getLog().debug((CharSequence)("    mergeReportFile=" + this.parsedMergeReportFile));
        if (!this.androidManifestFile.exists()) {
            return;
        }
        this.getLog().debug((CharSequence)"Using manifest merger V2");
        this.manifestMergerV2();
    }

    private void parseConfiguration() {
        if (this.manifestMerger != null) {
            this.parsedVersionName = StringUtils.isNotEmpty((String)this.manifestMerger.getVersionName()) ? this.manifestMerger.getVersionName() : this.manifestVersionName;
            this.parsedVersionCode = this.manifestMerger.getVersionCode() != null ? this.manifestMerger.getVersionCode() : this.manifestVersionCode;
            this.parsedVersionCodeUpdateFromVersion = this.manifestMerger.getVersionCodeUpdateFromVersion() != null ? this.manifestMerger.getVersionCodeUpdateFromVersion() : this.manifestVersionCodeUpdateFromVersion;
            this.parsedVersionDigits = this.manifestMerger.getVersionDigits() != null ? this.manifestMerger.getVersionDigits() : this.manifestVersionDigits;
            this.parsedUsesSdk = this.manifestMerger.getUsesSdk() != null ? this.manifestMerger.getUsesSdk() : this.manifestUsesSdk;
            this.parsedMergeLibraries = this.manifestMerger.getMergeLibraries() != null ? this.manifestMerger.getMergeLibraries() : this.manifestMergeLibraries;
            this.parsedMergeReportFile = this.manifestMerger.getMergeReportFile() != null ? this.manifestMerger.getMergeReportFile() : this.manifestMergeReportFile;
        } else {
            this.parsedVersionName = this.manifestVersionName;
            this.parsedVersionCode = this.manifestVersionCode;
            this.parsedUsesSdk = this.manifestUsesSdk;
            this.parsedVersionCodeUpdateFromVersion = this.manifestVersionCodeUpdateFromVersion;
            this.parsedVersionDigits = this.manifestVersionDigits;
            this.parsedMergeLibraries = this.manifestMergeLibraries;
            this.parsedMergeReportFile = this.manifestMergeReportFile;
        }
    }

    public void manifestMergerV2() throws MojoExecutionException, MojoFailureException {
        int versionCode;
        AndroidBuilder builder = new AndroidBuilder(this.project.toString(), "created by Android Maven Plugin", (ILogger)new MavenILogger(this.getLog()), false);
        String minSdkVersion = null;
        String targetSdkVersion = null;
        if (this.parsedUsesSdk != null) {
            minSdkVersion = this.parsedUsesSdk.getMinSdkVersion();
            targetSdkVersion = this.parsedUsesSdk.getTargetSdkVersion();
        }
        if (this.parsedVersionCodeUpdateFromVersion.booleanValue()) {
            VersionGenerator gen = new VersionGenerator(this.parsedVersionDigits);
            versionCode = gen.generate(this.parsedVersionName);
        } else {
            versionCode = this.parsedVersionCode;
        }
        ArrayList<MavenManifestDependency> manifestDependencies = new ArrayList<MavenManifestDependency>();
        if (this.parsedMergeLibraries.booleanValue()) {
            Set allArtifacts = this.project.getDependencyArtifacts();
            Set<Artifact> dependencyArtifacts = this.getArtifactResolverHelper().getFilteredArtifacts(allArtifacts, new String[0]);
            for (Artifact dependency : dependencyArtifacts) {
                File unpackedLibFolder = this.getUnpackedLibFolder(dependency);
                File manifestFile = new File(unpackedLibFolder, "AndroidManifest.xml");
                if (!manifestFile.exists()) continue;
                manifestDependencies.add(new MavenManifestDependency(manifestFile, manifestFile.getAbsolutePath(), new ArrayList<MavenManifestDependency>()));
            }
        }
        builder.mergeManifests(this.androidManifestFile, new ArrayList(), manifestDependencies, "", versionCode, this.parsedVersionName, minSdkVersion, targetSdkVersion, null, this.destinationManifestFile.getPath(), ManifestMerger2.MergeType.APPLICATION, new HashMap(), this.parsedMergeReportFile);
    }
}

