/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.common.AndroidExtension;
import com.jayway.maven.plugins.android.common.XmlHelper;
import com.jayway.maven.plugins.android.configuration.Manifest;
import com.jayway.maven.plugins.android.configuration.UsesSdk;
import com.jayway.maven.plugins.android.configuration.VersionGenerator;
import com.jayway.maven.plugins.android.standalonemojos.CompatibleScreen;
import com.jayway.maven.plugins.android.standalonemojos.SupportsScreens;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Deprecated
@Mojo(name="manifest-update", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ManifestUpdateMojo
extends AbstractAndroidMojo {
    private static final String ATTR_VERSION_NAME = "android:versionName";
    private static final String ATTR_VERSION_CODE = "android:versionCode";
    private static final String ATTR_SHARED_USER_ID = "android:sharedUserId";
    private static final String ATTR_DEBUGGABLE = "android:debuggable";
    private static final String ATTR_SCREEN_DENSITY = "android:screenDensity";
    private static final String ATTR_SCREEN_SIZE = "android:screenSize";
    private static final String ATTR_ANY_DENSITY = "android:anyDensity";
    private static final String ATTR_SMALL_SCREENS = "android:smallScreens";
    private static final String ATTR_NORMAL_SCREENS = "android:normalScreens";
    private static final String ATTR_LARGE_SCREENS = "android:largeScreens";
    private static final String ATTR_XLARGE_SCREENS = "android:xlargeScreens";
    private static final String ATTR_RESIZEABLE = "android:resizeable";
    private static final String ATTR_REQUIRES_SMALLEST_WIDTH_DP = "android:requiresSmallestWidthDp";
    private static final String ATTR_LARGEST_WIDTH_LIMIT_DP = "android:largestWidthLimitDp";
    private static final String ATTR_COMPATIBLE_WIDTH_LIMIT_DP = "android:compatibleWidthLimitDp";
    private static final String ATTR_MIN_SDK_VERSION = "android:minSdkVersion";
    private static final String ATTR_MAX_SDK_VERSION = "android:maxSdkVersion";
    private static final String ATTR_TARGET_SDK_VERSION = "android:targetSdkVersion";
    private static final String ATTR_NAME = "android:name";
    private static final String ATTR_AUTHORITIES = "android:authorities";
    private static final String ATTR_APPLICATION_ICON = "android:icon";
    private static final String ATTR_APPLICATION_LABEL = "android:label";
    private static final String ATTR_APPLICATION_THEME = "android:theme";
    private static final String ELEM_APPLICATION = "application";
    private static final String ELEM_PROVIDER = "provider";
    private static final String ELEM_SUPPORTS_SCREENS = "supports-screens";
    private static final String ELEM_COMPATIBLE_SCREENS = "compatible-screens";
    private static final String ELEM_SCREEN = "screen";
    private static final String ELEM_USES_SDK = "uses-sdk";
    @Parameter
    private Manifest manifest;
    @Parameter(property="android.manifest.versionName", defaultValue="${project.version}")
    protected String manifestVersionName;
    @Parameter(property="android.manifest.versionCode")
    protected Integer manifestVersionCode;
    @Parameter(property="android.manifest.versionCodeAutoIncrement", defaultValue="false")
    private Boolean manifestVersionCodeAutoIncrement = false;
    @Parameter(property="android.manifest.applicationIcon")
    private String manifestApplicationIcon;
    @Parameter(property="android.manifest.applicationLabel")
    private String manifestApplicationLabel;
    @Parameter(property="android.manifest.applicationTheme")
    private String manifestApplicationTheme;
    @Parameter(property="android.manifest.versionCodeUpdateFromVersion", defaultValue="false")
    protected Boolean manifestVersionCodeUpdateFromVersion = false;
    @Parameter(property="android.manifest.sharedUserId")
    protected String manifestSharedUserId;
    @Parameter(property="android.manifest.debuggable")
    protected Boolean manifestDebuggable;
    @Parameter(property="android.manifest.providerAuthorities")
    protected Properties manifestProviderAuthorities;
    protected SupportsScreens manifestSupportsScreens;
    protected List<CompatibleScreen> manifestCompatibleScreens;
    protected UsesSdk manifestUsesSdk;
    private String parsedVersionName;
    private Integer parsedVersionCode;
    private boolean parsedVersionCodeAutoIncrement;
    private String parsedApplicationIcon;
    private String parsedApplicationLabel;
    private String parsedApplicationTheme;
    private Boolean parsedVersionCodeUpdateFromVersion;
    private String parsedSharedUserId;
    private Boolean parsedDebuggable;
    private SupportsScreens parsedSupportsScreens;
    private List<CompatibleScreen> parsedCompatibleScreens;
    private Properties parsedProviderAuthorities;
    private UsesSdk parsedUsesSdk;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!AndroidExtension.isAndroidPackaging(this.project.getPackaging())) {
            return;
        }
        if (this.destinationManifestFile == null) {
            return;
        }
        this.parseConfiguration();
        this.getLog().info((CharSequence)("Attempting to update manifest " + this.destinationManifestFile));
        this.getLog().debug((CharSequence)("    usesSdk=" + this.parsedUsesSdk));
        this.getLog().debug((CharSequence)("    versionName=" + this.parsedVersionName));
        this.getLog().debug((CharSequence)("    versionCode=" + this.parsedVersionCode));
        this.getLog().debug((CharSequence)("    versionCodeAutoIncrement=" + this.parsedVersionCodeAutoIncrement));
        this.getLog().debug((CharSequence)("    versionCodeUpdateFromVersion=" + this.parsedVersionCodeUpdateFromVersion));
        this.getLog().debug((CharSequence)("    applicationIcon=" + this.parsedApplicationIcon));
        this.getLog().debug((CharSequence)("    applicationLabel=" + this.parsedApplicationLabel));
        this.getLog().debug((CharSequence)("    applicationTheme=" + this.parsedApplicationTheme));
        this.getLog().debug((CharSequence)("    sharedUserId=" + this.parsedSharedUserId));
        this.getLog().debug((CharSequence)("    debuggable=" + this.parsedDebuggable));
        this.getLog().debug((CharSequence)("    providerAuthorities: " + this.parsedProviderAuthorities));
        this.getLog().debug((CharSequence)("    supports-screens: " + (this.parsedSupportsScreens == null ? "not set" : "set")));
        this.getLog().debug((CharSequence)("    compatible-screens: " + (this.parsedCompatibleScreens == null ? "not set" : "set")));
        if (!this.destinationManifestFile.exists()) {
            return;
        }
        try {
            this.updateManifest(this.destinationManifestFile);
        }
        catch (IOException e) {
            throw new MojoFailureException("XML I/O error: " + this.destinationManifestFile, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoFailureException("Unable to prepare XML parser", (Throwable)e);
        }
        catch (SAXException e) {
            throw new MojoFailureException("Unable to parse XML: " + this.destinationManifestFile, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new MojoFailureException("Unable write XML: " + this.destinationManifestFile, (Throwable)e);
        }
    }

    private void parseConfiguration() {
        if (this.manifest != null) {
            this.parsedVersionName = StringUtils.isNotEmpty((String)this.manifest.getVersionName()) ? this.manifest.getVersionName() : this.manifestVersionName;
            this.parsedVersionCode = this.manifest.getVersionCode() != null ? this.manifest.getVersionCode() : this.manifestVersionCode;
            this.parsedVersionCodeAutoIncrement = this.manifest.getVersionCodeAutoIncrement() != null ? this.manifest.getVersionCodeAutoIncrement().booleanValue() : this.manifestVersionCodeAutoIncrement.booleanValue();
            this.parsedVersionCodeUpdateFromVersion = this.manifest.getVersionCodeUpdateFromVersion() != null ? this.manifest.getVersionCodeUpdateFromVersion() : this.manifestVersionCodeUpdateFromVersion;
            this.parsedApplicationIcon = StringUtils.isNotEmpty((String)this.manifest.getApplicationIcon()) ? this.manifest.getApplicationIcon() : this.manifestApplicationIcon;
            this.parsedApplicationLabel = StringUtils.isNotEmpty((String)this.manifest.getApplicationLabel()) ? this.manifest.getApplicationLabel() : this.manifestApplicationLabel;
            this.parsedApplicationTheme = StringUtils.isNotEmpty((String)this.manifest.getApplicationTheme()) ? this.manifest.getApplicationTheme() : this.manifestApplicationTheme;
            this.parsedSharedUserId = StringUtils.isNotEmpty((String)this.manifest.getSharedUserId()) ? this.manifest.getSharedUserId() : this.manifestSharedUserId;
            this.parsedDebuggable = this.manifest.getDebuggable() != null ? this.manifest.getDebuggable() : this.manifestDebuggable;
            this.parsedSupportsScreens = this.manifest.getSupportsScreens() != null ? this.manifest.getSupportsScreens() : this.manifestSupportsScreens;
            this.parsedCompatibleScreens = this.manifest.getCompatibleScreens() != null ? this.manifest.getCompatibleScreens() : this.manifestCompatibleScreens;
            this.parsedProviderAuthorities = this.manifest.getProviderAuthorities() != null ? this.manifest.getProviderAuthorities() : this.manifestProviderAuthorities;
            this.parsedUsesSdk = this.manifest.getUsesSdk() != null ? this.manifest.getUsesSdk() : this.manifestUsesSdk;
        } else {
            this.parsedVersionName = this.manifestVersionName;
            this.parsedVersionCode = this.manifestVersionCode;
            this.parsedVersionCodeAutoIncrement = this.manifestVersionCodeAutoIncrement;
            this.parsedVersionCodeUpdateFromVersion = this.manifestVersionCodeUpdateFromVersion;
            this.parsedApplicationIcon = this.manifestApplicationIcon;
            this.parsedApplicationLabel = this.manifestApplicationLabel;
            this.parsedApplicationTheme = this.manifestApplicationTheme;
            this.parsedSharedUserId = this.manifestSharedUserId;
            this.parsedDebuggable = this.manifestDebuggable;
            this.parsedSupportsScreens = this.manifestSupportsScreens;
            this.parsedCompatibleScreens = this.manifestCompatibleScreens;
            this.parsedProviderAuthorities = this.manifestProviderAuthorities;
            this.parsedUsesSdk = this.manifestUsesSdk;
        }
    }

    private Document readManifest(File manifestFile) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(manifestFile);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeManifest(File manifestFile, Document doc) throws IOException, TransformerException {
        TransformerFactory xfactory = TransformerFactory.newInstance();
        Transformer xformer = xfactory.newTransformer();
        xformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(doc);
        OutputStreamWriter writer = null;
        try {
            manifestFile.getParentFile().mkdirs();
            String encoding = doc.getXmlEncoding() != null ? doc.getXmlEncoding() : "UTF-8";
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(manifestFile, false), encoding);
            if (doc.getXmlEncoding() != null && doc.getXmlVersion() != null) {
                String xmldecl = String.format("<?xml version=\"%s\" encoding=\"%s\"?>%n", doc.getXmlVersion(), doc.getXmlEncoding());
                writer.write(xmldecl);
            }
            StreamResult result = new StreamResult(writer);
            xformer.transform(source, result);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void updateManifest(File manifestFile) throws IOException, ParserConfigurationException, SAXException, TransformerException, MojoFailureException, MojoExecutionException {
        boolean madeDirty;
        Attr sharedUserIdAttrib;
        Attr versionNameAttrib;
        Document doc = this.readManifest(manifestFile);
        Element manifestElement = doc.getDocumentElement();
        boolean dirty = false;
        if (StringUtils.isEmpty((String)this.parsedVersionName)) {
            this.parsedVersionName = this.project.getVersion();
        }
        if ((versionNameAttrib = manifestElement.getAttributeNode(ATTR_VERSION_NAME)) == null || !StringUtils.equals((String)this.parsedVersionName, (String)versionNameAttrib.getValue())) {
            this.getLog().info((CharSequence)("Setting android:versionName to " + this.parsedVersionName));
            manifestElement.setAttribute(ATTR_VERSION_NAME, this.parsedVersionName);
            dirty = true;
        }
        if (this.parsedVersionCodeAutoIncrement && this.parsedVersionCode != null || this.parsedVersionCodeUpdateFromVersion != false && this.parsedVersionCode != null || this.parsedVersionCodeAutoIncrement && this.parsedVersionCodeUpdateFromVersion.booleanValue()) {
            throw new MojoFailureException("versionCodeAutoIncrement, versionCodeUpdateFromVersion and versionCode are mutual exclusive. They cannot be specified at the same time. Please specify either versionCodeAutoIncrement, versionCodeUpdateFromVersion or versionCode!");
        }
        this.exportProperties();
        if (this.parsedVersionCodeAutoIncrement) {
            this.performVersioCodeAutoIncrement(manifestElement);
            dirty = true;
        }
        if (this.parsedVersionCodeUpdateFromVersion.booleanValue()) {
            this.performVersionCodeUpdateFromVersion(manifestElement);
            dirty = true;
        }
        if (this.parsedVersionCode != null) {
            Attr versionCodeAttr = manifestElement.getAttributeNode(ATTR_VERSION_CODE);
            int currentVersionCode = 0;
            if (versionCodeAttr != null) {
                currentVersionCode = NumberUtils.toInt((String)versionCodeAttr.getValue(), (int)0);
            }
            if (currentVersionCode != this.parsedVersionCode) {
                this.getLog().info((CharSequence)("Setting android:versionCode to " + this.parsedVersionCode));
                manifestElement.setAttribute(ATTR_VERSION_CODE, String.valueOf(this.parsedVersionCode));
                dirty = true;
            }
            this.project.getProperties().setProperty("android.manifest.versionCode", String.valueOf(this.parsedVersionCode));
        }
        if (!StringUtils.isEmpty((String)this.parsedApplicationIcon)) {
            dirty = this.updateApplicationAttribute(manifestElement, ATTR_APPLICATION_ICON, this.parsedApplicationIcon, dirty);
            this.project.getProperties().setProperty("android.manifest.applicationIcon", String.valueOf(this.parsedApplicationIcon));
        }
        if (!StringUtils.isEmpty((String)this.parsedApplicationLabel)) {
            dirty = this.updateApplicationAttribute(manifestElement, ATTR_APPLICATION_LABEL, this.parsedApplicationLabel, dirty);
            this.project.getProperties().setProperty("android.manifest.applicationLabel", String.valueOf(this.parsedApplicationLabel));
        }
        if (!StringUtils.isEmpty((String)this.parsedApplicationTheme)) {
            dirty = this.updateApplicationAttribute(manifestElement, ATTR_APPLICATION_THEME, this.parsedApplicationTheme, dirty);
            this.project.getProperties().setProperty("android.manifest.applicationTheme", String.valueOf(this.parsedApplicationTheme));
        }
        if (!(StringUtils.isEmpty((String)this.parsedSharedUserId) || (sharedUserIdAttrib = manifestElement.getAttributeNode(ATTR_SHARED_USER_ID)) != null && StringUtils.equals((String)this.parsedSharedUserId, (String)sharedUserIdAttrib.getValue()))) {
            this.getLog().info((CharSequence)("Setting android:sharedUserId to " + this.parsedSharedUserId));
            manifestElement.setAttribute(ATTR_SHARED_USER_ID, this.parsedSharedUserId);
            dirty = true;
        }
        if (this.parsedDebuggable != null) {
            NodeList appElems = manifestElement.getElementsByTagName(ELEM_APPLICATION);
            for (int i = 0; i < appElems.getLength(); ++i) {
                Element element;
                Attr debuggableAttrib;
                Node node = appElems.item(i);
                this.getLog().info((CharSequence)("Testing if node " + node.getNodeName() + " is application"));
                if (node.getNodeType() != 1 || (debuggableAttrib = (element = (Element)node).getAttributeNode(ATTR_DEBUGGABLE)) != null && this.parsedDebuggable == BooleanUtils.toBoolean((String)debuggableAttrib.getValue())) continue;
                this.getLog().info((CharSequence)("Setting android:debuggable to " + this.parsedDebuggable));
                element.setAttribute(ATTR_DEBUGGABLE, String.valueOf(this.parsedDebuggable));
                dirty = true;
            }
        }
        if (this.parsedSupportsScreens != null && (madeDirty = this.performSupportScreenModification(doc, manifestElement))) {
            dirty = true;
        }
        if (this.parsedCompatibleScreens != null) {
            this.getLog().info((CharSequence)"Setting compatible-screens");
            this.updateCompatibleScreens(doc, manifestElement);
            dirty = true;
        }
        dirty = this.processProviderAuthorities(manifestElement, dirty);
        if (dirty = this.processUsesSdk(doc, manifestElement, dirty)) {
            if (manifestFile.exists() && !manifestFile.delete()) {
                this.getLog().warn((CharSequence)("Could not remove old " + manifestFile));
            }
            this.getLog().info((CharSequence)("Made changes to manifest file, updating " + manifestFile));
            this.writeManifest(manifestFile, doc);
        } else {
            this.getLog().info((CharSequence)"No changes found to write to manifest file");
        }
    }

    private boolean processProviderAuthorities(Element manifestElement, boolean dirty) {
        boolean madeDirty;
        if (this.parsedProviderAuthorities != null && (madeDirty = this.updateProviderAuthorities(manifestElement))) {
            dirty = true;
        }
        return dirty;
    }

    private boolean processUsesSdk(Document doc, Element manifestElement, boolean dirty) {
        boolean madeDirty;
        if (this.parsedUsesSdk != null && (madeDirty = this.performUsesSdkModification(doc, manifestElement))) {
            dirty = true;
        }
        return dirty;
    }

    private boolean updateApplicationAttribute(Element manifestElement, String attribute, String value, boolean dirty) {
        NodeList appElements = manifestElement.getElementsByTagName(ELEM_APPLICATION);
        for (int i = 0; i < appElements.getLength(); ++i) {
            Element element;
            Attr labelAttrib;
            Node node = appElements.item(i);
            this.getLog().info((CharSequence)("Testing if node " + node.getNodeName() + " is application"));
            if (node.getNodeType() != 1 || (labelAttrib = (element = (Element)node).getAttributeNode(attribute)) != null && value.equals(labelAttrib.getValue())) continue;
            this.getLog().info((CharSequence)("Setting " + attribute + " to " + value));
            element.setAttribute(attribute, String.valueOf(value));
            dirty = true;
        }
        return dirty;
    }

    private void exportProperties() {
        this.project.getProperties().setProperty("android.manifest.versionName", this.parsedVersionName);
        this.project.getProperties().setProperty("android.manifest.versionCodeAutoIncrement", String.valueOf(this.parsedVersionCodeAutoIncrement));
        this.project.getProperties().setProperty("android.manifest.versionCodeUpdateFromVersion", String.valueOf(this.parsedVersionCodeUpdateFromVersion));
        this.project.getProperties().setProperty("android.manifest.debuggable", String.valueOf(this.parsedDebuggable));
        if (this.parsedSharedUserId != null) {
            this.project.getProperties().setProperty("android.manifest.sharedUserId", this.parsedSharedUserId);
        }
    }

    private void performVersioCodeAutoIncrement(Element manifestElement) {
        Attr versionCode = manifestElement.getAttributeNode(ATTR_VERSION_CODE);
        int currentVersionCode = 0;
        if (versionCode != null) {
            currentVersionCode = NumberUtils.toInt((String)versionCode.getValue(), (int)0);
        }
        manifestElement.setAttribute(ATTR_VERSION_CODE, String.valueOf(++currentVersionCode));
        this.project.getProperties().setProperty("android.manifest.versionCode", String.valueOf(currentVersionCode));
    }

    private void performVersionCodeUpdateFromVersion(Element manifestElement) throws MojoExecutionException {
        String verString = this.project.getVersion();
        this.getLog().debug((CharSequence)("Generating versionCode for " + verString));
        String verCode = this.generateVersionCodeFromVersionName(verString);
        this.getLog().info((CharSequence)("Setting android:versionCode to " + verCode));
        manifestElement.setAttribute(ATTR_VERSION_CODE, verCode);
        this.project.getProperties().setProperty("android.manifest.versionCode", String.valueOf(verCode));
    }

    private String generateVersionCodeFromVersionName(String versionName) throws MojoExecutionException {
        VersionGenerator gen = new VersionGenerator();
        return Integer.toString(gen.generate(versionName));
    }

    private boolean performSupportScreenModification(Document doc, Element manifestElement) {
        boolean dirty = false;
        Element supportsScreensElem = XmlHelper.getOrCreateElement(doc, manifestElement, ELEM_SUPPORTS_SCREENS);
        this.getLog().info((CharSequence)"Setting supports-screens");
        if (this.parsedSupportsScreens.getAnyDensity() != null) {
            supportsScreensElem.setAttribute(ATTR_ANY_DENSITY, this.parsedSupportsScreens.getAnyDensity());
            dirty = true;
        }
        if (this.parsedSupportsScreens.getSmallScreens() != null) {
            supportsScreensElem.setAttribute(ATTR_SMALL_SCREENS, this.parsedSupportsScreens.getSmallScreens());
            dirty = true;
        }
        if (this.parsedSupportsScreens.getNormalScreens() != null) {
            supportsScreensElem.setAttribute(ATTR_NORMAL_SCREENS, this.parsedSupportsScreens.getNormalScreens());
            dirty = true;
        }
        if (this.parsedSupportsScreens.getLargeScreens() != null) {
            supportsScreensElem.setAttribute(ATTR_LARGE_SCREENS, this.parsedSupportsScreens.getLargeScreens());
            dirty = true;
        }
        if (this.parsedSupportsScreens.getXlargeScreens() != null) {
            supportsScreensElem.setAttribute(ATTR_XLARGE_SCREENS, this.parsedSupportsScreens.getXlargeScreens());
            dirty = true;
        }
        if (this.parsedSupportsScreens.getCompatibleWidthLimitDp() != null) {
            supportsScreensElem.setAttribute(ATTR_COMPATIBLE_WIDTH_LIMIT_DP, this.parsedSupportsScreens.getCompatibleWidthLimitDp());
            dirty = true;
        }
        if (this.parsedSupportsScreens.getLargestWidthLimitDp() != null) {
            supportsScreensElem.setAttribute(ATTR_LARGEST_WIDTH_LIMIT_DP, this.parsedSupportsScreens.getLargestWidthLimitDp());
            dirty = true;
        }
        if (this.parsedSupportsScreens.getRequiresSmallestWidthDp() != null) {
            supportsScreensElem.setAttribute(ATTR_REQUIRES_SMALLEST_WIDTH_DP, this.parsedSupportsScreens.getRequiresSmallestWidthDp());
            dirty = true;
        }
        if (this.parsedSupportsScreens.getResizeable() != null) {
            supportsScreensElem.setAttribute(ATTR_RESIZEABLE, this.parsedSupportsScreens.getResizeable());
            dirty = true;
        }
        return dirty;
    }

    private boolean performUsesSdkModification(Document doc, Element manifestElement) {
        boolean dirty = false;
        Element usesSdkElem = XmlHelper.getOrCreateElement(doc, manifestElement, ELEM_USES_SDK);
        if (this.parsedUsesSdk.getMinSdkVersion() != null) {
            usesSdkElem.setAttribute(ATTR_MIN_SDK_VERSION, this.parsedUsesSdk.getMinSdkVersion());
            dirty = true;
        }
        if (this.parsedUsesSdk.getMaxSdkVersion() != null) {
            usesSdkElem.setAttribute(ATTR_MAX_SDK_VERSION, this.parsedUsesSdk.getMaxSdkVersion());
            dirty = true;
        }
        if (this.parsedUsesSdk.getTargetSdkVersion() != null) {
            usesSdkElem.setAttribute(ATTR_TARGET_SDK_VERSION, this.parsedUsesSdk.getTargetSdkVersion());
            dirty = true;
        }
        return dirty;
    }

    private void updateCompatibleScreens(Document doc, Element manifestElement) {
        Element compatibleScreensElem = XmlHelper.getOrCreateElement(doc, manifestElement, ELEM_COMPATIBLE_SCREENS);
        NodeList manifestScreenElems = compatibleScreensElem.getElementsByTagName(ELEM_SCREEN);
        int numManifestScreens = manifestScreenElems.getLength();
        ArrayList<CompatibleScreen> manifestScreens = new ArrayList<CompatibleScreen>(numManifestScreens);
        for (int i = 0; i < numManifestScreens; ++i) {
            Element screenElem = (Element)manifestScreenElems.item(i);
            CompatibleScreen screen = new CompatibleScreen();
            screen.setScreenDensity(screenElem.getAttribute(ATTR_SCREEN_DENSITY));
            screen.setScreenSize(screenElem.getAttribute(ATTR_SCREEN_SIZE));
            manifestScreens.add(screen);
            this.getLog().debug((CharSequence)("Found Manifest compatible-screen: " + screen));
        }
        XmlHelper.removeDirectChildren(compatibleScreensElem);
        for (CompatibleScreen screen : this.parsedCompatibleScreens) {
            this.getLog().debug((CharSequence)("Found POM compatible-screen: " + screen));
        }
        HashSet<CompatibleScreen> mergedScreens = new HashSet<CompatibleScreen>();
        mergedScreens.addAll(manifestScreens);
        mergedScreens.addAll(this.parsedCompatibleScreens);
        for (CompatibleScreen screen : mergedScreens) {
            this.getLog().debug((CharSequence)("Using compatible-screen: " + screen));
            Element screenElem = doc.createElement(ELEM_SCREEN);
            screenElem.setAttribute(ATTR_SCREEN_SIZE, screen.getScreenSize());
            screenElem.setAttribute(ATTR_SCREEN_DENSITY, screen.getScreenDensity());
            compatibleScreensElem.appendChild(screenElem);
        }
    }

    private boolean updateProviderAuthorities(Element manifestElement) {
        boolean dirty = false;
        NodeList appElems = manifestElement.getElementsByTagName(ELEM_APPLICATION);
        for (int i = 0; i < appElems.getLength(); ++i) {
            Node node = appElems.item(i);
            if (node.getNodeType() != 1) continue;
            NodeList providerElems = manifestElement.getElementsByTagName(ELEM_PROVIDER);
            for (int j = 0; j < providerElems.getLength(); ++j) {
                Node providerNode = providerElems.item(j);
                if (providerNode.getNodeType() != 1) continue;
                Element providerElem = (Element)providerNode;
                Attr providerName = providerElem.getAttributeNode(ATTR_NAME);
                this.getLog().debug((CharSequence)("Checking provider " + providerName.getValue()));
                if (!this.shouldPerformProviderUpdate(providerName)) continue;
                dirty = true;
                String name = providerName.getValue();
                String newAuthorities = this.parsedProviderAuthorities.getProperty(name);
                this.getLog().info((CharSequence)("Updating provider " + name + " authorities attr to " + newAuthorities));
                this.performProviderUpdate(providerElem, newAuthorities);
            }
        }
        return dirty;
    }

    private boolean shouldPerformProviderUpdate(Attr providerName) {
        if (providerName == null) {
            return false;
        }
        for (String propName : this.parsedProviderAuthorities.stringPropertyNames()) {
            if (!propName.equals(providerName.getValue())) continue;
            return true;
        }
        return false;
    }

    private void performProviderUpdate(Element providerElem, String newAuthorities) {
        Attr providerAuthorities = providerElem.getAttributeNode(ATTR_AUTHORITIES);
        providerAuthorities.setValue(newAuthorities);
    }
}

