/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PluginInfo {
    private static final String COLON = ":";
    private static Properties prop;
    private static String groupId;
    private static String artifactId;
    private static String version;

    private static void loadProperties() {
        prop = new Properties();
        InputStream in = PluginInfo.class.getResourceAsStream("plugin.properties");
        try {
            prop.load(in);
            groupId = prop.getProperty("groupId");
            artifactId = prop.getProperty("artifactId");
            version = prop.getProperty("version");
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getGAV() {
        StringBuilder builder = new StringBuilder().append(groupId).append(COLON).append(artifactId).append(COLON).append(version);
        return builder.toString();
    }

    public static String getGroupId() {
        return groupId;
    }

    public static String getArtifactId() {
        return artifactId;
    }

    public static String getVersion() {
        return version;
    }

    public static String getQualifiedGoal(String goal) {
        StringBuilder builder = new StringBuilder().append(groupId).append(COLON).append(artifactId).append(COLON).append(version).append(COLON).append(goal);
        return builder.toString();
    }

    static {
        PluginInfo.loadProperties();
    }
}

