/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.phase08preparepackage;

import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.CommandExecutor;
import com.simpligility.maven.plugins.android.ExecutionException;
import com.simpligility.maven.plugins.android.IncludeExcludeSet;
import com.simpligility.maven.plugins.android.InclusionExclusionResolver;
import com.simpligility.maven.plugins.android.common.ZipExtractor;
import com.simpligility.maven.plugins.android.configuration.Dex;
import com.simpligility.maven.plugins.android.phase08preparepackage.DexCompiler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

@Mojo(name="dex", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class DexMojo
extends AbstractAndroidMojo {
    @Parameter(property="android.dex.compiler", defaultValue="dex")
    private String dexCompiler;
    @Parameter
    private Dex dex;
    @Parameter(property="android.dex.jvmArguments", defaultValue="-Xmx1024M")
    private String[] dexJvmArguments;
    @Parameter(property="android.dex.coreLibrary", defaultValue="false")
    private boolean dexCoreLibrary;
    @Parameter(property="android.dex.noLocals", defaultValue="false")
    private boolean dexNoLocals;
    @Parameter(property="android.dex.optimize", defaultValue="true")
    private boolean dexOptimize;
    @Parameter(property="android.dex.predex", defaultValue="false")
    private boolean dexPreDex;
    @Parameter(property="android.dex.forcejumbo", defaultValue="false")
    private boolean dexForceJumbo;
    @Parameter(property="android.dex.dexPreDexLibLocation", defaultValue="${project.build.directory}${file.separator}dexedLibs")
    private String dexPreDexLibLocation;
    @Parameter(property="android.dex.incremental", defaultValue="false")
    private boolean dexIncremental;
    @Parameter(property="android.proguard.obfuscatedJar")
    private File obfuscatedJar;
    @Parameter(property="android.dex.multidex", defaultValue="false")
    private boolean dexMultiDex;
    @Parameter(property="android.dex.maindexlist")
    private String dexMainDexList;
    @Parameter(property="android.dex.minimalmaindex", defaultValue="false")
    private boolean dexMinimalMainDex;
    @Parameter(property="android.dex.generatemaindexlist", defaultValue="false")
    private boolean dexGenerateMainDexList;
    @Parameter(property="android.dex.dexarguments")
    private String dexArguments;
    @Parameter(property="skipDependencies", defaultValue="false")
    private boolean skipDependencies;
    @Parameter(property="artifactTypeSet")
    private IncludeExcludeSet artifactTypeSet;
    @Parameter(property="artifactSet")
    private IncludeExcludeSet artifactSet;
    private String[] parsedJvmArguments;
    private boolean parsedCoreLibrary;
    private boolean parsedNoLocals;
    private boolean parsedOptimize;
    private boolean parsedPreDex;
    private boolean parsedForceJumbo;
    private String parsedPreDexLibLocation;
    private boolean parsedIncremental;
    private boolean parsedMultiDex;
    private String parsedMainDexList;
    private boolean parsedMinimalMainDex;
    private boolean parsedGenerateMainDexList;
    private String parsedDexArguments;
    private DexCompiler parsedDexCompiler;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File outputFile;
        this.parseConfiguration();
        this.getLog().debug((CharSequence)("DexCompiler set to " + (Object)((Object)this.parsedDexCompiler)));
        if (this.parsedDexCompiler != DexCompiler.DEX) {
            this.getLog().info((CharSequence)("Not executing DexMojo because DEX compiler is set to " + (Object)((Object)this.parsedDexCompiler)));
            return;
        }
        if (this.getJack().isEnabled().booleanValue()) {
            return;
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        if (this.parsedMultiDex) {
            outputFile = this.targetDirectory;
            if (this.parsedGenerateMainDexList) {
                this.getAndroidSdk().assertThatBuildToolsVersionIsAtLeast("22.0.0", "generate main dex list");
                File generatedMainDexClassesList = this.generateMainDexClassesList(executor);
                this.parsedMainDexList = generatedMainDexClassesList.getAbsolutePath();
                this.parsedMinimalMainDex = true;
            }
        } else {
            outputFile = new File(this.targetDirectory, "classes.dex");
        }
        if (this.generateApk) {
            this.runDex(executor, outputFile);
        }
        if (this.attachJar) {
            File jarFile = new File(this.targetDirectory + File.separator + this.finalName + ".jar");
            this.projectHelper.attachArtifact(this.project, "jar", this.project.getArtifact().getClassifier(), jarFile);
        }
        if (this.attachSources) {
            File apksources = this.createApkSourcesFile();
            this.projectHelper.attachArtifact(this.project, "apksources", apksources);
        }
    }

    private Set<File> getDexInputFiles() throws MojoExecutionException {
        HashSet<File> inputs = new HashSet<File>();
        if (this.obfuscatedJar != null && this.obfuscatedJar.exists()) {
            this.getLog().debug((CharSequence)("Adding dex input (obfuscatedJar) : " + this.obfuscatedJar));
            inputs.add(this.obfuscatedJar);
        } else {
            this.getLog().debug((CharSequence)"Using non-obfuscated input");
            inputs.add(this.projectOutputDirectory);
            this.getLog().debug((CharSequence)("Adding dex input : " + this.project.getBuild().getOutputDirectory()));
            for (Artifact artifact : InclusionExclusionResolver.filterArtifacts(this.getTransitiveDependencyArtifacts(new String[0]), this.skipDependencies, this.artifactTypeSet.getIncludes(), this.artifactTypeSet.getExcludes(), this.artifactSet.getIncludes(), this.artifactSet.getExcludes())) {
                if (artifact.getType().equals("so") || artifact.getType().equals("a") || artifact.getType().equals("apklib") || artifact.getType().equals("aar")) continue;
                if (artifact.getType().equals("apk")) {
                    this.getLog().debug((CharSequence)("Extracting APK classes to target/classes : " + artifact.getArtifactId()));
                    File apkClassesJar = this.getUnpackedLibHelper().getJarFileForApk(artifact);
                    this.getLog().debug((CharSequence)("Extracting APK : " + apkClassesJar + " to " + this.targetDirectory));
                    ZipExtractor extractor = new ZipExtractor(this.getLog());
                    extractor.extract(apkClassesJar, this.targetDirectory, ".class");
                    continue;
                }
                this.getLog().debug((CharSequence)("Adding dex input : " + artifact.getFile()));
                inputs.add(artifact.getFile().getAbsoluteFile());
            }
        }
        return inputs;
    }

    private void parseConfiguration() {
        if (this.dex != null) {
            this.parsedJvmArguments = this.dex.getJvmArguments() == null ? this.dexJvmArguments : this.dex.getJvmArguments();
            this.parsedCoreLibrary = this.dex.isCoreLibrary() == null ? this.dexCoreLibrary : this.dex.isCoreLibrary();
            this.parsedNoLocals = this.dex.isNoLocals() == null ? this.dexNoLocals : this.dex.isNoLocals();
            this.parsedOptimize = this.dex.isOptimize() == null ? this.dexOptimize : this.dex.isOptimize();
            this.parsedPreDex = this.dex.isPreDex() == null ? this.dexPreDex : this.dex.isPreDex();
            this.parsedPreDexLibLocation = this.dex.getPreDexLibLocation() == null ? this.dexPreDexLibLocation : this.dex.getPreDexLibLocation();
            this.parsedIncremental = this.dex.isIncremental() == null ? this.dexIncremental : this.dex.isIncremental();
            this.parsedForceJumbo = this.dex.isForceJumbo() == null ? this.dexForceJumbo : this.dex.isForceJumbo();
            this.parsedMultiDex = this.dex.isMultiDex() == null ? this.dexMultiDex : this.dex.isMultiDex();
            this.parsedMainDexList = this.dex.getMainDexList() == null ? this.dexMainDexList : this.dex.getMainDexList();
            this.parsedMinimalMainDex = this.dex.isMinimalMainDex() == null ? this.dexMinimalMainDex : this.dex.isMinimalMainDex();
            this.parsedGenerateMainDexList = this.dex.isGenerateMainDexList() == null ? this.dexGenerateMainDexList : this.dex.isGenerateMainDexList();
            this.parsedDexArguments = this.dex.getDexArguments() == null ? this.dexArguments : this.dex.getDexArguments();
            this.parsedDexCompiler = DexCompiler.valueOfIgnoreCase(this.dexCompiler);
        } else {
            this.parsedJvmArguments = this.dexJvmArguments;
            this.parsedCoreLibrary = this.dexCoreLibrary;
            this.parsedNoLocals = this.dexNoLocals;
            this.parsedOptimize = this.dexOptimize;
            this.parsedPreDex = this.dexPreDex;
            this.parsedPreDexLibLocation = this.dexPreDexLibLocation;
            this.parsedIncremental = this.dexIncremental;
            this.parsedForceJumbo = this.dexForceJumbo;
            this.parsedMultiDex = this.dexMultiDex;
            this.parsedMainDexList = this.dexMainDexList;
            this.parsedMinimalMainDex = this.dexMinimalMainDex;
            this.parsedGenerateMainDexList = this.dexGenerateMainDexList;
            this.parsedDexArguments = this.dexArguments;
            this.parsedDexCompiler = DexCompiler.valueOfIgnoreCase(this.dexCompiler);
        }
    }

    private Set<File> preDex(CommandExecutor executor, Set<File> inputFiles) throws MojoExecutionException {
        HashSet<File> filtered = new HashSet<File>();
        this.getLog().info((CharSequence)"Pre dex-ing libraries for faster dex-ing of the final application.");
        for (File inputFile : inputFiles) {
            if (inputFile.getName().matches(".*\\.jar$")) {
                List<String> commands = this.dexDefaultCommands();
                File predexJar = this.predexJarPath(inputFile);
                commands.add("--output=" + predexJar.getAbsolutePath());
                commands.add(inputFile.getAbsolutePath());
                filtered.add(predexJar);
                if (predexJar.isFile() && predexJar.lastModified() >= inputFile.lastModified()) continue;
                this.getLog().info((CharSequence)("Pre-dex ing jar: " + inputFile.getAbsolutePath()));
                this.executeJava(commands, executor);
                continue;
            }
            filtered.add(inputFile);
        }
        return filtered;
    }

    private File predexJarPath(File inputFile) {
        File predexLibsDirectory = new File(this.parsedPreDexLibLocation.trim());
        predexLibsDirectory.mkdirs();
        return new File(predexLibsDirectory, inputFile.getName());
    }

    private List<String> dexDefaultCommands() throws MojoExecutionException {
        List<String> commands = this.jarDefaultCommands();
        commands.add(this.getAndroidSdk().getDxJarPath());
        commands.add("--dex");
        return commands;
    }

    private List<String> jarDefaultCommands() {
        List<String> commands = this.javaDefaultCommands();
        commands.add("-jar");
        return commands;
    }

    private List<String> javaDefaultCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        if (this.parsedJvmArguments != null) {
            for (String jvmArgument : this.parsedJvmArguments) {
                if (!jvmArgument.startsWith("-")) {
                    jvmArgument = "-" + jvmArgument;
                }
                this.getLog().debug((CharSequence)("Adding jvm argument " + jvmArgument));
                commands.add(jvmArgument);
            }
        }
        return commands;
    }

    private void runDex(CommandExecutor executor, File outputFile) throws MojoExecutionException {
        Set<File> inputFiles;
        List<String> commands = this.dexDefaultCommands();
        Set<File> filteredFiles = inputFiles = this.getDexInputFiles();
        if (this.parsedPreDex) {
            filteredFiles = this.preDex(executor, inputFiles);
        }
        if (!this.parsedOptimize) {
            commands.add("--no-optimize");
        }
        if (this.parsedCoreLibrary) {
            commands.add("--core-library");
        }
        if (this.parsedIncremental) {
            commands.add("--incremental");
        }
        if (this.parsedNoLocals) {
            commands.add("--no-locals");
        }
        if (this.parsedForceJumbo) {
            commands.add("--force-jumbo");
        }
        if (this.parsedMultiDex) {
            commands.add("--multi-dex");
            if (this.parsedMainDexList != null) {
                commands.add("--main-dex-list=" + this.parsedMainDexList);
            }
            if (this.parsedMinimalMainDex) {
                commands.add("--minimal-main-dex");
            }
        }
        if (this.parsedDexArguments != null) {
            commands.add(this.parsedDexArguments);
        }
        commands.add("--output=" + outputFile.getAbsolutePath());
        for (File inputFile : filteredFiles) {
            commands.add(inputFile.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("Convert classes to Dex : " + outputFile));
        this.executeJava(commands, executor);
    }

    private String executeJava(List<String> commands, CommandExecutor executor) throws MojoExecutionException {
        String javaExecutable = DexMojo.getJavaExecutable().getAbsolutePath();
        this.getLog().debug((CharSequence)(javaExecutable + " " + commands.toString()));
        try {
            executor.setCaptureStdOut(true);
            executor.executeCommand(javaExecutable, commands, this.project.getBasedir(), false);
            return executor.getStandardOut();
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private static File getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        String slash = File.separator;
        return new File(javaHome + slash + "bin" + slash + "java");
    }

    private File generateMainDexClassesJar(CommandExecutor executor) throws MojoExecutionException {
        List<String> commands = this.jarDefaultCommands();
        commands.add(this.getAndroidSdk().getProguardJarPath());
        commands.add("-dontnote");
        commands.add("-dontwarn");
        commands.add("-forceprocessing");
        commands.add("-dontoptimize");
        commands.add("-dontpreverify");
        commands.add("-dontobfuscate");
        Set<File> inputFiles = this.getDexInputFiles();
        for (File inputFile : inputFiles) {
            commands.add("-injars");
            commands.add(inputFile.getAbsolutePath() + "(!META-INF/**)");
        }
        commands.add("-libraryjars");
        commands.add(this.getAndroidSdk().getShrinkedAndroidJarPath());
        commands.add("-include");
        commands.add(this.getAndroidSdk().getMainDexClassesRulesPath());
        commands.add("-outjars");
        File mainDexClassesJar = new File(this.targetDirectory, "mainDexClasses.jar");
        commands.add(mainDexClassesJar.getAbsolutePath());
        this.getLog().info((CharSequence)("Generating main dex classes jar : " + mainDexClassesJar));
        this.executeJava(commands, executor);
        return mainDexClassesJar;
    }

    private File generateMainDexClassesList(CommandExecutor executor) throws MojoExecutionException {
        File mainDexClassesJar = this.generateMainDexClassesJar(executor);
        List<String> commands = this.javaDefaultCommands();
        commands.add("-Djava.ext.dirs=" + this.getAndroidSdk().getBuildToolsLibDirectoryPath());
        commands.add("com.android.multidex.MainDexListBuilder");
        commands.add(mainDexClassesJar.getAbsolutePath());
        Set<File> inputFiles = this.getDexInputFiles();
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.join(inputFiles, (char)File.pathSeparatorChar));
        commands.add(sb.toString());
        File mainDexClassesList = new File(this.targetDirectory, "mainDexClasses.txt");
        this.getLog().info((CharSequence)("Generating main dex classes list : " + mainDexClassesList));
        String output = this.executeJava(commands, executor);
        try {
            FileUtils.writeStringToFile((File)mainDexClassesList, (String)output);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to write command output with main dex classes list to " + mainDexClassesList, (Exception)ex);
        }
        return mainDexClassesList;
    }

    protected File createApkSourcesFile() throws MojoExecutionException {
        File apksources = new File(this.targetDirectory, this.finalName + ".apksources");
        FileUtils.deleteQuietly((File)apksources);
        try {
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(apksources);
            this.addDirectory(jarArchiver, this.assetsDirectory, "assets");
            this.addDirectory(jarArchiver, this.resourceDirectory, "res");
            this.addDirectory(jarArchiver, this.sourceDirectory, "src/main/java");
            this.addJavaResources(jarArchiver, this.resources);
            jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating .apksource file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating .apksource file.", (Exception)e);
        }
        return apksources;
    }

    protected String endWithSlash(String prefix) {
        if (!(prefix = (String)StringUtils.defaultIfEmpty((CharSequence)prefix, (CharSequence)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void addDirectory(JarArchiver jarArchiver, File directory, String prefix) {
        if (directory != null && directory.exists()) {
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setPrefix(this.endWithSlash(prefix));
            fileSet.setDirectory(directory);
            jarArchiver.addFileSet((FileSet)fileSet);
        }
    }

    protected void addJavaResources(JarArchiver jarArchiver, List<Resource> javaResources) {
        for (Resource javaResource : javaResources) {
            this.addJavaResource(jarArchiver, javaResource);
        }
    }

    protected void addJavaResource(JarArchiver jarArchiver, Resource javaResource) {
        File javaResourceDirectory;
        if (javaResource != null && (javaResourceDirectory = new File(javaResource.getDirectory())).exists()) {
            DefaultFileSet javaResourceFileSet = new DefaultFileSet();
            javaResourceFileSet.setDirectory(javaResourceDirectory);
            javaResourceFileSet.setPrefix(this.endWithSlash("src/main/resources"));
            jarArchiver.addFileSet((FileSet)javaResourceFileSet);
        }
    }
}

