/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.standalonemojos;

import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.CommandExecutor;
import com.simpligility.maven.plugins.android.common.JarHelper;
import com.simpligility.maven.plugins.android.config.ConfigPojo;
import com.simpligility.maven.plugins.android.config.PullParameter;
import com.simpligility.maven.plugins.android.configuration.MetaInf;
import com.simpligility.maven.plugins.android.configuration.Unpack;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="unpack", requiresDependencyResolution=ResolutionScope.COMPILE)
public class UnpackMojo
extends AbstractAndroidMojo {
    @Deprecated
    @Parameter(property="android.lazyLibraryUnpack")
    private boolean lazyLibraryUnpack;
    @PullParameter(defaultValueGetterMethod="getDefaultMetaInf")
    private MetaInf unpackMetaInf;
    @PullParameter(defaultValueGetterMethod="getLazyLibraryUnpack")
    @Parameter(property="android.unpack.lazy")
    private Boolean unpackLazy;
    @Parameter(alias="metaInf")
    private MetaInf pluginMetaInf;
    @ConfigPojo(prefix="unpack")
    @Parameter
    private Unpack unpack;
    @Parameter(defaultValue="${project.build.directory}/android-classes", readonly=true)
    private File unpackOutputDirectory;
    @Parameter(defaultValue="false", readonly=true)
    private boolean includeNonClassFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        if (this.generateApk) {
            this.unpackClasses();
        }
    }

    private File unpackClasses() throws MojoExecutionException {
        File outputDirectory = this.unpackOutputDirectory;
        if (this.lazyLibraryUnpack && outputDirectory.exists()) {
            this.getLog().info((CharSequence)"skip library unpacking due to lazyLibraryUnpack policy");
        } else {
            outputDirectory.mkdirs();
            for (Artifact artifact : this.getRelevantCompileArtifacts()) {
                if (artifact.getFile().isDirectory()) {
                    try {
                        FileUtils.copyDirectory((File)artifact.getFile(), (File)outputDirectory);
                        continue;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("IOException while copying " + artifact.getFile().getAbsolutePath() + " into " + outputDirectory.getAbsolutePath(), (Exception)e);
                    }
                }
                try {
                    JarHelper.unjar(new JarFile(artifact.getFile()), outputDirectory, new JarHelper.UnjarListener(){

                        @Override
                        public boolean include(JarEntry jarEntry) {
                            return UnpackMojo.this.isIncluded(jarEntry);
                        }
                    });
                }
                catch (IOException e) {
                    throw new MojoExecutionException("IOException while unjarring " + artifact.getFile().getAbsolutePath() + " into " + outputDirectory.getAbsolutePath(), (Exception)e);
                }
            }
        }
        try {
            if (!this.projectOutputDirectory.equals(outputDirectory)) {
                FileUtils.copyDirectory((File)this.projectOutputDirectory, (File)outputDirectory);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while copying " + this.sourceDirectory.getAbsolutePath() + " into " + outputDirectory.getAbsolutePath(), (Exception)e);
        }
        return outputDirectory;
    }

    boolean isIncluded(JarEntry jarEntry) {
        String entName = jarEntry.getName();
        if (entName.endsWith(".class")) {
            return true;
        }
        if (this.includeNonClassFiles && !entName.startsWith("META-INF/")) {
            return true;
        }
        return this.unpackMetaInf != null && this.unpackMetaInf.isIncluded(entName);
    }

    MetaInf getDefaultMetaInf() {
        return this.pluginMetaInf;
    }

    boolean getLazyLibraryUnpack() {
        return this.lazyLibraryUnpack;
    }
}

