/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.requests.searches.queries.geo;

import com.sksamuel.elastic4s.Index;
import com.sksamuel.elastic4s.XContentBuilder;
import com.sksamuel.elastic4s.XContentFactory$;
import com.sksamuel.elastic4s.requests.common.DistanceUnit;
import com.sksamuel.elastic4s.requests.searches.GeoPoint;
import com.sksamuel.elastic4s.requests.searches.queries.geo.CircleShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.EnvelopeShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.GeoShapeQuery;
import com.sksamuel.elastic4s.requests.searches.queries.geo.GeometryCollectionShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.InlineShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.LineStringShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.MultiLineStringShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.MultiPointShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.MultiPolygonShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.PointShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.PolygonShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.PreindexedShape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.Shape;
import com.sksamuel.elastic4s.requests.searches.queries.geo.ShapeDefinition;
import com.sksamuel.elastic4s.requests.searches.queries.geo.Shapes;
import com.sksamuel.elastic4s.requests.searches.queries.geo.SingleShape;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GeoShapeQueryBodyFn$ {
    public static final GeoShapeQueryBodyFn$ MODULE$ = new GeoShapeQueryBodyFn$();

    private double[] coordinates(GeoPoint point) {
        return new double[]{point.long(), point.lat()};
    }

    public XContentBuilder apply(GeoShapeQuery q) {
        XContentBuilder xContentBuilder;
        InlineShape inlineShape;
        ShapeDefinition shape;
        XContentBuilder builder = XContentFactory$.MODULE$.jsonBuilder();
        builder.startObject("geo_shape");
        builder.startObject(q.field());
        Shape shape2 = q.shape();
        if (shape2 instanceof InlineShape && (shape = (inlineShape = (InlineShape)shape2).shape()) != null) {
            ShapeDefinition shapeDefinition = shape;
            builder.startObject("shape");
            this.buildShapeDefinition(shapeDefinition, builder);
            xContentBuilder = builder.endObject();
        } else if (shape2 instanceof PreindexedShape) {
            PreindexedShape preindexedShape = (PreindexedShape)shape2;
            String id = preindexedShape.id();
            Index index = preindexedShape.index();
            String tpe = preindexedShape.type();
            String path = preindexedShape.path();
            builder.startObject("indexed_shape");
            builder.field("id", id);
            builder.field("index", index.name());
            builder.field("type", tpe);
            builder.field("path", path);
            xContentBuilder = builder.endObject();
        } else {
            throw new MatchError((Object)shape2);
        }
        q.relation().map((Function1 & Serializable)x$1 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$1.getClass().getSimpleName().toLowerCase()), "$")).foreach((Function1 & Serializable)x$2 -> builder.field("relation", (String)x$2));
        q.ignoreUnmapped().foreach((Function1 & Serializable)x$3 -> builder.field("ignore_unmapped", BoxesRunTime.unboxToBoolean((Object)x$3)));
        q.boost().foreach((Function1 & Serializable)x$4 -> builder.field("boost", BoxesRunTime.unboxToDouble((Object)x$4)));
        q.queryName().foreach((Function1 & Serializable)x$5 -> builder.field("_name", (String)x$5));
        return builder.endObject().endObject();
    }

    private XContentBuilder buildShapeDefinition(ShapeDefinition shape, XContentBuilder builder) {
        XContentBuilder xContentBuilder;
        ShapeDefinition shapeDefinition = shape;
        if (shapeDefinition instanceof SingleShape) {
            SingleShape singleShape = (SingleShape)shapeDefinition;
            xContentBuilder = this.buildSingleShape(singleShape, builder);
        } else if (shapeDefinition instanceof GeometryCollectionShape) {
            GeometryCollectionShape geometryCollectionShape = (GeometryCollectionShape)shapeDefinition;
            builder.field("type", shape.geoShapeType().toString().toLowerCase());
            builder.startArray("geometries");
            geometryCollectionShape.shapes().foreach((Function1 & Serializable)s -> {
                builder.startObject();
                MODULE$.buildShapeDefinition((ShapeDefinition)s, builder);
                return builder.endObject();
            });
            xContentBuilder = builder.endArray();
        } else {
            throw new MatchError((Object)shapeDefinition);
        }
        return xContentBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XContentBuilder buildSingleShape(SingleShape shape, XContentBuilder builder) {
        CircleShape circleShape;
        Shapes.Circle circle;
        builder.field("type", shape.geoShapeType().toString().toLowerCase());
        SingleShape singleShape = shape;
        if (singleShape instanceof PointShape) {
            PointShape pointShape = (PointShape)singleShape;
            GeoPoint point = pointShape.point();
            return builder.array("coordinates", this.coordinates(point));
        }
        if (singleShape instanceof EnvelopeShape) {
            EnvelopeShape envelopeShape = (EnvelopeShape)singleShape;
            GeoPoint upperLeft = envelopeShape.upperLeft();
            GeoPoint lowerRight = envelopeShape.lowerRight();
            return builder.array("coordinates", (double[][])((Object[])new double[][]{this.coordinates(upperLeft), this.coordinates(lowerRight)}));
        }
        if (singleShape instanceof MultiPointShape) {
            MultiPointShape multiPointShape = (MultiPointShape)singleShape;
            Seq<GeoPoint> points = multiPointShape.points();
            return builder.array("coordinates", (double[][])((IterableOnceOps)points.map((Function1 & Serializable)x$6 -> (double[])Predef$.MODULE$.identity((Object)MODULE$.coordinates((GeoPoint)x$6)))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        }
        if (singleShape instanceof LineStringShape) {
            LineStringShape lineStringShape = (LineStringShape)singleShape;
            GeoPoint first = lineStringShape.p1();
            GeoPoint second = lineStringShape.p2();
            Seq<GeoPoint> remaining = lineStringShape.path();
            GeoPoint geoPoint = first;
            GeoPoint geoPoint2 = second;
            List points = remaining.toList().$colon$colon((Object)geoPoint2).$colon$colon((Object)geoPoint);
            return builder.array("coordinates", (double[][])points.map((Function1 & Serializable)x$7 -> (double[])Predef$.MODULE$.identity((Object)MODULE$.coordinates((GeoPoint)x$7))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        }
        if (singleShape instanceof MultiLineStringShape) {
            MultiLineStringShape multiLineStringShape = (MultiLineStringShape)singleShape;
            Seq<Seq<GeoPoint>> points = multiLineStringShape.coordinates();
            return builder.array("coordinates", (double[][][])((IterableOnceOps)points.map((Function1 & Serializable)x$8 -> (double[][])((IterableOnceOps)x$8.map((Function1 & Serializable)x$9 -> (double[])Predef$.MODULE$.identity((Object)MODULE$.coordinates((GeoPoint)x$9)))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
        }
        if (singleShape instanceof CircleShape && (circle = (circleShape = (CircleShape)singleShape).circle()) != null) {
            GeoPoint point = circle.point();
            Tuple2<Object, DistanceUnit> tuple2 = circle.distance();
            if (tuple2 != null) {
                double radius = tuple2._1$mcD$sp();
                DistanceUnit unit = (DistanceUnit)tuple2._2();
                builder.array("coordinates", this.coordinates(point));
                return builder.field("radius", new StringBuilder(1).append(unit.toMeters(radius)).append("m").toString());
            }
        }
        if (singleShape instanceof PolygonShape) {
            PolygonShape polygonShape = (PolygonShape)singleShape;
            Shapes.Polygon p = polygonShape.polygon();
            Seq coords = (Seq)p.holes().fold((Function0 & Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{p.points()})), (Function1 & Serializable)h -> (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{p.points()})).$plus$plus((IterableOnce)h));
            return builder.array("coordinates", (double[][][])((IterableOnceOps)coords.map((Function1 & Serializable)x$10 -> (double[][])((IterableOnceOps)x$10.map((Function1 & Serializable)x$11 -> (double[])Predef$.MODULE$.identity((Object)MODULE$.coordinates((GeoPoint)x$11)))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
        }
        if (!(singleShape instanceof MultiPolygonShape)) throw new MatchError((Object)singleShape);
        MultiPolygonShape multiPolygonShape = (MultiPolygonShape)singleShape;
        Seq<Shapes.Polygon> polygons = multiPolygonShape.coordinate();
        Seq coords = (Seq)polygons.map((Function1 & Serializable)x0$1 -> {
            Shapes.Polygon polygon = x0$1;
            if (polygon == null) {
                throw new MatchError((Object)polygon);
            }
            Seq<GeoPoint> points = polygon.points();
            Option<Seq<Seq<GeoPoint>>> holes = polygon.holes();
            double[][][] dArray = (double[][][])((IterableOnceOps)((IterableOps)holes.fold((Function0 & Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{points})), (Function1 & Serializable)h -> (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{points})).$plus$plus((IterableOnce)h))).map((Function1 & Serializable)x$12 -> (double[][])((IterableOnceOps)x$12.map((Function1 & Serializable)x$13 -> (double[])Predef$.MODULE$.identity((Object)MODULE$.coordinates((GeoPoint)x$13)))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
            return dArray;
        });
        return builder.array("coordinates", (double[][][][])coords.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))))));
    }

    private GeoShapeQueryBodyFn$() {
    }
}

