/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdministrationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.common.TopicAndPartition;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class PreferredReplicaLeaderElectionCommand$
implements Logging {
    public static final PreferredReplicaLeaderElectionCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new PreferredReplicaLeaderElectionCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PreferredReplicaLeaderElectionCommand$ preferredReplicaLeaderElectionCommand$ = this;
        synchronized (preferredReplicaLeaderElectionCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("path-to-json-file", "The JSON file with the list of partitions for which preferred replica leader election should be done, in the following format - \n{\"partitions\":\n\t[{\"topic\": \"foo\", \"partition\": 1},\n\t {\"topic\": \"foobar\", \"partition\": 2}]\n}\nDefaults to all existing partitions").withRequiredArg().describedAs("list of partitions for which preferred replica leader election needs to be triggered").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        OptionSet optionSet = optionParser.parse(stringArray);
        CommandLineUtils$.MODULE$.checkRequiredArgs(optionParser, optionSet, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{argumentAcceptingOptionSpec2}));
        String string = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2);
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(string, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            Set<TopicAndPartition> set = optionSet.has((OptionSpec)argumentAcceptingOptionSpec) ? this.parsePreferredReplicaElectionData(Utils$.MODULE$.readFileAsString((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec), Utils$.MODULE$.readFileAsString$default$2())) : ZkUtils$.MODULE$.getAllPartitions(zkClient);
            PreferredReplicaLeaderElectionCommand preferredReplicaLeaderElectionCommand = new PreferredReplicaLeaderElectionCommand(zkClient, set);
            preferredReplicaLeaderElectionCommand.moveLeaderToPreferredReplica();
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Successfully started preferred replica election for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{set})));
        }
        catch (Exception exception) {
            Predef$.MODULE$.println((Object)"Failed to start preferred replica election");
            Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(exception));
        }
        finally {
            if (zkClient != null) {
                zkClient.close();
            }
        }
    }

    public scala.collection.immutable.Set<TopicAndPartition> parsePreferredReplicaElectionData(String string) {
        Option<Object> option = Json$.MODULE$.parseFull(string);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object object = some.x();
            Option option2 = ((Map)object).get((Object)"partitions");
            if (option2 instanceof Some) {
                scala.collection.immutable.Set set;
                Some some2 = (Some)option2;
                Object object2 = some2.x();
                List list = (List)object2;
                scala.collection.immutable.Set set2 = set = ((TraversableOnce)list.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final TopicAndPartition apply(Map<String, Object> map) {
                        String string = (String)map.get((Object)"topic").get();
                        int n = BoxesRunTime.unboxToInt((Object)map.get((Object)"partition").get());
                        return new TopicAndPartition(string, n);
                    }
                }, List$.MODULE$.canBuildFrom())).toSet();
                return set2;
            }
            None$ none$ = None$.MODULE$;
            Option option3 = option2;
            if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                throw new AdministrationException("Preferred replica election data is empty");
            }
            throw new MatchError((Object)option2);
        }
        None$ none$ = None$.MODULE$;
        Option<Object> option4 = option;
        if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
            throw new AdministrationException("Preferred replica election data is empty");
        }
        throw new MatchError(option);
    }

    public void writePreferredReplicaElectionData(ZkClient zkClient, Set<TopicAndPartition> set) {
        String string = ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath();
        ObjectRef objectRef = new ObjectRef((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        set.foreach((Function1)new Serializable(objectRef){
            public static final long serialVersionUID = 0L;
            private final ObjectRef partitionsData$1;

            public final ListBuffer<String> apply(TopicAndPartition topicAndPartition) {
                return ((ListBuffer)this.partitionsData$1.elem).$plus$eq((Object)Utils$.MODULE$.mergeJsonFields((Seq<String>)((Seq)Utils$.MODULE$.mapToJsonFields((Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic"), (Object)topicAndPartition.topic())}))), true).$plus$plus(Utils$.MODULE$.mapToJsonFields((Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)topicAndPartition.partition())).toString())}))), false), Seq$.MODULE$.canBuildFrom()))));
            }
            {
                this.partitionsData$1 = objectRef;
            }
        });
        String string2 = Utils$.MODULE$.seqToJson((Seq<String>)((ListBuffer)objectRef.elem), false);
        String string3 = Utils$.MODULE$.mapToJson((Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)((Object)BoxesRunTime.boxToInteger((int)1)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partitions"), (Object)string2)}))), false);
        try {
            ZkUtils$.MODULE$.createPersistentPath(zkClient, string, string3);
            this.info((Function0<String>)new Serializable(string3){
                public static final long serialVersionUID = 0L;
                private final String jsonData$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Created preferred replica election path with %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jsonData$1}));
                }
                {
                    this.jsonData$1 = string;
                }
            });
            return;
        }
        catch (Exception exception) {
            throw new AdministrationException(exception.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            scala.collection.immutable.Set<TopicAndPartition> set2 = this.parsePreferredReplicaElectionData((String)ZkUtils$.MODULE$.readData(zkClient, string)._1());
            throw new AdministrationException(new StringBuilder().append((Object)"Preferred replica leader election currently in progress for ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%s. Aborting operation")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{set2}))).toString());
        }
    }

    private PreferredReplicaLeaderElectionCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

