/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerStats$;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.controller.ReplicaStateMachine$BrokerChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0004\u0001\t\u0005\t\u0015!\u0003\u0016!\t1r#D\u0001\u0003\u0013\tA\"AA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0011A$\b\t\u0003-\u0001AQaA\rA\u0002UAqa\b\u0001C\u0002\u0013%\u0001%A\td_:$(o\u001c7mKJ\u001cuN\u001c;fqR,\u0012!\t\t\u0003-\tJ!a\t\u0002\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0003\u0004&\u0001\u0001\u0006I!I\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0003%\u0002\"!\u0003\u0016\n\u0005-R!aA%oi\"1Q\u0006\u0001Q\u0001\n%\nQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\tu.\u001cE.[3oiV\t\u0011\u0007\u0005\u00023s5\t1G\u0003\u00025k\u0005A!p[2mS\u0016tGO\u0003\u00027o\u00051\u0011\nM%uK\u000eT\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e4\u0005!Q6n\u00117jK:$\bB\u0002\u001f\u0001A\u0003%\u0011'A\u0005{W\u000ec\u0017.\u001a8uA!9a\b\u0001a\u0001\n\u0003y\u0014\u0001\u0004:fa2L7-Y*uCR,W#\u0001!\u0011\t\u00053\u0005JU\u0007\u0002\u0005*\u00111\tR\u0001\b[V$\u0018M\u00197f\u0015\t)%\"\u0001\u0006d_2dWm\u0019;j_:L!a\u0012\"\u0003\u00075\u000b\u0007\u000fE\u0003\n\u0013.K\u0013&\u0003\u0002K\u0015\t1A+\u001e9mKN\u0002\"\u0001T(\u000f\u0005%i\u0015B\u0001(\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059S\u0001C\u0001\fT\u0013\t!&A\u0001\u0007SKBd\u0017nY1Ti\u0006$X\rC\u0004W\u0001\u0001\u0007I\u0011A,\u0002!I,\u0007\u000f\\5dCN#\u0018\r^3`I\u0015\fHC\u0001-\\!\tI\u0011,\u0003\u0002[\u0015\t!QK\\5u\u0011\u001daV+!AA\u0002\u0001\u000b1\u0001\u001f\u00132\u0011\u0019q\u0006\u0001)Q\u0005\u0001\u0006i!/\u001a9mS\u000e\f7\u000b^1uK\u0002Bq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011-\u0001\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eDW#\u00012\u0011\u0005Y\u0019\u0017B\u00013\u0003\u0005q\u0019uN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"DaA\u001a\u0001!\u0002\u0013\u0011\u0017a\u00052s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\u0003b\u00025\u0001\u0005\u0004%I![\u0001\u000bQ\u0006\u001c8\u000b^1si\u0016$W#\u00016\u0011\u0005-$X\"\u00017\u000b\u00055t\u0017AB1u_6L7M\u0003\u0002pa\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005E\u0014\u0018\u0001B;uS2T\u0011a]\u0001\u0005U\u00064\u0018-\u0003\u0002vY\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:Daa\u001e\u0001!\u0002\u0013Q\u0017a\u00035bgN#\u0018M\u001d;fI\u0002Bq!\u001f\u0001C\u0002\u0013%!0A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ,\u0012a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018!\u00027pORR'bAA\u0001o\u00051\u0011\r]1dQ\u0016L1!!\u0002~\u0005\u0019aunZ4fe\"9\u0011\u0011\u0002\u0001!\u0002\u0013Y\u0018AE:uCR,7\t[1oO\u0016dunZ4fe\u0002Bq!!\u0004\u0001\t\u0003\ty!A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003aCq!a\u0005\u0001\t\u0003\ty!A\tsK\u001eL7\u000f^3s\u0019&\u001cH/\u001a8feNDq!a\u0006\u0001\t\u0003\ty!\u0001\u0005tQV$Hm\\<o\u0011\u001d\tY\u0002\u0001C\u0001\u0003;\t!\u0003[1oI2,7\u000b^1uK\u000eC\u0017M\\4fgR)\u0001,a\b\u00022!A\u0011\u0011EA\r\u0001\u0004\t\u0019#\u0001\u0005sKBd\u0017nY1t!\u0019\t)#a\n\u0002,5\tA)C\u0002\u0002*\u0011\u00131aU3u!\r1\u0012QF\u0005\u0004\u0003_\u0011!a\u0005)beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0007bBA\u001a\u00033\u0001\rAU\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\rC\u0004\u00028\u0001!\t!!\u000f\u0002#!\fg\u000e\u001a7f'R\fG/Z\"iC:<W\rF\u0005Y\u0003w\ty$a\u0011\u0002H!9\u0011QHA\u001b\u0001\u0004Y\u0015!\u0002;pa&\u001c\u0007bBA!\u0003k\u0001\r!K\u0001\na\u0006\u0014H/\u001b;j_:Dq!!\u0012\u00026\u0001\u0007\u0011&A\u0005sKBd\u0017nY1JI\"9\u00111GA\u001b\u0001\u0004\u0011\u0006bBA&\u0001\u0011%\u0011QJ\u0001\u001aCN\u001cXM\u001d;WC2LG\r\u0015:fm&|Wo]*uCR,7\u000fF\u0006Y\u0003\u001f\n\t&a\u0015\u0002V\u0005}\u0003bBA\u001f\u0003\u0013\u0002\ra\u0013\u0005\b\u0003\u0003\nI\u00051\u0001*\u0011\u001d\t)%!\u0013A\u0002%B\u0001\"a\u0016\u0002J\u0001\u0007\u0011\u0011L\u0001\u000bMJ|Wn\u0015;bi\u0016\u001c\b#BA\u0013\u00037\u0012\u0016bAA/\t\n\u00191+Z9\t\u000f\u0005M\u0012\u0011\na\u0001%\"9\u00111\r\u0001\u0005\n\u0005\u0015\u0014\u0001\b:fO&\u001cH/\u001a:Ce>\\WM]\"iC:<W\rT5ti\u0016tWM\u001d\u000b\u0003\u0003O\u0002b!!\u001b\u0002l\u0005=T\"\u00019\n\u0007\u00055\u0004O\u0001\u0003MSN$\b\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005U$/\u0001\u0003mC:<\u0017b\u0001)\u0002t!9\u00111\u0010\u0001\u0005\n\u0005=\u0011AF5oSRL\u0017\r\\5{KJ+\u0007\u000f\\5dCN#\u0018\r^3\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\u00061r-\u001a;BY2\u0014V\r\u001d7jG\u0006\u001cxJ\u001c\"s_.,'\u000f\u0006\u0004\u0002$\u0005\r\u0015\u0011\u0012\u0005\t\u0003\u000b\u000bi\b1\u0001\u0002\b\u00061Ao\u001c9jGN\u0004R!!\n\u0002\\-C\u0001\"a#\u0002~\u0001\u0007\u0011QR\u0001\nEJ|7.\u001a:JIN\u0004R!!\n\u0002\\%Bq!!%\u0001\t\u0003\t\u0019*A\u000fhKR\u0004\u0016M\u001d;ji&|gn]!tg&<g.\u001a3U_\n\u0013xn[3s)\u0019\t)*a)\u0002&B1\u0011QEA.\u0003/\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;#\u0011AB2p[6|g.\u0003\u0003\u0002\"\u0006m%!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"A\u0011QQAH\u0001\u0004\t9\tC\u0004\u0002(\u0006=\u0005\u0019A\u0015\u0002\u0011\t\u0014xn[3s\u0013\u00124a!a+\u0001\u0001\u00055&\u0001\u0006\"s_.,'o\u00115b]\u001e,G*[:uK:,'oE\u0004\u0002*\u0006=\u0016Q\u0017\b\u0011\t\u0005E\u0014\u0011W\u0005\u0005\u0003g\u000b\u0019H\u0001\u0004PE*,7\r\u001e\t\u0004e\u0005]\u0016bAA]g\t\u0001\u0012JW6DQ&dG\rT5ti\u0016tWM\u001d\u0005\b5\u0005%F\u0011AA_)\t\ty\f\u0005\u0003\u0002B\u0006%V\"\u0001\u0001\t\u0011\u0005\u0015\u0017\u0011\u0016C\u0001\u0003\u000f\f\u0011\u0003[1oI2,7\t[5mI\u000eC\u0017M\\4f)\u0015A\u0016\u0011ZAg\u0011\u001d\tY-a1A\u0002-\u000b!\u0002]1sK:$\b+\u0019;i\u0011!\ty-a1A\u0002\u0005E\u0017!E2veJ,g\u000e\u001e\"s_.,'\u000fT5tiB)\u0011\u0011NA6\u0017\u0002")
public class ReplicaStateMachine
implements Logging {
    public final KafkaController kafka$controller$ReplicaStateMachine$$controller;
    private final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$ReplicaStateMachine$$zkClient;
    private Map<Tuple3<String, Object, Object>, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext() {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public ZkClient kafka$controller$ReplicaStateMachine$$zkClient() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient;
    }

    public Map<Tuple3<String, Object, Object>, ReplicaState> replicaState() {
        return this.replicaState;
    }

    public void replicaState_$eq(Map<Tuple3<String, Object, Object>, ReplicaState> map) {
        this.replicaState = map;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted() {
        return this.kafka$controller$ReplicaStateMachine$$hasStarted;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializeReplicaState();
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(true);
        this.handleStateChanges(this.getAllReplicasOnBroker((Seq<String>)this.kafka$controller$ReplicaStateMachine$$controllerContext().allTopics().toSeq(), (Seq<Object>)this.kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().toSeq()), OnlineReplica$.MODULE$);
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started replica state machine with initial state -> ").append((Object)this.$outer.replicaState().toString()).toString();
            }
            {
                if (replicaStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaStateMachine;
            }
        });
    }

    public void registerListeners() {
        this.registerBrokerChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(false);
        this.replicaState().clear();
    }

    public void handleStateChanges(Set<PartitionAndReplica> set, ReplicaState replicaState) {
        this.info((Function0<String>)new Serializable(this, set, replicaState){
            public static final long serialVersionUID = 0L;
            private final Set replicas$1;
            private final ReplicaState targetState$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.replicas$1.mkString(",")}));
            }
            {
                this.replicas$1 = set;
                this.targetState$1 = replicaState;
            }
        });
        try {
            this.brokerRequestBatch().newBatch();
            set.foreach((Function1)new Serializable(this, replicaState){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaStateMachine $outer;
                private final ReplicaState targetState$1;

                public final void apply(PartitionAndReplica partitionAndReplica) {
                    this.$outer.handleStateChange(partitionAndReplica.topic(), partitionAndReplica.partition(), partitionAndReplica.replica(), this.targetState$1);
                }
                {
                    if (replicaStateMachine == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = replicaStateMachine;
                    this.targetState$1 = replicaState;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$ReplicaStateMachine$$controller.epoch(), this.kafka$controller$ReplicaStateMachine$$controllerContext().correlationId().getAndIncrement(), this.kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokers());
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(this, replicaState){
                public static final long serialVersionUID = 0L;
                private final ReplicaState targetState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Error while moving some replicas to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = replicaState;
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = exception;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStateChange(String string, int n, int n2, ReplicaState replicaState) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        if (!this.kafka$controller$ReplicaStateMachine$$hasStarted().get()) throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition %s to %s failed because replica state machine has not started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition, replicaState})));
        try {
            this.replicaState().getOrElseUpdate((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final NonExistentReplica$ apply() {
                    return NonExistentReplica$.MODULE$;
                }
            });
            Seq seq = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
            ReplicaState replicaState2 = replicaState;
            NewReplica$ newReplica$ = NewReplica$.MODULE$;
            ReplicaState replicaState3 = replicaState2;
            if (!(newReplica$ != null ? !newReplica$.equals(replicaState3) : replicaState3 != null)) {
                Option<LeaderIsrAndControllerEpoch> option;
                this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentReplica$[]{NonExistentReplica$.MODULE$})), replicaState);
                Option<LeaderIsrAndControllerEpoch> option2 = option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$ReplicaStateMachine$$zkClient(), string, n);
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                    if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == n2) {
                        throw new StateChangeFailedException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s cannot be moved to NewReplica")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2), topicAndPartition}))).append((Object)"state as it is being requested to become leader").toString());
                    }
                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n2})), string, n, leaderIsrAndControllerEpoch, (Seq<Object>)seq);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<LeaderIsrAndControllerEpoch> option3 = option2;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError(option2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)NewReplica$.MODULE$);
                this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to NewReplica")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                NonExistentReplica$ nonExistentReplica$ = NonExistentReplica$.MODULE$;
                ReplicaState replicaState4 = replicaState2;
                if (!(nonExistentReplica$ != null ? !nonExistentReplica$.equals(replicaState4) : replicaState4 != null)) {
                    this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflineReplica$[]{OfflineReplica$.MODULE$})), replicaState);
                    this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n2})), string, n, true);
                    Seq seq2 = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                    this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, seq2.filterNot((Function1)new Serializable(this, n2){
                        public static final long serialVersionUID = 0L;
                        private final int replicaId$1;

                        public final boolean apply(int n) {
                            return this.apply$mcZI$sp(n);
                        }

                        public boolean apply$mcZI$sp(int n) {
                            return n == this.replicaId$1;
                        }
                        {
                            this.replicaId$1 = n;
                        }
                    }));
                    this.replicaState().remove((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)));
                    this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to NonExistentReplica")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    OnlineReplica$ onlineReplica$ = OnlineReplica$.MODULE$;
                    ReplicaState replicaState5 = replicaState2;
                    if (!(onlineReplica$ != null ? !onlineReplica$.equals(replicaState5) : replicaState5 != null)) {
                        this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$})), replicaState);
                        ReplicaState replicaState6 = (ReplicaState)this.replicaState().apply((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)));
                        NewReplica$ newReplica$2 = NewReplica$.MODULE$;
                        ReplicaState replicaState7 = replicaState6;
                        if (!(newReplica$2 != null ? !newReplica$2.equals(replicaState7) : replicaState7 != null)) {
                            Seq seq3 = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                            Object object = seq3.contains((Object)BoxesRunTime.boxToInteger((int)n2)) ? BoxedUnit.UNIT : this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, seq3.$colon$plus((Object)BoxesRunTime.boxToInteger((int)n2), Seq$.MODULE$.canBuildFrom()));
                            this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to OnlineReplica")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Option option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n2})), string, n, leaderIsrAndControllerEpoch, (Seq<Object>)seq);
                                this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)OnlineReplica$.MODULE$);
                                this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to OnlineReplica")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option option4 = option;
                                if (none$ != null ? !none$.equals(option4) : option4 != null) throw new MatchError((Object)option);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)OnlineReplica$.MODULE$);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    } else {
                        boolean bl;
                        OfflineReplica$ offlineReplica$ = OfflineReplica$.MODULE$;
                        ReplicaState replicaState8 = replicaState2;
                        if (offlineReplica$ != null ? !offlineReplica$.equals(replicaState8) : replicaState8 != null) throw new MatchError((Object)replicaState2);
                        this.assertValidPreviousStates(string, n, n2, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$})), replicaState);
                        Option option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                        if (option instanceof Some) {
                            boolean bl2;
                            Some some = (Some)option;
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                            if (leaderIsrAndControllerEpoch.leaderAndIsr().isr().contains((Object)BoxesRunTime.boxToInteger((int)n2))) {
                                boolean bl3;
                                Option<LeaderIsrAndControllerEpoch> option5 = this.kafka$controller$ReplicaStateMachine$$controller.removeReplicaFromIsr(string, n, n2);
                                if (option5 instanceof Some) {
                                    Some some2 = (Some)option5;
                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = (LeaderIsrAndControllerEpoch)some2.x();
                                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderIsrAndControllerEpoch2.leaderAndIsr().leader()})), string, n, leaderIsrAndControllerEpoch2, (Seq<Object>)seq);
                                    this.replicaState().put((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)OfflineReplica$.MODULE$);
                                    this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s to OfflineReplica")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                                    bl3 = false;
                                } else {
                                    None$ none$ = None$.MODULE$;
                                    Option<LeaderIsrAndControllerEpoch> option6 = option5;
                                    if (none$ != null ? !none$.equals(option6) : option6 != null) throw new MatchError(option5);
                                    bl3 = true;
                                }
                                bl2 = bl3;
                            } else {
                                bl2 = false;
                            }
                            bl = bl2;
                        } else {
                            None$ none$ = None$.MODULE$;
                            Option option7 = option;
                            if (none$ != null ? !none$.equals(option7) : option7 != null) throw new MatchError((Object)option);
                            bl = true;
                        }
                        boolean bl4 = bl;
                        if (bl4) {
                            throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Failed to change state of replica %d for partition %s since the leader and isr path in zookeeper is empty")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2), topicAndPartition})));
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition [%s,%d] to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)n2), string, BoxesRunTime.boxToInteger((int)n), replicaState})), throwable);
        }
    }

    private void assertValidPreviousStates(String string, int n, int n2, Seq<ReplicaState> seq, ReplicaState replicaState) {
        Predef$.MODULE$.assert(seq.contains(this.replicaState().apply((Object)new Tuple3((Object)string, (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2)))), (Function0)new Serializable(this, string, n, n2, seq, replicaState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;
            private final String topic$1;
            private final int partition$1;
            private final int replicaId$2;
            private final Seq fromStates$1;
            private final ReplicaState targetState$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Replica %s for partition [%s,%d] should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$2), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), this.fromStates$1.mkString(","), this.targetState$2}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.replicaState().apply((Object)new Tuple3((Object)this.topic$1, (Object)BoxesRunTime.boxToInteger((int)this.partition$1), (Object)BoxesRunTime.boxToInteger((int)this.replicaId$2)))}))).toString();
            }
            {
                if (replicaStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaStateMachine;
                this.topic$1 = string;
                this.partition$1 = n;
                this.replicaId$2 = n2;
                this.fromStates$1 = seq;
                this.targetState$2 = replicaState;
            }
        });
    }

    private List<String> registerBrokerChangeListener() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerIdsPath(), (IZkChildListener)new BrokerChangeListener());
    }

    private void initializeReplicaState() {
        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22 = tuple2;
                boolean bl = tuple22 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final void apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22 = tuple2;
                if (tuple22 != null) {
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                    Seq seq = (Seq)tuple22._2();
                    String string = topicAndPartition.topic();
                    int n = topicAndPartition.partition();
                    seq.foreach((Function1)new Serializable(this, string, n){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$initializeReplicaState$2 $outer;
                        private final String topic$2;
                        private final int partition$2;

                        public final Option<ReplicaState> apply(int n) {
                            boolean bl;
                            block4: {
                                Option option;
                                block3: {
                                    block2: {
                                        bl = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)n));
                                        if (!bl) break block2;
                                        option = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().replicaState().put((Object)new Tuple3((Object)this.topic$2, (Object)BoxesRunTime.boxToInteger((int)this.partition$2), (Object)BoxesRunTime.boxToInteger((int)n)), (Object)OnlineReplica$.MODULE$);
                                        break block3;
                                    }
                                    if (bl) break block4;
                                    option = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().replicaState().put((Object)new Tuple3((Object)this.topic$2, (Object)BoxesRunTime.boxToInteger((int)this.partition$2), (Object)BoxesRunTime.boxToInteger((int)n)), (Object)OfflineReplica$.MODULE$);
                                }
                                return option;
                            }
                            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                            this.topic$2 = string;
                            this.partition$2 = n;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple22);
            }

            public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (replicaStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaStateMachine;
            }
        });
    }

    private Set<PartitionAndReplica> getAllReplicasOnBroker(Seq<String> seq, Seq<Object> seq2) {
        return ((TraversableOnce)((GenericTraversableTemplate)seq2.map((Function1)new Serializable(this, seq, seq2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;
            public final Seq topics$1;
            public final Seq brokerIds$1;

            public final Iterable<PartitionAndReplica> apply(int n) {
                Map map = (Map)this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, n){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getAllReplicasOnBroker$1 $outer;
                    private final int brokerId$1;

                    public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                        return this.$outer.topics$1.contains((Object)((TopicAndPartition)tuple2._1()).topic()) && ((SeqLike)tuple2._2()).contains((Object)BoxesRunTime.boxToInteger((int)this.brokerId$1));
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                        this.brokerId$1 = n;
                    }
                });
                if (map.size() == 0) {
                    this.$outer.info((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$getAllReplicasOnBroker$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("No state transitions triggered since no partitions are assigned to brokers %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.brokerIds$1.mkString(",")}));
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                        }
                    });
                }
                return (Iterable)map.map((Function1)new Serializable(this, n){
                    public static final long serialVersionUID = 0L;
                    private final int brokerId$1;

                    public final PartitionAndReplica apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                        return new PartitionAndReplica(((TopicAndPartition)tuple2._1()).topic(), ((TopicAndPartition)tuple2._1()).partition(), this.brokerId$1);
                    }
                    {
                        this.brokerId$1 = n;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                if (replicaStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaStateMachine;
                this.topics$1 = seq;
                this.brokerIds$1 = seq2;
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms())).toSet();
    }

    public Seq<TopicAndPartition> getPartitionsAssignedToBroker(Seq<String> seq, int n) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final int brokerId$2;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                return ((SeqLike)tuple2._2()).contains((Object)BoxesRunTime.boxToInteger((int)this.brokerId$2));
            }
            {
                this.brokerId$2 = n;
            }
        })).keySet().toSeq();
    }

    public ReplicaStateMachine(KafkaController kafkaController) {
        this.kafka$controller$ReplicaStateMachine$$controller = kafkaController;
        Logging$class.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerContext = kafkaController.controllerContext();
        this.controllerId = kafkaController.config().brokerId();
        this.kafka$controller$ReplicaStateMachine$$zkClient = this.kafka$controller$ReplicaStateMachine$$controllerContext().zkClient();
        this.replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(kafkaController.controllerContext(), (Function3<Object, RequestOrResponse, Function1<RequestOrResponse, BoxedUnit>, BoxedUnit>)new $anonfun$1(this), this.controllerId(), kafkaController.clientId());
        this.kafka$controller$ReplicaStateMachine$$hasStarted = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica state machine on controller ").append((Object)BoxesRunTime.boxToInteger((int)kafkaController.config().brokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class BrokerChangeListener
    implements IZkChildListener,
    Logging {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            BrokerChangeListener brokerChangeListener = this;
            synchronized (brokerChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        @Override
        public void trace(Function0<String> function0) {
            Logging$class.trace(this, function0);
        }

        @Override
        public Object trace(Function0<Throwable> function0) {
            return Logging$class.trace(this, function0);
        }

        @Override
        public void trace(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.trace(this, function0, function02);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> function0) {
            Logging$class.swallowTrace(this, function0);
        }

        @Override
        public void debug(Function0<String> function0) {
            Logging$class.debug(this, function0);
        }

        @Override
        public Object debug(Function0<Throwable> function0) {
            return Logging$class.debug(this, function0);
        }

        @Override
        public void debug(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.debug(this, function0, function02);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> function0) {
            Logging$class.swallowDebug(this, function0);
        }

        @Override
        public void info(Function0<String> function0) {
            Logging$class.info(this, function0);
        }

        @Override
        public Object info(Function0<Throwable> function0) {
            return Logging$class.info(this, function0);
        }

        @Override
        public void info(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.info(this, function0, function02);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> function0) {
            Logging$class.swallowInfo(this, function0);
        }

        @Override
        public void warn(Function0<String> function0) {
            Logging$class.warn(this, function0);
        }

        @Override
        public Object warn(Function0<Throwable> function0) {
            return Logging$class.warn(this, function0);
        }

        @Override
        public void warn(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.warn(this, function0, function02);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> function0) {
            Logging$class.swallowWarn(this, function0);
        }

        @Override
        public void swallow(Function0<BoxedUnit> function0) {
            Logging$class.swallow(this, function0);
        }

        @Override
        public void error(Function0<String> function0) {
            Logging$class.error(this, function0);
        }

        @Override
        public Object error(Function0<Throwable> function0) {
            return Logging$class.error(this, function0);
        }

        @Override
        public void error(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.error(this, function0, function02);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> function0) {
            Logging$class.swallowError(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0) {
            Logging$class.fatal(this, function0);
        }

        @Override
        public Object fatal(Function0<Throwable> function0) {
            return Logging$class.fatal(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.fatal(this, function0, function02);
        }

        public void handleChildChange(String string, List<String> list) {
            this.info((Function0<String>)new Serializable(this, string, list){
                public static final long serialVersionUID = 0L;
                private final String parentPath$1;
                private final List currentBrokerList$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Broker change listener fired for path %s with children %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentPath$1, JavaConversions$.MODULE$.asScalaBuffer(this.currentBrokerList$1).mkString(",")}));
                }
                {
                    this.parentPath$1 = string;
                    this.currentBrokerList$1 = list;
                }
            });
            Object object = this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerLock();
            synchronized (object) {
                Object object2 = this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$hasStarted().get() ? ControllerStats$.MODULE$.leaderElectionTimer().time(new Serializable(this, list){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BrokerChangeListener $outer;
                    private final List currentBrokerList$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        try {
                            scala.collection.immutable.Set set = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(this.currentBrokerList$1).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(String string) {
                                    return new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).toSet();
                            scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)set.$minus$minus(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveOrShuttingDownBrokerIds());
                            scala.collection.immutable.Set set3 = (scala.collection.immutable.Set)set2.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1 $outer;

                                public final Option<Broker> apply(int n) {
                                    return ZkUtils$.MODULE$.getBrokerInfo(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$zkClient(), n);
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                }
                            }, Set$.MODULE$.canBuildFrom());
                            scala.collection.immutable.Set set4 = (scala.collection.immutable.Set)((SetLike)set3.filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Option<Broker> option) {
                                    return option.isDefined();
                                }
                            })).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Broker apply(Option<Broker> option) {
                                    return (Broker)option.get();
                                }
                            }, Set$.MODULE$.canBuildFrom());
                            scala.collection.immutable.Set set5 = (scala.collection.immutable.Set)this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveOrShuttingDownBrokerIds().$minus$minus((GenTraversableOnce)set);
                            this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokers_$eq((scala.collection.immutable.Set<Broker>)((scala.collection.immutable.Set)((SetLike)((TraversableLike)set.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1 $outer;

                                public final Option<Broker> apply(int n) {
                                    return ZkUtils$.MODULE$.getBrokerInfo(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$zkClient(), n);
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                }
                            }, Set$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Option<Broker> option) {
                                    return option.isDefined();
                                }
                            })).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Broker apply(Option<Broker> option) {
                                    return (Broker)option.get();
                                }
                            }, Set$.MODULE$.canBuildFrom())));
                            this.$outer.info((Function0<String>)new Serializable(this, set2, set5){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1 $outer;
                                private final scala.collection.immutable.Set newBrokerIds$1;
                                private final scala.collection.immutable.Set deadBrokerIds$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Newly added brokers: %s, deleted brokers: %s, all live brokers: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newBrokerIds$1.mkString(","), this.deadBrokerIds$1.mkString(","), this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().mkString(",")}));
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                    this.newBrokerIds$1 = set;
                                    this.deadBrokerIds$1 = set2;
                                }
                            });
                            set4.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1 $outer;

                                public final void apply(Broker broker) {
                                    this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerChannelManager().addBroker(broker);
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                }
                            });
                            set5.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ BrokerChangeListener$$anonfun$handleChildChange$1 $outer;

                                public final void apply(int n) {
                                    this.apply$mcVI$sp(n);
                                }

                                public void apply$mcVI$sp(int n) {
                                    this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerChannelManager().removeBroker(n);
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                }
                            });
                            if (set2.size() > 0) {
                                this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controller.onBrokerStartup((Seq<Object>)set2.toSeq());
                            }
                            if (set5.size() > 0) {
                                this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controller.onBrokerFailure((Seq<Object>)set5.toSeq());
                            }
                        }
                        catch (Exception exception) {
                            this.$outer.error((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Error while handling broker changes";
                                }
                            }, (Function0<Throwable>)new Serializable(this, exception){
                                public static final long serialVersionUID = 0L;
                                private final Exception e$2;

                                public final Exception apply() {
                                    return this.e$2;
                                }
                                {
                                    this.e$2 = exception;
                                }
                            });
                        }
                    }

                    public /* synthetic */ BrokerChangeListener kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if (brokerChangeListener == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = brokerChangeListener;
                        this.currentBrokerList$1 = list;
                    }
                }) : BoxedUnit.UNIT;
                return;
            }
        }

        public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer() {
            return ReplicaStateMachine.this;
        }

        public BrokerChangeListener() {
            if (ReplicaStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[BrokerChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)ReplicaStateMachine.this.kafka$controller$ReplicaStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

