/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.IOException;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anonfun$loadLogs$1$;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig;
import kafka.utils.FileLock;
import kafka.utils.KafkaScheduler;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tea!B\u0001\u0003\u0001\u00111!A\u0003'pO6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\u0007\u00019Q\u0002\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001dEi\u0011a\u0004\u0006\u0003!\u0011\tQ!\u001e;jYNL!AE\b\u0003\u000f1{wmZ5oO\"AA\u0003\u0001BC\u0002\u0013\u0005a#\u0001\u0004d_:4\u0017nZ\u0002\u0001+\u00059\u0002C\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011A$\u0007\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u0018\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!I\u0001\ng\u000eDW\rZ;mKJ\u0004\"A\u0004\u0012\n\u0005\rz!AD&bM.\f7k\u00195fIVdWM\u001d\u0005\tK\u0001\u0011)\u0019!C\u0005M\u0005!A/[7f+\u00059\u0003C\u0001\b)\u0013\tIsB\u0001\u0003US6,\u0007\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u000bQLW.\u001a\u0011\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\u0011y\u0013GM\u001a\u0011\u0005A\u0002Q\"\u0001\u0002\t\u000bQa\u0003\u0019A\f\t\u000b\u0001b\u0003\u0019A\u0011\t\u000b\u0015b\u0003\u0019A\u0014\t\u000fU\u0002!\u0019!C\u0001m\u0005\t2\t\\3b]NCW\u000f\u001e3po:4\u0015\u000e\\3\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\t1\fgn\u001a\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014H\u0001\u0004TiJLgn\u001a\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u001c\u0002%\rcW-\u00198TQV$Hm\\<o\r&dW\r\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u00017\u0003!aunY6GS2,\u0007B\u0002#\u0001A\u0003%q'A\u0005M_\u000e\\g)\u001b7fA!9a\t\u0001b\u0001\n\u00039\u0015a\u00027pO\u0012K'o]\u000b\u0002\u0011B\u0019\u0001\"S&\n\u0005)K!!B!se\u0006L\bC\u0001'P\u001b\u0005i%B\u0001(<\u0003\tIw.\u0003\u0002Q\u001b\n!a)\u001b7f\u0011\u0019\u0011\u0006\u0001)A\u0005\u0011\u0006AAn\\4ESJ\u001c\b\u0005C\u0004U\u0001\t\u0007I\u0011B+\u0002\u001d1|wMR5mKNK'0Z'baV\ta\u000b\u0005\u0003X5r\u0013W\"\u0001-\u000b\u0005eK\u0011AC2pY2,7\r^5p]&\u00111\f\u0017\u0002\u0004\u001b\u0006\u0004\bCA/a\u001d\tAa,\u0003\u0002`\u0013\u00051\u0001K]3eK\u001aL!AP1\u000b\u0005}K\u0001C\u0001\u0005d\u0013\t!\u0017BA\u0002J]RDaA\u001a\u0001!\u0002\u00131\u0016a\u00047pO\u001aKG.Z*ju\u0016l\u0015\r\u001d\u0011\t\u000f!\u0004!\u0019!C\u0005S\u0006\u0001Bn\\4GYV\u001c\b.\u00138uKJ4\u0018\r\\\u000b\u0002E\"11\u000e\u0001Q\u0001\n\t\f\u0011\u0003\\8h\r2,8\u000f[%oi\u0016\u0014h/\u00197!\u0011\u001di\u0007A1A\u0005\nU\u000b\u0011\u0003\\8h\r2,8\u000f[%oi\u0016\u0014h/\u00197t\u0011\u0019y\u0007\u0001)A\u0005-\u0006\u0011Bn\\4GYV\u001c\b.\u00138uKJ4\u0018\r\\:!\u0011\u001d\t\bA1A\u0005\nI\fq\u0002\\8h\u0007J,\u0017\r^5p]2{7m[\u000b\u0002gB\u0011\u0001\b^\u0005\u0003kf\u0012aa\u00142kK\u000e$\bBB<\u0001A\u0003%1/\u0001\tm_\u001e\u001c%/Z1uS>tGj\\2lA!9\u0011\u0010\u0001b\u0001\n\u0013Q\u0018a\u00057pOJ+G/\u001a8uS>t7+\u001b>f\u001b\u0006\u0004X#A>\u0011\t]SF\f \t\u0003\u0011uL!A`\u0005\u0003\t1{gn\u001a\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003|\u0003Qawn\u001a*fi\u0016tG/[8o'&TX-T1qA!A\u0011Q\u0001\u0001C\u0002\u0013%!0A\tm_\u001e\u0014V\r^3oi&|g.T:NCBDq!!\u0003\u0001A\u0003%10\u0001\nm_\u001e\u0014V\r^3oi&|g.T:NCB\u0004\u0003\u0002CA\u0007\u0001\t\u0007I\u0011\u0002>\u0002\u00191|wMU8mY6\u001bX*\u00199\t\u000f\u0005E\u0001\u0001)A\u0005w\u0006iAn\\4S_2dWj]'ba\u0002B\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\u000211|wMU8mY\u0012+g-Y;mi&sG/\u001a:wC2l5/F\u0001}\u0011\u001d\tY\u0002\u0001Q\u0001\nq\f\u0011\u0004\\8h%>dG\u000eR3gCVdG/\u00138uKJ4\u0018\r\\'tA!I\u0011q\u0004\u0001C\u0002\u0013%\u0011qC\u0001\u0015Y><7\t\\3b]V\u0004\u0018J\u001c;feZ\fG.T:\t\u000f\u0005\r\u0002\u0001)A\u0005y\u0006)Bn\\4DY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0003\"CA\u0014\u0001\t\u0007I\u0011BA\f\u0003YawnZ\"mK\u0006tW\u000f\u001d#fM\u0006,H\u000e^!hK6\u001b\bbBA\u0016\u0001\u0001\u0006I\u0001`\u0001\u0018Y><7\t\\3b]V\u0004H)\u001a4bk2$\u0018iZ3Ng\u0002B\u0011\"a\f\u0001\u0005\u0004%I!!\r\u0002\t1|wm]\u000b\u0003\u0003g\u0001rADA\u001b\u0003s\t)%C\u0002\u00028=\u0011A\u0001U8pYB!\u00111HA!\u001b\t\tiDC\u0002\u0002@\u0011\taaY8n[>t\u0017\u0002BA\"\u0003{\u0011\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\r\u0001\u0014qI\u0005\u0004\u0003\u0013\u0012!a\u0001'pO\"A\u0011Q\n\u0001!\u0002\u0013\t\u0019$A\u0003m_\u001e\u001c\b\u0005C\u0005\u0002R\u0001\u0001\r\u0011\"\u0003\u0002T\u0005AA-\u001b:M_\u000e\\7/\u0006\u0002\u0002VA)q+a\u0016\u0002\\%\u0019\u0011\u0011\f-\u0003\u0007M+\u0017\u000fE\u0002\u000f\u0003;J1!a\u0018\u0010\u0005!1\u0015\u000e\\3M_\u000e\\\u0007\"CA2\u0001\u0001\u0007I\u0011BA3\u00031!\u0017N\u001d'pG.\u001cx\fJ3r)\u0011\t9'!\u001c\u0011\u0007!\tI'C\u0002\u0002l%\u0011A!\u00168ji\"Q\u0011qNA1\u0003\u0003\u0005\r!!\u0016\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0015BA+\u0003%!\u0017N\u001d'pG.\u001c\b\u0005C\u0004\u0002x\u0001!I!!\u001f\u00021\r\u0014X-\u0019;f\u0003:$g+\u00197jI\u0006$X\rT8h\t&\u00148\u000f\u0006\u0003\u0002h\u0005m\u0004\u0002CA?\u0003k\u0002\r!a \u0002\t\u0011L'o\u001d\t\u0005/\u0006]3\nC\u0004\u0002\u0004\u0002!I!!\"\u0002\u00171|7m\u001b'pO\u0012K'o\u001d\u000b\u0005\u0003+\n9\t\u0003\u0005\u0002~\u0005\u0005\u0005\u0019AA@\u0011\u001d\tY\t\u0001C\u0005\u0003\u001b\u000b\u0001\u0002\\8bI2{wm\u001d\u000b\u0005\u0003O\ny\t\u0003\u0005\u0002~\u0005%\u0005\u0019AA@\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+\u000bqa\u001d;beR,\b\u000f\u0006\u0002\u0002h!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0015AB4fi2{w\r\u0006\u0004\u0002\u001e\u0006\r\u0016q\u0015\t\u0006\u0011\u0005}\u0015QI\u0005\u0004\u0003CK!AB(qi&|g\u000eC\u0004\u0002&\u0006]\u0005\u0019\u0001/\u0002\u000bQ|\u0007/[2\t\u000f\u0005%\u0016q\u0013a\u0001E\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0003[\u0003A\u0011AAX\u000399W\r^(s\u0007J,\u0017\r^3M_\u001e$b!!\u0012\u00022\u0006M\u0006bBAS\u0003W\u0003\r\u0001\u0018\u0005\b\u0003S\u000bY\u000b1\u0001c\u0011\u001d\t9\f\u0001C\u0005\u0003s\u000bAc\u0019:fCR,Gj\\4JM:{G/\u0012=jgR\u001cH\u0003BA#\u0003wC\u0001\"!0\u00026\u0002\u0007\u0011\u0011H\u0001\u0012i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007bBAa\u0001\u0011%\u00111Y\u0001\u000b]\u0016DH\u000fT8h\t&\u0014H#A&\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002J\u0006Qq-\u001a;PM\u001a\u001cX\r^:\u0015\u0011\u0005-\u0017QZAh\u0003'\u0004BaVA,y\"A\u0011QXAc\u0001\u0004\tI\u0004C\u0004\u0002R\u0006\u0015\u0007\u0019\u0001?\u0002\u0013QLW.Z:uC6\u0004\bbBAk\u0003\u000b\u0004\rAY\u0001\u000e[\u0006Dh*^7PM\u001a\u001cX\r^:\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\u000612\r\\3b]V\u0004X\t\u001f9je\u0016$7+Z4nK:$8\u000fF\u0002c\u0003;DqaAAl\u0001\u0004\t)\u0005C\u0004\u0002b\u0002!I!a9\u0002;\rdW-\u00198vaN+w-\\3oiN$v.T1j]R\f\u0017N\\*ju\u0016$2AYAs\u0011\u001d\u0019\u0011q\u001ca\u0001\u0003\u000bBq!!;\u0001\t\u0003\t)*A\u0006dY\u0016\fg.\u001e9M_\u001e\u001c\bbBAw\u0001\u0011\u0005\u0011QS\u0001\tg\",H\u000fZ8x]\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\u0018aB1mY2{wm\u001d\u000b\u0003\u0003k\u0004RaVA|\u0003\u000bJ1!!?Y\u0005!IE/\u001a:bE2,\u0007bBA\u007f\u0001\u0011%\u0011QS\u0001\u000fM2,8\u000f\u001b#jeRLHj\\4t\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0005\u0007\tq\u0003]1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3\u0015\t\u0005e\"Q\u0001\u0005\b\u0005\u000f\ty\u00101\u0001]\u0003\u0011q\u0017-\\3\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e\u00051Ao\u001c9jGN$\"Aa\u0004\u0011\t]\u000b9\u0010\u0018\u0015\u0004\u0001\tM\u0001c\u0001\b\u0003\u0016%\u0019!qC\b\u0003\u0015QD'/Z1eg\u00064W\r")
public class LogManager
implements Logging {
    private final KafkaConfig config;
    private final KafkaScheduler scheduler;
    private final Time kafka$log$LogManager$$time;
    private final String CleanShutdownFile;
    private final String LockFile;
    private final File[] logDirs;
    private final Map<String, Object> kafka$log$LogManager$$logFileSizeMap;
    private final int kafka$log$LogManager$$logFlushInterval;
    private final Map<String, Object> kafka$log$LogManager$$logFlushIntervals;
    private final Object logCreationLock;
    private final Map<String, Object> logRetentionSizeMap;
    private final Map<String, Object> logRetentionMsMap;
    private final Map<String, Object> kafka$log$LogManager$$logRollMsMap;
    private final long kafka$log$LogManager$$logRollDefaultIntervalMs;
    private final long kafka$log$LogManager$$logCleanupIntervalMs;
    private final long kafka$log$LogManager$$logCleanupDefaultAgeMs;
    private final Pool<TopicAndPartition, Log> kafka$log$LogManager$$logs;
    private Seq<FileLock> dirLocks;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogManager logManager = this;
        synchronized (logManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time kafka$log$LogManager$$time() {
        return this.kafka$log$LogManager$$time;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    public String LockFile() {
        return this.LockFile;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Map<String, Object> kafka$log$LogManager$$logFileSizeMap() {
        return this.kafka$log$LogManager$$logFileSizeMap;
    }

    public int kafka$log$LogManager$$logFlushInterval() {
        return this.kafka$log$LogManager$$logFlushInterval;
    }

    public Map<String, Object> kafka$log$LogManager$$logFlushIntervals() {
        return this.kafka$log$LogManager$$logFlushIntervals;
    }

    private Object logCreationLock() {
        return this.logCreationLock;
    }

    private Map<String, Object> logRetentionSizeMap() {
        return this.logRetentionSizeMap;
    }

    private Map<String, Object> logRetentionMsMap() {
        return this.logRetentionMsMap;
    }

    public Map<String, Object> kafka$log$LogManager$$logRollMsMap() {
        return this.kafka$log$LogManager$$logRollMsMap;
    }

    public long kafka$log$LogManager$$logRollDefaultIntervalMs() {
        return this.kafka$log$LogManager$$logRollDefaultIntervalMs;
    }

    public long kafka$log$LogManager$$logCleanupIntervalMs() {
        return this.kafka$log$LogManager$$logCleanupIntervalMs;
    }

    public long kafka$log$LogManager$$logCleanupDefaultAgeMs() {
        return this.kafka$log$LogManager$$logCleanupDefaultAgeMs;
    }

    public Pool<TopicAndPartition, Log> kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    private Seq<FileLock> dirLocks() {
        return this.dirLocks;
    }

    private void dirLocks_$eq(Seq<FileLock> seq) {
        this.dirLocks = seq;
    }

    private void createAndValidateLogDirs(Seq<File> seq) {
        if (((TraversableOnce)seq.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(File file) {
                return file.getCanonicalPath();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().size() < seq.size()) {
            throw new KafkaException(new StringBuilder().append((Object)"Duplicate log directory found: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).mkString(", ")).toString());
        }
        seq.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final void apply(File file) {
                block5: {
                    block4: {
                        if (file.exists()) break block4;
                        this.$outer.info((Function0<String>)new Serializable(this, file){
                            public static final long serialVersionUID = 0L;
                            private final File dir$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Log directory '").append((Object)this.dir$1.getAbsolutePath()).append((Object)"' not found, creating it.").toString();
                            }
                            {
                                this.dir$1 = file;
                            }
                        });
                        boolean bl = file.mkdirs();
                        if (!bl) break block5;
                    }
                    if (file.isDirectory() && file.canRead()) {
                        return;
                    }
                    throw new KafkaException(new StringBuilder().append((Object)file.getAbsolutePath()).append((Object)" is not a readable log directory.").toString());
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to create data directory ").append((Object)file.getAbsolutePath()).toString());
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        });
    }

    private Seq<FileLock> lockLogDirs(Seq<File> seq) {
        return (Seq)seq.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final FileLock apply(File file) {
                FileLock fileLock = new FileLock(new File(file, this.$outer.LockFile()));
                if (fileLock.tryLock()) {
                    return fileLock;
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to acquire lock on file .lock in ").append((Object)fileLock.file().getParentFile().getAbsolutePath()).append((Object)". A Kafka instance in another process or thread is using this directory.").toString());
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void loadLogs(Seq<File> seq) {
        seq.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final void apply(File file) {
                File file2 = new File(file, this.$outer.CleanShutdownFile());
                boolean bl = !file2.exists();
                file2.delete();
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    Predef$.MODULE$.refArrayOps((Object[])fileArray).foreach((Function1)new Serializable(this, bl){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$loadLogs$1 $outer;
                        private final boolean needsRecovery$1;

                        public final void apply(File file) {
                            if (file.isDirectory()) {
                                this.$outer.kafka$log$LogManager$$anonfun$$$outer().info((Function0<String>)new Serializable(this, file){
                                    public static final long serialVersionUID = 0L;
                                    private final File dir$2;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Loading log '").append((Object)this.dir$2.getName()).append((Object)"'").toString();
                                    }
                                    {
                                        this.dir$2 = file;
                                    }
                                });
                                TopicAndPartition topicAndPartition = this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$parseTopicPartitionName(file.getName());
                                long l = BoxesRunTime.unboxToLong((Object)this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logRollMsMap().get((Object)topicAndPartition.topic()).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$loadLogs$1$$anonfun$apply$3 $outer;

                                    public final long apply() {
                                        return this.apply$mcJ$sp();
                                    }

                                    public long apply$mcJ$sp() {
                                        return this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logRollDefaultIntervalMs();
                                    }
                                    {
                                        if (var1_1 == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = var1_1;
                                    }
                                }));
                                int n = BoxesRunTime.unboxToInt((Object)this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logFileSizeMap().get((Object)topicAndPartition.topic()).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$loadLogs$1$$anonfun$apply$3 $outer;

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().config().logSegmentBytes();
                                    }
                                    {
                                        if (var1_1 == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = var1_1;
                                    }
                                }));
                                Log log = new Log(file, n, this.$outer.kafka$log$LogManager$$anonfun$$$outer().config().messageMaxBytes(), this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logFlushInterval(), l, this.needsRecovery$1, this.$outer.kafka$log$LogManager$$anonfun$$$outer().config().logIndexSizeMaxBytes(), this.$outer.kafka$log$LogManager$$anonfun$$$outer().config().logIndexIntervalBytes(), this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$time(), this.$outer.kafka$log$LogManager$$anonfun$$$outer().config().brokerId());
                                Log log2 = this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logs().put(topicAndPartition, log);
                                if (log2 != null) {
                                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Duplicate log directories found: %s, %s!")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.dir().getAbsolutePath(), log2.dir().getAbsolutePath()})));
                                }
                            }
                        }

                        public /* synthetic */ $anonfun$loadLogs$1 kafka$log$LogManager$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                            this.needsRecovery$1 = bl;
                        }
                    });
                }
            }

            public /* synthetic */ LogManager kafka$log$LogManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        });
    }

    public void startup() {
        if (this.scheduler != null) {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Starting log cleaner every ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$log$LogManager$$logCleanupIntervalMs())).append((Object)" ms").toString();
                }
                {
                    if (logManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logManager;
                }
            });
            this.scheduler.scheduleWithRate((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.cleanupLogs();
                }
                {
                    if (logManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logManager;
                }
            }, "kafka-logcleaner-", 60000L, this.kafka$log$LogManager$$logCleanupIntervalMs(), false);
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Starting log flusher every ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.config().logFlushSchedulerIntervalMs())).append((Object)" ms with the following overrides ").append(this.$outer.kafka$log$LogManager$$logFlushIntervals()).toString();
                }
                {
                    if (logManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logManager;
                }
            });
            this.scheduler.scheduleWithRate((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$log$LogManager$$flushDirtyLogs();
                }
                {
                    if (logManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logManager;
                }
            }, "kafka-logflusher-", this.config().logFlushSchedulerIntervalMs(), this.config().logFlushSchedulerIntervalMs(), false);
        }
    }

    public Option<Log> getLog(String string, int n) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        Log log = this.kafka$log$LogManager$$logs().get(topicAndPartition);
        return log == null ? None$.MODULE$ : new Some((Object)log);
    }

    public Log getOrCreateLog(String string, int n) {
        Log log;
        block4: {
            Log log2;
            block3: {
                Log log3;
                block2: {
                    TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
                    log = this.kafka$log$LogManager$$logs().get(topicAndPartition);
                    if (log != null) break block2;
                    log2 = this.createLogIfNotExists(topicAndPartition);
                    break block3;
                }
                if (log == null) break block4;
                log2 = log3 = log;
            }
            return log2;
        }
        throw new MatchError((Object)log);
    }

    private Log createLogIfNotExists(TopicAndPartition topicAndPartition) {
        Object object = this.logCreationLock();
        synchronized (object) {
            Log log;
            block4: {
                log = this.kafka$log$LogManager$$logs().get(topicAndPartition);
                if (log != null) break block4;
                File file = this.nextLogDir();
                File file2 = new File(file, new StringBuilder().append((Object)topicAndPartition.topic()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)topicAndPartition.partition())).toString());
                file2.mkdirs();
                long l = BoxesRunTime.unboxToLong((Object)this.kafka$log$LogManager$$logRollMsMap().get((Object)topicAndPartition.topic()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LogManager $outer;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.$outer.kafka$log$LogManager$$logRollDefaultIntervalMs();
                    }
                    {
                        if (logManager == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = logManager;
                    }
                }));
                int n = BoxesRunTime.unboxToInt((Object)this.kafka$log$LogManager$$logFileSizeMap().get((Object)topicAndPartition.topic()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LogManager $outer;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.$outer.config().logSegmentBytes();
                    }
                    {
                        if (logManager == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = logManager;
                    }
                }));
                log = new Log(file2, n, this.config().messageMaxBytes(), this.kafka$log$LogManager$$logFlushInterval(), l, false, this.config().logIndexSizeMaxBytes(), this.config().logIndexIntervalBytes(), this.kafka$log$LogManager$$time(), this.config().brokerId());
                this.info((Function0<String>)new Serializable(this, topicAndPartition, file){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPartition$1;
                    private final File dataDir$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Created log for partition [%s,%d] in %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1.topic(), BoxesRunTime.boxToInteger((int)this.topicAndPartition$1.partition()), this.dataDir$1.getAbsolutePath()}));
                    }
                    {
                        this.topicAndPartition$1 = topicAndPartition;
                        this.dataDir$1 = file;
                    }
                });
                this.kafka$log$LogManager$$logs().put(topicAndPartition, log);
                Log log2 = log;
                return log2;
            }
            return log;
        }
    }

    private File nextLogDir() {
        File file;
        if (Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).size() == 1) {
            file = this.logDirs()[0];
        } else {
            scala.collection.immutable.Map map = this.allLogs().groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Log log) {
                    return log.dir().getParent();
                }
            }).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Iterable<Log> iterable) {
                    return iterable.size();
                }
            });
            scala.collection.immutable.Map map2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(File file) {
                    return new Tuple2((Object)file.getPath(), (Object)BoxesRunTime.boxToInteger((int)0));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
            Buffer buffer = map2.$plus$plus((GenTraversableOnce)map).toBuffer();
            Tuple2 tuple2 = (Tuple2)((IterableLike)buffer.sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<String, Object> tuple2) {
                    return tuple2._2$mcI$sp();
                }
            }, (Ordering)Ordering.Int$.MODULE$)).head();
            file = new File((String)tuple2._1());
        }
        return file;
    }

    public Seq<Object> getOffsets(TopicAndPartition topicAndPartition, long l, int n) {
        Option<Log> option;
        block4: {
            Seq<Object> seq;
            block3: {
                block2: {
                    Option<Log> option2 = this.getLog(topicAndPartition.topic(), topicAndPartition.partition());
                    option = option2;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Log log = (Log)some.x();
                    seq = log.getOffsetsBefore(l, n);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Log> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                seq = Log$.MODULE$.getEmptyOffsets(l);
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public int kafka$log$LogManager$$cleanupExpiredSegments(Log log) {
        long l = this.kafka$log$LogManager$$time().milliseconds();
        String string = this.kafka$log$LogManager$$parseTopicPartitionName(log.name()).topic();
        long l2 = BoxesRunTime.unboxToLong((Object)this.logRetentionMsMap().get((Object)string).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.kafka$log$LogManager$$logCleanupDefaultAgeMs();
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        }));
        Seq<LogSegment> seq = log.markDeletedWhile((Function1<LogSegment, Object>)new Serializable(this, l, l2){
            public static final long serialVersionUID = 0L;
            private final long startMs$1;
            private final long logCleanupThresholdMs$1;

            public final boolean apply(LogSegment logSegment) {
                return this.startMs$1 - logSegment.messageSet().file().lastModified() > this.logCleanupThresholdMs$1;
            }
            {
                this.startMs$1 = l;
                this.logCleanupThresholdMs$1 = l2;
            }
        });
        int n = log.deleteSegments(seq);
        return n;
    }

    public int kafka$log$LogManager$$cleanupSegmentsToMaintainSize(Log log) {
        String string = this.kafka$log$LogManager$$parseTopicPartitionName(log.dir().getName()).topic();
        long l = BoxesRunTime.unboxToLong((Object)this.logRetentionSizeMap().get((Object)string).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.config().logRetentionBytes();
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        }));
        if (l < 0L || log.size() < l) {
            return 0;
        }
        LongRef longRef = new LongRef(log.size() - l);
        Seq<LogSegment> seq = log.markDeletedWhile((Function1<LogSegment, Object>)new Serializable(this, longRef){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final LongRef diff$1;

            public final boolean apply(LogSegment logSegment) {
                return this.$outer.kafka$log$LogManager$$shouldDelete$1(logSegment, this.diff$1);
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
                this.diff$1 = longRef;
            }
        });
        int n = log.deleteSegments(seq);
        return n;
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Beginning log cleanup...";
            }
        });
        IntRef intRef = new IntRef(0);
        long l = this.kafka$log$LogManager$$time().milliseconds();
        this.allLogs().foreach((Function1)new Serializable(this, intRef){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final IntRef total$1;

            public final void apply(Log log) {
                this.$outer.debug((Function0<String>)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final Log log$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Garbage collecting '").append((Object)this.log$2.name()).append((Object)"'").toString();
                    }
                    {
                        this.log$2 = log;
                    }
                });
                this.total$1.elem += this.$outer.kafka$log$LogManager$$cleanupExpiredSegments(log) + this.$outer.kafka$log$LogManager$$cleanupSegmentsToMaintainSize(log);
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
                this.total$1 = intRef;
            }
        });
        this.debug((Function0<String>)new Serializable(this, intRef, l){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final IntRef total$1;
            private final long startMs$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Log cleanup completed. ").append((Object)BoxesRunTime.boxToInteger((int)this.total$1.elem)).append((Object)" files deleted in ").append((Object)BoxesRunTime.boxToLong((long)((this.$outer.kafka$log$LogManager$$time().milliseconds() - this.startMs$2) / 1000L))).append((Object)" seconds").toString();
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
                this.total$1 = intRef;
                this.startMs$2 = l;
            }
        });
    }

    public void shutdown() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down.";
            }
        });
        try {
            this.allLogs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Log log) {
                    log.close();
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply(File file) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$shutdown$3 $outer;
                        private final File dir$3;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            new File(this.dir$3, this.$outer.kafka$log$LogManager$$anonfun$$$outer().CleanShutdownFile()).createNewFile();
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                            this.dir$3 = file;
                        }
                    });
                }

                public /* synthetic */ LogManager kafka$log$LogManager$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if (logManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logManager;
                }
            });
        }
        catch (Throwable throwable) {
            this.dirLocks().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(FileLock fileLock) {
                    fileLock.destroy();
                }
            });
            throw throwable;
        }
        this.dirLocks().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutdown complete.";
            }
        });
    }

    public Iterable<Log> allLogs() {
        return this.kafka$log$LogManager$$logs().values();
    }

    public void kafka$log$LogManager$$flushDirtyLogs() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Checking for dirty logs to flush...";
            }
        });
        this.allLogs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final void apply(Log log) {
                try {
                    long l = System.currentTimeMillis() - log.getLastFlushedTime();
                    IntRef intRef = new IntRef(this.$outer.config().logFlushIntervalMs());
                    if (this.$outer.kafka$log$LogManager$$logFlushIntervals().contains((Object)log.topicName())) {
                        intRef.elem = BoxesRunTime.unboxToInt((Object)this.$outer.kafka$log$LogManager$$logFlushIntervals().apply((Object)log.topicName()));
                    }
                    this.$outer.debug((Function0<String>)new Serializable(this, log, l, intRef){
                        public static final long serialVersionUID = 0L;
                        private final Log log$1;
                        private final long timeSinceLastFlush$1;
                        private final IntRef logFlushInterval$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)this.log$1.topicName()).append((Object)" flush interval  ").append((Object)BoxesRunTime.boxToInteger((int)this.logFlushInterval$1.elem)).append((Object)" last flushed ").append((Object)BoxesRunTime.boxToLong((long)this.log$1.getLastFlushedTime())).append((Object)" time since last flush: ").append((Object)BoxesRunTime.boxToLong((long)this.timeSinceLastFlush$1)).toString();
                        }
                        {
                            this.log$1 = log;
                            this.timeSinceLastFlush$1 = l;
                            this.logFlushInterval$1 = intRef;
                        }
                    });
                    if (l >= (long)intRef.elem) {
                        log.flush();
                    }
                }
                catch (Exception exception) {
                    this.$outer.error((Function0<String>)new Serializable(this, log){
                        public static final long serialVersionUID = 0L;
                        private final Log log$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Error flushing topic ").append((Object)this.log$1.topicName()).toString();
                        }
                        {
                            this.log$1 = log;
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = exception;
                        }
                    });
                    Exception exception2 = exception;
                    if (exception2 instanceof IOException) {
                        this.$outer.fatal((Function0<String>)new Serializable(this, exception){
                            public static final long serialVersionUID = 0L;
                            private final Exception e$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Halting due to unrecoverable I/O error while flushing logs: ").append((Object)this.e$1.getMessage()).toString();
                            }
                            {
                                this.e$1 = exception;
                            }
                        }, (Function0<Throwable>)new Serializable(this, exception){
                            public static final long serialVersionUID = 0L;
                            private final Exception e$1;

                            public final Exception apply() {
                                return this.e$1;
                            }
                            {
                                this.e$1 = exception;
                            }
                        });
                        System.exit(1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        });
    }

    public TopicAndPartition kafka$log$LogManager$$parseTopicPartitionName(String string) {
        int n = string.lastIndexOf(45);
        return new TopicAndPartition(string.substring(0, n), new StringOps(Predef$.MODULE$.augmentString(string.substring(n + 1))).toInt());
    }

    public Iterable<String> topics() {
        return (Iterable)this.kafka$log$LogManager$$logs().keys().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TopicAndPartition topicAndPartition) {
                return topicAndPartition.topic();
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public final boolean kafka$log$LogManager$$shouldDelete$1(LogSegment logSegment, LongRef longRef) {
        boolean bl;
        if (longRef.elem - logSegment.size() >= 0L) {
            longRef.elem -= logSegment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogManager(KafkaConfig kafkaConfig, KafkaScheduler kafkaScheduler, Time time) {
        this.config = kafkaConfig;
        this.scheduler = kafkaScheduler;
        this.kafka$log$LogManager$$time = time;
        Logging$class.$init$(this);
        this.CleanShutdownFile = ".kafka_cleanshutdown";
        this.LockFile = ".lock";
        this.logDirs = (File[])((TraversableOnce)kafkaConfig.logDirs().map((Function1)new $anonfun$7(this), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class));
        this.kafka$log$LogManager$$logFileSizeMap = kafkaConfig.logSegmentBytesPerTopicMap();
        this.kafka$log$LogManager$$logFlushInterval = kafkaConfig.logFlushIntervalMessages();
        this.kafka$log$LogManager$$logFlushIntervals = kafkaConfig.logFlushIntervalMsPerTopicMap();
        this.logCreationLock = new Object();
        this.logRetentionSizeMap = kafkaConfig.logRetentionBytesPerTopicMap();
        this.logRetentionMsMap = (Map)kafkaConfig.logRetentionHoursPerTopicMap().map((Function1)new $anonfun$8(this), Map$.MODULE$.canBuildFrom());
        this.kafka$log$LogManager$$logRollMsMap = (Map)kafkaConfig.logRollHoursPerTopicMap().map((Function1)new $anonfun$9(this), Map$.MODULE$.canBuildFrom());
        this.kafka$log$LogManager$$logRollDefaultIntervalMs = 3600000L * (long)kafkaConfig.logRollHours();
        this.kafka$log$LogManager$$logCleanupIntervalMs = 60000L * (long)kafkaConfig.logCleanupIntervalMins();
        this.kafka$log$LogManager$$logCleanupDefaultAgeMs = 3600000L * (long)kafkaConfig.logRetentionHours();
        this.logIdent_$eq(new StringBuilder().append((Object)"[Log Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)kafkaConfig.brokerId())).append((Object)"] ").toString());
        this.kafka$log$LogManager$$logs = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.createAndValidateLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])this.logDirs()));
        this.dirLocks = this.lockLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])this.logDirs()));
        this.loadLogs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])this.logDirs()));
    }
}

