/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Range;
import kafka.utils.Range$class;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t)!+\u00198hKB\u0011q\"F\u0005\u0003-A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001a\u0003)iWm]:bO\u0016\u001cV\r^\u000b\u00025A\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u000f\r&dW-T3tg\u0006<WmU3u\u0011!y\u0002A!A!\u0002\u0013Q\u0012aC7fgN\fw-Z*fi\u0002B\u0001\"\t\u0001\u0003\u0006\u0004%\tAI\u0001\u0006S:$W\r_\u000b\u0002GA\u00111\u0004J\u0005\u0003K\t\u00111b\u00144gg\u0016$\u0018J\u001c3fq\"Aq\u0005\u0001B\u0001B\u0003%1%\u0001\u0004j]\u0012,\u0007\u0010\t\u0005\tS\u0001\u0011)\u0019!C\u0001U\u0005)1\u000f^1siV\t1\u0006\u0005\u0002\nY%\u0011QF\u0003\u0002\u0005\u0019>tw\r\u0003\u00050\u0001\t\u0005\t\u0015!\u0003,\u0003\u0019\u0019H/\u0019:uA!A\u0011\u0007\u0001BC\u0002\u0013\u0005!'\u0001\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001cX#A\u001a\u0011\u0005%!\u0014BA\u001b\u000b\u0005\rIe\u000e\u001e\u0005\to\u0001\u0011\t\u0011)A\u0005g\u0005\u0019\u0012N\u001c3fq&sG/\u001a:wC2\u0014\u0015\u0010^3tA!A\u0011\b\u0001B\u0001B\u0003%!(\u0001\u0003uS6,\u0007CA\b<\u0013\ta\u0004C\u0001\u0003US6,\u0007\"\u0002 \u0001\t\u0003y\u0014A\u0002\u001fj]&$h\b\u0006\u0004A\u0003\n\u001bE)\u0012\t\u00037\u0001AQ\u0001G\u001fA\u0002iAQ!I\u001fA\u0002\rBQ!K\u001fA\u0002-BQ!M\u001fA\u0002MBQ!O\u001fA\u0002iBqa\u0012\u0001A\u0002\u0013\u0005\u0001*A\bgSJ\u001cH/\u00119qK:$G+[7f+\u0005I\u0005cA\u0005KW%\u00111J\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f5\u0003\u0001\u0019!C\u0001\u001d\u0006\u0019b-\u001b:ti\u0006\u0003\b/\u001a8e)&lWm\u0018\u0013fcR\u0011qJ\u0015\t\u0003\u0013AK!!\u0015\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b'2\u000b\t\u00111\u0001J\u0003\rAH%\r\u0005\u0007+\u0002\u0001\u000b\u0015B%\u0002!\u0019L'o\u001d;BaB,g\u000e\u001a+j[\u0016\u0004\u0003bB,\u0001\u0001\u0004%\tAM\u0001\u0019Ef$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJL\bbB-\u0001\u0001\u0004%\tAW\u0001\u001dEf$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJLx\fJ3r)\ty5\fC\u0004T1\u0006\u0005\t\u0019A\u001a\t\ru\u0003\u0001\u0015)\u00034\u0003e\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/\u001f\u0011\t\u000f}\u0003\u0001\u0019!C\u0001A\u00069A-\u001a7fi\u0016$W#A1\u0011\u0005%\u0011\u0017BA2\u000b\u0005\u001d\u0011un\u001c7fC:Dq!\u001a\u0001A\u0002\u0013\u0005a-A\u0006eK2,G/\u001a3`I\u0015\fHCA(h\u0011\u001d\u0019F-!AA\u0002\u0005Da!\u001b\u0001!B\u0013\t\u0017\u0001\u00033fY\u0016$X\r\u001a\u0011)\u0005!\\\u0007CA\u0005m\u0013\ti'B\u0001\u0005w_2\fG/\u001b7f\u0011\u0015q\u0004\u0001\"\u0001p)\u0015\u0001\u0005O\u001f?~\u0011\u0015\th\u000e1\u0001s\u0003\r!\u0017N\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\f!![8\u000b\u0003]\fAA[1wC&\u0011\u0011\u0010\u001e\u0002\u0005\r&dW\rC\u0003|]\u0002\u00071&A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\b\"B\u0019o\u0001\u0004\u0019\u0004\"\u0002@o\u0001\u0004\u0019\u0014\u0001D7bq&sG-\u001a=TSj,\u0007BBA\u0001\u0001\u0011\u0005!&\u0001\u0003tSj,\u0007bBA\u0003\u0001\u0011\u0005\u0011qA\u0001\u0016kB$\u0017\r^3GSJ\u001cH/\u00119qK:$G+[7f)\u0005y\u0005bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\u0007CB\u0004XM\u001c3\u0015\u000b=\u000by!a\u0005\t\u000f\u0005E\u0011\u0011\u0002a\u0001W\u00051qN\u001a4tKRD\u0001\"!\u0006\u0002\n\u0001\u0007\u0011qC\u0001\t[\u0016\u001c8/Y4fgB!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e\u0011\tq!\\3tg\u0006<W-\u0003\u0003\u0002\"\u0005m!\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+G\u000fC\u0004\u0002&\u0001!I!a\n\u0002\u001fQ\u0014\u0018M\\:mCR,wJ\u001a4tKR$B!!\u000b\u00020A\u00191$a\u000b\n\u0007\u00055\"A\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u000f\u0005E\u00111\u0005a\u0001W!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0012\u0001\u0002:fC\u0012$\u0002\"a\u000e\u0002>\u0005}\u00121\t\t\u0005\u00033\tI$\u0003\u0003\u0002<\u0005m!AC'fgN\fw-Z*fi\"110!\rA\u0002-Bq!!\u0011\u00022\u0001\u00071'A\u0004nCb\u001c\u0016N_3\t\u000f\u0005\u0015\u0013\u0011\u0007a\u0001\u0013\u0006IQ.\u0019=PM\u001a\u001cX\r\u001e\u0005\b\u0003\u0013\u0002A\u0011IA&\u0003!!xn\u0015;sS:<GCAA'!\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*m\u0006!A.\u00198h\u0013\u0011\t9&!\u0015\u0003\rM#(/\u001b8h\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\n!\u0002\u001e:v]\u000e\fG/\u001a+p)\ry\u0015q\f\u0005\b\u0003#\tI\u00061\u0001,\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003K\n!B\\3yi>3gm]3u)\u0005Y\u0003bBA5\u0001\u0011\u0005\u0011qA\u0001\u0006M2,8\u000f\u001b\u0005\b\u0003[\u0002A\u0011AA\u0004\u0003\u0015\u0019Gn\\:fQ\r\u0001\u0011\u0011\u000f\t\u0004\u001f\u0005M\u0014bAA;!\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class LogSegment
implements Range,
Logging {
    private final FileMessageSet messageSet;
    private final OffsetIndex index;
    private final long start;
    private final int indexIntervalBytes;
    private final Time time;
    private Option<Object> firstAppendTime;
    private int bytesSinceLastIndexEntry;
    private volatile boolean deleted;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    @Override
    public boolean isEmpty() {
        return Range$class.isEmpty(this);
    }

    @Override
    public boolean contains(long l) {
        return Range$class.contains(this, l);
    }

    public FileMessageSet messageSet() {
        return this.messageSet;
    }

    public OffsetIndex index() {
        return this.index;
    }

    @Override
    public long start() {
        return this.start;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public Option<Object> firstAppendTime() {
        return this.firstAppendTime;
    }

    public void firstAppendTime_$eq(Option<Object> option) {
        this.firstAppendTime = option;
    }

    public int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    public void bytesSinceLastIndexEntry_$eq(int n) {
        this.bytesSinceLastIndexEntry = n;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public void deleted_$eq(boolean bl) {
        this.deleted = bl;
    }

    @Override
    public long size() {
        return this.messageSet().sizeInBytes();
    }

    public void updateFirstAppendTime() {
        if (this.firstAppendTime().isEmpty()) {
            this.firstAppendTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.milliseconds())));
        }
    }

    public void append(long l, ByteBufferMessageSet byteBufferMessageSet) {
        if (byteBufferMessageSet.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, l, byteBufferMessageSet){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long offset$1;
                private final ByteBufferMessageSet messages$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.messageSet().sizeInBytes())}));
                }
                {
                    if (logSegment == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logSegment;
                    this.offset$1 = l;
                    this.messages$1 = byteBufferMessageSet;
                }
            });
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(l, this.messageSet().sizeInBytes());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.messageSet().append(byteBufferMessageSet);
            this.updateFirstAppendTime();
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + byteBufferMessageSet.sizeInBytes());
        }
    }

    private OffsetPosition translateOffset(long l) {
        OffsetPosition offsetPosition = this.index().lookup(l);
        return this.messageSet().searchFor(l, offsetPosition.position());
    }

    public MessageSet read(long l, int n, Option<Object> option) {
        Option<Object> option2;
        block9: {
            int n2;
            OffsetPosition offsetPosition;
            block8: {
                int n3;
                block7: {
                    if (n < 0) {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
                    }
                    if (n == 0) {
                        return MessageSet$.MODULE$.Empty();
                    }
                    n3 = this.messageSet().sizeInBytes();
                    offsetPosition = this.translateOffset(l);
                    if (offsetPosition == null) {
                        return MessageSet$.MODULE$.Empty();
                    }
                    option2 = option;
                    None$ none$ = None$.MODULE$;
                    Option<Object> option3 = option2;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                    n2 = n;
                    break block8;
                }
                if (!(option2 instanceof Some)) break block9;
                Some some = (Some)option2;
                long l2 = BoxesRunTime.unboxToLong((Object)some.x());
                if (l2 < l) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to read with a maximum offset (%d) less than the start offset (%d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l2), BoxesRunTime.boxToLong((long)l)})));
                }
                OffsetPosition offsetPosition2 = this.translateOffset(l2);
                int n4 = offsetPosition2 == null ? n3 : offsetPosition2.position();
                n2 = package$.MODULE$.min(n4 - offsetPosition.position(), n);
            }
            int n5 = n2;
            return this.messageSet().read(offsetPosition.position(), n5);
        }
        throw new MatchError(option2);
    }

    @Override
    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(start=").append((Object)BoxesRunTime.boxToLong((long)this.start())).append((Object)", size=").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)")").toString();
    }

    public void truncateTo(long l) {
        OffsetPosition offsetPosition = this.translateOffset(l);
        if (offsetPosition == null) {
            return;
        }
        this.index().truncateTo(l);
        this.index().resize(this.index().maxIndexSize());
        this.messageSet().truncateTo(offsetPosition.position());
        if (this.messageSet().sizeInBytes() == 0) {
            this.firstAppendTime_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
    }

    public long nextOffset() {
        Option<MessageAndOffset> option;
        block4: {
            long l;
            block3: {
                block2: {
                    MessageSet messageSet = this.read(this.index().lastOffset(), this.messageSet().sizeInBytes(), (Option<Object>)None$.MODULE$);
                    option = messageSet.lastOption();
                    None$ none$ = None$.MODULE$;
                    Option<MessageAndOffset> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = this.start();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                MessageAndOffset messageAndOffset = (MessageAndOffset)some.x();
                l = messageAndOffset.nextOffset();
            }
            return l;
        }
        throw new MatchError(option);
    }

    public void flush() {
        this.messageSet().flush();
        this.index().flush();
    }

    public void close() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.index().close();
            }
            {
                if (logSegment == null) {
                    throw new NullPointerException();
                }
                this.$outer = logSegment;
            }
        });
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.messageSet().close();
            }
            {
                if (logSegment == null) {
                    throw new NullPointerException();
                }
                this.$outer = logSegment;
            }
        });
    }

    public LogSegment(FileMessageSet fileMessageSet, OffsetIndex offsetIndex, long l, int n, Time time) {
        this.messageSet = fileMessageSet;
        this.index = offsetIndex;
        this.start = l;
        this.indexIntervalBytes = n;
        this.time = time;
        Range$class.$init$(this);
        Logging$class.$init$(this);
        this.firstAppendTime = fileMessageSet.sizeInBytes() > 0 ? new Some((Object)BoxesRunTime.boxToLong((long)time.milliseconds())) : None$.MODULE$;
        this.bytesSinceLastIndexEntry = 0;
        this.deleted = false;
    }

    public LogSegment(File file, long l, int n, int n2) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(file, l)), new OffsetIndex(Log$.MODULE$.indexFilename(file, l), l, n2), l, n, SystemTime$.MODULE$);
    }
}

