/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.api.FetchRequest;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.RequestChannel$;
import kafka.network.RequestMetrics;
import kafka.network.RequestMetrics$;
import kafka.network.Send;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rEv!B\u0001\u0003\u0011\u00039\u0011A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0006\u0003\u0007\u0011\tqA\\3uo>\u00148NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011aBU3rk\u0016\u001cHo\u00115b]:,GnE\u0002\n\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u000beIA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u00059\u0001b\u0002\u000f\n\u0005\u0004%\t!H\u0001\b\u00032dGi\u001c8f+\u0005q\u0002CA\u0010!\u001b\u0005Ia\u0001B\u0011\n\u0001\n\u0012qAU3rk\u0016\u001cHo\u0005\u0003!\u0019\r2\u0003CA\u0007%\u0013\t)cBA\u0004Qe>$Wo\u0019;\u0011\u000559\u0013B\u0001\u0015\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!Q\u0003E!f\u0001\n\u0003Y\u0013!\u00039s_\u000e,7o]8s+\u0005a\u0003CA\u0007.\u0013\tqcBA\u0002J]RD\u0001\u0002\r\u0011\u0003\u0012\u0003\u0006I\u0001L\u0001\u000baJ|7-Z:t_J\u0004\u0003\u0002\u0003\u001a!\u0005+\u0007I\u0011A\u001a\u0002\u0015I,\u0017/^3ti.+\u00170F\u00015!\tiQ'\u0003\u00027\u001d\t\u0019\u0011I\\=\t\u0011a\u0002#\u0011#Q\u0001\nQ\n1B]3rk\u0016\u001cHoS3zA!A!\b\tBA\u0002\u0013%1(\u0001\u0004ck\u001a4WM]\u000b\u0002yA\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0004]&|'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012!BQ=uK\n+hMZ3s\u0011!)\u0005E!a\u0001\n\u00131\u0015A\u00032vM\u001a,'o\u0018\u0013fcR\u0011qI\u0013\t\u0003\u001b!K!!\u0013\b\u0003\tUs\u0017\u000e\u001e\u0005\b\u0017\u0012\u000b\t\u00111\u0001=\u0003\rAH%\r\u0005\t\u001b\u0002\u0012\t\u0012)Q\u0005y\u00059!-\u001e4gKJ\u0004\u0003\u0002C(!\u0005+\u0007I\u0011\u0001)\u0002\u0017M$\u0018M\u001d;US6,Wj]\u000b\u0002#B\u0011QBU\u0005\u0003':\u0011A\u0001T8oO\"AQ\u000b\tB\tB\u0003%\u0011+\u0001\u0007ti\u0006\u0014H\u000fV5nK6\u001b\b\u0005\u0003\u0005XA\tU\r\u0011\"\u0001Y\u00035\u0011X-\\8uK\u0006#GM]3tgV\t\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]\u0001\u0006\u0019a.\u001a;\n\u0005y[&!D*pG.,G/\u00113ee\u0016\u001c8\u000f\u0003\u0005aA\tE\t\u0015!\u0003Z\u00039\u0011X-\\8uK\u0006#GM]3tg\u0002BQ!\u0007\u0011\u0005\u0002\t$bAH2eK\u001a<\u0007\"\u0002\u0016b\u0001\u0004a\u0003\"\u0002\u001ab\u0001\u0004!\u0004\"\u0002\u001eb\u0001\u0004a\u0004\"B(b\u0001\u0004\t\u0006bB,b!\u0003\u0005\r!\u0017\u0005\bS\u0002\u0002\r\u0011\"\u0001Q\u00035!W-];fk\u0016$\u0016.\\3Ng\"91\u000e\ta\u0001\n\u0003a\u0017!\u00053fcV,W/\u001a+j[\u0016l5o\u0018\u0013fcR\u0011q)\u001c\u0005\b\u0017*\f\t\u00111\u0001R\u0011\u0019y\u0007\u0005)Q\u0005#\u0006qA-Z9vKV,G+[7f\u001bN\u0004\u0003F\u00018r!\ti!/\u0003\u0002t\u001d\tAao\u001c7bi&dW\rC\u0004vA\u0001\u0007I\u0011\u0001)\u0002-\u0005\u0004\u0018\u000eT8dC2\u001cu.\u001c9mKR,G+[7f\u001bNDqa\u001e\u0011A\u0002\u0013\u0005\u00010\u0001\u000eba&dunY1m\u0007>l\u0007\u000f\\3uKRKW.Z't?\u0012*\u0017\u000f\u0006\u0002Hs\"91J^A\u0001\u0002\u0004\t\u0006BB>!A\u0003&\u0011+A\fba&dunY1m\u0007>l\u0007\u000f\\3uKRKW.Z'tA!\u0012!0\u001d\u0005\b}\u0002\u0002\r\u0011\"\u0001Q\u0003Y\u0011Xm\u001d9p]N,7i\\7qY\u0016$X\rV5nK6\u001b\b\"CA\u0001A\u0001\u0007I\u0011AA\u0002\u0003i\u0011Xm\u001d9p]N,7i\\7qY\u0016$X\rV5nK6\u001bx\fJ3r)\r9\u0015Q\u0001\u0005\b\u0017~\f\t\u00111\u0001R\u0011\u001d\tI\u0001\tQ!\nE\u000bqC]3ta>t7/Z\"p[BdW\r^3US6,Wj\u001d\u0011)\u0007\u0005\u001d\u0011\u000fC\u0005\u0002\u0010\u0001\u0012\r\u0011\"\u0001\u0002\u0012\u0005I!/Z9vKN$\u0018\nZ\u000b\u0003\u0003'\u00012!DA\u000b\u0013\r\t9B\u0004\u0002\u0006'\"|'\u000f\u001e\u0005\t\u00037\u0001\u0003\u0015!\u0003\u0002\u0014\u0005Q!/Z9vKN$\u0018\n\u001a\u0011\t\u0013\u0005}\u0001E1A\u0005\u0002\u0005\u0005\u0012A\u0003:fcV,7\u000f^(cUV\u0011\u00111\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002.\u0005\u001d\"!\u0005*fcV,7\u000f^(s%\u0016\u001c\bo\u001c8tK\"A\u0011\u0011\u0007\u0011!\u0002\u0013\t\u0019#A\u0006sKF,Xm\u001d;PE*\u0004\u0003\"CA\u001bA\t\u0007I\u0011BA\u001c\u00035\u0011X-];fgRdunZ4feV\u0011\u0011\u0011\b\t\u0005\u0003w\tI%\u0004\u0002\u0002>)!\u0011qHA!\u0003\u0015awn\u001a\u001bk\u0015\u0011\t\u0019%!\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t9%A\u0002pe\u001eLA!a\u0013\u0002>\t1Aj\\4hKJD\u0001\"a\u0014!A\u0003%\u0011\u0011H\u0001\u000fe\u0016\fX/Z:u\u0019><w-\u001a:!\u0011\u001d\t\u0019\u0006\tC\u0001\u0003+\nA#\u001e9eCR,'+Z9vKN$X*\u001a;sS\u000e\u001cH#A$\t\u0013\u0005e\u0003%!A\u0005\u0002\u0005m\u0013\u0001B2paf$2BHA/\u0003?\n\t'a\u0019\u0002f!A!&a\u0016\u0011\u0002\u0003\u0007A\u0006\u0003\u00053\u0003/\u0002\n\u00111\u00015\u0011!Q\u0014q\u000bI\u0001\u0002\u0004a\u0004\u0002C(\u0002XA\u0005\t\u0019A)\t\u0011]\u000b9\u0006%AA\u0002eC\u0011\"!\u001b!#\u0003%\t!a\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u000e\u0016\u0004Y\u0005=4FAA9!\u0011\t\u0019(! \u000e\u0005\u0005U$\u0002BA<\u0003s\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005md\"\u0001\u0006b]:|G/\u0019;j_:LA!a \u0002v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\r\u0005%%A\u0005\u0002\u0005\u0015\u0015AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000fS3\u0001NA8\u0011%\tY\tII\u0001\n\u0003\ti)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005=%f\u0001\u001f\u0002p!I\u00111\u0013\u0011\u0012\u0002\u0013\u0005\u0011QS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t9JK\u0002R\u0003_B\u0011\"a'!#\u0003%\t!!(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u0014\u0016\u00043\u0006=\u0004\u0002CARA%\u0005I\u0011A\u001e\u0002\u0011\t,hMZ3sIEB\u0011\"a*!\u0003\u0003%\t%!+\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u000b\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\t\fQ\u0001\u0005Y\u0006tw-\u0003\u0003\u00026\u0006=&AB*ue&tw\r\u0003\u0005\u0002:\u0002\n\t\u0011\"\u0001,\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\ti\fIA\u0001\n\u0003\ty,\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007Q\n\t\r\u0003\u0005L\u0003w\u000b\t\u00111\u0001-\u0011%\t)\rIA\u0001\n\u0003\n9-A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\rE\u0003\u0002L\u0006EG'\u0004\u0002\u0002N*\u0019\u0011q\u001a\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002T\u00065'\u0001C%uKJ\fGo\u001c:\t\u0013\u0005]\u0007%!A\u0005\u0002\u0005e\u0017\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m\u0017\u0011\u001d\t\u0004\u001b\u0005u\u0017bAAp\u001d\t9!i\\8mK\u0006t\u0007\u0002C&\u0002V\u0006\u0005\t\u0019\u0001\u001b\t\u0013\u0005\u0015\b%!A\u0005B\u0005\u001d\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u00031B\u0011\"a;!\u0003\u0003%\t%!<\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a+\t\u0013\u0005E\b%!A\u0005B\u0005M\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\\\u0006U\b\u0002C&\u0002p\u0006\u0005\t\u0019\u0001\u001b\t\u000f\u0005e\u0018\u0002)A\u0005=\u0005A\u0011\t\u001c7E_:,\u0007\u0005C\u0004\u0002~&!\t!a@\u0002%\u001d,Go\u00155vi\u0012|wO\u001c*fG\u0016Lg/\u001a\u000b\u0002y\u001dI!1A\u0005\u0002\u0002#\u0005!QA\u0001\b%\u0016\fX/Z:u!\ry\"q\u0001\u0004\tC%\t\t\u0011#\u0001\u0003\nM)!q\u0001B\u0006MAQ!Q\u0002B\nYQb\u0014+\u0017\u0010\u000e\u0005\t=!b\u0001B\t\u001d\u00059!/\u001e8uS6,\u0017\u0002\u0002B\u000b\u0005\u001f\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c86\u0011\u001dI\"q\u0001C\u0001\u00053!\"A!\u0002\t\u0015\u0005-(qAA\u0001\n\u000b\ni\u000f\u0003\u0006\u0003 \t\u001d\u0011\u0011!CA\u0005C\tQ!\u00199qYf$2B\bB\u0012\u0005K\u00119C!\u000b\u0003,!1!F!\bA\u00021BaA\rB\u000f\u0001\u0004!\u0004B\u0002\u001e\u0003\u001e\u0001\u0007A\b\u0003\u0004P\u0005;\u0001\r!\u0015\u0005\t/\nu\u0001\u0013!a\u00013\"Q!q\u0006B\u0004\u0003\u0003%\tI!\r\u0002\u000fUt\u0017\r\u001d9msR!!1\u0007B !\u0015i!Q\u0007B\u001d\u0013\r\u00119D\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00115\u0011Y\u0004\f\u001b=#fK1A!\u0010\u000f\u0005\u0019!V\u000f\u001d7fk!I!\u0011\tB\u0017\u0003\u0003\u0005\rAH\u0001\u0004q\u0012\u0002\u0004B\u0003B#\u0005\u000f\t\n\u0011\"\u0001\u0002\u001e\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIUB!B!\u0013\u0003\bE\u0005I\u0011AAO\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0004B\u0003B'\u0005\u000f\t\t\u0011\"\u0003\u0003P\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0006\u0005\u0003\u0002.\nM\u0013\u0002\u0002B+\u0003_\u0013aa\u00142kK\u000e$hA\u0002B-\u0013\u0001\u0013YF\u0001\u0005SKN\u0004xN\\:f'\u0015\u00119\u0006D\u0012'\u0011%Q#q\u000bBK\u0002\u0013\u00051\u0006C\u00051\u0005/\u0012\t\u0012)A\u0005Y!Q!1\rB,\u0005+\u0007I\u0011A\u000f\u0002\u000fI,\u0017/^3ti\"Q!q\rB,\u0005#\u0005\u000b\u0011\u0002\u0010\u0002\u0011I,\u0017/^3ti\u0002B1Ba\u001b\u0003X\tU\r\u0011\"\u0001\u0003n\u0005a!/Z:q_:\u001cXmU3oIV\u0011!q\u000e\t\u0004\u0011\tE\u0014b\u0001B:\u0005\t!1+\u001a8e\u0011-\u00119Ha\u0016\u0003\u0012\u0003\u0006IAa\u001c\u0002\u001bI,7\u000f]8og\u0016\u001cVM\u001c3!\u0011\u001dI\"q\u000bC\u0001\u0005w\"\u0002B! \u0003\u0000\t\u0005%1\u0011\t\u0004?\t]\u0003B\u0002\u0016\u0003z\u0001\u0007A\u0006C\u0004\u0003d\te\u0004\u0019\u0001\u0010\t\u0011\t-$\u0011\u0010a\u0001\u0005_Bq!\u0007B,\t\u0003\u00119\t\u0006\u0004\u0003~\t%%1\u0012\u0005\b\u0005G\u0012)\t1\u0001\u001f\u0011!\u0011iI!\"A\u0002\t=\u0014\u0001B:f]\u0012D!\"!\u0017\u0003X\u0005\u0005I\u0011\u0001BI)!\u0011iHa%\u0003\u0016\n]\u0005\u0002\u0003\u0016\u0003\u0010B\u0005\t\u0019\u0001\u0017\t\u0013\t\r$q\u0012I\u0001\u0002\u0004q\u0002B\u0003B6\u0005\u001f\u0003\n\u00111\u0001\u0003p!Q\u0011\u0011\u000eB,#\u0003%\t!a\u001b\t\u0015\u0005\r%qKI\u0001\n\u0003\u0011i*\u0006\u0002\u0003 *\u001aa$a\u001c\t\u0015\u0005-%qKI\u0001\n\u0003\u0011\u0019+\u0006\u0002\u0003&*\"!qNA8\u0011)\t9Ka\u0016\u0002\u0002\u0013\u0005\u0013\u0011\u0016\u0005\n\u0003s\u00139&!A\u0005\u0002-B!\"!0\u0003X\u0005\u0005I\u0011\u0001BW)\r!$q\u0016\u0005\t\u0017\n-\u0016\u0011!a\u0001Y!Q\u0011Q\u0019B,\u0003\u0003%\t%a2\t\u0015\u0005]'qKA\u0001\n\u0003\u0011)\f\u0006\u0003\u0002\\\n]\u0006\u0002C&\u00034\u0006\u0005\t\u0019\u0001\u001b\t\u0015\u0005\u0015(qKA\u0001\n\u0003\n9\u000f\u0003\u0006\u0002l\n]\u0013\u0011!C!\u0003[D!\"!=\u0003X\u0005\u0005I\u0011\tB`)\u0011\tYN!1\t\u0011-\u0013i,!AA\u0002Q:\u0011B!2\n\u0003\u0003E\tAa2\u0002\u0011I+7\u000f]8og\u0016\u00042a\bBe\r%\u0011I&CA\u0001\u0012\u0003\u0011YmE\u0003\u0003J\n5g\u0005\u0005\u0006\u0003\u000e\t=GF\bB8\u0005{JAA!5\u0003\u0010\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000fe\u0011I\r\"\u0001\u0003VR\u0011!q\u0019\u0005\u000b\u0003W\u0014I-!A\u0005F\u00055\bB\u0003B\u0010\u0005\u0013\f\t\u0011\"!\u0003\\RA!Q\u0010Bo\u0005?\u0014\t\u000f\u0003\u0004+\u00053\u0004\r\u0001\f\u0005\b\u0005G\u0012I\u000e1\u0001\u001f\u0011!\u0011YG!7A\u0002\t=\u0004B\u0003B\u0018\u0005\u0013\f\t\u0011\"!\u0003fR!!q\u001dBx!\u0015i!Q\u0007Bu!\u001di!1\u001e\u0017\u001f\u0005_J1A!<\u000f\u0005\u0019!V\u000f\u001d7fg!Q!\u0011\tBr\u0003\u0003\u0005\rA! \t\u0015\t5#\u0011ZA\u0001\n\u0013\u0011yEB\u0003\u000b\u0005\u0001\u0011)pE\u0003\u0003t2\u00119\u0010\u0005\u0003\u0003z\n}XB\u0001B~\u0015\r\u0011i\u0010B\u0001\b[\u0016$(/[2t\u0013\u0011\u0019\tAa?\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0006\u0004\u0006\tM(Q1A\u0005\u0002-\nQB\\;n!J|7-Z:t_J\u001c\bBCB\u0005\u0005g\u0014\t\u0011)A\u0005Y\u0005qa.^7Qe>\u001cWm]:peN\u0004\u0003BCB\u0007\u0005g\u0014)\u0019!C\u0001W\u0005I\u0011/^3vKNK'0\u001a\u0005\u000b\u0007#\u0011\u0019P!A!\u0002\u0013a\u0013AC9vKV,7+\u001b>fA!9\u0011Da=\u0005\u0002\rUACBB\f\u00073\u0019Y\u0002E\u0002\t\u0005gDqa!\u0002\u0004\u0014\u0001\u0007A\u0006C\u0004\u0004\u000e\rM\u0001\u0019\u0001\u0017\t\u0015\r}!1\u001fa\u0001\n\u0013\u0019\t#A\tsKN\u0004xN\\:f\u0019&\u001cH/\u001a8feN,\"aa\t\u0011\r\r\u00152QGB\u001e\u001d\u0011\u00199c!\r\u000f\t\r%2qF\u0007\u0003\u0007WQ1a!\f\u0007\u0003\u0019a$o\\8u}%\tq\"C\u0002\u000449\tq\u0001]1dW\u0006<W-\u0003\u0003\u00048\re\"\u0001\u0002'jgRT1aa\r\u000f!\u0015i1Q\b\u0017H\u0013\r\u0019yD\u0004\u0002\n\rVt7\r^5p]FB!ba\u0011\u0003t\u0002\u0007I\u0011BB#\u0003U\u0011Xm\u001d9p]N,G*[:uK:,'o]0%KF$2aRB$\u0011%Y5\u0011IA\u0001\u0002\u0004\u0019\u0019\u0003C\u0005\u0004L\tM\b\u0015)\u0003\u0004$\u0005\u0011\"/Z:q_:\u001cX\rT5ti\u0016tWM]:!\u0011)\u0019yEa=C\u0002\u0013%1\u0011K\u0001\re\u0016\fX/Z:u#V,W/Z\u000b\u0003\u0007'\u0002ba!\u0016\u0004`\r\rTBAB,\u0015\u0011\u0019Ifa\u0017\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0004^\u0001\u000bA!\u001e;jY&!1\u0011MB,\u0005I\t%O]1z\u00052|7m[5oOF+X-^3\u0011\u0007\r\u0015\u0004E\u0004\u0002\t\u0001!I1\u0011\u000eBzA\u0003%11K\u0001\u000ee\u0016\fX/Z:u#V,W/\u001a\u0011\t\u0015\r5$1\u001fb\u0001\n\u0013\u0019y'\u0001\bsKN\u0004xN\\:f#V,W/Z:\u0016\u0005\rE\u0004#B\u0007\u0004t\r]\u0014bAB;\u001d\t)\u0011I\u001d:bsB11QKB=\u0007{JAaa\u001f\u0004X\ti!\t\\8dW&tw-U;fk\u0016\u0004Ba!\u001a\u0003X!I1\u0011\u0011BzA\u0003%1\u0011O\u0001\u0010e\u0016\u001c\bo\u001c8tKF+X-^3tA!A1Q\u0011Bz\t\u0003\u00199)A\u0006tK:$'+Z9vKN$HcA$\u0004\n\"A!1MBB\u0001\u0004\u0019\u0019\u0007\u0003\u0005\u0004\u000e\nMH\u0011ABH\u00031\u0019XM\u001c3SKN\u0004xN\\:f)\r95\u0011\u0013\u0005\t\u0007'\u001bY\t1\u0001\u0004~\u0005A!/Z:q_:\u001cX\r\u0003\u0005\u0004\u0018\nMH\u0011ABM\u00039\u0011XmY3jm\u0016\u0014V-];fgR$\"aa\u0019\t\u0011\ru%1\u001fC\u0001\u0007?\u000bqB]3dK&4XMU3ta>t7/\u001a\u000b\u0005\u0007{\u001a\t\u000b\u0003\u0004+\u00077\u0003\r\u0001\f\u0005\t\u0007K\u0013\u0019\u0010\"\u0001\u0004(\u0006\u0019\u0012\r\u001a3SKN\u0004xN\\:f\u0019&\u001cH/\u001a8feR\u0019qi!+\t\u0011\r-61\u0015a\u0001\u0007w\t!b\u001c8SKN\u0004xN\\:f\u0011!\u0019yKa=\u0005\u0002\u0005U\u0013\u0001C:ikR$wn\u001e8")
public class RequestChannel
implements KafkaMetricsGroup {
    private final int numProcessors;
    private final int queueSize;
    private List<Function1<Object, BoxedUnit>> responseListeners;
    private final ArrayBlockingQueue<Request> kafka$network$RequestChannel$$requestQueue;
    private final BlockingQueue<Response>[] kafka$network$RequestChannel$$responseQueues;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static ByteBuffer getShutdownReceive() {
        return RequestChannel$.MODULE$.getShutdownReceive();
    }

    public static Request AllDone() {
        return RequestChannel$.MODULE$.AllDone();
    }

    @Override
    public <T> Gauge<T> newGauge(String string, Gauge<T> gauge) {
        return KafkaMetricsGroup$class.newGauge(this, string, gauge);
    }

    @Override
    public Meter newMeter(String string, String string2, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, string, string2, timeUnit);
    }

    @Override
    public Histogram newHistogram(String string, boolean bl) {
        return KafkaMetricsGroup$class.newHistogram(this, string, bl);
    }

    @Override
    public Timer newTimer(String string, TimeUnit timeUnit, TimeUnit timeUnit2) {
        return KafkaMetricsGroup$class.newTimer(this, string, timeUnit, timeUnit2);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        RequestChannel requestChannel = this;
        synchronized (requestChannel) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public int numProcessors() {
        return this.numProcessors;
    }

    public int queueSize() {
        return this.queueSize;
    }

    private List<Function1<Object, BoxedUnit>> responseListeners() {
        return this.responseListeners;
    }

    private void responseListeners_$eq(List<Function1<Object, BoxedUnit>> list) {
        this.responseListeners = list;
    }

    public ArrayBlockingQueue<Request> kafka$network$RequestChannel$$requestQueue() {
        return this.kafka$network$RequestChannel$$requestQueue;
    }

    public BlockingQueue<Response>[] kafka$network$RequestChannel$$responseQueues() {
        return this.kafka$network$RequestChannel$$responseQueues;
    }

    public void sendRequest(Request request) {
        this.kafka$network$RequestChannel$$requestQueue().put(request);
    }

    public void sendResponse(Response response) {
        this.kafka$network$RequestChannel$$responseQueues()[response.processor()].put(response);
        this.responseListeners().foreach((Function1)new Serializable(this, response){
            public static final long serialVersionUID = 0L;
            private final Response response$1;

            public final void apply(Function1<Object, BoxedUnit> function1) {
                function1.apply$mcVI$sp(this.response$1.processor());
            }
            {
                this.response$1 = response;
            }
        });
    }

    public Request receiveRequest() {
        return this.kafka$network$RequestChannel$$requestQueue().take();
    }

    public Response receiveResponse(int n) {
        return (Response)this.kafka$network$RequestChannel$$responseQueues()[n].poll();
    }

    public void addResponseListener(Function1<Object, BoxedUnit> function1) {
        this.responseListeners_$eq((List<Function1<Object, BoxedUnit>>)this.responseListeners().$colon$colon(function1));
    }

    public void shutdown() {
        this.kafka$network$RequestChannel$$requestQueue().clear();
    }

    public RequestChannel(int n, int n2) {
        this.numProcessors = n;
        this.queueSize = n2;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.responseListeners = Nil$.MODULE$;
        this.kafka$network$RequestChannel$$requestQueue = new ArrayBlockingQueue(n2);
        this.kafka$network$RequestChannel$$responseQueues = new BlockingQueue[n];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RequestChannel $outer;

            public final void apply(int n) {
                this.apply$mcVI$sp(n);
            }

            public void apply$mcVI$sp(int n) {
                this.$outer.kafka$network$RequestChannel$$responseQueues()[n] = new LinkedBlockingQueue<Response>();
            }
            {
                if (requestChannel == null) {
                    throw new NullPointerException();
                }
                this.$outer = requestChannel;
            }
        });
        this.newGauge("RequestQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ RequestChannel $outer;

            public int value() {
                return this.$outer.kafka$network$RequestChannel$$requestQueue().size();
            }
            {
                if (requestChannel == null) {
                    throw new NullPointerException();
                }
                this.$outer = requestChannel;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RequestChannel $outer;

            public final Gauge<Object> apply(int n) {
                return this.$outer.newGauge(new StringBuilder().append((Object)"Processor-").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)"-ResponseQueueSize").toString(), new Gauge<Object>(this, n){
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final int i$1;

                    public int value() {
                        return this.$outer.kafka$network$RequestChannel$$anonfun$$$outer().kafka$network$RequestChannel$$responseQueues()[this.i$1].size();
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                        this.i$1 = n;
                    }
                });
            }

            public /* synthetic */ RequestChannel kafka$network$RequestChannel$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (requestChannel == null) {
                    throw new NullPointerException();
                }
                this.$outer = requestChannel;
            }
        });
    }

    public static class Request
    implements Product,
    Serializable {
        private final int processor;
        private final Object requestKey;
        private ByteBuffer kafka$network$RequestChannel$Request$$buffer;
        private final long startTimeMs;
        private final SocketAddress remoteAddress;
        private volatile long dequeueTimeMs;
        private volatile long apiLocalCompleteTimeMs;
        private volatile long responseCompleteTimeMs;
        private final short requestId;
        private final RequestOrResponse requestObj;
        private final Logger requestLogger;

        public ByteBuffer buffer$1() {
            return this.kafka$network$RequestChannel$Request$$buffer;
        }

        public int processor() {
            return this.processor;
        }

        public Object requestKey() {
            return this.requestKey;
        }

        public ByteBuffer kafka$network$RequestChannel$Request$$buffer() {
            return this.kafka$network$RequestChannel$Request$$buffer;
        }

        private void kafka$network$RequestChannel$Request$$buffer_$eq(ByteBuffer byteBuffer) {
            this.kafka$network$RequestChannel$Request$$buffer = byteBuffer;
        }

        public long startTimeMs() {
            return this.startTimeMs;
        }

        public SocketAddress remoteAddress() {
            return this.remoteAddress;
        }

        public long dequeueTimeMs() {
            return this.dequeueTimeMs;
        }

        public void dequeueTimeMs_$eq(long l) {
            this.dequeueTimeMs = l;
        }

        public long apiLocalCompleteTimeMs() {
            return this.apiLocalCompleteTimeMs;
        }

        public void apiLocalCompleteTimeMs_$eq(long l) {
            this.apiLocalCompleteTimeMs = l;
        }

        public long responseCompleteTimeMs() {
            return this.responseCompleteTimeMs;
        }

        public void responseCompleteTimeMs_$eq(long l) {
            this.responseCompleteTimeMs = l;
        }

        public short requestId() {
            return this.requestId;
        }

        public RequestOrResponse requestObj() {
            return this.requestObj;
        }

        private Logger requestLogger() {
            return this.requestLogger;
        }

        public void updateRequestMetrics() {
            long l = SystemTime$.MODULE$.milliseconds();
            if (this.apiLocalCompleteTimeMs() < 0L) {
                this.apiLocalCompleteTimeMs_$eq(this.responseCompleteTimeMs());
            }
            long l2 = BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(this.dequeueTimeMs() - this.startTimeMs())).max((Object)BoxesRunTime.boxToLong((long)0L)));
            long l3 = BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(this.apiLocalCompleteTimeMs() - this.dequeueTimeMs())).max((Object)BoxesRunTime.boxToLong((long)0L)));
            long l4 = BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(this.responseCompleteTimeMs() - this.apiLocalCompleteTimeMs())).max((Object)BoxesRunTime.boxToLong((long)0L)));
            long l5 = BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(l - this.responseCompleteTimeMs())).max((Object)BoxesRunTime.boxToLong((long)0L)));
            long l6 = l - this.startTimeMs();
            List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RequestMetrics[]{(RequestMetrics)RequestMetrics$.MODULE$.metricsMap().apply((Object)RequestKeys$.MODULE$.nameForKey(this.requestId()))}));
            if (this.requestId() == RequestKeys$.MODULE$.FetchKey()) {
                boolean bl = ((FetchRequest)this.requestObj()).isFromFollower();
                list = list.$colon$colon(bl ? RequestMetrics$.MODULE$.metricsMap().apply((Object)RequestMetrics$.MODULE$.followFetchMetricName()) : RequestMetrics$.MODULE$.metricsMap().apply((Object)RequestMetrics$.MODULE$.consumerFetchMetricName()));
            }
            list.foreach((Function1)new Serializable(this, l2, l3, l4, l5, l6){
                public static final long serialVersionUID = 0L;
                private final long queueTime$1;
                private final long apiLocalTime$1;
                private final long apiRemoteTime$1;
                private final long responseSendTime$1;
                private final long totalTime$1;

                public final void apply(RequestMetrics requestMetrics) {
                    requestMetrics.requestRate().mark();
                    requestMetrics.queueTimeHist().update(this.queueTime$1);
                    requestMetrics.localTimeHist().update(this.apiLocalTime$1);
                    requestMetrics.remoteTimeHist().update(this.apiRemoteTime$1);
                    requestMetrics.responseSendTimeHist().update(this.responseSendTime$1);
                    requestMetrics.totalTimeHist().update(this.totalTime$1);
                }
                {
                    this.queueTime$1 = l;
                    this.apiLocalTime$1 = l2;
                    this.apiRemoteTime$1 = l3;
                    this.responseSendTime$1 = l4;
                    this.totalTime$1 = l5;
                }
            });
            if (this.requestLogger().isTraceEnabled()) {
                this.requestLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Completed request:%s from client %s;totalTime:%d,queueTime:%d,localTime:%d,remoteTime:%d,sendTime:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.requestObj(), this.remoteAddress(), BoxesRunTime.boxToLong((long)l6), BoxesRunTime.boxToLong((long)l2), BoxesRunTime.boxToLong((long)l3), BoxesRunTime.boxToLong((long)l4), BoxesRunTime.boxToLong((long)l5)})));
            }
        }

        public Request copy(int n, Object object, ByteBuffer byteBuffer, long l, SocketAddress socketAddress) {
            return new Request(n, object, byteBuffer, l, socketAddress);
        }

        public int copy$default$1() {
            return this.processor();
        }

        public Object copy$default$2() {
            return this.requestKey();
        }

        public ByteBuffer copy$default$3() {
            return this.kafka$network$RequestChannel$Request$$buffer();
        }

        public long copy$default$4() {
            return this.startTimeMs();
        }

        public SocketAddress copy$default$5() {
            return this.remoteAddress();
        }

        public String productPrefix() {
            return "Request";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 4: {
                    object = this.remoteAddress();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.startTimeMs());
                    break;
                }
                case 2: {
                    object = this.buffer$1();
                    break;
                }
                case 1: {
                    object = this.requestKey();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.processor());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object object) {
            return object instanceof Request;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.processor());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.requestKey()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.buffer$1()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.startTimeMs()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteAddress()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof Request)) return false;
            boolean bl = true;
            if (!bl) return false;
            Request request = (Request)object;
            if (this.processor() != request.processor()) return false;
            if (!BoxesRunTime.equals((Object)this.requestKey(), (Object)request.requestKey())) return false;
            ByteBuffer byteBuffer = this.buffer$1();
            ByteBuffer byteBuffer2 = request.buffer$1();
            if (byteBuffer == null) {
                if (byteBuffer2 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
            if (this.startTimeMs() != request.startTimeMs()) return false;
            SocketAddress socketAddress = this.remoteAddress();
            SocketAddress socketAddress2 = request.remoteAddress();
            if (socketAddress == null) {
                if (socketAddress2 != null) {
                    return false;
                }
            } else if (!socketAddress.equals(socketAddress2)) return false;
            if (!request.canEqual(this)) return false;
            return true;
        }

        public Request(int n, Object object, ByteBuffer byteBuffer, long l, SocketAddress socketAddress) {
            this.processor = n;
            this.requestKey = object;
            this.kafka$network$RequestChannel$Request$$buffer = byteBuffer;
            this.startTimeMs = l;
            this.remoteAddress = socketAddress;
            Product.class.$init$((Product)this);
            this.dequeueTimeMs = -1L;
            this.apiLocalCompleteTimeMs = -1L;
            this.responseCompleteTimeMs = -1L;
            this.requestId = this.kafka$network$RequestChannel$Request$$buffer().getShort();
            this.requestObj = (RequestOrResponse)RequestKeys$.MODULE$.deserializerForKey(this.requestId()).apply((Object)this.kafka$network$RequestChannel$Request$$buffer());
            this.kafka$network$RequestChannel$Request$$buffer_$eq(null);
            this.requestLogger = Logger.getLogger((String)"kafka.request.logger");
            RequestChannel$.MODULE$.trace((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Request $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Processor %d received request : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.processor()), this.$outer.requestObj()}));
                }
                {
                    if (request == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = request;
                }
            });
        }
    }

    public static class Response
    implements Product,
    Serializable {
        private final int processor;
        private final Request request;
        private final Send responseSend;

        public int processor() {
            return this.processor;
        }

        public Request request() {
            return this.request;
        }

        public Send responseSend() {
            return this.responseSend;
        }

        public Response copy(int n, Request request, Send send2) {
            return new Response(n, request, send2);
        }

        public int copy$default$1() {
            return this.processor();
        }

        public Request copy$default$2() {
            return this.request();
        }

        public Send copy$default$3() {
            return this.responseSend();
        }

        public String productPrefix() {
            return "Response";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 2: {
                    object = this.responseSend();
                    break;
                }
                case 1: {
                    object = this.request();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.processor());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object object) {
            return object instanceof Response;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.processor());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.request()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.responseSend()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof Response)) return false;
            boolean bl = true;
            if (!bl) return false;
            Response response = (Response)object;
            if (this.processor() != response.processor()) return false;
            Request request = this.request();
            Request request2 = response.request();
            if (request == null) {
                if (request2 != null) {
                    return false;
                }
            } else if (!((Object)request).equals(request2)) return false;
            Send send2 = this.responseSend();
            Send send3 = response.responseSend();
            if (send2 == null) {
                if (send3 != null) {
                    return false;
                }
            } else if (!send2.equals(send3)) return false;
            if (!response.canEqual(this)) return false;
            return true;
        }

        public Response(int n, Request request, Send send2) {
            this.processor = n;
            this.request = request;
            this.responseSend = send2;
            Product.class.$init$((Product)this);
            request.responseCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
        }

        public Response(Request request, Send send2) {
            this(request.processor(), request, send2);
        }
    }
}

