/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SocketChannel;
import kafka.common.ErrorMapping$;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.network.Send;
import kafka.network.Send$class;
import kafka.network.Transmission$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0001\u0002\u0001\u0005\u0019\u0011a\"T3tg\u0006<WmU3u'\u0016tGM\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\n\u0004\u0001\u001di\u0001C\u0001\u0005\f\u001b\u0005I!\"\u0001\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00051I!AB!osJ+g\r\u0005\u0002\u000f#5\tqB\u0003\u0002\u0011\t\u00059a.\u001a;x_J\\\u0017B\u0001\n\u0010\u0005\u0011\u0019VM\u001c3\t\u0011Q\u0001!Q1A\u0005\u0002Y\t\u0001\"\\3tg\u0006<Wm]\u0002\u0001+\u00059\u0002C\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u0005\u0003\u001diWm]:bO\u0016L!\u0001H\r\u0003\u00155+7o]1hKN+G\u000f\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%iWm]:bO\u0016\u001c\b\u0005\u0003\u0005!\u0001\t\u0015\r\u0011\"\u0001\"\u0003%)'O]8s\u0007>$W-F\u0001#!\tA1%\u0003\u0002%\u0013\t)1\u000b[8si\"Aa\u0005\u0001B\u0001B\u0003%!%\u0001\u0006feJ|'oQ8eK\u0002BQ\u0001\u000b\u0001\u0005\u0002%\na\u0001P5oSRtDc\u0001\u0016-[A\u00111\u0006A\u0007\u0002\u0005!)Ac\na\u0001/!)\u0001e\na\u0001E!9q\u0006\u0001a\u0001\n\u0013\u0001\u0014\u0001B:f]R,\u0012!\r\t\u0003\u0011IJ!aM\u0005\u0003\u0007%sG\u000fC\u00046\u0001\u0001\u0007I\u0011\u0002\u001c\u0002\u0011M,g\u000e^0%KF$\"a\u000e\u001e\u0011\u0005!A\u0014BA\u001d\n\u0005\u0011)f.\u001b;\t\u000fm\"\u0014\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\t\ru\u0002\u0001\u0015)\u00032\u0003\u0015\u0019XM\u001c;!\u0011\u001dy\u0004A1A\u0005\nA\nAa]5{K\"1\u0011\t\u0001Q\u0001\nE\nQa]5{K\u0002Bqa\u0011\u0001C\u0002\u0013%A)\u0001\u0004iK\u0006$WM]\u000b\u0002\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0004]&|'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013!BQ=uK\n+hMZ3s\u0011\u0019q\u0005\u0001)A\u0005\u000b\u00069\u0001.Z1eKJ\u0004\u0003b\u0002)\u0001\u0001\u0004%\t!U\u0001\tG>l\u0007\u000f\\3uKV\t!\u000b\u0005\u0002\t'&\u0011A+\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d1\u0006\u00011A\u0005\u0002]\u000bAbY8na2,G/Z0%KF$\"a\u000e-\t\u000fm*\u0016\u0011!a\u0001%\"1!\f\u0001Q!\nI\u000b\u0011bY8na2,G/\u001a\u0011\t\u000b!\u0002A\u0011\u0001/\u0015\u0005)j\u0006\"\u0002\u000b\\\u0001\u00049\u0002\"\u0002\u0015\u0001\t\u0003yF#\u0001\u0016\t\u000b\u0005\u0004A\u0011\u00012\u0002\u000f]\u0014\u0018\u000e^3U_R\u0011\u0011g\u0019\u0005\u0006I\u0002\u0004\r!Z\u0001\bG\"\fgN\\3m!\t1\u0017.D\u0001h\u0015\tAw)\u0001\u0005dQ\u0006tg.\u001a7t\u0013\tQwM\u0001\u000bHCRDWM]5oO\nKH/Z\"iC:tW\r\u001c\u0005\u0006Y\u0002!\t\u0001M\u0001\tg\u0016tGmU5{K\"\u0012\u0001A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c\u0012\tQ!\u001e;jYNL!a\u001d9\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0001")
public class MessageSetSend
implements Send {
    private final MessageSet messages;
    private final short errorCode;
    private int sent;
    private final int size;
    private final ByteBuffer header;
    private boolean complete;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int writeCompletely(GatheringByteChannel gatheringByteChannel) {
        return Send$class.writeCompletely(this, gatheringByteChannel);
    }

    @Override
    public void expectIncomplete() {
        Transmission$class.expectIncomplete(this);
    }

    @Override
    public void expectComplete() {
        Transmission$class.expectComplete(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        MessageSetSend messageSetSend = this;
        synchronized (messageSetSend) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public MessageSet messages() {
        return this.messages;
    }

    public short errorCode() {
        return this.errorCode;
    }

    private int sent() {
        return this.sent;
    }

    private void sent_$eq(int n) {
        this.sent = n;
    }

    private int size() {
        return this.size;
    }

    private ByteBuffer header() {
        return this.header;
    }

    @Override
    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean bl) {
        this.complete = bl;
    }

    @Override
    public int writeTo(GatheringByteChannel gatheringByteChannel) {
        this.expectIncomplete();
        int n = 0;
        if (this.header().hasRemaining()) {
            n += gatheringByteChannel.write(this.header());
        }
        if (!this.header().hasRemaining()) {
            int n2 = this.messages().writeTo(gatheringByteChannel, this.sent(), this.size() - this.sent());
            n += n2;
            this.sent_$eq(this.sent() + n2);
        }
        if (this.logger().isTraceEnabled() && gatheringByteChannel instanceof SocketChannel) {
            SocketChannel socketChannel = (SocketChannel)gatheringByteChannel;
            this.logger().trace((Object)new StringBuilder().append(this.sent()).append((Object)" bytes written to ").append((Object)socketChannel.socket().getRemoteSocketAddress()).append((Object)" expecting to send ").append((Object)BoxesRunTime.boxToInteger((int)this.size())).append((Object)" bytes").toString());
        }
        if (this.sent() >= this.size()) {
            this.complete_$eq(true);
        }
        return n;
    }

    public int sendSize() {
        return this.size() + this.header().capacity();
    }

    public MessageSetSend(MessageSet messageSet, short s) {
        this.messages = messageSet;
        this.errorCode = s;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Send$class.$init$(this);
        this.sent = 0;
        this.size = messageSet.sizeInBytes();
        this.header = ByteBuffer.allocate(6);
        this.header().putInt(this.size() + 2);
        this.header().putShort(s);
        this.header().rewind();
        this.complete = false;
    }

    public MessageSetSend(MessageSet messageSet) {
        this(messageSet, ErrorMapping$.MODULE$.NoError());
    }

    public MessageSetSend() {
        this(MessageSet$.MODULE$.Empty());
    }
}

