/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.tools.DumpLogSegments$$anonfun$kafka$tools$DumpLogSegments$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class DumpLogSegments$ {
    public static final DumpLogSegments$ MODULE$;

    static {
        new DumpLogSegments$();
    }

    public void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder optionSpecBuilder = optionParser.accepts("print-data-log", "if set, printing the messages content when dumping data logs");
        OptionSpecBuilder optionSpecBuilder2 = optionParser.accepts("verify-index-only", "if set, just verify the index log without printing its content");
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        OptionSpecBuilder optionSpecBuilder3 = optionParser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration");
        OptionSet optionSet = optionParser.parse(stringArray);
        if (!optionSet.has((OptionSpec)argumentAcceptingOptionSpec)) {
            System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append((Object)argumentAcceptingOptionSpec).append((Object)"\"").toString());
            optionParser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        boolean bl = optionSet.has((OptionSpec)optionSpecBuilder);
        boolean bl2 = optionSet.has((OptionSpec)optionSpecBuilder2);
        String[] stringArray2 = ((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec)).split(",");
        int n = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2);
        boolean bl3 = optionSet.has((OptionSpec)optionSpecBuilder3);
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])stringArray2).foreach((Function1)new Serializable(bl, bl2, n, bl3, hashMap, hashMap2){
            public static final long serialVersionUID = 0L;
            private final boolean print$1;
            private final boolean verifyOnly$1;
            private final int maxMessageSize$1;
            private final boolean isDeepIteration$1;
            private final HashMap misMatchesForIndexFilesMap$1;
            private final HashMap nonConsecutivePairsForLogFilesMap$1;

            public final void apply(String string) {
                File file = new File(string);
                if (file.getName().endsWith(Log$.MODULE$.LogFileSuffix())) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Dumping ").append((Object)file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpLog(file, this.print$1, (HashMap<String, List<Tuple2<Object, Object>>>)this.nonConsecutivePairsForLogFilesMap$1, this.isDeepIteration$1);
                } else if (file.getName().endsWith(Log$.MODULE$.IndexFileSuffix())) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Dumping ").append((Object)file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpIndex(file, this.verifyOnly$1, (HashMap<String, List<Tuple2<Object, Object>>>)this.misMatchesForIndexFilesMap$1, this.maxMessageSize$1);
                }
            }
            {
                this.print$1 = bl;
                this.verifyOnly$1 = bl2;
                this.maxMessageSize$1 = n;
                this.isDeepIteration$1 = bl3;
                this.misMatchesForIndexFilesMap$1 = hashMap;
                this.nonConsecutivePairsForLogFilesMap$1 = hashMap2;
            }
        });
        hashMap.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> tuple2) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string = (String)tuple22._1();
                    List list = (List)tuple22._2();
                    System.err.println(new StringBuilder().append((Object)"Mismatches in :").append((Object)string).toString());
                    list.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> tuple2) {
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)tuple2._1$mcJ$sp()), BoxesRunTime.boxToLong((long)tuple2._2$mcJ$sp())})));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple22);
            }
        });
        hashMap2.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> tuple2) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string = (String)tuple22._1();
                    List list = (List)tuple22._2();
                    System.err.println(new StringBuilder().append((Object)"Non-secutive offsets in :").append((Object)string).toString());
                    list.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> tuple2) {
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  %d is followed by %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)tuple2._1$mcJ$sp()), BoxesRunTime.boxToLong((long)tuple2._2$mcJ$sp())})));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple22);
            }
        });
    }

    public void kafka$tools$DumpLogSegments$$dumpIndex(File file, boolean bl, HashMap<String, List<Tuple2<Object, Object>>> hashMap, int n) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                long l = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                String string = new StringBuilder().append((Object)file.getAbsolutePath().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString();
                File file2 = new File(string);
                FileMessageSet fileMessageSet = new FileMessageSet(file2);
                OffsetIndex offsetIndex = new OffsetIndex(file, l, OffsetIndex$.MODULE$.$lessinit$greater$default$3());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetIndex.entries()).foreach$mVc$sp((Function1)new Serializable(file, bl, hashMap, n, fileMessageSet, offsetIndex, object){
                    public static final long serialVersionUID = 0L;
                    private final File file$2;
                    private final boolean verifyOnly$2;
                    private final HashMap misMatchesForIndexFilesMap$2;
                    private final int maxMessageSize$2;
                    private final FileMessageSet messageSet$1;
                    private final OffsetIndex index$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int n) {
                        this.apply$mcVI$sp(n);
                    }

                    public void apply$mcVI$sp(int n) {
                        BoxedUnit boxedUnit;
                        OffsetPosition offsetPosition = this.index$1.entry(n);
                        FileMessageSet fileMessageSet = this.messageSet$1.read(offsetPosition.position(), this.maxMessageSize$2);
                        MessageAndOffset messageAndOffset = (MessageAndOffset)DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator((MessageAndOffset)fileMessageSet.head(), true).next();
                        if (messageAndOffset.offset() != offsetPosition.offset() + this.index$1.baseOffset()) {
                            List list = (List)this.misMatchesForIndexFilesMap$2.getOrElse((Object)this.file$2.getName(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final List<Tuple2<Object, Object>> apply() {
                                    return Nil$.MODULE$;
                                }
                            });
                            list = list.$colon$colon((Object)new Tuple2.mcJJ.sp(offsetPosition.offset() + this.index$1.baseOffset(), messageAndOffset.offset()));
                            boxedUnit = this.misMatchesForIndexFilesMap$2.put((Object)this.file$2.getName(), (Object)list);
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        if (offsetPosition.offset() == 0L && n > 0) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        if (!this.verifyOnly$2) {
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("offset: %d position: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(offsetPosition.offset() + this.index$1.baseOffset())), BoxesRunTime.boxToInteger((int)offsetPosition.position())})));
                        }
                    }
                    {
                        this.file$2 = file;
                        this.verifyOnly$2 = bl;
                        this.misMatchesForIndexFilesMap$2 = hashMap;
                        this.maxMessageSize$2 = n;
                        this.messageSet$1 = fileMessageSet;
                        this.index$1 = offsetIndex;
                        this.nonLocalReturnKey1$1 = object;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void kafka$tools$DumpLogSegments$$dumpLog(File file, boolean bl, HashMap<String, List<Tuple2<Object, Object>>> hashMap, boolean bl2) {
        long l = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Starting offset: ").append((Object)BoxesRunTime.boxToLong((long)l)).toString());
        FileMessageSet fileMessageSet = new FileMessageSet(file);
        LongRef longRef = new LongRef(0L);
        LongRef longRef2 = new LongRef(-1L);
        fileMessageSet.foreach(new Serializable(file, bl, hashMap, bl2, longRef, longRef2){
            public static final long serialVersionUID = 0L;
            public final File file$1;
            public final boolean printContents$1;
            public final HashMap nonConsecutivePairsForLogFilesMap$2;
            private final boolean isDeepIteration$2;
            public final LongRef validBytes$1;
            public final LongRef lastOffset$1;

            public final void apply(MessageAndOffset messageAndOffset) {
                Iterator<MessageAndOffset> iterator = DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator(messageAndOffset, this.isDeepIteration$2);
                iterator.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$kafka$tools$DumpLogSegments$$dumpLog$1 $outer;

                    public final void apply(MessageAndOffset messageAndOffset) {
                        BoxedUnit boxedUnit;
                        Message message = messageAndOffset.message();
                        if (this.$outer.lastOffset$1.elem == -1L) {
                            this.$outer.lastOffset$1.elem = messageAndOffset.offset();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            CompressionCodec compressionCodec = message.compressionCodec();
                            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                            if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) && messageAndOffset.offset() != this.$outer.lastOffset$1.elem + 1L) {
                                List list = (List)this.$outer.nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)this.$outer.file$1.getName(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final List<Tuple2<Object, Object>> apply() {
                                        return Nil$.MODULE$;
                                    }
                                });
                                list = list.$colon$colon((Object)new Tuple2.mcJJ.sp(this.$outer.lastOffset$1.elem, messageAndOffset.offset()));
                                boxedUnit = this.$outer.nonConsecutivePairsForLogFilesMap$2.put((Object)this.$outer.file$1.getName(), (Object)list);
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        this.$outer.lastOffset$1.elem = messageAndOffset.offset();
                        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"offset: ").append((Object)BoxesRunTime.boxToLong((long)messageAndOffset.offset())).append((Object)" position: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.validBytes$1.elem)).append((Object)" isvalid: ").append((Object)BoxesRunTime.boxToBoolean((boolean)message.isValid())).append((Object)" payloadsize: ").append((Object)BoxesRunTime.boxToInteger((int)message.payloadSize())).append((Object)" magic: ").append((Object)BoxesRunTime.boxToByte((byte)message.magic())).append((Object)" compresscodec: ").append((Object)message.compressionCodec()).append((Object)" crc: ").append((Object)BoxesRunTime.boxToLong((long)message.checksum())).toString());
                        if (message.hasKey()) {
                            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" keysize: ").append((Object)BoxesRunTime.boxToInteger((int)message.keySize())).toString());
                        }
                        if (this.$outer.printContents$1) {
                            if (message.hasKey()) {
                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" key: ").append((Object)Utils$.MODULE$.readString(messageAndOffset.message().key(), "UTF-8")).toString());
                            }
                            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" payload: ").append((Object)Utils$.MODULE$.readString(messageAndOffset.message().payload(), "UTF-8")).toString());
                        }
                        Predef$.MODULE$.println();
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                    }
                });
                this.validBytes$1.elem += (long)MessageSet$.MODULE$.entrySize(messageAndOffset.message());
            }
            {
                this.file$1 = file;
                this.printContents$1 = bl;
                this.nonConsecutivePairsForLogFilesMap$2 = hashMap;
                this.isDeepIteration$2 = bl2;
                this.validBytes$1 = longRef;
                this.lastOffset$1 = longRef2;
            }
        });
        long l2 = (long)fileMessageSet.sizeInBytes() - longRef.elem;
        if (l2 > 0L) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Found %d invalid bytes at the end of %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l2), file.getName()})));
        }
    }

    public Iterator<MessageAndOffset> kafka$tools$DumpLogSegments$$getIterator(MessageAndOffset messageAndOffset, boolean bl) {
        IteratorTemplate<MessageAndOffset> iteratorTemplate;
        if (bl) {
            Message message = messageAndOffset.message();
            CompressionCodec compressionCodec = message.compressionCodec();
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            CompressionCodec compressionCodec2 = compressionCodec;
            IteratorTemplate<MessageAndOffset> iteratorTemplate2 = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? this.getSingleMessageIterator(messageAndOffset) : ByteBufferMessageSet$.MODULE$.decompress(message).iterator();
            iteratorTemplate = iteratorTemplate2;
        } else {
            iteratorTemplate = this.getSingleMessageIterator(messageAndOffset);
        }
        return iteratorTemplate;
    }

    private IteratorTemplate<MessageAndOffset> getSingleMessageIterator(MessageAndOffset messageAndOffset) {
        return new IteratorTemplate<MessageAndOffset>(messageAndOffset){
            private boolean messageIterated;
            private final MessageAndOffset messageAndOffset$1;

            public boolean messageIterated() {
                return this.messageIterated;
            }

            public void messageIterated_$eq(boolean bl) {
                this.messageIterated = bl;
            }

            public MessageAndOffset makeNext() {
                MessageAndOffset messageAndOffset;
                if (this.messageIterated()) {
                    messageAndOffset = (MessageAndOffset)this.allDone();
                } else {
                    this.messageIterated_$eq(true);
                    messageAndOffset = this.messageAndOffset$1;
                }
                return messageAndOffset;
            }
            {
                this.messageAndOffset$1 = messageAndOffset;
                this.messageIterated = false;
            }
        };
    }

    private DumpLogSegments$() {
        MODULE$ = this;
    }
}

