/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.common.KafkaException;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Utils$
implements Logging {
    public static final Utils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new Utils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public Runnable runnable(Function0<BoxedUnit> function0) {
        return new Runnable(function0){
            private final Function0 fun$2;

            public void run() {
                this.fun$2.apply$mcV$sp();
            }
            {
                this.fun$2 = function0;
            }
        };
    }

    public Runnable loggedRunnable(Function0<BoxedUnit> function0, String string) {
        return new Runnable(function0, string){
            private final Function0 fun$1;
            private final String name$1;

            public void run() {
                Thread.currentThread().setName(this.name$1);
                try {
                    this.fun$1.apply$mcV$sp();
                }
                catch (Throwable throwable) {
                    Utils$.MODULE$.error((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "error in loggedRunnable";
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable t$1;

                        public final Throwable apply() {
                            return this.t$1;
                        }
                        {
                            this.t$1 = throwable;
                        }
                    });
                }
            }
            {
                this.fun$1 = function0;
                this.name$1 = string;
            }
        };
    }

    public Thread daemonThread(Runnable runnable) {
        return this.newThread(runnable, true);
    }

    public Thread daemonThread(String string, Runnable runnable) {
        return this.newThread(string, runnable, true);
    }

    public Thread daemonThread(String string, Function0<BoxedUnit> function0) {
        return this.daemonThread(string, this.runnable(function0));
    }

    public Thread newThread(String string, Runnable runnable, boolean bl) {
        Thread thread = new Thread(runnable, string);
        thread.setDaemon(bl);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable throwable) {
                Utils$.MODULE$.error((Function0<String>)new Serializable(this, thread){
                    public static final long serialVersionUID = 0L;
                    private final Thread t$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Uncaught exception in thread '").append((Object)this.t$2.getName()).append((Object)"':").toString();
                    }
                    {
                        this.t$2 = thread;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = throwable;
                    }
                });
            }
        });
        return thread;
    }

    public Thread newThread(Runnable runnable, boolean bl) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(bl);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable throwable) {
                Utils$.MODULE$.error((Function0<String>)new Serializable(this, thread){
                    public static final long serialVersionUID = 0L;
                    private final Thread t$3;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Uncaught exception in thread '").append((Object)this.t$3.getName()).append((Object)"':").toString();
                    }
                    {
                        this.t$3 = thread;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$2;

                    public final Throwable apply() {
                        return this.e$2;
                    }
                    {
                        this.e$2 = throwable;
                    }
                });
            }
        });
        return thread;
    }

    public byte[] readBytes(ByteBuffer byteBuffer) {
        return this.readBytes(byteBuffer, 0, byteBuffer.limit());
    }

    public byte[] readBytes(ByteBuffer byteBuffer, int n, int n2) {
        Buffer buffer;
        byte[] byArray = new byte[n2];
        if (byteBuffer.hasArray()) {
            System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + n, byArray, 0, n2);
            buffer = BoxedUnit.UNIT;
        } else {
            byteBuffer.mark();
            byteBuffer.get(byArray);
            buffer = byteBuffer.reset();
        }
        return byArray;
    }

    public Properties loadProps(String string) {
        FileInputStream fileInputStream = new FileInputStream(string);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        return properties;
    }

    public FileChannel openChannel(File file, boolean bl) {
        return bl ? new RandomAccessFile(file, "rw").getChannel() : new FileInputStream(file).getChannel();
    }

    public void swallow(Function2<Object, Throwable, BoxedUnit> function2, Function0<BoxedUnit> function0) {
        try {
            function0.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            function2.apply((Object)throwable.getMessage(), (Object)throwable);
        }
    }

    public boolean equal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        Object object = new Object();
        try {
            if (byteBuffer.position() != byteBuffer2.position()) {
                return false;
            }
            if (byteBuffer.remaining() != byteBuffer2.remaining()) {
                return false;
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), byteBuffer.remaining()).foreach$mVc$sp((Function1)new Serializable(byteBuffer, byteBuffer2, object){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer b1$1;
                private final ByteBuffer b2$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(int n) {
                    this.apply$mcVI$sp(n);
                }

                public void apply$mcVI$sp(int n) {
                    if (this.b1$1.get(n) != this.b2$1.get(n)) {
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                    }
                }
                {
                    this.b1$1 = byteBuffer;
                    this.b2$1 = byteBuffer2;
                    this.nonLocalReturnKey1$1 = object;
                }
            });
            return true;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    public String readString(ByteBuffer byteBuffer, String string) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return new String(byArray, string);
    }

    public void croak(String string) {
        System.err.println(string);
        System.exit(1);
    }

    public void rm(String string) {
        this.rm(new File(string));
    }

    public void rm(Seq<String> seq) {
        seq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String string) {
                Utils$.MODULE$.rm(new File(string));
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void rm(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                Predef$.MODULE$.refArrayOps((Object[])fileArray).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(File file) {
                        Utils$.MODULE$.rm(file);
                    }
                });
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerMBean(Object object, String string) {
        try {
            Boolean bl2;
            MBeanServer mBeanServer;
            MBeanServer mBeanServer2 = mBeanServer = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer2) {
                ObjectName objectName = new ObjectName(string);
                if (mBeanServer.isRegistered(objectName)) {
                    mBeanServer.unregisterMBean(objectName);
                }
                mBeanServer.registerMBean(object, objectName);
                bl2 = BoxesRunTime.boxToBoolean((boolean)true);
            }
            boolean bl = BoxesRunTime.unboxToBoolean((Object)bl2);
            return bl;
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(string){
                public static final long serialVersionUID = 0L;
                private final String name$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to register Mbean ").append((Object)this.name$2).toString();
                }
                {
                    this.name$2 = string;
                }
            }, (Function0<Throwable>)new Serializable(exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$3;

                public final Exception apply() {
                    return this.e$3;
                }
                {
                    this.e$3 = exception;
                }
            });
            return false;
        }
    }

    public void unregisterMBean(String string) {
        MBeanServer mBeanServer;
        MBeanServer mBeanServer2 = mBeanServer = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer2) {
            BoxedUnit boxedUnit;
            ObjectName objectName = new ObjectName(string);
            if (mBeanServer.isRegistered(objectName)) {
                mBeanServer.unregisterMBean(objectName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long readUnsignedInt(ByteBuffer byteBuffer) {
        return (long)byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    public long readUnsignedInt(ByteBuffer byteBuffer, int n) {
        return (long)byteBuffer.getInt(n) & 0xFFFFFFFFL;
    }

    public void writetUnsignedInt(ByteBuffer byteBuffer, long l) {
        byteBuffer.putInt((int)(l & 0xFFFFFFFFL));
    }

    public void writeUnsignedInt(ByteBuffer byteBuffer, int n, long l) {
        byteBuffer.putInt(n, (int)(l & 0xFFFFFFFFL));
    }

    public long crc32(byte[] byArray) {
        return this.crc32(byArray, 0, byArray.length);
    }

    public long crc32(byte[] byArray, int n, int n2) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, n, n2);
        return cRC32.getValue();
    }

    public int hashcode(Seq<Object> seq) {
        if (seq == null) {
            return 0;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < seq.length()) {
            if (seq.apply(n2) == null) continue;
            n = 31 * n + seq.apply(n2).hashCode();
            ++n2;
        }
        return n;
    }

    public <K, V> Map<K, List<V>> groupby(Iterable<V> iterable, Function1<V, K> function1) {
        HashMap hashMap = new HashMap();
        iterable.foreach((Function1)new Serializable(function1, hashMap){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;
            private final HashMap m$1;

            public final Option<List<V>> apply(V v) {
                Option option;
                block4: {
                    Option option2;
                    block3: {
                        Object object;
                        block2: {
                            Some some;
                            List list;
                            object = this.f$1.apply(v);
                            option = this.m$1.get(object);
                            if (!(option instanceof Some) || (list = (List)(some = (Some)option).x()) == null) break block2;
                            List list2 = list;
                            V v2 = v;
                            option2 = this.m$1.put(object, (Object)list2.$colon$colon(v2));
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option3 = option;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                        option2 = this.m$1.put(object, (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                    }
                    return option2;
                }
                throw new MatchError((Object)option);
            }
            {
                this.f$1 = function1;
                this.m$1 = hashMap;
            }
        });
        return hashMap;
    }

    public int read(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) {
        int n;
        int n2 = readableByteChannel.read(byteBuffer);
        if (-1 == n2) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        int n3 = n = n2;
        return n3;
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    public <V> V notNull(V v) {
        if (v == null) {
            throw new KafkaException("Value cannot be null.");
        }
        return v;
    }

    public Tuple2<String, Object> parseHostPort(String string) {
        String[] stringArray = string.split(":");
        return new Tuple2((Object)stringArray[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(stringArray[1])).toInt()));
    }

    public String stackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public Map<String, String> parseCsvMap(String string) {
        HashMap hashMap = new HashMap();
        if ("".equals(string)) {
            return hashMap;
        }
        String[][] stringArray = (String[][])Predef$.MODULE$.refArrayOps((Object[])string.split("\\s*,\\s*")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String string) {
                return string.split("\\s*:\\s*");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])stringArray).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String[] stringArray) {
                return new Tuple2((Object)stringArray[0], (Object)stringArray[1]);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
    }

    public Seq<String> parseCsvList(String string) {
        return string == null || string.isEmpty() ? (Seq)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])string.split("\\s*,\\s*")).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String string) {
                return !string.equals("");
            }
        }));
    }

    public <T> T createObject(String string, Seq<Object> seq) {
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor((Class[])((TraversableOnce)seq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(Object object) {
                return object.getClass();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class)));
        return (T)constructor.newInstance((Object[])seq.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public boolean nullOrEmpty(String string) {
        return string == null || string.equals("");
    }

    public String mergeJsonFields(Seq<String> seq) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        stringBuilder.append(((TraversableOnce)((TraversableLike)seq.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String string) {
                return string.trim();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", "));
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public Seq<String> mapToJsonFields(Map<String, String> map, boolean bl) {
        ListBuffer listBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        StringBuilder stringBuilder = new StringBuilder();
        ((TraversableLike)map.toList().sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$))).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> tuple2) {
                Tuple2<String, String> tuple22 = tuple2;
                boolean bl = tuple22 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(bl, listBuffer, stringBuilder){
            public static final long serialVersionUID = 0L;
            private final boolean valueInQuotes$1;
            private final ListBuffer jsonFields$1;
            private final StringBuilder builder$1;

            public final void apply(Tuple2<String, String> tuple2) {
                Tuple2<String, String> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string = (String)tuple22._1();
                    String string2 = (String)tuple22._2();
                    this.builder$1.append(new StringBuilder().append((Object)"\"").append((Object)string).append((Object)"\":").toString());
                    StringBuilder stringBuilder = this.valueInQuotes$1 ? this.builder$1.append(new StringBuilder().append((Object)"\"").append((Object)string2).append((Object)"\"").toString()) : this.builder$1.append(string2);
                    this.jsonFields$1.$plus$eq((Object)this.builder$1.toString());
                    this.builder$1.clear();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.valueInQuotes$1 = bl;
                this.jsonFields$1 = listBuffer;
                this.builder$1 = stringBuilder;
            }
        });
        return listBuffer;
    }

    public String mapToJson(Map<String, String> map, boolean bl) {
        return this.mergeJsonFields(this.mapToJsonFields(map, bl));
    }

    public String seqToJson(Seq<String> seq, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        StringBuilder stringBuilder2 = bl ? stringBuilder.append(((TraversableOnce)seq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String string) {
                return new StringBuilder().append((Object)"\"").append((Object)string).append((Object)"\"").toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")) : stringBuilder.append(seq.mkString(", "));
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    public String mapWithSeqValuesToJson(Map<String, Seq<Object>> map) {
        return this.mergeJsonFields(this.mapToJsonFields((Map<String, String>)((Map)map.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, Seq<Object>> tuple2) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(tuple2._1()), (Object)Utils$.MODULE$.seqToJson((Seq<String>)((Seq)((TraversableLike)tuple2._2()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int n) {
                        return ((Object)BoxesRunTime.boxToInteger((int)n)).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())), false));
            }
        }, Map$.MODULE$.canBuildFrom())), false));
    }

    public <T> Iterator<T> circularIterator(Iterable<T> iterable) {
        Stream stream = (Stream)package$.MODULE$.Stream().continually((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }).flatMap((Function1)new Serializable(iterable){
            public static final long serialVersionUID = 0L;
            private final Iterable coll$1;

            public final Iterable<T> apply(int n) {
                return (Iterable)this.coll$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final T apply(T t) {
                        return t;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                this.coll$1 = iterable;
            }
        }, Stream$.MODULE$.canBuildFrom());
        return stream.iterator();
    }

    public String readFileAsString(String string, Charset charset) {
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        try {
            FileChannel fileChannel = fileInputStream.getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            return charset.decode(mappedByteBuffer).toString();
        }
        finally {
            fileInputStream.close();
        }
    }

    public Charset readFileAsString$default$2() {
        return Charset.defaultCharset();
    }

    public int abs(int n) {
        return n & Integer.MAX_VALUE;
    }

    private Utils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

