/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.admin.AdministrationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.Cluster;
import kafka.common.KafkaException;
import kafka.common.NoEpochForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.consumer.TopicCount;
import kafka.consumer.TopicCount$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReassignedPartitionsContext;
import kafka.controller.ReassignedPartitionsContext$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import kafka.utils.ZkUtils$$anonfun$getConsumersPerTopic$1$;
import kafka.utils.ZkUtils$$anonfun$getReplicaAssignmentForTopics$1$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ZkUtils$
implements Logging {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String ReassignPartitionsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ZkUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZkUtils$ zkUtils$ = this;
        synchronized (zkUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String getTopicPath(String string) {
        return new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)string).toString();
    }

    public String getTopicPartitionsPath(String string) {
        return new StringBuilder().append((Object)this.getTopicPath(string)).append((Object)"/partitions").toString();
    }

    public int getController(ZkClient zkClient) {
        Option option = (Option)this.readDataMaybeNull(zkClient, this.ControllerPath())._1();
        if (option instanceof Some) {
            Some some = (Some)option;
            String string = (String)some.x();
            int n = new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
            return n;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new KafkaException("Controller doesn't exist");
        }
        throw new MatchError((Object)option);
    }

    public String getTopicPartitionPath(String string, int n) {
        return new StringBuilder().append((Object)this.getTopicPartitionsPath(string)).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String string, int n) {
        return new StringBuilder().append((Object)this.getTopicPartitionPath(string, n)).append((Object)"/").append((Object)"state").toString();
    }

    public Seq<Object> getSortedBrokerList(ZkClient zkClient) {
        return (Seq)((SeqLike)this.getChildren(zkClient, this.BrokerIdsPath()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String string) {
                return new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
            }
        }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$);
    }

    public Seq<Broker> getAllBrokersInCluster(ZkClient zkClient) {
        Seq seq = (Seq)this.getChildrenParentMayNotExist(zkClient, this.BrokerIdsPath()).sorted((Ordering)Ordering.String$.MODULE$);
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)seq.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String string) {
                return new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$2;

            public final Option<Broker> apply(int n) {
                return ZkUtils$.MODULE$.getBrokerInfo(this.zkClient$2, n);
            }
            {
                this.zkClient$2 = zkClient;
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Broker> option) {
                return option.isDefined();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(Option<Broker> option) {
                return (Broker)option.get();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<LeaderIsrAndControllerEpoch> getLeaderIsrAndEpochForPartition(ZkClient zkClient, String string, int n) {
        Option option;
        block4: {
            Option<LeaderIsrAndControllerEpoch> option2;
            block3: {
                block2: {
                    String string2 = this.getTopicPartitionLeaderAndIsrPath(string, n);
                    Tuple2<Option<String>, Stat> tuple2 = this.readDataMaybeNull(zkClient, string2);
                    Option option3 = (Option)tuple2._1();
                    Stat stat = (Stat)tuple2._2();
                    option = option3;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String string3 = (String)some.x();
                    option2 = this.parseLeaderAndIsr(string3, string, n, stat);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block4;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError((Object)option);
    }

    public Option<LeaderAndIsr> getLeaderAndIsrForPartition(ZkClient zkClient, String string, int n) {
        return this.getLeaderIsrAndEpochForPartition(zkClient, string, n).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LeaderAndIsr apply(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch) {
                return leaderIsrAndControllerEpoch.leaderAndIsr();
            }
        });
    }

    public Option<LeaderIsrAndControllerEpoch> parseLeaderAndIsr(String string, String string2, int n, Stat stat) {
        Option<Object> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = Json$.MODULE$.parseFull(string);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object object = some.x();
                    Map map = (Map)object;
                    int n2 = BoxesRunTime.unboxToInt((Object)map.get((Object)"leader").get());
                    int n3 = BoxesRunTime.unboxToInt((Object)map.get((Object)"leader_epoch").get());
                    List list = (List)map.get((Object)"isr").get();
                    int n4 = BoxesRunTime.unboxToInt((Object)map.get((Object)"controller_epoch").get());
                    int n5 = stat.getVersion();
                    this.debug((Function0<String>)new Serializable(string2, n, n2, n3, list, n5){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final int partition$1;
                        private final int leader$1;
                        private final int epoch$1;
                        private final List isr$1;
                        private final int zkPathVersion$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Leader %d, Epoch %d, Isr %s, Zk path version %d for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leader$1), BoxesRunTime.boxToInteger((int)this.epoch$1), this.isr$1.toString(), BoxesRunTime.boxToInteger((int)this.zkPathVersion$1), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                        }
                        {
                            this.topic$1 = string;
                            this.partition$1 = n;
                            this.leader$1 = n2;
                            this.epoch$1 = n3;
                            this.isr$1 = list;
                            this.zkPathVersion$1 = n4;
                        }
                    });
                    none$ = new Some((Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(n2, n3, (List<Object>)list, n5), n4));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Option<Object> getLeaderForPartition(ZkClient zkClient, String string, int n) {
        Option option;
        block7: {
            None$ none$;
            block6: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        None$ none$2;
                        block4: {
                            block3: {
                                Option option3 = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(string, n))._1();
                                option = option3;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String string2 = (String)some.x();
                                option2 = Json$.MODULE$.parseFull(string2);
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object object = some2.x();
                                none$2 = new Some((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)((Map)object).get((Object)"leader").get())));
                                break block4;
                            }
                            None$ none$3 = None$.MODULE$;
                            Option<Object> option4 = option2;
                            if (none$3 != null ? !none$3.equals(option4) : option4 != null) break block5;
                            none$2 = None$.MODULE$;
                        }
                        none$ = none$2;
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$4 = None$.MODULE$;
                Option option5 = option;
                if (none$4 != null ? !none$4.equals(option5) : option5 != null) break block7;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public int getEpochForPartition(ZkClient zkClient, String string, int n) {
        Option option = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(string, n))._1();
        Option option2 = option;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String string2 = (String)some.x();
            Option<Object> option3 = Json$.MODULE$.parseFull(string2);
            None$ none$ = None$.MODULE$;
            Option<Object> option4 = option3;
            if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
                throw new NoEpochForPartitionException(new StringOps(Predef$.MODULE$.augmentString("No epoch, leaderAndISR data for partition [%s,%d] is invalid")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n)})));
            }
            if (option3 instanceof Some) {
                int n2;
                Some some2 = (Some)option3;
                Object object = some2.x();
                int n3 = n2 = BoxesRunTime.unboxToInt((Object)((Map)object).get((Object)"leader_epoch").get());
                return n3;
            }
            throw new MatchError(option3);
        }
        None$ none$ = None$.MODULE$;
        Option option5 = option2;
        if (!(none$ != null ? !none$.equals(option5) : option5 != null)) {
            throw new NoEpochForPartitionException(new StringOps(Predef$.MODULE$.augmentString("No epoch, ISR path for partition [%s,%d] is empty")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n)})));
        }
        throw new MatchError((Object)option2);
    }

    public Seq<Object> getInSyncReplicasForPartition(ZkClient zkClient, String string, int n) {
        Option option;
        block7: {
            Seq seq;
            block6: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        Seq seq2;
                        block4: {
                            block3: {
                                Option option3 = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(string, n))._1();
                                option = option3;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String string2 = (String)some.x();
                                option2 = Json$.MODULE$.parseFull(string2);
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object object = some2.x();
                                seq2 = (Seq)((Map)object).get((Object)"isr").get();
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<Object> option4 = option2;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block5;
                            seq2 = (Seq)Seq$.MODULE$.empty();
                        }
                        seq = seq2;
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option option5 = option;
                if (none$ != null ? !none$.equals(option5) : option5 != null) break block7;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    public Seq<Object> getReplicasForPartition(ZkClient zkClient, String string, int n) {
        Option option;
        block13: {
            Seq seq;
            block12: {
                block2: {
                    Option<Object> option2;
                    block11: {
                        Seq seq2;
                        block10: {
                            block3: {
                                Option option3;
                                block9: {
                                    Seq seq3;
                                    block8: {
                                        block4: {
                                            Option option4;
                                            block7: {
                                                Seq seq4;
                                                block6: {
                                                    block5: {
                                                        Seq seq5;
                                                        Option option5 = (Option)this.readDataMaybeNull(zkClient, this.getTopicPath(string))._1();
                                                        option = option5;
                                                        if (!(option instanceof Some)) break block2;
                                                        Some some = (Some)option;
                                                        String string2 = (String)some.x();
                                                        option2 = Json$.MODULE$.parseFull(string2);
                                                        if (!(option2 instanceof Some)) break block3;
                                                        Some some2 = (Some)option2;
                                                        Object object = some2.x();
                                                        option3 = ((Map)object).get((Object)"partitions");
                                                        if (!(option3 instanceof Some)) break block4;
                                                        Some some3 = (Some)option3;
                                                        Object object2 = some3.x();
                                                        option4 = ((Map)object2).get((Object)((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                                                        if (!(option4 instanceof Some)) break block5;
                                                        Some some4 = (Some)option4;
                                                        seq4 = seq5 = (Seq)some4.x();
                                                        break block6;
                                                    }
                                                    None$ none$ = None$.MODULE$;
                                                    Option option6 = option4;
                                                    if (none$ != null ? !none$.equals(option6) : option6 != null) break block7;
                                                    seq4 = (Seq)Seq$.MODULE$.empty();
                                                }
                                                seq3 = seq4;
                                                break block8;
                                            }
                                            throw new MatchError((Object)option4);
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option7 = option3;
                                        if (none$ != null ? !none$.equals(option7) : option7 != null) break block9;
                                        seq3 = (Seq)Seq$.MODULE$.empty();
                                    }
                                    seq2 = seq3;
                                    break block10;
                                }
                                throw new MatchError((Object)option3);
                            }
                            None$ none$ = None$.MODULE$;
                            Option<Object> option8 = option2;
                            if (none$ != null ? !none$.equals(option8) : option8 != null) break block11;
                            seq2 = (Seq)Seq$.MODULE$.empty();
                        }
                        seq = seq2;
                        break block12;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option option9 = option;
                if (none$ != null ? !none$.equals(option9) : option9 != null) break block13;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    public boolean isPartitionOnBroker(ZkClient zkClient, String string, int n, int n2) {
        Seq<Object> seq = this.getReplicasForPartition(zkClient, string, n);
        this.debug((Function0<String>)new Serializable(string, n, seq){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final int partition$2;
            private final Seq replicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("The list of replicas for partition [%s,%d] is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, BoxesRunTime.boxToInteger((int)this.partition$2), this.replicas$1}));
            }
            {
                this.topic$2 = string;
                this.partition$2 = n;
                this.replicas$1 = seq;
            }
        });
        return seq.contains((Object)((Object)BoxesRunTime.boxToInteger((int)n2)).toString());
    }

    public void registerBrokerInZk(ZkClient zkClient, int n, String string, int n2, int n3) {
        String string2 = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
        String string3 = Utils$.MODULE$.mergeJsonFields((Seq<String>)((Seq)Utils$.MODULE$.mapToJsonFields((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"host"), (Object)string)}))), true).$plus$plus(Utils$.MODULE$.mapToJsonFields((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)((Object)BoxesRunTime.boxToInteger((int)1)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"jmx_port"), (Object)((Object)BoxesRunTime.boxToInteger((int)n3)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"port"), (Object)((Object)BoxesRunTime.boxToInteger((int)n2)).toString())}))), false), Seq$.MODULE$.canBuildFrom())));
        try {
            this.createEphemeralPathExpectConflict(zkClient, string2, string3);
            this.info((Function0<String>)new Serializable(n, string, n2, string2){
                public static final long serialVersionUID = 0L;
                private final int id$1;
                private final String host$1;
                private final int port$1;
                private final String brokerIdPath$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Registered broker %d at path %s with address %s:%d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id$1), this.brokerIdPath$1, this.host$1, BoxesRunTime.boxToInteger((int)this.port$1)}));
                }
                {
                    this.id$1 = n;
                    this.host$1 = string;
                    this.port$1 = n2;
                    this.brokerIdPath$1 = string2;
                }
            });
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new RuntimeException(new StringBuilder().append((Object)"A broker is already registered on the path ").append((Object)string2).append((Object)". This probably ").append((Object)"indicates that you either have configured a brokerid that is already in use, or ").append((Object)"else you have shutdown this broker and restarted it faster than the zookeeper ").append((Object)"timeout so it appears to be re-registering.").toString());
        }
    }

    public String getConsumerPartitionOwnerPath(String string, String string2, int n) {
        ZKGroupTopicDirs zKGroupTopicDirs = new ZKGroupTopicDirs(string, string2);
        return new StringBuilder().append((Object)zKGroupTopicDirs.consumerOwnerDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
    }

    public String leaderAndIsrZkData(LeaderAndIsr leaderAndIsr, int n) {
        String string = Utils$.MODULE$.seqToJson((Seq<String>)((Seq)leaderAndIsr.isr().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int n) {
                return ((Object)BoxesRunTime.boxToInteger((int)n)).toString();
            }
        }, List$.MODULE$.canBuildFrom())), false);
        return Utils$.MODULE$.mapToJson((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)((Object)BoxesRunTime.boxToInteger((int)1)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader"), (Object)((Object)BoxesRunTime.boxToInteger((int)leaderAndIsr.leader())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"leader_epoch"), (Object)((Object)BoxesRunTime.boxToInteger((int)leaderAndIsr.leaderEpoch())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"controller_epoch"), (Object)((Object)BoxesRunTime.boxToInteger((int)n)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"isr"), (Object)string)}))), false);
    }

    public String replicaAssignmentZkdata(Map<String, Seq<Object>> map) {
        String string = Utils$.MODULE$.mapWithSeqValuesToJson(map);
        return Utils$.MODULE$.mapToJson((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)((Object)BoxesRunTime.boxToInteger((int)1)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partitions"), (Object)string)}))), false);
    }

    public void makeSurePersistentPathExists(ZkClient zkClient, String string) {
        if (!zkClient.exists(string)) {
            zkClient.createPersistent(string, true);
        }
    }

    private void createParentPath(ZkClient zkClient, String string) {
        String string2 = string.substring(0, string.lastIndexOf(47));
        if (string2.length() != 0) {
            zkClient.createPersistent(string2, true);
        }
    }

    private void createEphemeralPath(ZkClient zkClient, String string, String string2) {
        try {
            zkClient.createEphemeral(string, (Object)string2);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(zkClient, string);
            zkClient.createEphemeral(string, (Object)string2);
        }
    }

    public void createEphemeralPathExpectConflict(ZkClient zkClient, String string, String string2) {
        ObjectRef objectRef;
        ZkNodeExistsException zkNodeExistsException2;
        block6: {
            try {
                this.createEphemeralPath(zkClient, string, string2);
            }
            catch (Exception exception) {
                throw exception;
            }
            catch (ZkNodeExistsException zkNodeExistsException2) {
                objectRef = new ObjectRef(null);
                try {
                    objectRef.elem = (String)this.readData(zkClient, string)._1();
                }
                catch (Exception exception) {
                    throw exception;
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if ((String)objectRef.elem == null) break block6;
                String string3 = (String)objectRef.elem;
                String string4 = string2;
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
                this.info((Function0<String>)new Serializable(string, string2){
                    public static final long serialVersionUID = 0L;
                    private final String path$2;
                    private final String data$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)this.path$2).append((Object)" exists with value ").append((Object)this.data$2).append((Object)" during connection loss; this is ok").toString();
                    }
                    {
                        this.path$2 = string;
                        this.data$2 = string2;
                    }
                });
            }
            return;
        }
        this.info((Function0<String>)new Serializable(string, string2, objectRef){
            public static final long serialVersionUID = 0L;
            private final String path$2;
            private final String data$2;
            private final ObjectRef storedData$1;

            public final String apply() {
                return new StringBuilder().append((Object)"conflict in ").append((Object)this.path$2).append((Object)" data: ").append((Object)this.data$2).append((Object)" stored data: ").append((Object)((String)this.storedData$1.elem)).toString();
            }
            {
                this.path$2 = string;
                this.data$2 = string2;
                this.storedData$1 = objectRef;
            }
        });
        throw zkNodeExistsException2;
    }

    public void createPersistentPath(ZkClient zkClient, String string, String string2) {
        try {
            zkClient.createPersistent(string, (Object)string2);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(zkClient, string);
            zkClient.createPersistent(string, (Object)string2);
        }
    }

    public String createPersistentPath$default$3() {
        return "";
    }

    public String createSequentialPersistentPath(ZkClient zkClient, String string, String string2) {
        return zkClient.createPersistentSequential(string, (Object)string2);
    }

    public String createSequentialPersistentPath$default$3() {
        return "";
    }

    public void updatePersistentPath(ZkClient zkClient, String string, String string2) {
        try {
            zkClient.writeData(string, (Object)string2);
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(zkClient, string);
            try {
                zkClient.createPersistent(string, (Object)string2);
            }
            catch (Exception exception) {
                throw exception;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                zkClient.writeData(string, (Object)string2);
            }
        }
    }

    public Tuple2<Object, Object> conditionalUpdatePersistentPath(ZkClient zkClient, String string, String string2, int n) {
        Tuple2.mcZI.sp sp2;
        try {
            Stat stat = zkClient.writeDataReturnStat(string, (Object)string2, n);
            this.debug((Function0<String>)new Serializable(string, string2, n, stat){
                public static final long serialVersionUID = 0L;
                private final String path$1;
                private final String data$1;
                private final int expectVersion$1;
                private final Stat stat$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Conditional update of path %s with value %s and expected version %d succeeded, returning the new version: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, this.data$1, BoxesRunTime.boxToInteger((int)this.expectVersion$1), BoxesRunTime.boxToInteger((int)this.stat$1.getVersion())}));
                }
                {
                    this.path$1 = string;
                    this.data$1 = string2;
                    this.expectVersion$1 = n;
                    this.stat$1 = stat;
                }
            });
            sp2 = new Tuple2.mcZI.sp(true, stat.getVersion());
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(string, string2, n, exception){
                public static final long serialVersionUID = 0L;
                private final String path$1;
                private final String data$1;
                private final int expectVersion$1;
                private final Exception e$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Conditional update of path %s with data %s and expected version %d failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, this.data$1, BoxesRunTime.boxToInteger((int)this.expectVersion$1), this.e$1.getMessage()}));
                }
                {
                    this.path$1 = string;
                    this.data$1 = string2;
                    this.expectVersion$1 = n;
                    this.e$1 = exception;
                }
            });
            sp2 = new Tuple2.mcZI.sp(false, -1);
        }
        return sp2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<Object, Object> conditionalUpdatePersistentPathIfExists(ZkClient zkClient, String string, String string2, int n) {
        Tuple2.mcZI.sp sp2;
        try {
            Stat stat = zkClient.writeDataReturnStat(string, (Object)string2, n);
            this.debug((Function0<String>)new Serializable(string, string2, n, stat){
                public static final long serialVersionUID = 0L;
                private final String path$4;
                private final String data$3;
                private final int expectVersion$2;
                private final Stat stat$2;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Conditional update of path %s with value %s and expected version %d succeeded, returning the new version: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$4, this.data$3, BoxesRunTime.boxToInteger((int)this.expectVersion$2), BoxesRunTime.boxToInteger((int)this.stat$2.getVersion())}));
                }
                {
                    this.path$4 = string;
                    this.data$3 = string2;
                    this.expectVersion$2 = n;
                    this.stat$2 = stat;
                }
            });
            sp2 = new Tuple2.mcZI.sp(true, stat.getVersion());
            return sp2;
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(string, string2, n, exception){
                public static final long serialVersionUID = 0L;
                private final String path$4;
                private final String data$3;
                private final int expectVersion$2;
                private final Exception e$2;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Conditional update of path %s with data %s and expected version %d failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$4, this.data$3, BoxesRunTime.boxToInteger((int)this.expectVersion$2), this.e$2.getMessage()}));
                }
                {
                    this.path$4 = string;
                    this.data$3 = string2;
                    this.expectVersion$2 = n;
                    this.e$2 = exception;
                }
            });
            sp2 = new Tuple2.mcZI.sp(false, -1);
            return sp2;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            throw zkNoNodeException;
        }
    }

    public void updateEphemeralPath(ZkClient zkClient, String string, String string2) {
        try {
            zkClient.writeData(string, (Object)string2);
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(zkClient, string);
            zkClient.createEphemeral(string, (Object)string2);
        }
    }

    public boolean deletePath(ZkClient zkClient, String string) {
        boolean bl;
        try {
            bl = zkClient.delete(string);
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new Serializable(string){
                public static final long serialVersionUID = 0L;
                private final String path$3;

                public final String apply() {
                    return new StringBuilder().append((Object)this.path$3).append((Object)" deleted during connection loss; this is ok").toString();
                }
                {
                    this.path$3 = string;
                }
            });
            bl = false;
        }
        return bl;
    }

    public void deletePathRecursive(ZkClient zkClient, String string) {
        try {
            zkClient.deleteRecursive(string);
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new Serializable(string){
                public static final long serialVersionUID = 0L;
                private final String path$5;

                public final String apply() {
                    return new StringBuilder().append((Object)this.path$5).append((Object)" deleted during connection loss; this is ok").toString();
                }
                {
                    this.path$5 = string;
                }
            });
        }
    }

    public void maybeDeletePath(String string, String string2) {
        try {
            ZkClient zkClient = new ZkClient(string, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            zkClient.deleteRecursive(string2);
            zkClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Tuple2<String, Stat> readData(ZkClient zkClient, String string) {
        Stat stat = new Stat();
        String string2 = (String)zkClient.readData(string, stat);
        return new Tuple2((Object)string2, (Object)stat);
    }

    public Tuple2<Option<String>, Stat> readDataMaybeNull(ZkClient zkClient, String string) {
        Tuple2 tuple2;
        Stat stat = new Stat();
        try {
            tuple2 = new Tuple2((Object)new Some(zkClient.readData(string, stat)), (Object)stat);
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)stat);
        }
        Tuple2 tuple22 = tuple2;
        return tuple22;
    }

    public Seq<String> getChildren(ZkClient zkClient, String string) {
        return JavaConversions$.MODULE$.asScalaBuffer(zkClient.getChildren(string));
    }

    public Seq<String> getChildrenParentMayNotExist(ZkClient zkClient, String string) {
        try {
            return JavaConversions$.MODULE$.asScalaBuffer(zkClient.getChildren(string));
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return Nil$.MODULE$;
        }
    }

    public boolean pathExists(ZkClient zkClient, String string) {
        return zkClient.exists(string);
    }

    public String getLastPart(String string) {
        return string.substring(string.lastIndexOf(47) + 1);
    }

    public Cluster getCluster(ZkClient zkClient) {
        Cluster cluster = new Cluster();
        Seq<String> seq = this.getChildrenParentMayNotExist(zkClient, this.BrokerIdsPath());
        seq.foreach((Function1)new Serializable(zkClient, cluster){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$5;
            private final Cluster cluster$1;

            public final Option<Broker> apply(String string) {
                String string2 = (String)ZkUtils$.MODULE$.readData(this.zkClient$5, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)string).toString())._1();
                return this.cluster$1.add(Broker$.MODULE$.createBroker(new StringOps(Predef$.MODULE$.augmentString(string)).toInt(), string2));
            }
            {
                this.zkClient$5 = zkClient;
                this.cluster$1 = cluster;
            }
        });
        return cluster;
    }

    public scala.collection.mutable.Map<TopicAndPartition, LeaderIsrAndControllerEpoch> getPartitionLeaderAndIsrForTopics(ZkClient zkClient, Set<TopicAndPartition> set) {
        HashMap hashMap = new HashMap();
        set.foreach((Function1)new Serializable(zkClient, hashMap){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$8;
            private final HashMap ret$1;

            public final Object apply(TopicAndPartition topicAndPartition) {
                Option<LeaderIsrAndControllerEpoch> option;
                block4: {
                    BoxedUnit boxedUnit;
                    block3: {
                        block2: {
                            option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkClient$8, topicAndPartition.topic(), topicAndPartition.partition());
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                            boxedUnit = this.ret$1.put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<LeaderIsrAndControllerEpoch> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new MatchError(option);
            }
            {
                this.zkClient$8 = zkClient;
                this.ret$1 = hashMap;
            }
        });
        return hashMap;
    }

    public scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> getReplicaAssignmentForTopics(ZkClient zkClient, Seq<String> seq) {
        HashMap hashMap = new HashMap();
        seq.foreach((Function1)new Serializable(zkClient, hashMap){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;
            public final HashMap ret$2;

            public final void apply(String string) {
                Option option;
                block10: {
                    block9: {
                        block2: {
                            Option<Object> option2;
                            block8: {
                                block7: {
                                    block3: {
                                        Option option3;
                                        block6: {
                                            block5: {
                                                block4: {
                                                    Option option4 = (Option)ZkUtils$.MODULE$.readDataMaybeNull(this.zkClient$1, ZkUtils$.MODULE$.getTopicPath(string))._1();
                                                    option = option4;
                                                    if (!(option instanceof Some)) break block2;
                                                    Some some = (Some)option;
                                                    String string2 = (String)some.x();
                                                    option2 = Json$.MODULE$.parseFull(string2);
                                                    if (!(option2 instanceof Some)) break block3;
                                                    Some some2 = (Some)option2;
                                                    Object object = some2.x();
                                                    option3 = ((Map)object).get((Object)"partitions");
                                                    if (!(option3 instanceof Some)) break block4;
                                                    Some some3 = (Some)option3;
                                                    Object object2 = some3.x();
                                                    Map map = (Map)object2;
                                                    map.withFilter((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final boolean apply(Tuple2<String, Seq<Object>> tuple2) {
                                                            Tuple2<String, Seq<Object>> tuple22 = tuple2;
                                                            boolean bl = tuple22 != null;
                                                            return bl;
                                                        }
                                                    }).foreach((Function1)new Serializable(this, string){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ anonfun.getReplicaAssignmentForTopics.1 $outer;
                                                        public final String topic$3;

                                                        public final void apply(Tuple2<String, Seq<Object>> tuple2) {
                                                            Tuple2<String, Seq<Object>> tuple22 = tuple2;
                                                            if (tuple22 != null) {
                                                                String string = (String)tuple22._1();
                                                                Seq seq = (Seq)tuple22._2();
                                                                this.$outer.ret$2.put((Object)new TopicAndPartition(this.topic$3, new StringOps(Predef$.MODULE$.augmentString(string)).toInt()), (Object)seq);
                                                                ZkUtils$.MODULE$.debug((Function0<String>)new Serializable(this, string, seq){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final /* synthetic */ anonfun$getReplicaAssignmentForTopics$1$$anonfun$apply$3 $outer;
                                                                    private final String partition$3;
                                                                    private final Seq replicas$2;

                                                                    public final String apply() {
                                                                        return new StringOps(Predef$.MODULE$.augmentString("Replicas assigned to topic [%s], partition [%s] are [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$3, this.partition$3, this.replicas$2}));
                                                                    }
                                                                    {
                                                                        if (var1_1 == null) {
                                                                            throw new NullPointerException();
                                                                        }
                                                                        this.$outer = var1_1;
                                                                        this.partition$3 = string;
                                                                        this.replicas$2 = seq;
                                                                    }
                                                                });
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                return;
                                                            }
                                                            throw new MatchError(tuple22);
                                                        }
                                                        {
                                                            if (var1_1 == null) {
                                                                throw new NullPointerException();
                                                            }
                                                            this.$outer = var1_1;
                                                            this.topic$3 = string;
                                                        }
                                                    });
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block5;
                                                }
                                                None$ none$ = None$.MODULE$;
                                                Option option5 = option3;
                                                if (none$ != null ? !none$.equals(option5) : option5 != null) break block6;
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            }
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block7;
                                        }
                                        throw new MatchError((Object)option3);
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<Object> option6 = option2;
                                    if (none$ != null ? !none$.equals(option6) : option6 != null) break block8;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block9;
                            }
                            throw new MatchError(option2);
                        }
                        None$ none$ = None$.MODULE$;
                        Option option7 = option;
                        if (none$ != null ? !none$.equals(option7) : option7 != null) break block10;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                this.zkClient$1 = zkClient;
                this.ret$2 = hashMap;
            }
        });
        return hashMap;
    }

    public scala.collection.mutable.Map<String, Map<Object, Seq<Object>>> getPartitionAssignmentForTopics(ZkClient zkClient, Seq<String> seq) {
        HashMap hashMap = new HashMap();
        seq.foreach((Function1)new Serializable(zkClient, hashMap){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$3;
            private final HashMap ret$3;

            public final HashMap<String, Map<Object, Seq<Object>>> apply(String string) {
                Option option;
                block10: {
                    Map map;
                    block9: {
                        block2: {
                            Option<Object> option2;
                            block8: {
                                Map map2;
                                block7: {
                                    block3: {
                                        Option option3;
                                        block6: {
                                            Map map3;
                                            block5: {
                                                block4: {
                                                    Option option4 = (Option)ZkUtils$.MODULE$.readDataMaybeNull(this.zkClient$3, ZkUtils$.MODULE$.getTopicPath(string))._1();
                                                    option = option4;
                                                    if (!(option instanceof Some)) break block2;
                                                    Some some = (Some)option;
                                                    String string2 = (String)some.x();
                                                    option2 = Json$.MODULE$.parseFull(string2);
                                                    if (!(option2 instanceof Some)) break block3;
                                                    Some some2 = (Some)option2;
                                                    Object object = some2.x();
                                                    option3 = ((Map)object).get((Object)"partitions");
                                                    if (!(option3 instanceof Some)) break block4;
                                                    Some some3 = (Some)option3;
                                                    Object object2 = some3.x();
                                                    Map map4 = (Map)object2;
                                                    map3 = (Map)map4.map((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final Tuple2<Object, Seq<Object>> apply(Tuple2<String, Seq<Object>> tuple2) {
                                                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString((String)tuple2._1())).toInt()), tuple2._2());
                                                        }
                                                    }, scala.collection.Map$.MODULE$.canBuildFrom());
                                                    break block5;
                                                }
                                                None$ none$ = None$.MODULE$;
                                                Option option5 = option3;
                                                if (none$ != null ? !none$.equals(option5) : option5 != null) break block6;
                                                map3 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                                            }
                                            map2 = map3;
                                            break block7;
                                        }
                                        throw new MatchError((Object)option3);
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<Object> option6 = option2;
                                    if (none$ != null ? !none$.equals(option6) : option6 != null) break block8;
                                    map2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                                }
                                map = map2;
                                break block9;
                            }
                            throw new MatchError(option2);
                        }
                        None$ none$ = None$.MODULE$;
                        Option option7 = option;
                        if (none$ != null ? !none$.equals(option7) : option7 != null) break block10;
                        map = (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                    Map map5 = map;
                    ZkUtils$.MODULE$.debug((Function0<String>)new Serializable(this, string, map5){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;
                        private final Map partitionMap$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Partition map for /brokers/topics/%s is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4, this.partitionMap$1}));
                        }
                        {
                            this.topic$4 = string;
                            this.partitionMap$1 = map;
                        }
                    });
                    return this.ret$3.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)string), (Object)map5));
                }
                throw new MatchError((Object)option);
            }
            {
                this.zkClient$3 = zkClient;
                this.ret$3 = hashMap;
            }
        });
        return hashMap;
    }

    public scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> getReplicaAssignmentFromPartitionAssignment(scala.collection.mutable.Map<String, Map<Object, Seq<Object>>> map) {
        HashMap hashMap = new HashMap();
        map.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Map<Object, Seq<Object>>> tuple2) {
                Tuple2<String, Map<Object, Seq<Object>>> tuple22 = tuple2;
                boolean bl = tuple22 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(hashMap){
            public static final long serialVersionUID = 0L;
            public final HashMap ret$4;

            public final void apply(Tuple2<String, Map<Object, Seq<Object>>> tuple2) {
                Tuple2<String, Map<Object, Seq<Object>>> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string = (String)tuple22._1();
                    Map map = (Map)tuple22._2();
                    map.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, Seq<Object>> tuple2) {
                            Tuple2<Object, Seq<Object>> tuple22 = tuple2;
                            boolean bl = tuple22 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, string){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getReplicaAssignmentFromPartitionAssignment.2 $outer;
                        private final String topic$5;

                        public final Option<Seq<Object>> apply(Tuple2<Object, Seq<Object>> tuple2) {
                            Tuple2<Object, Seq<Object>> tuple22 = tuple2;
                            if (tuple22 != null) {
                                int n = tuple22._1$mcI$sp();
                                Seq seq = (Seq)tuple22._2();
                                Option option = this.$outer.ret$4.put((Object)new Tuple2((Object)this.topic$5, (Object)BoxesRunTime.boxToInteger((int)n)), (Object)seq);
                                return option;
                            }
                            throw new MatchError(tuple22);
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                            this.topic$5 = string;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.ret$4 = hashMap;
            }
        });
        return hashMap;
    }

    public scala.collection.mutable.Map<String, Seq<Object>> getPartitionsForTopics(ZkClient zkClient, Seq<String> seq) {
        return (scala.collection.mutable.Map)this.getPartitionAssignmentForTopics(zkClient, seq).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<String, Map<Object, Seq<Object>>> tuple2) {
                String string = (String)tuple2._1();
                Map map = (Map)tuple2._2();
                ZkUtils$.MODULE$.debug((Function0<String>)new Serializable(this, string, map){
                    public static final long serialVersionUID = 0L;
                    private final String topic$6;
                    private final Map partitionMap$2;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("partition assignment of /brokers/topics/%s is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$6, this.partitionMap$2}));
                    }
                    {
                        this.topic$6 = string;
                        this.partitionMap$2 = map;
                    }
                });
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)string), map.keys().toSeq().sortWith((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int n, int n2) {
                        return this.apply$mcZII$sp(n, n2);
                    }

                    public boolean apply$mcZII$sp(int n, int n2) {
                        return n < n2;
                    }
                }));
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, Object>> getPartitionsAssignedToBroker(ZkClient zkClient, Seq<String> seq, int n) {
        scala.collection.mutable.Map<String, Map<Object, Seq<Object>>> map = this.getPartitionAssignmentForTopics(zkClient, seq);
        return ((TraversableOnce)((GenericTraversableTemplate)map.map((Function1)new Serializable(n){
            public static final long serialVersionUID = 0L;
            public final int brokerId$1;

            public final Iterable<Tuple2<String, Object>> apply(Tuple2<String, Map<Object, Seq<Object>>> tuple2) {
                String string = (String)tuple2._1();
                Map map = (Map)tuple2._2();
                Map map2 = (Map)map.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getPartitionsAssignedToBroker.1 $outer;

                    public final boolean apply(Tuple2<Object, Seq<Object>> tuple2) {
                        return ((SeqLike)tuple2._2()).contains((Object)BoxesRunTime.boxToInteger((int)this.$outer.brokerId$1));
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                    }
                });
                Iterable iterable = (Iterable)map2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Seq<Object>> tuple2) {
                        return tuple2._1$mcI$sp();
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom());
                return (Iterable)iterable.map((Function1)new Serializable(this, string){
                    public static final long serialVersionUID = 0L;
                    private final String topic$7;

                    public final Tuple2<String, Object> apply(int n) {
                        return new Tuple2((Object)this.topic$7, (Object)BoxesRunTime.boxToInteger((int)n));
                    }
                    {
                        this.topic$7 = string;
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom());
            }
            {
                this.brokerId$1 = n;
            }
        }, Iterable$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms())).toSeq();
    }

    public Map<TopicAndPartition, ReassignedPartitionsContext> getPartitionsBeingReassigned(ZkClient zkClient) {
        Option option;
        block4: {
            scala.collection.immutable.Map map;
            block3: {
                block2: {
                    Option option2 = (Option)this.readDataMaybeNull(zkClient, this.ReassignPartitionsPath())._1();
                    option = option2;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String string = (String)some.x();
                    Map<TopicAndPartition, Seq<Object>> map2 = this.parsePartitionReassignmentData(string);
                    map = (Map)map2.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<TopicAndPartition, ReassignedPartitionsContext> apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(tuple2._1()), (Object)new ReassignedPartitionsContext((Seq<Object>)((Seq)tuple2._2()), ReassignedPartitionsContext$.MODULE$.$lessinit$greater$default$2()));
                        }
                    }, scala.collection.Map$.MODULE$.canBuildFrom());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                map = scala.collection.Map$.MODULE$.empty();
            }
            return map;
        }
        throw new MatchError((Object)option);
    }

    public Map<TopicAndPartition, Seq<Object>> parsePartitionReassignmentData(String string) {
        Option<Object> option;
        block7: {
            scala.collection.mutable.Map map;
            block6: {
                block2: {
                    Option option2;
                    block5: {
                        block4: {
                            block3: {
                                map = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                                option = Json$.MODULE$.parseFull(string);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Object object = some.x();
                                option2 = ((Map)object).get((Object)"partitions");
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object object2 = some2.x();
                                ((Seq)object2).foreach((Function1)new Serializable(map){
                                    public static final long serialVersionUID = 0L;
                                    private final scala.collection.mutable.Map reassignedPartitions$1;

                                    public final scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> apply(Map<String, Object> map) {
                                        String string = (String)map.get((Object)"topic").get();
                                        int n = BoxesRunTime.unboxToInt((Object)map.get((Object)"partition").get());
                                        Seq seq = (Seq)map.get((Object)"replicas").get();
                                        return (scala.collection.mutable.Map)this.reassignedPartitions$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(string, n)), (Object)seq));
                                    }
                                    {
                                        this.reassignedPartitions$1 = map;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option3 = option2;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    throw new MatchError((Object)option2);
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return map;
        }
        throw new MatchError(option);
    }

    public String getPartitionReassignmentZkData(Map<TopicAndPartition, Seq<Object>> map) {
        ObjectRef objectRef = new ObjectRef((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        map.foreach((Function1)new Serializable(objectRef){
            public static final long serialVersionUID = 0L;
            private final ObjectRef jsonPartitionsData$1;

            public final ListBuffer<String> apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                String string = Utils$.MODULE$.seqToJson((Seq<String>)((Seq)((TraversableLike)tuple2._2()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int n) {
                        return ((Object)BoxesRunTime.boxToInteger((int)n)).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())), false);
                Seq<String> seq = Utils$.MODULE$.mapToJsonFields((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic"), (Object)((TopicAndPartition)tuple2._1()).topic())}))), true);
                Seq<String> seq2 = Utils$.MODULE$.mapToJsonFields((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)((TopicAndPartition)tuple2._1()).partition())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"replicas"), (Object)string)}))), false);
                return ((ListBuffer)this.jsonPartitionsData$1.elem).$plus$eq((Object)Utils$.MODULE$.mergeJsonFields((Seq<String>)((Seq)seq.$plus$plus(seq2, Seq$.MODULE$.canBuildFrom()))));
            }
            {
                this.jsonPartitionsData$1 = objectRef;
            }
        });
        return Utils$.MODULE$.mapToJson((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)((Object)BoxesRunTime.boxToInteger((int)1)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partitions"), (Object)Utils$.MODULE$.seqToJson((Seq<String>)((ListBuffer)objectRef.elem).toSeq(), false))}))), false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updatePartitionReassignmentData(ZkClient zkClient, Map<TopicAndPartition, Seq<Object>> map) {
        String string2 = this.ReassignPartitionsPath();
        int n = map.size();
        switch (n) {
            default: {
                String string = this.getPartitionReassignmentZkData(map);
                try {
                    this.updatePersistentPath(zkClient, string2, string);
                    this.info((Function0<String>)new Serializable(string){
                        public static final long serialVersionUID = 0L;
                        private final String jsonData$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Updated partition reassignment path with %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jsonData$1}));
                        }
                        {
                            this.jsonData$1 = string;
                        }
                    });
                    return;
                }
                catch (Exception exception) {
                    throw new AdministrationException(exception.toString());
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    this.createPersistentPath(zkClient, string2, string);
                    this.debug((Function0<String>)new Serializable(string2, string){
                        public static final long serialVersionUID = 0L;
                        private final String zkPath$1;
                        private final String jsonData$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Created path %s with %s for partition reassignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkPath$1, this.jsonData$1}));
                        }
                        {
                            this.zkPath$1 = string;
                            this.jsonData$1 = string2;
                        }
                    });
                    return;
                }
            }
            case 0: {
                this.deletePath(zkClient, string2);
                this.info((Function0<String>)new Serializable(string2){
                    public static final long serialVersionUID = 0L;
                    private final String zkPath$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("No more partitions need to be reassigned. Deleting zk path %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkPath$1}));
                    }
                    {
                        this.zkPath$1 = string;
                    }
                });
                return;
            }
        }
    }

    public Set<PartitionAndReplica> getAllReplicasOnBroker(ZkClient zkClient, Seq<String> seq, Seq<Object> seq2) {
        return Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)((GenericTraversableTemplate)seq2.map((Function1)new Serializable(zkClient, seq, seq2){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$7;
            private final Seq topics$1;
            public final Seq brokerIds$1;

            public final Seq<PartitionAndReplica> apply(int n) {
                Seq<Tuple2<String, Object>> seq = ZkUtils$.MODULE$.getPartitionsAssignedToBroker(this.zkClient$7, (Seq<String>)this.topics$1, n);
                if (seq.size() == 0) {
                    ZkUtils$.MODULE$.info((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getAllReplicasOnBroker.1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("No state transitions triggered since no partitions are assigned to brokers %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.brokerIds$1.mkString(",")}));
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                        }
                    });
                }
                return (Seq)seq.map((Function1)new Serializable(this, n){
                    public static final long serialVersionUID = 0L;
                    private final int brokerId$2;

                    public final PartitionAndReplica apply(Tuple2<String, Object> tuple2) {
                        return new PartitionAndReplica((String)tuple2._1(), tuple2._2$mcI$sp(), this.brokerId$2);
                    }
                    {
                        this.brokerId$2 = n;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.zkClient$7 = zkClient;
                this.topics$1 = seq;
                this.brokerIds$1 = seq2;
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms()));
    }

    public Set<TopicAndPartition> getPartitionsUndergoingPreferredReplicaElection(ZkClient zkClient) {
        Option option;
        block4: {
            Set set;
            block3: {
                block2: {
                    Option option2 = (Option)this.readDataMaybeNull(zkClient, this.PreferredReplicaLeaderElectionPath())._1();
                    option = option2;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String string = (String)some.x();
                    set = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData(string);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                set = Set$.MODULE$.empty();
            }
            return set;
        }
        throw new MatchError((Object)option);
    }

    public void deletePartition(ZkClient zkClient, int n, String string) {
        String string2 = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
        zkClient.delete(string2);
        String string3 = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)string).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString();
        zkClient.delete(string3);
    }

    public Seq<String> getConsumersInGroup(ZkClient zkClient, String string) {
        ZKGroupDirs zKGroupDirs = new ZKGroupDirs(string);
        return this.getChildren(zkClient, zKGroupDirs.consumerRegistryDir());
    }

    public scala.collection.mutable.Map<String, List<String>> getConsumersPerTopic(ZkClient zkClient, String string) {
        ZKGroupDirs zKGroupDirs = new ZKGroupDirs(string);
        Seq<String> seq = this.getChildrenParentMayNotExist(zkClient, zKGroupDirs.consumerRegistryDir());
        HashMap hashMap = new HashMap();
        seq.foreach((Function1)new Serializable(zkClient, string, hashMap){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$6;
            private final String group$1;
            public final HashMap consumersPerTopicMap$1;

            public final void apply(String string) {
                TopicCount topicCount = TopicCount$.MODULE$.constructTopicCount(this.group$1, string, this.zkClient$6);
                topicCount.getConsumerThreadIdsPerTopic().withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, Set<String>> tuple2) {
                        Tuple2<String, Set<String>> tuple22 = tuple2;
                        boolean bl = tuple22 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getConsumersPerTopic.1 $outer;

                    public final void apply(Tuple2<String, Set<String>> tuple2) {
                        Tuple2<String, Set<String>> tuple22 = tuple2;
                        if (tuple22 != null) {
                            String string = (String)tuple22._1();
                            Set set = (Set)tuple22._2();
                            set.foreach((Function1)new Serializable(this, string){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$getConsumersPerTopic$1$$anonfun$apply$13 $outer;
                                private final String topic$8;

                                public final Option<List<String>> apply(String string) {
                                    Option option;
                                    Option option2 = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.get((Object)this.topic$8);
                                    if (option2 instanceof Some) {
                                        Some some = (Some)option2;
                                        List list = (List)some.x();
                                        String string2 = string;
                                        option = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.put((Object)this.topic$8, (Object)list.$colon$colon((Object)string2));
                                    } else {
                                        option = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.put((Object)this.topic$8, (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string})));
                                    }
                                    return option;
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                    this.topic$8 = string;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple22);
                    }

                    public /* synthetic */ anonfun.getConsumersPerTopic.1 kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                    }
                });
            }
            {
                this.zkClient$6 = zkClient;
                this.group$1 = string;
                this.consumersPerTopicMap$1 = hashMap;
            }
        });
        hashMap.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, List<String>> tuple2) {
                Tuple2<String, List<String>> tuple22 = tuple2;
                boolean bl = tuple22 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(hashMap){
            public static final long serialVersionUID = 0L;
            private final HashMap consumersPerTopicMap$1;

            public final Option<List<String>> apply(Tuple2<String, List<String>> tuple2) {
                Tuple2<String, List<String>> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string = (String)tuple22._1();
                    List list = (List)tuple22._2();
                    Option option = this.consumersPerTopicMap$1.put((Object)string, list.sortWith((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String string, String string2) {
                            return new StringOps(Predef$.MODULE$.augmentString(string)).$less((Object)string2);
                        }
                    }));
                    return option;
                }
                throw new MatchError(tuple22);
            }
            {
                this.consumersPerTopicMap$1 = hashMap;
            }
        });
        return hashMap;
    }

    public Option<Broker> getBrokerInfo(ZkClient zkClient, int n) {
        Option option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = (Option)this.readDataMaybeNull(zkClient, new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString())._1();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String string = (String)some.x();
                    none$ = new Some((Object)Broker$.MODULE$.createBroker(n, string));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public Seq<String> getAllTopics(ZkClient zkClient) {
        Seq seq = this.getChildrenParentMayNotExist(zkClient, this.BrokerTopicsPath());
        return seq == null ? (Seq)Seq$.MODULE$.empty() : seq;
    }

    public Set<TopicAndPartition> getAllPartitions(ZkClient zkClient) {
        Seq<String> seq = this.getChildrenParentMayNotExist(zkClient, this.BrokerTopicsPath());
        return seq == null ? Set$.MODULE$.empty() : ((TraversableOnce)((GenericTraversableTemplate)seq.map((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$4;

            public final Seq<TopicAndPartition> apply(String string) {
                return (Seq)((TraversableLike)ZkUtils$.MODULE$.getChildren(this.zkClient$4, ZkUtils$.MODULE$.getTopicPartitionsPath(string)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String string) {
                        return new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, string){
                    public static final long serialVersionUID = 0L;
                    private final String topic$9;

                    public final TopicAndPartition apply(int n) {
                        return new TopicAndPartition(this.topic$9, n);
                    }
                    {
                        this.topic$9 = string;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.zkClient$4 = zkClient;
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms())).toSet();
    }

    private ZkUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConsumersPath = "/consumers";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.ReassignPartitionsPath = "/admin/reassign_partitions";
        this.PreferredReplicaLeaderElectionPath = "/admin/preferred_replica_election";
    }
}

