/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scapegoat.io;

import com.sksamuel.scapegoat.Feedback;
import com.sksamuel.scapegoat.Level;
import com.sksamuel.scapegoat.Levels$Error$;
import com.sksamuel.scapegoat.Levels$Info$;
import com.sksamuel.scapegoat.Levels$Warning$;
import com.sksamuel.scapegoat.Warning;
import com.sksamuel.scapegoat.io.CodeQualityReportElement;
import com.sksamuel.scapegoat.io.CriticalSeverity$;
import com.sksamuel.scapegoat.io.InfoSeverity$;
import com.sksamuel.scapegoat.io.Lines;
import com.sksamuel.scapegoat.io.Location;
import com.sksamuel.scapegoat.io.MinorSeverity$;
import com.sksamuel.scapegoat.io.ReportWriter;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class GitlabCodeQualityReportWriter$
implements ReportWriter {
    public static GitlabCodeQualityReportWriter$ MODULE$;

    static {
        new GitlabCodeQualityReportWriter$();
    }

    @Override
    public File write(File targetDir, Feedback feedback) {
        return ReportWriter.write$(this, targetDir, feedback);
    }

    @Override
    public String fileName() {
        return "scapegoat-gitlab.json";
    }

    @Override
    public String generate(Feedback feedback) {
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        return ((TraversableOnce)this.toCodeQualityElements(feedback.warningsWithMinimalLevel(), (Option<String>)package$.MODULE$.env().get((Object)"CI_PROJECT_DIR"), md5Digest).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toJsonArrayElement(), Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
    }

    public Seq<CodeQualityReportElement> toCodeQualityElements(Seq<Warning> warnings, Option<String> gitlabBuildDir, MessageDigest messageDigest) {
        return (Seq)warnings.map((Function1 & Serializable & scala.Serializable)warning -> {
            String fingerprintRaw = new StringBuilder(0).append(warning.sourceFileNormalized()).append(warning.snippet().getOrElse((Function0 & Serializable & scala.Serializable)() -> Integer.toString(warning.line()))).toString();
            messageDigest.reset();
            messageDigest.update(fingerprintRaw.getBytes(StandardCharsets.UTF_8));
            String fingerprint = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(messageDigest.digest())).map((Function1 & Serializable & scala.Serializable)x$2 -> GitlabCodeQualityReportWriter$.$anonfun$toCodeQualityElements$3(BoxesRunTime.unboxToByte((Object)x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
            Level level = warning.level();
            CriticalSeverity$ severity = Levels$Error$.MODULE$.equals(level) ? CriticalSeverity$.MODULE$ : (Levels$Warning$.MODULE$.equals(level) ? MinorSeverity$.MODULE$ : (Levels$Info$.MODULE$.equals(level) ? InfoSeverity$.MODULE$ : InfoSeverity$.MODULE$));
            String gitlabCiNormalizedPath = (String)gitlabBuildDir.map((Function1 & Serializable & scala.Serializable)buildDir -> {
                String fullBuildDir = buildDir.endsWith("/") ? buildDir : new StringBuilder(1).append((String)buildDir).append("/").toString();
                String file = warning.sourceFileFull();
                if (file.startsWith(fullBuildDir)) {
                    return (String)new StringOps(Predef$.MODULE$.augmentString(file)).drop(fullBuildDir.length());
                }
                return file;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> warning.sourceFileFull());
            String textStart = warning.explanation().startsWith(warning.text()) ? "" : (warning.text().endsWith(".") ? new StringBuilder(1).append(warning.text()).append(" ").toString() : new StringBuilder(2).append(warning.text()).append(". ").toString());
            String description = new StringBuilder(0).append(textStart).append(warning.explanation()).toString();
            return new CodeQualityReportElement(description, warning.inspection(), severity, new Location(gitlabCiNormalizedPath, new Lines(warning.line())), fingerprint);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ String $anonfun$toCodeQualityElements$3(byte x$2) {
        return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$2)}));
    }

    private GitlabCodeQualityReportWriter$() {
        MODULE$ = this;
        ReportWriter.$init$(this);
    }
}

