/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.audit.impl;

import com.slack.api.audit.AuditConfig;
import com.slack.api.methods.MethodsRateLimitTier;
import com.slack.api.rate_limits.RateLimiter;
import com.slack.api.rate_limits.WaitTime;
import com.slack.api.rate_limits.WaitTimeCalculator;
import com.slack.api.rate_limits.metrics.LastMinuteRequests;
import com.slack.api.rate_limits.metrics.MetricsDatastore;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAuditRateLimiter
implements RateLimiter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncAuditRateLimiter.class);
    private static final MethodsRateLimitTier AUDIT_LOGS_RATE_LIMIT_TIER = MethodsRateLimitTier.Tier3;
    private final MetricsDatastore metricsDatastore;
    private final AuditWaitTimeCalculator waitTimeCalculator;

    public MetricsDatastore getMetricsDatastore() {
        return this.metricsDatastore;
    }

    public AsyncAuditRateLimiter(AuditConfig config) {
        this.metricsDatastore = config.getMetricsDatastore();
        this.waitTimeCalculator = new AuditWaitTimeCalculator(config);
    }

    @Override
    public WaitTime acquireWaitTime(String teamId, String methodName) {
        return this.waitTimeCalculator.calculateWaitTime(teamId, methodName, MethodsRateLimitTier.getAllowedRequestsPerMinute(AUDIT_LOGS_RATE_LIMIT_TIER));
    }

    @Override
    public WaitTime acquireWaitTimeForChatPostMessage(String teamId, String channel) {
        throw new IllegalStateException("This rate limiter does not handle the pattern");
    }

    @Override
    public WaitTime acquireWaitTimeForAssistantThreadsSetStatus(String teamId, String channel) {
        throw new IllegalStateException("This rate limiter does not handle the pattern");
    }

    public static class AuditWaitTimeCalculator
    extends WaitTimeCalculator {
        private final AuditConfig config;

        public AuditWaitTimeCalculator(AuditConfig config) {
            this.config = config;
        }

        @Override
        public Optional<Long> getRateLimitedMethodRetryEpochMillis(String executorName, String teamId, String key) {
            return Optional.ofNullable(this.config.getMetricsDatastore().getRateLimitedMethodRetryEpochMillis(executorName, teamId, key));
        }

        @Override
        public Integer getNumberOfNodes() {
            return this.config.getMetricsDatastore().getNumberOfNodes();
        }

        @Override
        public String getExecutorName() {
            return this.config.getExecutorName();
        }

        @Override
        public LastMinuteRequests getLastMinuteRequests(String executorName, String teamId, String key) {
            return this.config.getMetricsDatastore().getLastMinuteRequests(executorName, teamId, key);
        }
    }
}

