/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.iterator;

import com.soebes.maven.plugins.iterator.ItemWithProperties;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractIteratorMojo
extends AbstractMojo {
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(required=true, readonly=true, defaultValue="${session}")
    private MavenSession mavenSession;
    @Parameter(property="iterator.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="iterator.failAtEnd", defaultValue="false")
    private boolean failAtEnd;
    @Parameter(required=true, defaultValue="@")
    private String beginToken;
    @Parameter(required=true, defaultValue="@")
    private String endToken;
    @Parameter(required=true, defaultValue="item")
    private String iteratorName;
    @Parameter(property="iterator.items")
    private List<String> items;
    @Parameter
    private List<ItemWithProperties> itemsWithProperties;
    @Parameter
    private String content;
    @Parameter(defaultValue=",")
    private String delimiter;
    @Parameter
    private File folder;
    @Parameter(defaultValue="NAME_COMPARATOR")
    private String sortOrder;

    public boolean isSortOrderValid(String sortOrder) {
        boolean result = sortOrder.equalsIgnoreCase("NAME_COMPARATOR") || sortOrder.equalsIgnoreCase("NAME_INSENSITIVE_COMPARATOR") || sortOrder.equalsIgnoreCase("NAME_INSENSITIVE_REVERSE") || sortOrder.equalsIgnoreCase("NAME_REVERSE") || sortOrder.equalsIgnoreCase("NAME_SYSTEM_COMPARATOR") || sortOrder.equalsIgnoreCase("NAME_SYSTEM_REVERSE");
        return result;
    }

    protected Comparator<File> convertSortOrder() {
        Comparator result = NameFileComparator.NAME_COMPARATOR;
        if (this.getSortOrder().equalsIgnoreCase("NAME_INSENSITIVE_COMPARATOR")) {
            result = NameFileComparator.NAME_INSENSITIVE_COMPARATOR;
        } else if (this.getSortOrder().equalsIgnoreCase("NAME_INSENSITIVE_REVERSE")) {
            result = NameFileComparator.NAME_INSENSITIVE_REVERSE;
        } else if (this.getSortOrder().equalsIgnoreCase("NAME_REVERSE")) {
            result = NameFileComparator.NAME_REVERSE;
        } else if (this.getSortOrder().equalsIgnoreCase("NAME_SYSTEM_COMPARATOR")) {
            result = NameFileComparator.NAME_SYSTEM_COMPARATOR;
        } else if (this.getSortOrder().equalsIgnoreCase("NAME_SYSTEM_REVERSE")) {
            result = NameFileComparator.NAME_SYSTEM_REVERSE;
        }
        return result;
    }

    public List<String> getFolders() throws MojoExecutionException {
        IOFileFilter folders = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{HiddenFileFilter.VISIBLE, DirectoryFileFilter.DIRECTORY});
        IOFileFilter makeSVNAware = FileFilterUtils.makeSVNAware((IOFileFilter)folders);
        IOFileFilter makeCVSAware = FileFilterUtils.makeCVSAware((IOFileFilter)makeSVNAware);
        String[] list = this.folder.list((FilenameFilter)makeCVSAware);
        if (list == null) {
            throw new MojoExecutionException("The specified folder doesn't exist: " + this.folder);
        }
        ArrayList<File> listOfDirectories = new ArrayList<File>();
        for (String item : list) {
            listOfDirectories.add(new File(this.folder, item));
        }
        Collections.sort(listOfDirectories, this.convertSortOrder());
        ArrayList<String> resultList = new ArrayList<String>();
        for (File file : listOfDirectories) {
            resultList.add(file.getName());
        }
        return resultList;
    }

    private List<String> getContentAsList() {
        String[] resultArray;
        ArrayList<String> result = new ArrayList<String>();
        for (String item : resultArray = this.content.split(this.delimiter)) {
            result.add(item.trim());
        }
        return result;
    }

    protected List<ItemWithProperties> getItemsConverted() throws MojoExecutionException {
        ArrayList<ItemWithProperties> result;
        block4: {
            block6: {
                block5: {
                    block3: {
                        result = new ArrayList();
                        if (!this.isItemsWithPropertiesSet()) break block3;
                        result = this.getItemsWithProperties();
                        break block4;
                    }
                    if (!this.isContentSet()) break block5;
                    for (String itemName : this.getContentAsList()) {
                        result.add(new ItemWithProperties(itemName, ItemWithProperties.NO_PROPERTIES));
                    }
                    break block4;
                }
                if (!this.isItemsSet()) break block6;
                for (String itemName : this.getItems()) {
                    result.add(new ItemWithProperties(itemName, ItemWithProperties.NO_PROPERTIES));
                }
                break block4;
            }
            if (!this.isFolderSet()) break block4;
            for (String itemName : this.getFolders()) {
                result.add(new ItemWithProperties(itemName, ItemWithProperties.NO_PROPERTIES));
            }
        }
        return result;
    }

    protected String getPlaceHolder() {
        return this.getBeginToken() + this.getIteratorName() + this.getEndToken();
    }

    protected boolean isItemsNull() {
        return this.items == null;
    }

    protected boolean isItemsWithPropertiesNull() {
        return this.itemsWithProperties == null;
    }

    protected boolean isItemsWithPropertiesSet() {
        return !this.isItemsWithPropertiesNull() && !this.itemsWithProperties.isEmpty();
    }

    protected boolean isItemsSet() {
        return !this.isItemsNull() && !this.items.isEmpty();
    }

    protected boolean isContentNull() {
        return this.content == null;
    }

    protected boolean isContentSet() {
        return this.content != null && this.content.trim().length() > 0;
    }

    protected boolean isFolderSet() {
        return this.folder != null;
    }

    protected boolean isFolderNull() {
        return this.folder == null;
    }

    public File getFolder() {
        return this.folder;
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }

    protected boolean isMoreThanOneSet() {
        boolean result = this.isItemsSet() ^ this.isContentSet() ^ this.isItemsWithPropertiesSet() ^ this.isFolderSet() && (!this.isItemsSet() || !this.isContentSet() || !this.isItemsWithPropertiesSet() || !this.isFolderSet());
        return !result;
    }

    protected boolean isNoneSet() {
        return this.isItemsNull() && this.isContentNull() && this.isItemsWithPropertiesNull() && this.isFolderNull();
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getBeginToken() {
        return this.beginToken;
    }

    public void setBeginToken(String beginToken) {
        this.beginToken = beginToken;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public String getIteratorName() {
        return this.iteratorName;
    }

    public void setIteratorName(String iteratorName) {
        this.iteratorName = iteratorName;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public List<String> getItems() {
        return this.items;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isFailAtEnd() {
        return this.failAtEnd;
    }

    public List<ItemWithProperties> getItemsWithProperties() {
        return this.itemsWithProperties;
    }

    public void setItemsWithProperties(List<ItemWithProperties> itemsWithProperties) {
        this.itemsWithProperties = itemsWithProperties;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }
}

