/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.session;

import akka.http.scaladsl.model.headers.HttpCookie;
import akka.http.scaladsl.model.headers.HttpCookie$;
import akka.http.scaladsl.model.headers.RawHeader;
import com.softwaremill.session.Crypto$;
import com.softwaremill.session.RefreshTokenData;
import com.softwaremill.session.RefreshTokenLookupResult;
import com.softwaremill.session.RefreshTokenManager;
import com.softwaremill.session.RefreshTokenManager$;
import com.softwaremill.session.SessionResult;
import com.softwaremill.session.SessionResult$Expired$;
import com.softwaremill.session.SessionResult$TokenNotFound$;
import com.softwaremill.session.SessionUtil$;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class RefreshTokenManager$class {
    public static String createSelector(RefreshTokenManager $this) {
        return SessionUtil$.MODULE$.randomString(16);
    }

    public static String createToken(RefreshTokenManager $this) {
        return SessionUtil$.MODULE$.randomString(64);
    }

    public static Option decodeSelectorAndToken(RefreshTokenManager $this, String value) {
        String[] s = value.split(":", 2);
        return s.length == 2 ? new Some((Object)new Tuple2((Object)s[0], (Object)s[1])) : None$.MODULE$;
    }

    public static String encodeSelectorAndToken(RefreshTokenManager $this, String selector, String token) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{selector, token}));
    }

    public static Future rotateToken(RefreshTokenManager $this, Object session2, Option existing, ExecutionContext ec) {
        String selector = $this.createSelector();
        String token = $this.createToken();
        Future storeFuture = $this.storage().store(new RefreshTokenData<Object>(session2, selector, Crypto$.MODULE$.hash_SHA256(token), $this.nowMillis() + $this.config().refreshTokenMaxAgeSeconds() * 1000L)).map((Function1)new Serializable($this, selector, token){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RefreshTokenManager $outer;
            private final String selector$1;
            private final String token$1;

            public final String apply(BoxedUnit x$2) {
                return this.$outer.encodeSelectorAndToken(this.selector$1, this.token$1);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.selector$1 = selector$1;
                this.token$1 = var3_3;
            }
        }, ec);
        existing.flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RefreshTokenManager $outer;

            public final Option<Tuple2<String, String>> apply(String value) {
                return this.$outer.decodeSelectorAndToken(value);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RefreshTokenManager $outer;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String s = (String)tuple2._1();
                    this.$outer.storage().schedule((Duration)Duration$.MODULE$.apply(this.$outer.config().removeUsedRefreshTokenAfter(), TimeUnit.SECONDS), new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ RefreshTokenManager$.anonfun.rotateToken.2 $outer;
                        private final String s$1;

                        public final Future<BoxedUnit> apply() {
                            return this.$outer.com$softwaremill$session$RefreshTokenManager$$anonfun$$$outer().storage().remove(this.s$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.s$1 = s$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ RefreshTokenManager com$softwaremill$session$RefreshTokenManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return storeFuture;
    }

    public static HttpCookie createCookie(RefreshTokenManager $this, String value) {
        return new HttpCookie($this.config().refreshTokenCookieConfig().name(), value, (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)$this.config().refreshTokenMaxAgeSeconds())), $this.config().refreshTokenCookieConfig().domain(), $this.config().refreshTokenCookieConfig().path(), $this.config().refreshTokenCookieConfig().secure(), $this.config().refreshTokenCookieConfig().httpOnly(), HttpCookie$.MODULE$.apply$default$9());
    }

    public static RawHeader createHeader(RefreshTokenManager $this, String value) {
        return new RawHeader($this.config().refreshTokenHeaderConfig().sendToClientHeaderName(), value);
    }

    public static Future sessionFromValue(RefreshTokenManager $this, String value, ExecutionContext ec) {
        Option<Tuple2<String, String>> option;
        block4: {
            Future future;
            block3: {
                block2: {
                    Some some;
                    Tuple2 tuple2;
                    option = $this.decodeSelectorAndToken(value);
                    if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block2;
                    String selector = (String)tuple2._1();
                    String token = (String)tuple2._2();
                    future = $this.storage().lookup(selector).flatMap((Function1)new Serializable($this, selector, token, ec){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ RefreshTokenManager $outer;
                        private final String selector$2;
                        private final String token$2;
                        private final ExecutionContext ec$1;

                        public final Future<SessionResult<T>> apply(Option<RefreshTokenLookupResult<T>> x0$2) {
                            Option<RefreshTokenLookupResult<T>> option;
                            block4: {
                                Future future;
                                block3: {
                                    block2: {
                                        option = x0$2;
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        RefreshTokenLookupResult lookupResult = (RefreshTokenLookupResult)some.x();
                                        future = lookupResult.expires() < this.$outer.nowMillis() ? this.$outer.storage().remove(this.selector$2).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final SessionResult$Expired$ apply(BoxedUnit x$3) {
                                                return SessionResult$Expired$.MODULE$;
                                            }
                                        }, this.ec$1) : (SessionUtil$.MODULE$.constantTimeEquals(Crypto$.MODULE$.hash_SHA256(this.token$2), lookupResult.tokenHash()) ? Future$.MODULE$.successful(new SessionResult.CreatedFromToken<Object>(lookupResult.createSession().apply())) : this.$outer.storage().remove(this.selector$2).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final SessionResult.Corrupt apply(BoxedUnit x$4) {
                                                return new SessionResult.Corrupt(new RuntimeException("Corrupt token hash"));
                                            }
                                        }, this.ec$1));
                                        break block3;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block4;
                                    future = Future$.MODULE$.successful((Object)SessionResult$TokenNotFound$.MODULE$);
                                }
                                return future;
                            }
                            throw new MatchError(option);
                        }
                        {
                            void var4_4;
                            void var3_3;
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.selector$2 = selector$2;
                            this.token$2 = var3_3;
                            this.ec$1 = var4_4;
                        }
                    }, ec);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                future = Future$.MODULE$.successful((Object)new SessionResult.Corrupt(new RuntimeException("Cannot decode selector/token")));
            }
            return future;
        }
        throw new MatchError(option);
    }

    public static Future removeToken(RefreshTokenManager $this, String value, ExecutionContext ec) {
        Option<Tuple2<String, String>> option;
        block4: {
            Future<BoxedUnit> future;
            block3: {
                block2: {
                    Some some;
                    Tuple2 tuple2;
                    option = $this.decodeSelectorAndToken(value);
                    if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block2;
                    String s = (String)tuple2._1();
                    future = $this.storage().remove(s);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            }
            return future;
        }
        throw new MatchError(option);
    }

    public static void $init$(RefreshTokenManager $this) {
    }
}

