/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.session;

import akka.http.scaladsl.model.headers.HttpCookie;
import akka.http.scaladsl.model.headers.HttpCookie$;
import akka.http.scaladsl.server.AuthorizationFailedRejection$;
import com.softwaremill.session.Crypto$;
import com.softwaremill.session.SessionConfig;
import com.softwaremill.session.SessionUtil$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001Y4qa\u0003\u0007\u0011\u0002\u0007\u00051\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0003!\u0001\u0019\u0005\u0011\u0005C\u0003'\u0001\u0019\u0005q\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u0003:\u0001\u0011\u0005!\bC\u0003G\u0001\u0011\u0005q\tC\u0003N\u0001\u0011%a\nC\u0003T\u0001\u0011%A\u000bC\u0003`\u0001\u0011%\u0001\rC\u0003d\u0001\u0011\u0005AMA\u0006DgJ4W*\u00198bO\u0016\u0014(BA\u0007\u000f\u0003\u001d\u0019Xm]:j_:T!a\u0004\t\u0002\u0019M|g\r^<be\u0016l\u0017\u000e\u001c7\u000b\u0003E\t1aY8n\u0007\u0001)\"\u0001F7\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002;A\u0011aCH\u0005\u0003?]\u0011A!\u00168ji\u000611m\u001c8gS\u001e,\u0012A\t\t\u0003G\u0011j\u0011\u0001D\u0005\u0003K1\u0011QbU3tg&|gnQ8oM&<\u0017!\u00038po6KG\u000e\\5t+\u0005A\u0003C\u0001\f*\u0013\tQsC\u0001\u0003M_:<\u0017!\u0006;pW\u0016t\u0017J\u001c<bY&$'+\u001a6fGRLwN\\\u000b\u0002[9\u0011afN\u0007\u0002_)\u0011\u0001'M\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005I\u001a\u0014\u0001C:dC2\fGm\u001d7\u000b\u0005Q*\u0014\u0001\u00025uiBT\u0011AN\u0001\u0005C.\\\u0017-\u0003\u00029_\u0005a\u0012)\u001e;i_JL'0\u0019;j_:4\u0015-\u001b7fIJ+'.Z2uS>t\u0017aC2sK\u0006$X\rV8lK:$\u0012a\u000f\t\u0003y\rs!!P!\u0011\u0005y:R\"A \u000b\u0005\u0001\u0013\u0012A\u0002\u001fs_>$h(\u0003\u0002C/\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011u#A\u0007wC2LG-\u0019;f)>\\WM\u001c\u000b\u0003\u0011.\u0003\"AF%\n\u0005);\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0019\u001a\u0001\raO\u0001\u0006i>\\WM\\\u0001\fK:\u001cw\u000eZ3U_.,g\u000eF\u0002<\u001fFCQ\u0001U\u0004A\u0002m\na!\\5mY&\u001c\b\"\u0002*\b\u0001\u0004Y\u0014\u0001\u00025nC\u000e\f1\u0002Z3d_\u0012,Gk\\6f]R\u0011QK\u0018\t\u0004-f[V\"A,\u000b\u0005a;\u0012\u0001B;uS2L!AW,\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u00179nZ\u0014BA/\u0018\u0005\u0019!V\u000f\u001d7fe!)A\n\u0003a\u0001w\u0005aq-\u001a8fe\u0006$X\rS7bGR\u00111(\u0019\u0005\u0006E&\u0001\raO\u0001\u0002i\u0006a1M]3bi\u0016\u001cun\\6jKR\tQ\r\u0005\u0002gW6\tqM\u0003\u0002iS\u00069\u0001.Z1eKJ\u001c(B\u000162\u0003\u0015iw\u000eZ3m\u0013\tawM\u0001\u0006IiR\u00048i\\8lS\u0016$QA\u001c\u0001C\u0002=\u0014\u0011\u0001V\t\u0003aN\u0004\"AF9\n\u0005I<\"a\u0002(pi\"Lgn\u001a\t\u0003-QL!!^\f\u0003\u0007\u0005s\u0017\u0010")
public interface CsrfManager<T> {
    public SessionConfig config();

    public long nowMillis();

    public static /* synthetic */ AuthorizationFailedRejection$ tokenInvalidRejection$(CsrfManager $this) {
        return $this.tokenInvalidRejection();
    }

    default public AuthorizationFailedRejection$ tokenInvalidRejection() {
        return AuthorizationFailedRejection$.MODULE$;
    }

    public static /* synthetic */ String createToken$(CsrfManager $this) {
        return $this.createToken();
    }

    default public String createToken() {
        String millis = Long.toString(this.nowMillis());
        String hmac = this.generateHmac(millis);
        return this.encodeToken(millis, hmac);
    }

    public static /* synthetic */ boolean validateToken$(CsrfManager $this, String token) {
        return $this.validateToken(token);
    }

    default public boolean validateToken(String token) {
        return new StringOps(Predef$.MODULE$.augmentString(token)).nonEmpty() && BoxesRunTime.unboxToBoolean((Object)this.decodeToken(token).fold((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CsrfManager.$anonfun$validateToken$1(x$2)), (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CsrfManager.$anonfun$validateToken$2(this, x0$1))));
    }

    private String encodeToken(String millis, String hmac) {
        return new StringBuilder(1).append(millis).append("-").append(hmac).toString();
    }

    private Try<Tuple2<String, String>> decodeToken(String token) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String[] splitted = token.split("-", 2);
            return new Tuple2((Object)splitted[0], (Object)splitted[1]);
        });
    }

    private String generateHmac(String t) {
        return Crypto$.MODULE$.sign_HmacSHA256_base64_v0_5_2(t, this.config().serverSecret());
    }

    public static /* synthetic */ HttpCookie createCookie$(CsrfManager $this) {
        return $this.createCookie();
    }

    default public HttpCookie createCookie() {
        String x$1 = this.config().csrfCookieConfig().name();
        String x$2 = this.createToken();
        None$ x$3 = None$.MODULE$;
        Option<String> x$4 = this.config().csrfCookieConfig().domain();
        Option<String> x$5 = this.config().csrfCookieConfig().path();
        boolean x$6 = this.config().csrfCookieConfig().secure();
        boolean x$7 = this.config().csrfCookieConfig().httpOnly();
        Option x$8 = HttpCookie$.MODULE$.apply$default$4();
        Option x$9 = HttpCookie$.MODULE$.apply$default$9();
        return HttpCookie$.MODULE$.apply(x$1, x$2, (Option)x$3, x$8, x$4, x$5, x$6, x$7, x$9).withSameSite(this.config().csrfCookieConfig().sameSite());
    }

    public static /* synthetic */ boolean $anonfun$validateToken$1(Throwable x$2) {
        return false;
    }

    public static /* synthetic */ boolean $anonfun$validateToken$2(CsrfManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String millis = (String)tuple2._1();
        String hmac = (String)tuple2._2();
        boolean bl = SessionUtil$.MODULE$.constantTimeEquals(hmac, $this.generateHmac(millis));
        return bl;
    }

    public static void $init$(CsrfManager $this) {
    }
}

