/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.session;

import com.softwaremill.session.Crypto$;
import com.softwaremill.session.DecodeResult;
import com.softwaremill.session.SessionConfig;
import com.softwaremill.session.SessionEncoder;
import com.softwaremill.session.SessionSerializer;
import com.softwaremill.session.SessionUtil$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005m3A!\u0002\u0004\u0001\u001b!AA\u0005\u0001B\u0001B\u0003-Q\u0005C\u00034\u0001\u0011\u0005A\u0007C\u00039\u0001\u0011\u0005\u0013\bC\u0003N\u0001\u0011\u0005cJA\nCCNL7mU3tg&|g.\u00128d_\u0012,'O\u0003\u0002\b\u0011\u000591/Z:tS>t'BA\u0005\u000b\u00031\u0019xN\u001a;xCJ,W.\u001b7m\u0015\u0005Y\u0011aA2p[\u000e\u0001QC\u0001\b\u001c'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007Y9\u0012$D\u0001\u0007\u0013\tAbA\u0001\bTKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\u0011\u0005iYB\u0002\u0001\u0003\u00069\u0001\u0011\r!\b\u0002\u0002)F\u0011a$\t\t\u0003!}I!\u0001I\t\u0003\u000f9{G\u000f[5oOB\u0011\u0001CI\u0005\u0003GE\u00111!\u00118z\u0003)\u0019XM]5bY&TXM\u001d\t\u0005-\u0019J\u0002&\u0003\u0002(\r\t\t2+Z:tS>t7+\u001a:jC2L'0\u001a:\u0011\u0005%\u0002dB\u0001\u0016/!\tY\u0013#D\u0001-\u0015\tiC\"\u0001\u0004=e>|GOP\u0005\u0003_E\ta\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011q&E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\"\"AN\u001c\u0011\u0007Y\u0001\u0011\u0004C\u0003%\u0005\u0001\u000fQ%\u0001\u0004f]\u000e|G-\u001a\u000b\u0005u\u0005\u001b\u0005\n\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005!A.\u00198h\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\r\u001f\t\u000b\t\u001b\u0001\u0019A\r\u0002\u0003QDQ\u0001R\u0002A\u0002\u0015\u000b\u0011B\\8x\u001b&dG.[:\u0011\u0005A1\u0015BA$\u0012\u0005\u0011auN\\4\t\u000b%\u001b\u0001\u0019\u0001&\u0002\r\r|gNZ5h!\t12*\u0003\u0002M\r\ti1+Z:tS>t7i\u001c8gS\u001e\fa\u0001Z3d_\u0012,GcA(Y5B\u0019\u0001kU+\u000e\u0003ES!AU\t\u0002\tU$\u0018\u000e\\\u0005\u0003)F\u00131\u0001\u0016:z!\r1b+G\u0005\u0003/\u001a\u0011A\u0002R3d_\u0012,'+Z:vYRDQ!\u0017\u0003A\u0002!\n\u0011a\u001d\u0005\u0006\u0013\u0012\u0001\rA\u0013")
public class BasicSessionEncoder<T>
implements SessionEncoder<T> {
    private final SessionSerializer<T, String> serializer;

    @Override
    public String encode(T t, long nowMillis, SessionConfig config) {
        String serialized = new StringBuilder(1).append("x").append((Object)this.serializer.serialize(t)).toString();
        String withExpiry = (String)config.sessionMaxAgeSeconds().fold((Function0 & Serializable)() -> serialized, (Function1 & Serializable)maxAge -> BasicSessionEncoder.$anonfun$encode$2(nowMillis, serialized, BoxesRunTime.unboxToLong((Object)maxAge)));
        String encrypted = config.sessionEncryptData() ? Crypto$.MODULE$.encrypt_AES(withExpiry, config.serverSecret()) : withExpiry;
        return new StringBuilder(1).append(Crypto$.MODULE$.sign_HmacSHA1_hex(withExpiry, config.serverSecret())).append("-").append(encrypted).toString();
    }

    @Override
    public Try<DecodeResult<T>> decode(String s, SessionConfig config) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Tuple2 tuple2;
            String[] splitted = s.split("-", 2);
            String decrypted = config.sessionEncryptData() ? Crypto$.MODULE$.decrypt_AES(splitted[1], config.serverSecret()) : splitted[1];
            Tuple2 tuple22 = BasicSessionEncoder.extractExpiry$1(decrypted, config);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Option expiry = (Option)tuple22._1();
            String serialized = (String)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)expiry, (Object)serialized);
            Option expiry2 = (Option)tuple23._1();
            String serialized2 = (String)tuple23._2();
            Try deserializedResult = $this.serializer.deserialize(serialized2.substring(1));
            Tuple2 tuple24 = tuple2 = deserializedResult.isFailure() && config.tokenMigrationV0_5_3Enabled() ? new Tuple2($this.serializer.deserializeV0_5_2(serialized2.substring(1)), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2(deserializedResult, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Try deserializedResult2 = (Try)tuple2._1();
            boolean deserializedLegacy = tuple2._2$mcZ$sp();
            Tuple2 tuple25 = new Tuple2((Object)deserializedResult2, (Object)BoxesRunTime.boxToBoolean((boolean)deserializedLegacy));
            Try deserializedResult3 = (Try)tuple25._1();
            boolean deserializedLegacy2 = tuple25._2$mcZ$sp();
            return deserializedResult3.map((Function1 & Serializable)deserialized -> {
                boolean signatureMatches = BasicSessionEncoder.verifySignature$1(splitted[0], decrypted, config);
                if (!signatureMatches && config.tokenMigrationV0_5_2Enabled()) {
                    boolean signatureMatchesLegacy = BasicSessionEncoder.verifySignature$1(splitted[0], serialized2, config);
                    boolean isLegacy = signatureMatchesLegacy || deserializedLegacy2;
                    return new DecodeResult<Object>(deserialized, (Option<Object>)expiry2, signatureMatchesLegacy, isLegacy);
                }
                return new DecodeResult<Object>(deserialized, (Option<Object>)expiry2, signatureMatches, deserializedLegacy2);
            });
        }).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ String $anonfun$encode$2(long nowMillis$1, String serialized$1, long maxAge) {
        long expiry = nowMillis$1 + maxAge * 1000L;
        return new StringBuilder(1).append(expiry).append("-").append(serialized$1).toString();
    }

    public static final /* synthetic */ Tuple2 $anonfun$decode$2(String data$1, long x$1) {
        String[] splitted = data$1.split("-", 2);
        return new Tuple2((Object)new Some((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(splitted[0])))), (Object)splitted[1]);
    }

    private static final Tuple2 extractExpiry$1(String data, SessionConfig config$1) {
        return (Tuple2)config$1.sessionMaxAgeSeconds().fold((Function0 & Serializable)() -> new Tuple2((Object)Option$.MODULE$.empty(), (Object)data), (Function1 & Serializable)x$1 -> BasicSessionEncoder.$anonfun$decode$2(data, BoxesRunTime.unboxToLong((Object)x$1)));
    }

    private static final boolean verifySignature$1(String tokenSignature, String expectedValue, SessionConfig config$1) {
        return SessionUtil$.MODULE$.constantTimeEquals(tokenSignature, Crypto$.MODULE$.sign_HmacSHA1_hex(expectedValue, config$1.serverSecret()));
    }

    public BasicSessionEncoder(SessionSerializer<T, String> serializer) {
        this.serializer = serializer;
    }
}

