/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.session;

import akka.http.scaladsl.model.headers.HttpCookie;
import akka.http.scaladsl.model.headers.HttpCookie$;
import akka.http.scaladsl.model.headers.RawHeader;
import com.softwaremill.session.Crypto$;
import com.softwaremill.session.RefreshTokenData;
import com.softwaremill.session.RefreshTokenLookupResult;
import com.softwaremill.session.RefreshTokenStorage;
import com.softwaremill.session.SessionConfig;
import com.softwaremill.session.SessionResult;
import com.softwaremill.session.SessionResult$Expired$;
import com.softwaremill.session.SessionResult$TokenNotFound$;
import com.softwaremill.session.SessionUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015caB\b\u0011!\u0003\r\ta\u0006\u0005\u0006?\u0001!\t\u0001\t\u0005\u0006I\u00011\t!\n\u0005\u0006U\u00011\ta\u000b\u0005\u0006_\u00011\t\u0001\r\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\u0019\u0002!\t\u0001\u0011\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u0006;\u0002!\tA\u0018\u0005\u0006_\u0002!\t\u0001\u001d\u0005\n\u0003\u000f\u0001\u0011\u0013!C\u0001\u0003\u0013Aq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\t\u0019\"+\u001a4sKNDGk\\6f]6\u000bg.Y4fe*\u0011\u0011CE\u0001\bg\u0016\u001c8/[8o\u0015\t\u0019B#\u0001\u0007t_\u001a$x/\u0019:f[&dGNC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001+\tAbg\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#A\u0011\u0011\u0005i\u0011\u0013BA\u0012\u001c\u0005\u0011)f.\u001b;\u0002\r\r|gNZ5h+\u00051\u0003CA\u0014)\u001b\u0005\u0001\u0012BA\u0015\u0011\u00055\u0019Vm]:j_:\u001cuN\u001c4jO\u0006Ian\\<NS2d\u0017n]\u000b\u0002YA\u0011!$L\u0005\u0003]m\u0011A\u0001T8oO\u000691\u000f^8sC\u001e,W#A\u0019\u0011\u0007\u001d\u0012D'\u0003\u00024!\t\u0019\"+\u001a4sKNDGk\\6f]N#xN]1hKB\u0011QG\u000e\u0007\u0001\t\u00159\u0004A1\u00019\u0005\u0005!\u0016CA\u001d=!\tQ\"(\u0003\u0002<7\t9aj\u001c;iS:<\u0007C\u0001\u000e>\u0013\tq4DA\u0002B]f\fab\u0019:fCR,7+\u001a7fGR|'\u000fF\u0001B!\t\u0011\u0015J\u0004\u0002D\u000fB\u0011AiG\u0007\u0002\u000b*\u0011aIF\u0001\u0007yI|w\u000e\u001e \n\u0005![\u0012A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n11\u000b\u001e:j]\u001eT!\u0001S\u000e\u0002\u0017\r\u0014X-\u0019;f)>\\WM\\\u0001\u0017I\u0016\u001cw\u000eZ3TK2,7\r^8s\u0003:$Gk\\6f]R\u0011q*\u0016\t\u00045A\u0013\u0016BA)\u001c\u0005\u0019y\u0005\u000f^5p]B!!dU!B\u0013\t!6D\u0001\u0004UkBdWM\r\u0005\u0006-\u001e\u0001\r!Q\u0001\u0006m\u0006dW/Z\u0001\u0017K:\u001cw\u000eZ3TK2,7\r^8s\u0003:$Gk\\6f]R\u0019\u0011)W.\t\u000biC\u0001\u0019A!\u0002\u0011M,G.Z2u_JDQ\u0001\u0018\u0005A\u0002\u0005\u000bQ\u0001^8lK:\f1B]8uCR,Gk\\6f]R\u0019ql\u001b7\u0015\u0005\u00014\u0007cA1e\u00036\t!M\u0003\u0002d7\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0015\u0014'A\u0002$viV\u0014X\rC\u0003h\u0013\u0001\u000f\u0001.\u0001\u0002fGB\u0011\u0011-[\u0005\u0003U\n\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000bEI\u0001\u0019\u0001\u001b\t\u000b5L\u0001\u0019\u00018\u0002\u0011\u0015D\u0018n\u001d;j]\u001e\u00042A\u0007)B\u00031\u0019'/Z1uK\u000e{wn[5f)\u0011\tx0!\u0001\u0011\u0005IlX\"A:\u000b\u0005Q,\u0018a\u00025fC\u0012,'o\u001d\u0006\u0003m^\fQ!\\8eK2T!\u0001_=\u0002\u0011M\u001c\u0017\r\\1eg2T!A_>\u0002\t!$H\u000f\u001d\u0006\u0002y\u0006!\u0011m[6b\u0013\tq8O\u0001\u0006IiR\u00048i\\8lS\u0016DQA\u0016\u0006A\u0002\u0005C\u0011\"a\u0001\u000b!\u0003\u0005\r!!\u0002\u0002\r5\f\u00070Q4f!\rQ\u0002\u000bL\u0001\u0017GJ,\u0017\r^3D_>\\\u0017.\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0002\u0016\u0005\u0003\u000b\tia\u000b\u0002\u0002\u0010A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011!C;oG\",7m[3e\u0015\r\tIbG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000f\u0003'\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00031\u0019'/Z1uK\"+\u0017\rZ3s)\u0011\t\u0019#!\u000b\u0011\u0007I\f)#C\u0002\u0002(M\u0014\u0011BU1x\u0011\u0016\fG-\u001a:\t\u000bYc\u0001\u0019A!\u0002!M,7o]5p]\u001a\u0013x.\u001c,bYV,G\u0003BA\u0018\u0003w!B!!\r\u0002:A!\u0011\rZA\u001a!\u00119\u0013Q\u0007\u001b\n\u0007\u0005]\u0002CA\u0007TKN\u001c\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006O6\u0001\u001d\u0001\u001b\u0005\u0006-6\u0001\r!Q\u0001\fe\u0016lwN^3U_.,g\u000e\u0006\u0003\u0002B\u0005\r\u0003cA1eC!)aK\u0004a\u0001\u0003\u0002")
public interface RefreshTokenManager<T> {
    public SessionConfig config();

    public long nowMillis();

    public RefreshTokenStorage<T> storage();

    public static /* synthetic */ String createSelector$(RefreshTokenManager $this) {
        return $this.createSelector();
    }

    default public String createSelector() {
        return SessionUtil$.MODULE$.randomString(16);
    }

    public static /* synthetic */ String createToken$(RefreshTokenManager $this) {
        return $this.createToken();
    }

    default public String createToken() {
        return SessionUtil$.MODULE$.randomString(64);
    }

    public static /* synthetic */ Option decodeSelectorAndToken$(RefreshTokenManager $this, String value) {
        return $this.decodeSelectorAndToken(value);
    }

    default public Option<Tuple2<String, String>> decodeSelectorAndToken(String value) {
        String[] s = value.split(":", 2);
        if (s.length == 2) {
            return new Some((Object)new Tuple2((Object)s[0], (Object)s[1]));
        }
        return None$.MODULE$;
    }

    public static /* synthetic */ String encodeSelectorAndToken$(RefreshTokenManager $this, String selector, String token) {
        return $this.encodeSelectorAndToken(selector, token);
    }

    default public String encodeSelectorAndToken(String selector, String token) {
        return new StringBuilder(1).append(selector).append(":").append(token).toString();
    }

    public static /* synthetic */ Future rotateToken$(RefreshTokenManager $this, Object session, Option existing, ExecutionContext ec) {
        return $this.rotateToken(session, (Option<String>)existing, ec);
    }

    default public Future<String> rotateToken(T session, Option<String> existing, ExecutionContext ec) {
        String selector = this.createSelector();
        String token = this.createToken();
        Future storeFuture = this.storage().store(new RefreshTokenData<T>(session, selector, Crypto$.MODULE$.hash_SHA256(token), this.nowMillis() + this.config().refreshTokenMaxAgeSeconds() * 1000L)).map((Function1 & Serializable)x$3 -> this.encodeSelectorAndToken(selector, token), ec);
        existing.flatMap((Function1 & Serializable)value -> this.decodeSelectorAndToken((String)value)).foreach((Function1 & Serializable)x0$1 -> {
            RefreshTokenManager.$anonfun$rotateToken$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        return storeFuture;
    }

    public static /* synthetic */ HttpCookie createCookie$(RefreshTokenManager $this, String value, Option maxAge) {
        return $this.createCookie(value, (Option<Object>)maxAge);
    }

    default public HttpCookie createCookie(String value, Option<Object> maxAge) {
        return HttpCookie$.MODULE$.apply(this.config().refreshTokenCookieConfig().name(), value, (Option)None$.MODULE$, maxAge, this.config().refreshTokenCookieConfig().domain(), this.config().refreshTokenCookieConfig().path(), this.config().refreshTokenCookieConfig().secure(), this.config().refreshTokenCookieConfig().httpOnly(), HttpCookie$.MODULE$.apply$default$9()).withSameSite(this.config().refreshTokenCookieConfig().sameSite());
    }

    public static /* synthetic */ Option createCookie$default$2$(RefreshTokenManager $this) {
        return $this.createCookie$default$2();
    }

    default public Option<Object> createCookie$default$2() {
        return new Some((Object)BoxesRunTime.boxToLong((long)this.config().refreshTokenMaxAgeSeconds()));
    }

    public static /* synthetic */ RawHeader createHeader$(RefreshTokenManager $this, String value) {
        return $this.createHeader(value);
    }

    default public RawHeader createHeader(String value) {
        return new RawHeader(this.config().refreshTokenHeaderConfig().sendToClientHeaderName(), value);
    }

    public static /* synthetic */ Future sessionFromValue$(RefreshTokenManager $this, String value, ExecutionContext ec) {
        return $this.sessionFromValue(value, ec);
    }

    default public Future<SessionResult<T>> sessionFromValue(String value, ExecutionContext ec) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, String>> option = this.decodeSelectorAndToken(value);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String selector = (String)tuple2._1();
            String token = (String)tuple2._2();
            return this.storage().lookup(selector).flatMap((Function1 & Serializable)x0$1 -> {
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    RefreshTokenLookupResult lookupResult = (RefreshTokenLookupResult)some.value();
                    if (lookupResult.expires() < this.nowMillis()) {
                        return this.storage().remove(selector).map((Function1 & Serializable)x$4 -> SessionResult$Expired$.MODULE$, ec);
                    }
                    if (!SessionUtil$.MODULE$.constantTimeEquals(Crypto$.MODULE$.hash_SHA256(token), lookupResult.tokenHash())) {
                        return this.storage().remove(selector).map((Function1 & Serializable)x$5 -> new SessionResult.Corrupt(new RuntimeException("Corrupt token hash")), ec);
                    }
                    return Future$.MODULE$.successful(new SessionResult.CreatedFromToken<Object>(lookupResult.createSession().apply()));
                }
                if (None$.MODULE$.equals(option)) {
                    return Future$.MODULE$.successful((Object)SessionResult$TokenNotFound$.MODULE$);
                }
                throw new MatchError((Object)option);
            }, ec);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)new SessionResult.Corrupt(new RuntimeException("Cannot decode selector/token")));
        }
        throw new MatchError(option);
    }

    public static /* synthetic */ Future removeToken$(RefreshTokenManager $this, String value) {
        return $this.removeToken(value);
    }

    default public Future<BoxedUnit> removeToken(String value) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, String>> option = this.decodeSelectorAndToken(value);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String s = (String)tuple2._1();
            return this.storage().remove(s);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        throw new MatchError(option);
    }

    public static /* synthetic */ void $anonfun$rotateToken$3(RefreshTokenManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String s = (String)tuple2._1();
            $this.storage().schedule((Duration)Duration$.MODULE$.apply($this.config().removeUsedRefreshTokenAfter(), TimeUnit.SECONDS), (Function0 & Serializable)() -> $this.storage().remove(s));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(RefreshTokenManager $this) {
    }
}

