/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.session;

import com.softwaremill.session.Crypto$;
import com.softwaremill.session.DecodeResult;
import com.softwaremill.session.JwtSessionEncoder$;
import com.softwaremill.session.JwtSessionEncoder$$anonfun$decode$1$;
import com.softwaremill.session.SessionConfig;
import com.softwaremill.session.SessionEncoder;
import com.softwaremill.session.SessionSerializer;
import com.softwaremill.session.SessionUtil$;
import java.util.Base64;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u0001%\u0011\u0011CS<u'\u0016\u001c8/[8o\u000b:\u001cw\u000eZ3s\u0015\t\u0019A!A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011\u0001D:pMR<\u0018M]3nS2d'\"A\u0004\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005)92c\u0001\u0001\f#A\u0011AbD\u0007\u0002\u001b)\ta\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0011\u001b\t1\u0011I\\=SK\u001a\u00042AE\n\u0016\u001b\u0005\u0011\u0011B\u0001\u000b\u0003\u00059\u0019Vm]:j_:,enY8eKJ\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\tA+\u0005\u0002\u001b;A\u0011AbG\u0005\u000395\u0011qAT8uQ&tw\r\u0005\u0002\r=%\u0011q$\u0004\u0002\u0004\u0003:L\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b1\u0002\u0012\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0003\u0013GU)\u0013B\u0001\u0013\u0003\u0005E\u0019Vm]:j_:\u001cVM]5bY&TXM\u001d\t\u0003MQr!aJ\u0019\u000f\u0005!rcBA\u0015-\u001b\u0005Q#BA\u0016\t\u0003\u0019a$o\\8u}%\tQ&A\u0002pe\u001eL!a\f\u0019\u0002\r)\u001cxN\u001c\u001bt\u0015\u0005i\u0013B\u0001\u001a4\u0003\u001d\u0001\u0018mY6bO\u0016T!a\f\u0019\n\u0005U2$A\u0002&WC2,XM\u0003\u00023g!A\u0001\b\u0001B\u0001B\u0003-\u0011(A\u0004g_Jl\u0017\r^:\u0011\u0005iZT\"A\u001a\n\u0005q\u001a$a\u0002$pe6\fGo\u001d\u0005\u0006}\u0001!\taP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001#2!\u0011\"D!\r\u0011\u0002!\u0006\u0005\u0006Cu\u0002\u001dA\t\u0005\bqu\u0002\n\u0011q\u0001:\u0011\u0015)\u0005\u0001\"\u0011G\u0003\u0019)gnY8eKR!qI\u0014)V!\tA5J\u0004\u0002\r\u0013&\u0011!*D\u0001\u0007!J,G-\u001a4\n\u00051k%AB*ue&twM\u0003\u0002K\u001b!)q\n\u0012a\u0001+\u0005\tA\u000fC\u0003R\t\u0002\u0007!+A\u0005o_^l\u0015\u000e\u001c7jgB\u0011AbU\u0005\u0003)6\u0011A\u0001T8oO\")a\u000b\u0012a\u0001/\u000611m\u001c8gS\u001e\u0004\"A\u0005-\n\u0005e\u0013!!D*fgNLwN\\\"p]\u001aLw\rC\u0003\\\u0001\u0011\u0005A,\u0001\u0007f]\u000e|G-\u001a,1?Vz&\u0007\u0006\u0003H;z{\u0006\"B([\u0001\u0004)\u0002\"B)[\u0001\u0004\u0011\u0006\"\u0002,[\u0001\u00049\u0006\"B1\u0001\t\u0003\u0012\u0017A\u00023fG>$W\rF\u0002dY:\u00042\u0001Z4j\u001b\u0005)'B\u00014\u000e\u0003\u0011)H/\u001b7\n\u0005!,'a\u0001+ssB\u0019!C[\u000b\n\u0005-\u0014!\u0001\u0004#fG>$WMU3tk2$\b\"B7a\u0001\u00049\u0015!A:\t\u000bY\u0003\u0007\u0019A,\t\u000bA\u0004A\u0011C9\u0002\u0019\r\u0014X-\u0019;f\u0011\u0016\fG-\u001a:\u0016\u0003\u0015BQa\u001d\u0001\u0005\u0012Q\fQb\u0019:fCR,\u0007+Y=m_\u0006$G\u0003B\u0013vm^DQa\u0014:A\u0002UAQ!\u0015:A\u0002ICQA\u0016:A\u0002]CQ!\u001f\u0001\u0005\u0012i\fa\"\u001a=ue\u0006\u001cG\u000fU1zY>\fG\rF\u0003|\u0003\u000b\tI\u0001E\u0002eOr\u0004B\u0001D?\u0016\u007f&\u0011a0\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t1\t\tAU\u0005\u0004\u0003\u0007i!AB(qi&|g\u000e\u0003\u0004\u0002\ba\u0004\r!J\u0001\u0002a\")a\u000b\u001fa\u0001/\"1Q\t\u0001C\t\u0003\u001b!2aRA\b\u0011\u001d\t\t\"a\u0003A\u0002\u0015\n!A\u001b<\t\r\u0005\u0004A\u0011CA\u000b)\u0011\t9\"!\u0007\u0011\u0007\u0011<W\u0005\u0003\u0004n\u0003'\u0001\ra\u0012\u0005\b\u0003;\u0001A\u0011CA\u0010\u00031!WmY8eKZ\u0003t,N03)\u0011\t9\"!\t\t\r5\fY\u00021\u0001H\u000f%\t)CAA\u0001\u0012\u0003\t9#A\tKoR\u001cVm]:j_:,enY8eKJ\u00042AEA\u0015\r!\t!!!A\t\u0002\u0005-2cAA\u0015\u0017!9a(!\u000b\u0005\u0002\u0005=BCAA\u0014\u0011)\t\u0019$!\u000b\u0012\u0002\u0013\u0005\u0011QG\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u0005]\u0012Q\n\u000b\u0003\u0003sQ3!OA\u001eW\t\ti\u0004\u0005\u0003\u0002@\u0005%SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA$\u001b\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0013\u0011\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u0002\r\u00022\t\u0007\u0011\u0004")
public class JwtSessionEncoder<T>
implements SessionEncoder<T> {
    private final SessionSerializer<T, JsonAST.JValue> serializer;
    private final Formats formats;

    public static <T> Formats $lessinit$greater$default$2() {
        return JwtSessionEncoder$.MODULE$.$lessinit$greater$default$2();
    }

    public String encode(T t, long nowMillis, SessionConfig config) {
        String h = this.encode(this.createHeader());
        String p = this.encode(this.createPayload(t, nowMillis, config));
        String base = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{h, p}));
        String signature = Crypto$.MODULE$.sign_HmacSHA256_base64(base, config.serverSecret());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base, signature}));
    }

    public String encodeV0_5_2(T t, long nowMillis, SessionConfig config) {
        String h = this.encode(this.createHeader());
        String p = this.encode(this.createPayload(t, nowMillis, config));
        String base = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{h, p}));
        String signature = Crypto$.MODULE$.sign_HmacSHA256_base64_v0_5_2(base, config.serverSecret());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base, signature}));
    }

    public Try<DecodeResult<T>> decode(String s, SessionConfig config) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, s, config){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JwtSessionEncoder $outer;
            private final String s$1;
            public final SessionConfig config$1;

            public final Try<DecodeResult<T>> apply() {
                String sCleaned = this.s$1.startsWith("Bearer") ? this.s$1.substring(7).trim() : this.s$1;
                List list = Predef$.MODULE$.refArrayOps((Object[])sCleaned.split("\\.")).toList();
                Some some = List$.MODULE$.unapplySeq((Seq)list);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                    Tuple2 tuple2;
                    Tuple3 tuple3;
                    String h = (String)((LinearSeqOptimized)some.get()).apply(0);
                    String p = (String)((LinearSeqOptimized)some.get()).apply(1);
                    String signature = (String)((LinearSeqOptimized)some.get()).apply(2);
                    Tuple3 tuple32 = tuple3 = new Tuple3((Object)h, (Object)p, (Object)signature);
                    String h2 = (String)tuple32._1();
                    String p2 = (String)tuple32._2();
                    String signature2 = (String)tuple32._3();
                    Try<JsonAST.JValue> decodedValue = this.$outer.decode(p2);
                    Tuple2 tuple22 = tuple2 = decodedValue.isFailure() && this.config$1.tokenMigrationV0_5_3Enabled() ? new Tuple2(this.$outer.decodeV0_5_2(p2), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2(decodedValue, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    if (tuple2 != null) {
                        Tuple2 tuple23;
                        Try decodedValue2 = (Try)tuple2._1();
                        boolean decodedLegacy = tuple2._2$mcZ$sp();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)decodedValue2, (Object)BoxesRunTime.boxToBoolean((boolean)decodedLegacy));
                        Try decodedValue3 = (Try)tuple24._1();
                        boolean decodedLegacy2 = tuple24._2$mcZ$sp();
                        return decodedValue3.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$decode$1 $outer;
                            public final String h$1;
                            public final String p$1;
                            public final String signature$1;
                            public final boolean decodedLegacy$1;

                            public final Try<DecodeResult<T>> apply(JsonAST.JValue jv) {
                                return this.$outer.com$softwaremill$session$JwtSessionEncoder$$anonfun$$$outer().extractPayload(jv, this.$outer.config$1).withFilter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Tuple2<T, Option<Object>> check$ifrefutable$1) {
                                        Tuple2<T, Option<Object>> tuple2 = check$ifrefutable$1;
                                        boolean bl = tuple2 != null;
                                        return bl;
                                    }
                                }).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$decode$1$$anonfun$apply$1 $outer;

                                    public final DecodeResult<T> apply(Tuple2<T, Option<Object>> x$3) {
                                        Tuple2<T, Option<Object>> tuple2 = x$3;
                                        if (tuple2 != null) {
                                            DecodeResult decodeResult;
                                            Object t = tuple2._1();
                                            Option exp = (Option)tuple2._2();
                                            boolean signatureMatches = SessionUtil$.MODULE$.constantTimeEquals(this.$outer.signature$1, Crypto$.MODULE$.sign_HmacSHA256_base64(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.h$1, this.$outer.p$1})), this.$outer.com$softwaremill$session$JwtSessionEncoder$$anonfun$$anonfun$$$outer().config$1.serverSecret()));
                                            if (!signatureMatches && this.$outer.com$softwaremill$session$JwtSessionEncoder$$anonfun$$anonfun$$$outer().config$1.tokenMigrationV0_5_3Enabled()) {
                                                boolean signatureMatchesLegacy = SessionUtil$.MODULE$.constantTimeEquals(this.$outer.signature$1, Crypto$.MODULE$.sign_HmacSHA256_base64_v0_5_2(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.h$1, this.$outer.p$1})), this.$outer.com$softwaremill$session$JwtSessionEncoder$$anonfun$$anonfun$$$outer().config$1.serverSecret()));
                                                boolean isLegacy = signatureMatchesLegacy || this.$outer.decodedLegacy$1;
                                                decodeResult = new DecodeResult(t, exp, signatureMatchesLegacy, isLegacy);
                                            } else {
                                                decodeResult = new DecodeResult(t, exp, signatureMatches, this.$outer.decodedLegacy$1);
                                            }
                                            DecodeResult decodeResult2 = decodeResult;
                                            return decodeResult2;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$decode$1 com$softwaremill$session$JwtSessionEncoder$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.h$1 = h$1;
                                this.p$1 = p$1;
                                this.signature$1 = signature$1;
                                this.decodedLegacy$1 = decodedLegacy$1;
                            }
                        });
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError((Object)list);
            }

            public /* synthetic */ JwtSessionEncoder com$softwaremill$session$JwtSessionEncoder$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.s$1 = s$1;
                this.config$1 = var3_3;
            }
        }).flatten(Predef$.MODULE$.$conforms());
    }

    public JsonAST.JValue createHeader() {
        return package$.MODULE$.JObject().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alg"), (Object)package$.MODULE$.JString().apply("HS256")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typ"), (Object)package$.MODULE$.JString().apply("JWT"))}));
    }

    public JsonAST.JValue createPayload(T t, long nowMillis, SessionConfig config) {
        JsonAST.JValue jValue;
        List exp = config.sessionMaxAgeSeconds().map((Function1)new Serializable(this, nowMillis){
            public static final long serialVersionUID = 0L;
            private final long nowMillis$1;

            public final long apply(long maxAge) {
                return this.apply$mcJJ$sp(maxAge);
            }

            public long apply$mcJJ$sp(long maxAge) {
                return this.nowMillis$1 / 1000L + maxAge;
            }
            {
                this.nowMillis$1 = nowMillis$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, JsonAST.JInt> apply(long exp) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exp"), (Object)package$.MODULE$.JInt().apply(BigInt$.MODULE$.long2bigInt(exp)));
            }
        }).toList();
        JsonAST.JValue serialized = (JsonAST.JValue)this.serializer.serialize(t);
        if (config.sessionEncryptData()) {
            JsonAST.JObject serializedWrapped = package$.MODULE$.JObject().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)serialized)}));
            jValue = package$.MODULE$.JString().apply(Crypto$.MODULE$.encrypt_AES(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)serializedWrapped, this.formats)), config.serverSecret()));
        } else {
            jValue = serialized;
        }
        JsonAST.JValue data = jValue;
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"data"), (Object)data);
        return package$.MODULE$.JObject().apply(exp.$colon$colon((Object)tuple2));
    }

    public Try<Tuple2<T, Option<Object>>> extractPayload(JsonAST.JValue p, SessionConfig config) {
        JsonAST.JValue jValue;
        None$ none$;
        JsonAST.JValue jValue2 = package$.MODULE$.jvalue2monadic(p).$bslash$bslash("exp");
        if (jValue2 instanceof JsonAST.JInt) {
            JsonAST.JInt jInt = (JsonAST.JInt)jValue2;
            BigInt e = jInt.num();
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)(e.longValue() * 1000L)));
        } else {
            none$ = None$.MODULE$;
        }
        None$ exp = none$;
        JsonAST.JValue rawData = package$.MODULE$.jvalue2monadic(p).$bslash$bslash("data");
        if (config.sessionEncryptData()) {
            JsonAST.JValue jValue3;
            JsonAST.JValue jValue4 = rawData;
            if (jValue4 instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue4;
                String s = jString.s();
                jValue3 = package$.MODULE$.jvalue2monadic(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(Crypto$.MODULE$.decrypt_AES(s, config.serverSecret())), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).$bslash$bslash("v");
            } else {
                jValue3 = rawData;
            }
            jValue = jValue3;
        } else {
            jValue = rawData;
        }
        JsonAST.JValue data = jValue;
        Try t = this.serializer.deserialize((Object)data);
        return t.map((Function1)new Serializable(this, (Option)exp){
            public static final long serialVersionUID = 0L;
            private final Option exp$1;

            public final Tuple2<T, Option<Object>> apply(T x$5) {
                return new Tuple2(x$5, (Object)this.exp$1);
            }
            {
                this.exp$1 = exp$1;
            }
        });
    }

    public String encode(JsonAST.JValue jv) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(jv, this.formats)).getBytes("utf-8"));
    }

    public Try<JsonAST.JValue> decode(String s) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final String s$2;

            public final JsonAST.JValue apply() {
                return JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(new String(Base64.getUrlDecoder().decode(this.s$2), "utf-8")), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
            }
            {
                this.s$2 = s$2;
            }
        });
    }

    public Try<JsonAST.JValue> decodeV0_5_2(String s) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final String s$3;

            public final JsonAST.JValue apply() {
                return JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(new String(SessionUtil$.MODULE$.parseBase64_v0_5_2(this.s$3), "utf-8")), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
            }
            {
                this.s$3 = s$3;
            }
        });
    }

    public JwtSessionEncoder(SessionSerializer<T, JsonAST.JValue> serializer, Formats formats) {
        this.serializer = serializer;
        this.formats = formats;
    }
}

