/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.macwire.internals;

import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0003\t)\u0011a\u0001T8hO\u0016\u0014(BA\u0002\u0005\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002\u0006\r\u00059Q.Y2xSJ,'BA\u0004\t\u00031\u0019xN\u001a;xCJ,W.\u001b7m\u0015\u0005I\u0011aA2p[N\u0011\u0001a\u0003\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bI\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\b1\u0001\u0001\r\u0011\"\u0001\u001a\u0003\u0015IG-\u001a8u+\u0005Q\u0002C\u0001\u0007\u001c\u0013\taRBA\u0002J]RDqA\b\u0001A\u0002\u0013\u0005q$A\u0005jI\u0016tGo\u0018\u0013fcR\u0011\u0001e\t\t\u0003\u0019\u0005J!AI\u0007\u0003\tUs\u0017\u000e\u001e\u0005\bIu\t\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\u0007M\u0001\u0001\u000b\u0015\u0002\u000e\u0002\r%$WM\u001c;!\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0015\t\u0007\u000f\u001d7z)\t\u0001#\u0006\u0003\u0004,O\u0011\u0005\r\u0001L\u0001\u0004[N<\u0007c\u0001\u0007._%\u0011a&\u0004\u0002\ty\tLh.Y7f}A\u0011\u0001g\r\b\u0003\u0019EJ!AM\u0007\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003e5AQa\u000e\u0001\u0005\u0002a\nQ\u0001\u001e:bG\u0016$\"\u0001I\u001d\t\r-2D\u00111\u0001-\u0011\u0015Y\u0004\u0001\"\u0001=\u0003%9\u0018\u000e\u001e5CY>\u001c7.\u0006\u0002>\u0003R\u0011a(\u0014\u000b\u0003\u007f)\u0003\"\u0001Q!\r\u0001\u0011)!I\u000fb\u0001\u0007\n\tA+\u0005\u0002E\u000fB\u0011A\"R\u0005\u0003\r6\u0011qAT8uQ&tw\r\u0005\u0002\r\u0011&\u0011\u0011*\u0004\u0002\u0004\u0003:L\bBB&;\t\u0003\u0007A*A\u0003cY>\u001c7\u000eE\u0002\r[}Baa\u000b\u001e\u0005\u0002\u0004a\u0003\"B(\u0001\t\u0003\u0001\u0016A\u00032fO&t'\t\\8dWR\t\u0001\u0005C\u0003S\u0001\u0011\u0005\u0001+\u0001\u0005f]\u0012\u0014En\\2l\u0011\u0015A\u0003\u0001\"\u0003U)\r\u0001SK\u0016\u0005\u0007WM#\t\u0019\u0001\u0017\t\u000b]\u001b\u0006\u0019\u0001\u000e\u0002\u0019\u0011,7/\u001b:fI2+g/\u001a7\t\u000fe\u0003!\u0019!C\u00053\u0005YAKU!D\u000b~cUIV#M\u0011\u0019Y\u0006\u0001)A\u00055\u0005aAKU!D\u000b~cUIV#MA!9Q\f\u0001b\u0001\n\u0013I\u0012a\u0003#F\u0005V;u\fT#W\u000b2Caa\u0018\u0001!\u0002\u0013Q\u0012\u0001\u0004#F\u0005V;u\fT#W\u000b2\u0003\u0003bB1\u0001\u0005\u0004%I!G\u0001\r\u001d>{FjT$`\u0019\u00163V\t\u0014\u0005\u0007G\u0002\u0001\u000b\u0011\u0002\u000e\u0002\u001b9{u\fT(H?2+e+\u0012'!\u0011\u001d)\u0007A1A\u0005\ne\tQ\u0001\\3wK2Daa\u001a\u0001!\u0002\u0013Q\u0012A\u00027fm\u0016d\u0007\u0005")
public final class Logger {
    private int ident = 0;
    private final int TRACE_LEVEL;
    private final int DEBUG_LEVEL;
    private final int NO_LOG_LEVEL;
    private final int level = System.getProperty("macwire.trace") == null ? (System.getProperty("macwire.debug") == null ? this.NO_LOG_LEVEL() : this.DEBUG_LEVEL()) : this.TRACE_LEVEL();

    public int ident() {
        return this.ident;
    }

    public void ident_$eq(int x$1) {
        this.ident = x$1;
    }

    public void apply(Function0<String> msg) {
        this.apply(msg, this.DEBUG_LEVEL());
    }

    public void trace(Function0<String> msg) {
        this.apply(msg, this.TRACE_LEVEL());
    }

    public <T> T withBlock(Function0<String> msg, Function0<T> block) {
        this.apply(msg);
        this.beginBlock();
        try {
            return (T)block.apply();
        }
        finally {
            this.endBlock();
        }
    }

    public void beginBlock() {
        this.ident_$eq(this.ident() + 1);
    }

    public void endBlock() {
        this.ident_$eq(this.ident() - 1);
    }

    private void apply(Function0<String> msg, int desiredLevel) {
        if (desiredLevel >= this.level()) {
            String prefix = new StringOps(Predef$.MODULE$.augmentString("   ")).$times(this.ident());
            String logLevelName = desiredLevel == this.DEBUG_LEVEL() ? "debug" : "trace";
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[", "] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, logLevelName, msg.apply()})));
        }
    }

    private int TRACE_LEVEL() {
        return this.TRACE_LEVEL;
    }

    private int DEBUG_LEVEL() {
        return this.DEBUG_LEVEL;
    }

    private int NO_LOG_LEVEL() {
        return this.NO_LOG_LEVEL;
    }

    private int level() {
        return this.level;
    }

    public Logger() {
        this.TRACE_LEVEL = 1;
        this.DEBUG_LEVEL = 2;
        this.NO_LOG_LEVEL = 3;
    }
}

