/*
 * Decompiled with CFR 0.152.
 */
package sttp.client;

import java.io.InputStream;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client.ByteArrayBody;
import sttp.client.ByteArrayBody$;
import sttp.client.ByteBufferBody;
import sttp.client.ByteBufferBody$;
import sttp.client.FileBody;
import sttp.client.FileBody$;
import sttp.client.FollowRedirectsBackend$;
import sttp.client.IgnoreResponse$;
import sttp.client.InputStreamBody;
import sttp.client.InputStreamBody$;
import sttp.client.NoBody$;
import sttp.client.RequestBody$;
import sttp.client.RequestOptions;
import sttp.client.RequestT;
import sttp.client.ResponseAs;
import sttp.client.ResponseAs$;
import sttp.client.ResponseAsByteArray$;
import sttp.client.ResponseAsFile;
import sttp.client.ResponseAsFromMetadata;
import sttp.client.ResponseAsStream;
import sttp.client.ResponseMetadata;
import sttp.client.StringBody;
import sttp.client.StringBody$;
import sttp.client.SttpApi;
import sttp.client.SttpApi$;
import sttp.client.internal.SttpFile;
import sttp.client.internal.package$;
import sttp.model.Header;
import sttp.model.MediaType$;
import sttp.model.Part;
import sttp.model.Part$;

public abstract class SttpApi$class {
    public static ResponseAs ignore(SttpApi $this) {
        return IgnoreResponse$.MODULE$;
    }

    public static ResponseAs asString(SttpApi $this) {
        return $this.asString(package$.MODULE$.Utf8());
    }

    public static ResponseAs asStringAlways(SttpApi $this) {
        return $this.asStringAlways(package$.MODULE$.Utf8());
    }

    public static ResponseAs asString(SttpApi $this, String charset) {
        return $this.asStringAlways(charset).mapWithMetadata(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Either<String, String> apply(String s, ResponseMetadata m) {
                return m.isSuccess() ? scala.package$.MODULE$.Right().apply((Object)s) : scala.package$.MODULE$.Left().apply((Object)s);
            }
        });
    }

    public static ResponseAs asStringAlways(SttpApi $this, String charset) {
        return $this.asByteArrayAlways().mapWithMetadata(new Serializable($this, charset){
            public static final long serialVersionUID = 0L;
            public final String charset$1;

            public final String apply(byte[] bytes, ResponseMetadata metadata) {
                String charset2 = (String)metadata.contentType().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(String ct) {
                        return package$.MODULE$.charsetFromContentType(ct);
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SttpApi$.anonfun.asStringAlways.1 $outer;

                    public final String apply() {
                        return this.$outer.charset$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return new String(bytes, charset2);
            }
            {
                this.charset$1 = charset$1;
            }
        });
    }

    public static ResponseAs asByteArray(SttpApi $this) {
        return $this.asEither($this.asStringAlways(), $this.asByteArrayAlways());
    }

    public static ResponseAs asByteArrayAlways(SttpApi $this) {
        return ResponseAsByteArray$.MODULE$;
    }

    public static ResponseAs asParams(SttpApi $this) {
        return $this.asParams(package$.MODULE$.Utf8());
    }

    public static ResponseAs asParams(SttpApi $this, String charset) {
        return ResponseAs$.MODULE$.RichResponseAsEither($this.asString(charset)).mapRight(new Serializable($this, charset){
            public static final long serialVersionUID = 0L;
            private final String charset$2;

            public final scala.collection.immutable.Seq<Tuple2<String, String>> apply(String x$1) {
                return ResponseAs$.MODULE$.parseParams(x$1, this.charset$2);
            }
            {
                this.charset$2 = charset$2;
            }
        });
    }

    public static ResponseAs asStream(SttpApi $this) {
        return $this.asEither($this.asStringAlways(), $this.asStreamAlways());
    }

    public static ResponseAs asStreamAlways(SttpApi $this) {
        return new ResponseAsStream(Predef.$eq$colon$eq$.MODULE$.tpEquals());
    }

    public static ResponseAs asSttpFile(SttpApi $this, SttpFile file) {
        return new ResponseAsFile(file);
    }

    public static ResponseAs fromMetadata(SttpApi $this, Function1 f) {
        return new ResponseAsFromMetadata(f);
    }

    public static ResponseAs asEither(SttpApi $this, ResponseAs onError, ResponseAs onSuccess) {
        return $this.fromMetadata(new Serializable($this, onError, onSuccess){
            public static final long serialVersionUID = 0L;
            private final ResponseAs onError$1;
            private final ResponseAs onSuccess$1;

            public final ResponseAs<Either<L, R>, S> apply(ResponseMetadata meta) {
                return meta.isSuccess() ? this.onSuccess$1.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Right<Nothing$, R> apply(R x$2) {
                        return scala.package$.MODULE$.Right().apply(x$2);
                    }
                }) : this.onError$1.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Left<L, Nothing$> apply(L x$3) {
                        return scala.package$.MODULE$.Left().apply(x$3);
                    }
                });
            }
            {
                this.onError$1 = onError$1;
                this.onSuccess$1 = onSuccess$1;
            }
        });
    }

    public static Part multipart(SttpApi $this, String name, String data) {
        return Part$.MODULE$.apply(name, (Object)new StringBody(data, package$.MODULE$.Utf8(), StringBody$.MODULE$.apply$default$3()), (Option)new Some((Object)MediaType$.MODULE$.TextPlainUtf8()), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
    }

    public static Part multipart(SttpApi $this, String name, String data, String encoding) {
        return Part$.MODULE$.apply(name, (Object)new StringBody(data, encoding, StringBody$.MODULE$.apply$default$3()), (Option)new Some((Object)MediaType$.MODULE$.TextPlainUtf8()), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
    }

    public static Part multipart(SttpApi $this, String name, byte[] data) {
        return Part$.MODULE$.apply(name, (Object)new ByteArrayBody(data, ByteArrayBody$.MODULE$.apply$default$2()), (Option)new Some((Object)MediaType$.MODULE$.ApplicationOctetStream()), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
    }

    public static Part multipart(SttpApi $this, String name, ByteBuffer data) {
        return Part$.MODULE$.apply(name, (Object)new ByteBufferBody(data, ByteBufferBody$.MODULE$.apply$default$2()), (Option)new Some((Object)MediaType$.MODULE$.ApplicationOctetStream()), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
    }

    public static Part multipart(SttpApi $this, String name, InputStream data) {
        return Part$.MODULE$.apply(name, (Object)new InputStreamBody(data, InputStreamBody$.MODULE$.apply$default$2()), (Option)new Some((Object)MediaType$.MODULE$.ApplicationOctetStream()), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
    }

    public static Part multipartSttpFile(SttpApi $this, String name, SttpFile file) {
        String x$4 = name;
        FileBody x$5 = new FileBody(file, FileBody$.MODULE$.apply$default$2());
        Some x$6 = new Some((Object)file.name());
        Some x$7 = new Some((Object)MediaType$.MODULE$.ApplicationOctetStream());
        Map x$8 = Part$.MODULE$.apply$default$5();
        Seq x$9 = Part$.MODULE$.apply$default$6();
        return Part$.MODULE$.apply(x$4, (Object)x$5, (Option)x$7, (Option)x$6, x$8, x$9);
    }

    public static Part multipart(SttpApi $this, String name, Map fs) {
        return Part$.MODULE$.apply(name, (Object)RequestBody$.MODULE$.paramsToStringBody((scala.collection.immutable.Seq<Tuple2<String, String>>)fs.toList(), package$.MODULE$.Utf8()), (Option)new Some((Object)MediaType$.MODULE$.ApplicationXWwwFormUrlencoded()), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
    }

    public static Part multipart(SttpApi $this, String name, Map fs, String encoding) {
        return Part$.MODULE$.apply(name, (Object)RequestBody$.MODULE$.paramsToStringBody((scala.collection.immutable.Seq<Tuple2<String, String>>)fs.toList(), encoding), (Option)new Some((Object)MediaType$.MODULE$.ApplicationXWwwFormUrlencoded()), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
    }

    public static Part multipart(SttpApi $this, String name, scala.collection.immutable.Seq fs) {
        return Part$.MODULE$.apply(name, (Object)RequestBody$.MODULE$.paramsToStringBody((scala.collection.immutable.Seq<Tuple2<String, String>>)fs, package$.MODULE$.Utf8()), (Option)new Some((Object)MediaType$.MODULE$.ApplicationXWwwFormUrlencoded()), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
    }

    public static Part multipart(SttpApi $this, String name, scala.collection.immutable.Seq fs, String encoding) {
        return Part$.MODULE$.apply(name, (Object)RequestBody$.MODULE$.paramsToStringBody((scala.collection.immutable.Seq<Tuple2<String, String>>)fs, encoding), (Option)new Some((Object)MediaType$.MODULE$.ApplicationXWwwFormUrlencoded()), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
    }

    public static Part multipart(SttpApi $this, String name, Object b, Function1 evidence$1) {
        return Part$.MODULE$.apply(name, ((Function1)Predef$.MODULE$.implicitly((Object)evidence$1)).apply(b), (Option)new Some((Object)MediaType$.MODULE$.ApplicationXWwwFormUrlencoded()), Part$.MODULE$.apply$default$4(), Part$.MODULE$.apply$default$5(), Part$.MODULE$.apply$default$6());
    }

    public static void $init$(SttpApi $this) {
        $this.sttp$client$SttpApi$_setter_$DefaultReadTimeout_$eq((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).minute());
        $this.sttp$client$SttpApi$_setter_$emptyRequest_$eq(new RequestT<None$, Either<String, String>, Nothing$>(None$.MODULE$, None$.MODULE$, NoBody$.MODULE$, (scala.collection.immutable.Seq<Header>)((scala.collection.immutable.Seq)scala.package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)), $this.asString(), new RequestOptions(true, $this.DefaultReadTimeout(), FollowRedirectsBackend$.MODULE$.MaxRedirects(), false), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))));
        $this.sttp$client$SttpApi$_setter_$basicRequest_$eq($this.emptyRequest().acceptEncoding("gzip, deflate"));
        $this.sttp$client$SttpApi$_setter_$quickRequest_$eq($this.basicRequest().response($this.asStringAlways()));
    }
}

