/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.internal;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import sttp.client3.ByteArrayBody;
import sttp.client3.ByteBufferBody;
import sttp.client3.FileBody;
import sttp.client3.InputStreamBody;
import sttp.client3.MultipartBody;
import sttp.client3.NoBody$;
import sttp.client3.RequestBody;
import sttp.client3.RequestT;
import sttp.client3.StreamBody;
import sttp.client3.StringBody;
import sttp.client3.internal.SttpFile;
import sttp.client3.internal.ToRfc2616Converter$;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.Method;
import sttp.model.Part;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001\u0002\b\u0010\u0001YAQA\b\u0001\u0005\u0002}Aqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004P\u0001\u0001\u0006I!\u0013\u0005\u0006!\u0002!\t!\u0015\u0005\u0006!\u0002!\t\u0001\u0018\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006O\u0002!\t\u0001\u001b\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u00179q!!\u0004\u0010\u0011\u0003\tyA\u0002\u0004\u000f\u001f!\u0005\u0011\u0011\u0003\u0005\u0007=-!\t!a\u0005\t\u000f\u0005U1\u0002\"\u0001\u0002\u0018\t\u0011Bk\u001c*gGJ2\u0014GN\"p]Z,'\u000f^3s\u0015\t\u0001\u0012#\u0001\u0005j]R,'O\\1m\u0015\t\u00112#A\u0004dY&,g\u000e^\u001a\u000b\u0003Q\tAa\u001d;ua\u000e\u0001QCA\f%'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u00022!\t\u0001#\u001b\u0005y\u0001CA\u0012%\u0019\u0001!Q!\n\u0001C\u0002\u0019\u0012\u0011AU\t\u0003O)\u0002\"!\u0007\u0015\n\u0005%R\"a\u0002(pi\"Lgn\u001a\u0019\u0004Wy*\u0005#\u0002\u0017._u\"U\"A\t\n\u00059\n\"\u0001\u0003*fcV,7\u000f\u001e+\u0011\u0005ARdBA\u00199\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026+\u00051AH]8pizJ\u0011\u0001F\u0005\u0003%MI!!O\t\u0002\u000fA\f7m[1hK&\u00111\b\u0010\u0002\t\u0013\u0012,g\u000e^5us*\u0011\u0011(\u0005\t\u0003Gy\"\u0011b\u0010\u0013\u0002\u0002\u0003\u0005)\u0011\u0001!\u0003\u0007}#\u0013'\u0005\u0002(\u0003B\u0011\u0011DQ\u0005\u0003\u0007j\u00111!\u00118z!\t\u0019S\tB\u0005GI\u0005\u0005\t\u0011!B\u0001\u0001\n\u0019q\f\n\u001a\u0002\u001b\t{WO\u001c3bef\u001c\u0005.\u0019:t+\u0005I\u0005cA\rK\u0019&\u00111J\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u000335K!A\u0014\u000e\u0003\t\rC\u0017M]\u0001\u000f\u0005>,h\u000eZ1ss\u000eC\u0017M]:!\u0003\u0015\t\u0007\u000f\u001d7z)\t\u0011&\f\u0005\u0002T/:\u0011A+\u0016\t\u0003giI!A\u0016\u000e\u0002\rA\u0013X\rZ3g\u0013\tA\u0016L\u0001\u0004TiJLgn\u001a\u0006\u0003-jAQa\u0017\u0003A\u0002\t\nqA]3rk\u0016\u001cH\u000fF\u0002S;zCQaW\u0003A\u0002\tBQaX\u0003A\u0002\u0001\f\u0001c]3og&$\u0018N^3IK\u0006$WM]:\u0011\u0007M\u000b'+\u0003\u0002c3\n\u00191+\u001a;\u0002\u0017\u0015DHO]1di\n{G-\u001f\u000b\u0003%\u0016DQA\u001a\u0004A\u0002\t\n\u0011A]\u0001\u0014Q\u0006tG\r\\3Nk2$\u0018\u000e]1si\n{G-\u001f\u000b\u0003%&DQA[\u0004A\u0002-\fQ\u0001]1siN\u00042\u0001\u001c9t\u001d\tiwN\u0004\u00024]&\t1$\u0003\u0002:5%\u0011\u0011O\u001d\u0002\u0004'\u0016\f(BA\u001d\u001b!\r!x/_\u0007\u0002k*\u0011aoE\u0001\u0006[>$W\r\\\u0005\u0003qV\u0014A\u0001U1siB\u0012!P \t\u0004Yml\u0018B\u0001?\u0012\u0005-\u0011V-];fgR\u0014u\u000eZ=\u0011\u0005\rrH!C@j\u0003\u0003\u0005\tQ!\u0001A\u0005\ryFeM\u0001\u000fKb$(/Y2u\u0011\u0016\fG-\u001a:t)\u0015\u0011\u0016QAA\u0004\u0011\u00151\u0007\u00021\u0001#\u0011\u0015y\u0006\u00021\u0001a\u0003A9WM\\3sCR,'i\\;oI\u0006\u0014\u0018\u0010F\u0001S\u0003I!vN\u00154deY\ndgQ8om\u0016\u0014H/\u001a:\u0011\u0005\u0005Z1CA\u0006\u0019)\t\ty!\u0001\tsKF,Xm\u001d;U_J37M\r\u001c2mU!\u0011\u0011DA\u0010+\t\tY\u0002\u0005\u0003\"\u0001\u0005u\u0001cA\u0012\u0002 \u00111Q%\u0004b\u0001\u0003C\t2aJA\u0012a\u0019\t)#!\f\u00024A9\u0001'a\n\u0002,\u0005E\u0012bAA\u0015y\t9!+Z9vKN$\bcA\u0012\u0002.\u0011Y\u0011qFA\u0010\u0003\u0003\u0005\tQ!\u0001A\u0005\ryF\u0005\u000e\t\u0004G\u0005MBaCA\u001b\u0003?\t\t\u0011!A\u0003\u0002\u0001\u00131a\u0018\u00136\u0001")
public class ToRfc2616Converter<R extends RequestT<Object, ?, ?>> {
    private final char[] BoundaryChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private volatile boolean bitmap$init$0 = true;

    public static <R extends RequestT<Object, ?, ?>> ToRfc2616Converter<R> requestToRfc2616() {
        return ToRfc2616Converter$.MODULE$.requestToRfc2616();
    }

    private char[] BoundaryChars() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/sttp/sttp/core/src/main/scala/sttp/client3/internal/ToRfc2616Converter.scala: 10");
        }
        return this.BoundaryChars;
    }

    public String apply(R request) {
        return this.apply(request, (Set<String>)HeaderNames$.MODULE$.SensitiveHeaders());
    }

    public String apply(R request, Set<String> sensitiveHeaders) {
        String extractMethod = ((Method)((RequestT)request).method()).method();
        Uri extractUri = (Uri)((RequestT)request).uri();
        String result = new StringBuilder(1).append(extractMethod).append(" ").append(extractUri).toString();
        String headers = this.extractHeaders(request, sensitiveHeaders);
        String resultWithHeaders = headers.isEmpty() ? result : new StringBuilder(1).append(result).append("\n").append(headers).toString();
        String body = this.extractBody(request);
        if (body.isEmpty()) {
            return resultWithHeaders;
        }
        return new StringBuilder(2).append(resultWithHeaders).append("\n\n").append(body).toString();
    }

    private String extractBody(R r) {
        RequestBody requestBody = ((RequestT)r).body();
        if (requestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)requestBody;
            String text = stringBody.s();
            return String.valueOf(text);
        }
        if (requestBody instanceof ByteArrayBody) {
            return "<PLACEHOLDER>";
        }
        if (requestBody instanceof ByteBufferBody) {
            return "<PLACEHOLDER>";
        }
        if (requestBody instanceof InputStreamBody) {
            return "<PLACEHOLDER>";
        }
        if (requestBody instanceof StreamBody) {
            return "<PLACEHOLDER>";
        }
        if (requestBody instanceof MultipartBody) {
            MultipartBody multipartBody = (MultipartBody)requestBody;
            scala.collection.immutable.Seq parts = multipartBody.parts();
            return this.handleMultipartBody((Seq<Part<RequestBody<?>>>)parts);
        }
        if (requestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)requestBody;
            SttpFile file = fileBody.f();
            return new StringBuilder(1).append("<").append(file.name()).toString();
        }
        if (NoBody$.MODULE$.equals(requestBody)) {
            return "";
        }
        throw new MatchError(requestBody);
    }

    public String handleMultipartBody(Seq<Part<RequestBody<?>>> parts) {
        String boundary = this.generateBoundary();
        return new StringBuilder(4).append(((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)p -> {
            RequestBody requestBody = (RequestBody)p.body();
            if (requestBody instanceof StringBody) {
                StringBody stringBody = (StringBody)requestBody;
                String s = stringBody.s();
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(93).append("--").append(boundary).append("\n               |Content-Disposition: form-data; name=\"").append(p.name()).append("\"\n               |\n               |").append(s).append("\n").toString())).stripMargin();
            }
            if (requestBody instanceof FileBody) {
                FileBody fileBody = (FileBody)requestBody;
                SttpFile f = fileBody.f();
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("--").append(boundary).append("\n               |Content-Disposition: form-data; name=\"").append(p.name()).append("\"\n               |\n               |< ").append(f.name()).append("\n").toString())).stripMargin();
            }
            return new StringBuilder(2).append("--").append(boundary).toString();
        }, scala.collection.Seq$.MODULE$.canBuildFrom())).mkString("")).append("--").append(boundary).append("--").toString();
    }

    private String extractHeaders(R r, Set<String> sensitiveHeaders) {
        return ((TraversableOnce)((TraversableLike)((RequestT)r).headers().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ToRfc2616Converter.$anonfun$extractHeaders$1(x$1)))).map((Function1 & Serializable & scala.Serializable)h -> h.toStringSafe(sensitiveHeaders), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private String generateBoundary() {
        Random$ random = Random$.MODULE$;
        return ((TraversableOnce)List$.MODULE$.fill(32, (Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> this.BoundaryChars()[random.nextInt(this.BoundaryChars().length)])).mkString();
    }

    public static final /* synthetic */ boolean $anonfun$extractHeaders$1(Header x$1) {
        return x$1.name().equalsIgnoreCase(HeaderNames$.MODULE$.AcceptEncoding());
    }
}

