/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.internal.httpclient;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sttp.capabilities.package;
import sttp.client3.ByteArrayBody;
import sttp.client3.ByteBufferBody;
import sttp.client3.FileBody;
import sttp.client3.InputStreamBody;
import sttp.client3.MultipartBody;
import sttp.client3.NoBody$;
import sttp.client3.RequestBody;
import sttp.client3.RequestT;
import sttp.client3.StreamBody;
import sttp.client3.StringBody;
import sttp.client3.internal.SttpFile;
import sttp.client3.internal.SttpToJavaConverters$;
import sttp.client3.internal.httpclient.MultiPartBodyPublisher;
import sttp.client3.internal.package$;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.Part;
import sttp.monad.MonadError;
import sttp.monad.syntax;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001C\u0007\u000f!\u0003\r\tA\u0005\f\t\u000by\u0001A\u0011\u0001\u0011\t\u000f\u0011\u0002!\u0019!D\u0001K!)\u0011\t\u0001D\u0002\u0005\")a\n\u0001C\u0001\u001f\"9\u00111\u0003\u0001\u0007\u0002\u0005U\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\b\u0003K\u0002A\u0011BA4\r\u0019\t\t\u000b\u0001\u0003\u0002$\"Q\u0011Q\u0015\u0005\u0003\u0002\u0003\u0006I!a*\t\u000f\u0005M\u0006\u0002\"\u0001\u00026\"9\u00111\u0018\u0005\u0005B\u0005u\u0006bBA^\u0011\u0011\u0005\u0013Q\u0019\u0002\u0011\u0005>$\u0017\u0010V8IiR\u00048\t\\5f]RT!a\u0004\t\u0002\u0015!$H\u000f]2mS\u0016tGO\u0003\u0002\u0012%\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0014)\u000591\r\\5f]R\u001c$\"A\u000b\u0002\tM$H\u000f]\u000b\u0004/%C4C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u00061A%\u001b8ji\u0012\u001a\u0001\u0001F\u0001\"!\tI\"%\u0003\u0002$5\t!QK\\5u\u0003\u001d\u0019HO]3b[N,\u0012A\n\t\u0004OM2dB\u0001\u00151\u001d\tIcF\u0004\u0002+[5\t1F\u0003\u0002-?\u00051AH]8pizJ\u0011!F\u0005\u0003_Q\tAbY1qC\nLG.\u001b;jKNL!!\r\u001a\u0002\u000fA\f7m[1hK*\u0011q\u0006F\u0005\u0003iU\u0012qa\u0015;sK\u0006l7O\u0003\u00022eA\u0011q\u0007\u000f\u0007\u0001\t\u0015I\u0004A1\u0001;\u0005\u0005\u0019\u0016CA\u001e?!\tIB(\u0003\u0002>5\t9aj\u001c;iS:<\u0007CA\r@\u0013\t\u0001%DA\u0002B]f\fQ!\\8oC\u0012,\u0012a\u0011\t\u0004\t\u001aCU\"A#\u000b\u0005\u0005#\u0012BA$F\u0005)iuN\\1e\u000bJ\u0014xN\u001d\t\u0003o%#QA\u0013\u0001C\u0002-\u0013\u0011AR\u000b\u0003u1#Q!T%C\u0002i\u0012\u0011aX\u0001\u0006CB\u0004H._\u000b\u0004!B\u001cH\u0003B)fkr\u00042aN%S!\t\u0019&M\u0004\u0002U?:\u0011Q\u000b\u0018\b\u0003-fs!AK,\n\u0003a\u000bAA[1wC&\u0011!lW\u0001\u0004]\u0016$(\"\u0001-\n\u0005us\u0016\u0001\u00025uiBT!AW.\n\u0005\u0001\f\u0017a\u0003%uiB\u0014V-];fgRT!!\u00180\n\u0005\r$'!\u0004\"pIf\u0004VO\u00197jg\",'O\u0003\u0002aC\")a\r\u0002a\u0001O\u00069!/Z9vKN$\b\u0003\u00025m_Jt!![6\u000f\u0005%R\u0017BA\n\u0015\u0013\t\t$#\u0003\u0002n]\n9!+Z9vKN$(BA\u0019\u0013!\t9\u0004\u000fB\u0003r\t\t\u0007!HA\u0001U!\t94\u000fB\u0003u\t\t\u0007!HA\u0001S\u0011\u00151H\u00011\u0001x\u0003\u001d\u0011W/\u001b7eKJ\u0004\"\u0001\u001f>\u000f\u0005e|V\"A1\n\u0005m$'a\u0002\"vS2$WM\u001d\u0005\u0006{\u0012\u0001\rA`\u0001\fG>tG/\u001a8u)f\u0004X\r\u0005\u0003\u001a\u007f\u0006\r\u0011bAA\u00015\t1q\n\u001d;j_:\u0004B!!\u0002\u0002\u000e9!\u0011qAA\u0005!\tQ#$C\u0002\u0002\fi\ta\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0003#\u0011aa\u0015;sS:<'bAA\u00065\u0005\t2\u000f\u001e:fC6$v\u000eU;cY&\u001c\b.\u001a:\u0015\u0007E\u000b9\u0002C\u0004\u0002\u001a\u0015\u0001\r!a\u0007\u0002\rM$(/Z1n!\u0011\ti\"!\t\u000f\u0007\u0005}!!D\u0001\u0001\u0013\r\t\u0019c\r\u0002\r\u0005&t\u0017M]=TiJ,\u0017-\\\u0001\u000e[VdG/\u001b9beR\u0014u\u000eZ=\u0016\t\u0005%\u00121\r\u000b\u0005\u0003W\t\u0019\u0004\u0005\u0003\u0002.\u0005=R\"\u0001\b\n\u0007\u0005EbB\u0001\fNk2$\u0018\u000eU1si\n{G-\u001f)vE2L7\u000f[3s\u0011\u001d\t)D\u0002a\u0001\u0003o\tQ\u0001]1siN\u0004b!!\u000f\u0002B\u0005\u001dc\u0002BA\u001e\u0003\u007fq1AKA\u001f\u0013\u0005Y\u0012BA\u0019\u001b\u0013\u0011\t\u0019%!\u0012\u0003\u0007M+\u0017O\u0003\u000225A1\u0011\u0011JA(\u0003'j!!a\u0013\u000b\u0007\u00055C#A\u0003n_\u0012,G.\u0003\u0003\u0002R\u0005-#\u0001\u0002)beR\u0004D!!\u0016\u0002`A1\u0011qKA-\u0003;j\u0011AE\u0005\u0004\u00037\u0012\"a\u0003*fcV,7\u000f\u001e\"pIf\u00042aNA0\t-\t\t'a\r\u0002\u0002\u0003\u0005)\u0011\u0001\u001e\u0003\u0007}#\u0013\u0007B\u0003r\r\t\u0007!(\u0001\u0005tkB\u0004H.[3s)\u0011\tI'a&\u0013\r\u0005-\u0014qNA>\r\u0019\tig\u0002\u0001\u0002j\taAH]3gS:,W.\u001a8u}A!\u0011\u0011OA<\u001b\t\t\u0019HC\u0002\u0002vm\u000bA\u0001\\1oO&!\u0011\u0011PA:\u0005\u0019y%M[3diB1\u0011QPAD\u0003\u0017k!!a \u000b\t\u0005\u0005\u00151Q\u0001\tMVt7\r^5p]*\u0019\u0011QQ.\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\u000byH\u0001\u0005TkB\u0004H.[3s!\u0011\ti)a%\u000e\u0005\u0005=%bAAI7\u0006\u0011\u0011n\\\u0005\u0005\u0003+\u000byIA\u0006J]B,Ho\u0015;sK\u0006l\u0007\u0002CAM\u000f\u0011\u0005\r!a'\u0002\u0003Q\u0004R!GAO\u0003\u0017K1!a(\u001b\u0005!a$-\u001f8b[\u0016t$a\u0007\"zi\u0016\u0014UO\u001a4fe\n\u000b7m[3e\u0013:\u0004X\u000f^*ue\u0016\fWnE\u0002\t\u0003\u0017\u000b1AY;g!\u0011\tI+a,\u000e\u0005\u0005-&bAAW7\u0006\u0019a.[8\n\t\u0005E\u00161\u0016\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003\u00028\u0006e\u0006cAA\u0010\u0011!9\u0011Q\u0015\u0006A\u0002\u0005\u001d\u0016\u0001\u0002:fC\u0012$\"!a0\u0011\u0007e\t\t-C\u0002\u0002Dj\u00111!\u00138u)!\ty,a2\u0002X\u0006m\u0007bBAe\u0019\u0001\u0007\u00111Z\u0001\u0006Ef$Xm\u001d\t\u00063\u00055\u0017\u0011[\u0005\u0004\u0003\u001fT\"!B!se\u0006L\bcA\r\u0002T&\u0019\u0011Q\u001b\u000e\u0003\t\tKH/\u001a\u0005\b\u00033d\u0001\u0019AA`\u0003\rygM\u001a\u0005\b\u0003;d\u0001\u0019AA`\u0003\raWM\u001c")
public interface BodyToHttpClient<F, S> {
    public package.Streams<S> streams();

    public MonadError<F> monad();

    public static /* synthetic */ Object apply$(BodyToHttpClient $this, RequestT request, HttpRequest.Builder builder, Option contentType) {
        return $this.apply(request, builder, (Option<String>)contentType);
    }

    default public <T, R> F apply(RequestT<Object, T, R> request, HttpRequest.Builder builder, Option<String> contentType) {
        RequestBody<R> requestBody = request.body();
        if (NoBody$.MODULE$.equals(requestBody)) {
            return (F)syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.noBody()), this.monad());
        }
        if (requestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)requestBody;
            String b = stringBody.s();
            return (F)syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofString(b)), this.monad());
        }
        if (requestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
            byte[] b = byteArrayBody.b();
            return (F)syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofByteArray(b)), this.monad());
        }
        if (requestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
            ByteBuffer b = byteBufferBody.b();
            if (b.hasArray()) {
                return (F)syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofByteArray(b.array(), 0, b.limit())), this.monad());
            }
            byte[] a = new byte[b.remaining()];
            b.get(a);
            return (F)syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofByteArray(a)), this.monad());
        }
        if (requestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
            InputStream b = inputStreamBody.b();
            return (F)syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofInputStream(SttpToJavaConverters$.MODULE$.toJavaSupplier((Function0 & Serializable & scala.Serializable)() -> b))), this.monad());
        }
        if (requestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)requestBody;
            SttpFile f = fileBody.f();
            return (F)syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofFile(f.toFile().toPath())), this.monad());
        }
        if (requestBody instanceof StreamBody) {
            StreamBody streamBody = (StreamBody)requestBody;
            Object s = streamBody.b();
            return this.streamToPublisher(s);
        }
        if (requestBody instanceof MultipartBody) {
            MultipartBody multipartBody = (MultipartBody)requestBody;
            scala.collection.immutable.Seq parts = multipartBody.parts();
            MultiPartBodyPublisher multipartBodyPublisher = this.multipartBody((Seq<Part<RequestBody<?>>>)parts);
            String baseContentType = (String)contentType.getOrElse((Function0 & Serializable & scala.Serializable)() -> "multipart/form-data");
            builder.header(HeaderNames$.MODULE$.ContentType(), new StringBuilder(11).append(baseContentType).append("; boundary=").append(multipartBodyPublisher.getBoundary()).toString());
            return (F)syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)multipartBodyPublisher.build()), this.monad());
        }
        throw new MatchError(requestBody);
    }

    public F streamToPublisher(Object var1);

    private <T> MultiPartBodyPublisher multipartBody(Seq<Part<RequestBody<?>>> parts) {
        MultiPartBodyPublisher multipartBuilder = new MultiPartBodyPublisher();
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Header header = Header$.MODULE$.apply(HeaderNames$.MODULE$.ContentDisposition(), p.contentDispositionHeaderValue());
            scala.collection.immutable.Seq allHeaders = (scala.collection.immutable.Seq)p.headers().$plus$colon((Object)header, Seq$.MODULE$.canBuildFrom());
            java.util.Map partHeaders = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)allHeaders.map((Function1 & Serializable & scala.Serializable)h -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)h.name()), (Object)h.value()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            boolean bl = false;
            StringBody stringBody = null;
            RequestBody requestBody = (RequestBody)p.body();
            if (NoBody$.MODULE$.equals(requestBody)) {
                return BoxedUnit.UNIT;
            }
            if (requestBody instanceof FileBody) {
                FileBody fileBody = (FileBody)requestBody;
                SttpFile f = fileBody.f();
                return multipartBuilder.addPart(p.name(), f.toFile().toPath(), (java.util.Map<String, String>)partHeaders);
            }
            if (requestBody instanceof StringBody) {
                bl = true;
                stringBody = (StringBody)requestBody;
                String b = stringBody.s();
                String e = stringBody.encoding();
                if (e.equalsIgnoreCase(package$.MODULE$.Utf8())) {
                    return multipartBuilder.addPart(p.name(), b, (java.util.Map<String, String>)partHeaders);
                }
            }
            if (bl) {
                String b = stringBody.s();
                String e = stringBody.encoding();
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> new ByteArrayInputStream(b.getBytes(e))), (java.util.Map<String, String>)partHeaders);
            }
            if (requestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
                byte[] b = byteArrayBody.b();
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> new ByteArrayInputStream(b)), (java.util.Map<String, String>)partHeaders);
            }
            if (requestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
                ByteBuffer b = byteBufferBody.b();
                if (b.isReadOnly()) {
                    return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> new ByteBufferBackedInputStream(this, b)), (java.util.Map<String, String>)partHeaders);
                }
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> new ByteArrayInputStream(b.array())), (java.util.Map<String, String>)partHeaders);
            }
            if (requestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
                InputStream b = inputStreamBody.b();
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> b), (java.util.Map<String, String>)partHeaders);
            }
            if (requestBody instanceof StreamBody) {
                throw new IllegalArgumentException("Streaming multipart bodies are not supported");
            }
            if (requestBody instanceof MultipartBody) {
                throw package$.MODULE$.throwNestedMultipartNotAllowed();
            }
            throw new MatchError((Object)requestBody);
        });
        return multipartBuilder;
    }

    private Supplier<InputStream> supplier(Function0<InputStream> t) {
        return new Supplier<InputStream>(null, t){
            private final Function0 t$1;

            public InputStream get() {
                return (InputStream)this.t$1.apply();
            }
            {
                this.t$1 = t$1;
            }
        };
    }

    public static void $init$(BodyToHttpClient $this) {
    }

    private class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;
        public final /* synthetic */ BodyToHttpClient $outer;

        @Override
        public int read() {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            int len2 = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len2);
            return len2;
        }

        public /* synthetic */ BodyToHttpClient sttp$client3$internal$httpclient$BodyToHttpClient$ByteBufferBackedInputStream$$$outer() {
            return this.$outer;
        }

        public ByteBufferBackedInputStream(BodyToHttpClient $outer, ByteBuffer buf) {
            this.buf = buf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

