/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.internal.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class MultiPartBodyPublisher {
    private List<PartsSpecification> partsSpecificationList = new ArrayList<PartsSpecification>();
    private String boundary = UUID.randomUUID().toString();

    MultiPartBodyPublisher() {
    }

    public HttpRequest.BodyPublisher build() {
        if (this.partsSpecificationList.size() == 0) {
            throw new IllegalStateException("Must have at least one part to build multipart message.");
        }
        this.addFinalBoundaryPart();
        return HttpRequest.BodyPublishers.ofByteArrays(() -> new PartsIterator());
    }

    public String getBoundary() {
        return this.boundary;
    }

    public MultiPartBodyPublisher addPart(String string, String string2, Map<String, String> map) {
        PartsSpecification partsSpecification = new PartsSpecification();
        partsSpecification.type = PartsSpecification.TYPE.STRING;
        partsSpecification.name = string;
        partsSpecification.value = string2;
        partsSpecification.headers = map;
        this.partsSpecificationList.add(partsSpecification);
        return this;
    }

    public MultiPartBodyPublisher addPart(String string, Path path, Map<String, String> map) {
        PartsSpecification partsSpecification = new PartsSpecification();
        partsSpecification.type = PartsSpecification.TYPE.FILE;
        partsSpecification.name = string;
        partsSpecification.path = path;
        partsSpecification.headers = map;
        this.partsSpecificationList.add(partsSpecification);
        return this;
    }

    public MultiPartBodyPublisher addPart(String string, Supplier<InputStream> supplier, Map<String, String> map) {
        PartsSpecification partsSpecification = new PartsSpecification();
        partsSpecification.type = PartsSpecification.TYPE.STREAM;
        partsSpecification.name = string;
        partsSpecification.stream = supplier;
        partsSpecification.headers = map;
        this.partsSpecificationList.add(partsSpecification);
        return this;
    }

    private void addFinalBoundaryPart() {
        PartsSpecification partsSpecification = new PartsSpecification();
        partsSpecification.type = PartsSpecification.TYPE.FINAL_BOUNDARY;
        partsSpecification.value = "--" + this.boundary + "--";
        this.partsSpecificationList.add(partsSpecification);
    }

    class PartsIterator
    implements Iterator<byte[]> {
        private Iterator<PartsSpecification> iter;
        private InputStream currentFileInput;
        private boolean done;
        private byte[] next;

        PartsIterator() {
            this.iter = MultiPartBodyPublisher.this.partsSpecificationList.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.done) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            try {
                this.next = this.computeNext();
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            if (this.next == null) {
                this.done = true;
                return false;
            }
            return true;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] byArray = this.next;
            this.next = null;
            return byArray;
        }

        private byte[] computeNext() throws IOException {
            if (this.currentFileInput == null) {
                Object object;
                if (!this.iter.hasNext()) {
                    return null;
                }
                PartsSpecification partsSpecification = this.iter.next();
                String string = partsSpecification.headers.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining("\r\n"));
                if (PartsSpecification.TYPE.STRING.equals((Object)partsSpecification.type)) {
                    String string2 = "--" + MultiPartBodyPublisher.this.boundary + "\r\n" + string + "\r\n\r\n" + partsSpecification.value + "\r\n";
                    return string2.getBytes(StandardCharsets.UTF_8);
                }
                if (PartsSpecification.TYPE.FINAL_BOUNDARY.equals((Object)partsSpecification.type)) {
                    return partsSpecification.value.getBytes(StandardCharsets.UTF_8);
                }
                if (PartsSpecification.TYPE.FILE.equals((Object)partsSpecification.type)) {
                    object = partsSpecification.path;
                    this.currentFileInput = Files.newInputStream((Path)object, new OpenOption[0]);
                } else {
                    this.currentFileInput = partsSpecification.stream.get();
                }
                object = "--" + MultiPartBodyPublisher.this.boundary + "\r\n" + string + "\r\n\r\n";
                return ((String)object).getBytes(StandardCharsets.UTF_8);
            }
            byte[] byArray = new byte[8192];
            int n = this.currentFileInput.read(byArray);
            if (n > 0) {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                return byArray2;
            }
            this.currentFileInput.close();
            this.currentFileInput = null;
            return "\r\n".getBytes(StandardCharsets.UTF_8);
        }
    }

    static class PartsSpecification {
        TYPE type;
        String name;
        String value;
        Path path;
        Supplier<InputStream> stream;
        Map<String, String> headers = new HashMap<String, String>();

        PartsSpecification() {
        }

        public static enum TYPE {
            STRING,
            FILE,
            STREAM,
            FINAL_BOUNDARY;

        }
    }
}

