/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.internal.httpclient;

import java.io.Serializable;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import sttp.client3.internal.httpclient.Sequencer;
import sttp.client3.internal.ws.SimpleQueue;
import sttp.client3.internal.ws.WebSocketEvent;
import sttp.model.Headers;
import sttp.monad.Canceler;
import sttp.monad.MonadAsyncError;
import sttp.monad.MonadError;
import sttp.monad.syntax;
import sttp.monad.syntax$;
import sttp.ws.WebSocketClosed;
import sttp.ws.WebSocketFrame;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!\u0002\b\u0010\u0001M9\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"A\u0001\f\u0001B\u0001B\u0003%\u0011\fC\u0003^\u0001\u0011\u0005a\fC\u0003f\u0001\u0011\u0005c\rC\u0003l\u0001\u0011\u0005C\u000eC\u0004y\u0001E\u0005I\u0011A=\t\u0015\u0005%\u0001\u0001#b\u0001\n\u0003\nY\u0001C\u0004\u0002\u001a\u0001!\t%a\u0007\t\rU\u0003A1IA\u0010\u0011\u001d\t9\u0003\u0001C\u0005\u0003S\u0011QbV3c'>\u001c7.\u001a;J[Bd'B\u0001\t\u0012\u0003)AG\u000f\u001e9dY&,g\u000e\u001e\u0006\u0003%M\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003)U\tqa\u00197jK:$8GC\u0001\u0017\u0003\u0011\u0019H\u000f\u001e9\u0016\u0005a93c\u0001\u0001\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u00042\u0001I\u0012&\u001b\u0005\t#B\u0001\u0012\u0016\u0003\t98/\u0003\u0002%C\tIq+\u001a2T_\u000e\\W\r\u001e\t\u0003M\u001db\u0001\u0001B\u0003)\u0001\t\u0007!FA\u0001G\u0007\u0001)\"a\u000b\u001a\u0012\u00051z\u0003C\u0001\u000e.\u0013\tq3DA\u0004O_RD\u0017N\\4\u0011\u0005i\u0001\u0014BA\u0019\u001c\u0005\r\te.\u001f\u0003\u0006g\u001d\u0012\ra\u000b\u0002\u0002?B\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\u0005QR$\bO\u0003\u0002:u\u0005\u0019a.\u001a;\u000b\u0003m\nAA[1wC&\u0011AEN\u0001\u0006cV,W/\u001a\t\u0005\u007f\u0005+3)D\u0001A\u0015\t\u0011\u0013#\u0003\u0002C\u0001\nY1+[7qY\u0016\fV/Z;f!\tyD)\u0003\u0002F\u0001\nqq+\u001a2T_\u000e\\W\r^#wK:$\u0018aB0jg>\u0003XM\u001c\t\u0003\u0011>k\u0011!\u0013\u0006\u0003\u0015.\u000ba!\u0019;p[&\u001c'B\u0001'N\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u001dj\nA!\u001e;jY&\u0011\u0001+\u0013\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\r}kwN\\1e!\r\u0019f+J\u0007\u0002)*\u0011Q+F\u0001\u0006[>t\u0017\rZ\u0005\u0003/R\u0013q\"T8oC\u0012\f5/\u001f8d\u000bJ\u0014xN]\u0001\ng\u0016\fX/\u001a8dKJ\u00042AW.&\u001b\u0005y\u0011B\u0001/\u0010\u0005%\u0019V-];f]\u000e,'/\u0001\u0004=S:LGO\u0010\u000b\u0007?\u0002\f'm\u00193\u0011\u0007i\u0003Q\u0005C\u0003#\r\u0001\u0007A\u0007C\u0003>\r\u0001\u0007a\bC\u0003G\r\u0001\u0007q\tC\u0003R\r\u0001\u0007!\u000bC\u0003Y\r\u0001\u0007\u0011,A\u0004sK\u000e,\u0017N^3\u0015\u0003\u001d\u00042AJ\u0014i!\t\u0001\u0013.\u0003\u0002kC\tqq+\u001a2T_\u000e\\W\r\u001e$sC6,\u0017\u0001B:f]\u0012$2!\\9t!\r1sE\u001c\t\u00035=L!\u0001]\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006e\"\u0001\r\u0001[\u0001\u0002M\"9A\u000f\u0003I\u0001\u0002\u0004)\u0018AD5t\u0007>tG/\u001b8vCRLwN\u001c\t\u00035YL!a^\u000e\u0003\u000f\t{w\u000e\\3b]\u0006q1/\u001a8eI\u0011,g-Y;mi\u0012\u0012T#\u0001>+\u0005U\\8&\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0001\u001c\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u000fq(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006qQ\u000f]4sC\u0012,\u0007*Z1eKJ\u001cXCAA\u0007!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n+\u0005)Qn\u001c3fY&!\u0011qCA\t\u0005\u001dAU-\u00193feN\fa![:Pa\u0016tGCAA\u000f!\r1s%^\u000b\u0003\u0003C\u0001BaUA\u0012K%\u0019\u0011Q\u0005+\u0003\u00155{g.\u00193FeJ|'/A\u000bge>l7i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0015\u00075\fY\u0003C\u0004\u0002.5\u0001\r!a\f\u0002\u0005\r4\u0007#BA\u0019\u0003g!T\"A&\n\u0007\u0005U2JA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004")
public class WebSocketImpl<F>
implements sttp.ws.WebSocket<F> {
    private Headers upgradeHeaders;
    private final WebSocket ws;
    private final SimpleQueue<F, WebSocketEvent> queue;
    private final AtomicBoolean _isOpen;
    private final MonadAsyncError<F> _monad;
    private final Sequencer<F> sequencer;
    private volatile boolean bitmap$0;

    public F receiveDataFrame(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveDataFrame$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveDataFrame$default$1() {
        return sttp.ws.WebSocket.receiveDataFrame$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveTextFrame(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveTextFrame$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveTextFrame$default$1() {
        return sttp.ws.WebSocket.receiveTextFrame$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveBinaryFrame(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveBinaryFrame$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveBinaryFrame$default$1() {
        return sttp.ws.WebSocket.receiveBinaryFrame$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveText(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveText$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveText$default$1() {
        return sttp.ws.WebSocket.receiveText$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveBinary(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveBinary$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public <T> F eitherClose(Function0<F> f) {
        return (F)sttp.ws.WebSocket.eitherClose$((sttp.ws.WebSocket)this, f);
    }

    public <T> F either(Function0<F> f) {
        return (F)sttp.ws.WebSocket.either$((sttp.ws.WebSocket)this, f);
    }

    public F sendText(String payload) {
        return (F)sttp.ws.WebSocket.sendText$((sttp.ws.WebSocket)this, (String)payload);
    }

    public F sendBinary(byte[] payload) {
        return (F)sttp.ws.WebSocket.sendBinary$((sttp.ws.WebSocket)this, (byte[])payload);
    }

    public F close() {
        return (F)sttp.ws.WebSocket.close$((sttp.ws.WebSocket)this);
    }

    public F receive() {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> $this.queue.poll()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WebSocketFrame f;
            boolean bl = false;
            WebSocketEvent.Frame frame = null;
            boolean bl2 = false;
            WebSocketEvent.Error error = null;
            WebSocketEvent webSocketEvent = x0$1;
            if (webSocketEvent instanceof WebSocketEvent.Open) {
                return this.receive();
            }
            if (webSocketEvent instanceof WebSocketEvent.Frame) {
                bl = true;
                frame = (WebSocketEvent.Frame)webSocketEvent;
                WebSocketFrame c = frame.f();
                if (c instanceof WebSocketFrame.Close) {
                    WebSocketFrame.Close close = (WebSocketFrame.Close)c;
                    $this.queue.offer(new WebSocketEvent.Error((Throwable)new WebSocketClosed((Option)new Some((Object)close))));
                    return this.monad().unit((Object)close);
                }
            }
            if (webSocketEvent instanceof WebSocketEvent.Error) {
                bl2 = true;
                error = (WebSocketEvent.Error)webSocketEvent;
                Throwable t = error.t();
                if (t instanceof Exception) {
                    Exception exception = (Exception)t;
                    $this.queue.offer(error);
                    return this.monad().error((Throwable)exception);
                }
            }
            if (bl2) {
                Throwable t = error.t();
                throw t;
            }
            if (bl && (f = frame.f()) != null) {
                WebSocketFrame webSocketFrame = f;
                return this.monad().eval((Function0 & Serializable & scala.Serializable)() -> {
                    $this.ws.request(1L);
                    return webSocketFrame;
                });
            }
            throw new MatchError((Object)webSocketEvent);
        }, this.monad());
    }

    public F send(WebSocketFrame f, boolean isContinuation) {
        return this.sequencer.apply((Function0 & Serializable & scala.Serializable)() -> this.monad().flatten(this.monad().eval((Function0 & Serializable & scala.Serializable)() -> {
            WebSocketFrame webSocketFrame = f;
            if (webSocketFrame instanceof WebSocketFrame.Text) {
                WebSocketFrame.Text text = (WebSocketFrame.Text)webSocketFrame;
                String payload = text.payload();
                boolean finalFragment = text.finalFragment();
                return this.fromCompletableFuture($this.ws.sendText(payload, finalFragment));
            }
            if (webSocketFrame instanceof WebSocketFrame.Binary) {
                WebSocketFrame.Binary binary = (WebSocketFrame.Binary)webSocketFrame;
                byte[] payload = binary.payload();
                boolean finalFragment = binary.finalFragment();
                return this.fromCompletableFuture($this.ws.sendBinary(ByteBuffer.wrap(payload), finalFragment));
            }
            if (webSocketFrame instanceof WebSocketFrame.Ping) {
                WebSocketFrame.Ping ping = (WebSocketFrame.Ping)webSocketFrame;
                byte[] payload = ping.payload();
                return this.fromCompletableFuture($this.ws.sendPing(ByteBuffer.wrap(payload)));
            }
            if (webSocketFrame instanceof WebSocketFrame.Pong) {
                WebSocketFrame.Pong pong = (WebSocketFrame.Pong)webSocketFrame;
                byte[] payload = pong.payload();
                return this.fromCompletableFuture($this.ws.sendPong(ByteBuffer.wrap(payload)));
            }
            if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close close = (WebSocketFrame.Close)webSocketFrame;
                int statusCode = close.statusCode();
                String reasonText = close.reasonText();
                boolean wasOpen = $this._isOpen.getAndSet(false);
                if (wasOpen) {
                    return this.fromCompletableFuture($this.ws.sendClose(statusCode, reasonText));
                }
                return syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)BoxedUnit.UNIT), this.monad());
            }
            throw new MatchError((Object)webSocketFrame);
        })));
    }

    public boolean send$default$2() {
        return false;
    }

    private Headers upgradeHeaders$lzycompute() {
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (!this.bitmap$0) {
                this.upgradeHeaders = new Headers((Seq)Nil$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.upgradeHeaders;
    }

    public Headers upgradeHeaders() {
        if (!this.bitmap$0) {
            return this.upgradeHeaders$lzycompute();
        }
        return this.upgradeHeaders;
    }

    public F isOpen() {
        return (F)this.monad().eval((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this._isOpen.get());
    }

    public MonadError<F> monad() {
        return this._monad;
    }

    private F fromCompletableFuture(CompletableFuture<WebSocket> cf) {
        return (F)this._monad.async((Function1 & Serializable & scala.Serializable)cb -> {
            cf.whenComplete((BiConsumer)new BiConsumer<WebSocket, Throwable>(null, cb){
                private final Function1 cb$1;

                public BiConsumer<WebSocket, Throwable> andThen(BiConsumer<? super WebSocket, ? super Throwable> x$1) {
                    return BiConsumer.super.andThen(x$1);
                }

                public void accept(WebSocket t, Throwable error) {
                    if (error != null) {
                        this.cb$1.apply((Object)package$.MODULE$.Left().apply((Object)error));
                        return;
                    }
                    this.cb$1.apply((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                }
                {
                    this.cb$1 = cb$1;
                }
            });
            return new Canceler((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cf.cancel(true));
        });
    }

    public WebSocketImpl(WebSocket ws, SimpleQueue<F, WebSocketEvent> queue, AtomicBoolean _isOpen, MonadAsyncError<F> _monad, Sequencer<F> sequencer) {
        this.ws = ws;
        this.queue = queue;
        this._isOpen = _isOpen;
        this._monad = _monad;
        this.sequencer = sequencer;
        sttp.ws.WebSocket.$init$((sttp.ws.WebSocket)this);
    }
}

