/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.logging;

import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.listener.RequestListener;
import sttp.client3.logging.Log;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001\u0002\u0006\f\u0001IA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\b\u0001B\u0001B\u0003-a\bC\u0003E\u0001\u0011\u0005Q\tC\u0003L\u0001\u0011%A\nC\u0003N\u0001\u0011%a\nC\u0003[\u0001\u0011\u00053\fC\u0003u\u0001\u0011\u0005S\u000fC\u0004\u0002 \u0001!\t%!\t\u0003\u001f1{wmZ5oO2K7\u000f^3oKJT!\u0001D\u0007\u0002\u000f1|wmZ5oO*\u0011abD\u0001\bG2LWM\u001c;4\u0015\u0005\u0001\u0012\u0001B:uiB\u001c\u0001!\u0006\u0002\u0014EM\u0019\u0001\u0001\u0006\u000e\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\u0011Yb\u0004\t\u0018\u000e\u0003qQ!!H\u0007\u0002\u00111L7\u000f^3oKJL!a\b\u000f\u0003\u001fI+\u0017/^3ti2K7\u000f^3oKJ\u0004\"!\t\u0012\r\u0001\u0011)1\u0005\u0001b\u0001I\t\ta)\u0006\u0002&YE\u0011a%\u000b\t\u0003+\u001dJ!\u0001\u000b\f\u0003\u000f9{G\u000f[5oOB\u0011QCK\u0005\u0003WY\u00111!\u00118z\t\u0015i#E1\u0001&\u0005\u0005y\u0006cA\u000b0c%\u0011\u0001G\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005U\u0011\u0014BA\u001a\u0017\u0005\u0011auN\\4\u0002\u00071|w\rE\u00027o\u0001j\u0011aC\u0005\u0003q-\u00111\u0001T8h\u00035Ign\u00197vI\u0016$\u0016.\\5oOB\u0011QcO\u0005\u0003yY\u0011qAQ8pY\u0016\fg.A\u0001n!\ry$\tI\u0007\u0002\u0001*\u0011\u0011iD\u0001\u0006[>t\u0017\rZ\u0005\u0003\u0007\u0002\u0013!\"T8oC\u0012,%O]8s\u0003\u0019a\u0014N\\5u}Q\u0019a)\u0013&\u0015\u0005\u001dC\u0005c\u0001\u001c\u0001A!)Q\b\u0002a\u0002}!)A\u0007\u0002a\u0001k!)\u0011\b\u0002a\u0001u\u0005\u0019an\\<\u0015\u0003E\nq!\u001a7baN,G\r\u0006\u0002P1B\u0019Qc\f)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005U3\u0012AC2p]\u000e,(O]3oi&\u0011qK\u0015\u0002\t\tV\u0014\u0018\r^5p]\")\u0011L\u0002a\u0001]\u0005!aM]8n\u00035\u0011WMZ8sKJ+\u0017/^3tiR\u0011A,\u0018\t\u0004C\tr\u0003\"\u00020\b\u0001\u0004y\u0016a\u0002:fcV,7\u000f\u001e\u0019\u0004A>\u0014\b\u0003B1l]Ft!AY5\u000f\u0005\rDgB\u00013h\u001b\u0005)'B\u00014\u0012\u0003\u0019a$o\\8u}%\t\u0001#\u0003\u0002\u000f\u001f%\u0011!.D\u0001\ba\u0006\u001c7.Y4f\u0013\taWNA\u0004SKF,Xm\u001d;\u000b\u0005)l\u0001CA\u0011p\t%\u0001X,!A\u0001\u0002\u000b\u0005QEA\u0002`IE\u0002\"!\t:\u0005\u0013Ml\u0016\u0011!A\u0001\u0006\u0003)#aA0%e\u0005\u0001\"/Z9vKN$X\t_2faRLwN\u001c\u000b\u0007mj\f9!a\u0003\u0011\u0007\u0005\u0012s\u000f\u0005\u0002\u0016q&\u0011\u0011P\u0006\u0002\u0005+:LG\u000fC\u0003_\u0011\u0001\u00071\u0010\r\u0003}}\u0006\r\u0001#B1l{\u0006\u0005\u0001CA\u0011\u007f\t%y(0!A\u0001\u0002\u000b\u0005QEA\u0002`IM\u00022!IA\u0002\t)\t)A_A\u0001\u0002\u0003\u0015\t!\n\u0002\u0004?\u0012\"\u0004BBA\u0005\u0011\u0001\u0007a&A\u0002uC\u001eDq!!\u0004\t\u0001\u0004\ty!A\u0001f!\u0011\t\t\"!\u0007\u000f\t\u0005M\u0011q\u0003\b\u0004I\u0006U\u0011\"A\f\n\u0005)4\u0012\u0002BA\u000e\u0003;\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0005)4\u0012!\u0005:fcV,7\u000f^*vG\u000e,7o\u001d4vYR9a/a\t\u00026\u0005%\u0003B\u00020\n\u0001\u0004\t)\u0003\r\u0004\u0002(\u0005-\u0012\u0011\u0007\t\u0007C.\fI#a\f\u0011\u0007\u0005\nY\u0003B\u0006\u0002.\u0005\r\u0012\u0011!A\u0001\u0006\u0003)#aA0%kA\u0019\u0011%!\r\u0005\u0017\u0005M\u00121EA\u0001\u0002\u0003\u0015\t!\n\u0002\u0004?\u00122\u0004bBA\u001c\u0013\u0001\u0007\u0011\u0011H\u0001\te\u0016\u001c\bo\u001c8tKB\"\u00111HA#!\u0019\ti$a\u0010\u0002D5\tQ\"C\u0002\u0002B5\u0011\u0001BU3ta>t7/\u001a\t\u0004C\u0005\u0015CaCA$\u0003k\t\t\u0011!A\u0003\u0002\u0015\u00121a\u0018\u00138\u0011\u0019\tI!\u0003a\u0001]\u0001")
public class LoggingListener<F>
implements RequestListener<F, Option<Object>> {
    private final Log<F> log;
    private final boolean includeTiming;
    private final MonadError<F> m;

    private long now() {
        return System.currentTimeMillis();
    }

    private Option<Duration> elapsed(Option<Object> from) {
        return from.map((Function1 & java.io.Serializable & Serializable)f -> Duration$.MODULE$.apply(this.now() - BoxesRunTime.unboxToLong((Object)f), TimeUnit.MILLISECONDS));
    }

    @Override
    public F beforeRequest(RequestT<Object, ?, ?> request) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & java.io.Serializable & Serializable)() -> $this.log.beforeRequestSend(request)).map((Function1 & java.io.Serializable & Serializable)x$1 -> {
            if ($this.includeTiming) {
                return new Some((Object)BoxesRunTime.boxToLong((long)this.now()));
            }
            return None$.MODULE$;
        }, this.m);
    }

    @Override
    public F requestException(RequestT<Object, ?, ?> request, Option<Object> tag, Exception e) {
        return this.log.requestException(request, this.elapsed(tag), e);
    }

    @Override
    public F requestSuccessful(RequestT<Object, ?, ?> request, Response<?> response, Option<Object> tag) {
        return this.log.response(request, response, (Option<String>)None$.MODULE$, this.elapsed(tag));
    }

    public LoggingListener(Log<F> log, boolean includeTiming, MonadError<F> m) {
        this.log = log;
        this.includeTiming = includeTiming;
        this.m = m;
    }
}

