/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3;

import java.io.Serializable;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import sttp.capabilities.package;
import sttp.client3.MultipartBody;
import sttp.client3.RequestBody;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.SttpBackend;
import sttp.client3.SttpBackendOptions;
import sttp.client3.internal.httpclient.BodyFromHttpClient;
import sttp.client3.internal.httpclient.BodyToHttpClient;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.HttpVersion;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.ResponseMetadata;
import sttp.model.ResponseMetadata$;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.model.Uri;
import sttp.monad.MonadError;
import sttp.monad.syntax$;
import sttp.ws.WebSocket;

@ScalaSignature(bytes="\u0006\u0001\tEb!B\r\u001b\u0003\u0003y\u0002\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u00071\u0002!\t!!\u000f\t\u0013\u0005%\u0003A1A\u0007\u0002\u0005-SABA2\u0001\u0001\t)\u0007C\u0004\u0002r\u00011\t\"a\u001d\t\u000f\u0005\u0015\u0005A\"\u0005\u0002\b\"A\u0011q\u0012\u0001\u0005\u0002i\t\t\nC\u0005\u0002@\u0002\u0011\r\u0011b\u0003\u0002B\"A\u0011Q\u001a\u0001!\u0002\u0013\t\u0019\r\u0003\u0005\u0002P\u0002!\tAGAi\u0011\u001d\u0011Y\u0002\u0001D\t\u0005;AqA!\n\u0001\t\u0003\u00129cB\u0003V5!\u0005aKB\u0003\u001a5!\u0005q\u000bC\u0003Y!\u0011\u0005\u0011,\u0002\u0003[!\u0001Yf\u0001B7\u0011\t9D\u0001b]\n\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\u00061N!\ta\u001f\u0005\u0007\u007fN!\t%!\u0001\t\u0011\u0005%\u0001\u0003\"\u0001\u001b\u0003\u0017A\u0001\"!\u0003\u0011\t\u0003Q\u0012q\u0003\u0002\u0012\u0011R$\bo\u00117jK:$()Y2lK:$'BA\u000e\u001d\u0003\u001d\u0019G.[3oiNR\u0011!H\u0001\u0005gR$\bo\u0001\u0001\u0016\u000f\u0001j\u0013q\b\u001e\u00028M\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\u0011A\u0013fK\u001d\u000e\u0003iI!A\u000b\u000e\u0003\u0017M#H\u000f\u001d\"bG.,g\u000e\u001a\t\u0003Y5b\u0001\u0001B\u0003/\u0001\t\u0007qFA\u0001G+\t\u0001t'\u0005\u00022iA\u0011!EM\u0005\u0003g\r\u0012qAT8uQ&tw\r\u0005\u0002#k%\u0011ag\t\u0002\u0004\u0003:LH!\u0002\u001d.\u0005\u0004\u0001$!A0\u0011\u00051RD!B\u001e\u0001\u0005\u0004\u0001$!\u0001)\u0002\r\rd\u0017.\u001a8u!\tqT)D\u0001@\u0015\t\u0001\u0015)\u0001\u0003iiR\u0004(B\u0001\"D\u0003\rqW\r\u001e\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1uH\u0001\u0006IiR\u00048\t\\5f]R\f1b\u00197pg\u0016\u001cE.[3oiB\u0011!%S\u0005\u0003\u0015\u000e\u0012qAQ8pY\u0016\fg.A\u000bdkN$x.\\#oG>$\u0017N\\4IC:$G.\u001a:\u0011\t5\u0013\u0012Q\u0007\b\u0003\u001d>q!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005Is\u0012A\u0002\u001fs_>$h(C\u0001\u001e\u0013\tYB$A\tIiR\u00048\t\\5f]R\u0014\u0015mY6f]\u0012\u0004\"\u0001\u000b\t\u0014\u0005A\t\u0013A\u0002\u001fj]&$h\bF\u0001W\u0005=)enY8eS:<\u0007*\u00198eY\u0016\u0014XC\u0001/d!\u0011\u0011Sl\u00182\n\u0005y\u001b#a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\u0011\t\t\u0002'-Z\u0005\u0003C\u000e\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u0017d\t\u0015!'C1\u00011\u0005\u0005\u0011\u0005C\u00014k\u001d\t9\u0007\u000e\u0005\u0002QG%\u0011\u0011nI\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002jG\t\u0011\u0002K]8ys\u0006+H\u000f[3oi&\u001c\u0017\r^8s'\t\u0019r\u000e\u0005\u0002qc6\t\u0011)\u0003\u0002s\u0003\ni\u0011)\u001e;iK:$\u0018nY1u_J\fA!Y;uQB\u0011Q\u000f\u001f\b\u0003QYL!a\u001e\u000e\u0002%M#H\u000f\u001d\"bG.,g\u000eZ(qi&|gn]\u0005\u0003sj\u0014\u0011\u0002\u0015:pqf\fU\u000f\u001e5\u000b\u0005]TBC\u0001?\u007f!\ti8#D\u0001\u0011\u0011\u0015\u0019X\u00031\u0001u\u0003e9W\r\u001e)bgN<xN\u001d3BkRDWM\u001c;jG\u0006$\u0018n\u001c8\u0015\u0005\u0005\r\u0001c\u00019\u0002\u0006%\u0019\u0011qA!\u0003-A\u000b7o]<pe\u0012\fU\u000f\u001e5f]RL7-\u0019;j_:\fQ\u0002Z3gCVdGo\u00117jK:$HcA\u001f\u0002\u000e!9\u0011qB\fA\u0002\u0005E\u0011aB8qi&|gn\u001d\t\u0004Q\u0005M\u0011bAA\u000b5\t\u00112\u000b\u001e;q\u0005\u0006\u001c7.\u001a8e\u001fB$\u0018n\u001c8t)\u0015i\u0014\u0011DA\u000e\u0011\u001d\ty\u0001\u0007a\u0001\u0003#Aq!!\b\u0019\u0001\u0004\ty\"\u0001\u0005fq\u0016\u001cW\u000f^8s!\u0015\u0011\u0013\u0011EA\u0013\u0013\r\t\u0019c\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005=2)\u0001\u0003vi&d\u0017\u0002BA\u001a\u0003S\u0011\u0001\"\u0012=fGV$xN\u001d\t\u0004Y\u0005]B!\u00023\u0001\u0005\u0004\u0001D\u0003CA\u001e\u0003\u0007\n)%a\u0012\u0011\u0011!\u00021&!\u0010:\u0003k\u00012\u0001LA \t\u0019\t\t\u0005\u0001b\u0001a\t\t1\u000bC\u0003=\t\u0001\u0007Q\bC\u0003H\t\u0001\u0007\u0001\nC\u0003L\t\u0001\u0007A*A\u0004tiJ,\u0017-\\:\u0016\u0005\u00055\u0003CBA(\u0003;\niD\u0004\u0003\u0002R\u0005]cbA(\u0002T%\u0019\u0011Q\u000b\u000f\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\n\t\u0005e\u00131L\u0001\ba\u0006\u001c7.Y4f\u0015\r\t)\u0006H\u0005\u0005\u0003?\n\tGA\u0004TiJ,\u0017-\\:\u000b\t\u0005e\u00131\f\u0002\u0003!\u0016\u0013R!a\u001a:\u0003W2a!!\u001b\u0001\u0001\u0005\u0015$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004#BA(\u0003[Z\u0013\u0002BA8\u0003C\u0012a!\u00124gK\u000e$\u0018\u0001\u00052pIf$v\u000e\u0013;ua\u000ec\u0017.\u001a8u+\t\t)\bE\u0004\u0002x\u0005\u00055&!\u0010\u000e\u0005\u0005e$\u0002BA>\u0003{\n!\u0002\u001b;ua\u000ed\u0017.\u001a8u\u0015\r\tyHG\u0001\tS:$XM\u001d8bY&!\u00111QA=\u0005A\u0011u\u000eZ=U_\"#H\u000f]\"mS\u0016tG/\u0001\nc_\u0012LhI]8n\u0011R$\bo\u00117jK:$XCAAE!%\t9(a#,\u0003{\t)$\u0003\u0003\u0002\u000e\u0006e$A\u0005\"pIf4%o\\7IiR\u00048\t\\5f]R\fabY8om\u0016\u0014HOU3rk\u0016\u001cH/\u0006\u0004\u0002\u0014\u0006=\u0016Q\u0017\u000b\u0005\u0003+\u000bi\n\u0005\u0003-[\u0005]\u0005c\u0001 \u0002\u001a&\u0019\u00111T \u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e\u0005\b\u0003?K\u0001\u0019AAQ\u0003\u001d\u0011X-];fgR\u0004\u0002\"a)\u0002(\u00065\u00161\u0017\b\u0004Q\u0005\u0015\u0016bAA-5%!\u0011\u0011VAV\u0005\u001d\u0011V-];fgRT1!!\u0017\u001b!\ra\u0013q\u0016\u0003\u0007\u0003cK!\u0019\u0001\u0019\u0003\u0003Q\u00032\u0001LA[\t\u001d\t9,\u0003b\u0001\u0003s\u0013\u0011AU\t\u0004\u0003w#\u0004cAA_\r5\t\u0001!A\u0003n_:\fG-\u0006\u0002\u0002DB)\u0011QYAeW5\u0011\u0011q\u0019\u0006\u0004\u0003\u007fc\u0012\u0002BAf\u0003\u000f\u0014!\"T8oC\u0012,%O]8s\u0003\u0019iwN\\1eA\u0005a!/Z1e%\u0016\u001c\bo\u001c8tKV1\u00111[Ap\u00053!\u0002\"!6\u0002b\u0006M(1\u0003\t\u0005Y5\n9\u000eE\u0003)\u00033\fi.C\u0002\u0002\\j\u0011\u0001BU3ta>t7/\u001a\t\u0004Y\u0005}GABAY\u0019\t\u0007\u0001\u0007C\u0004\u0002d2\u0001\r!!:\u0002\u0007I,7\u000f\r\u0003\u0002h\u0006=\b#\u0002 \u0002j\u00065\u0018bAAv\u007f\ta\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tKB\u0019A&a<\u0005\u0017\u0005E\u0018\u0011]A\u0001\u0002\u0003\u0015\t\u0001\r\u0002\u0004?\u0012\n\u0004bBA{\u0019\u0001\u0007\u0011q_\u0001\be\u0016\u001c(i\u001c3z!!\tIP!\u0001\u00026\t\u001da\u0002BA~\u0003\u007ft1\u0001UA\u007f\u0013\u0005!\u0013bAA-G%!!1\u0001B\u0003\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011\u0011L\u0012\u0011\u000b\t%!qB\u0016\u000e\u0005\t-!b\u0001B\u00079\u0005\u0011qo]\u0005\u0005\u0005#\u0011YAA\u0005XK\n\u001cvnY6fi\"9\u0011q\u0014\u0007A\u0002\tU\u0001\u0003CAR\u0003O\u000biNa\u0006\u0011\u00071\u0012I\u0002B\u0004\u000282\u0011\r!!/\u0002!M$\u0018M\u001c3be\u0012,enY8eS:<WC\u0001B\u0010!!\u0011#\u0011EA\u001bK\u0006U\u0012b\u0001B\u0012G\tIa)\u001e8di&|gNM\u0001\u0006G2|7/\u001a\u000b\u0003\u0005S\u0001B\u0001L\u0017\u0003,A\u0019!E!\f\n\u0007\t=2E\u0001\u0003V]&$\b")
public abstract class HttpClientBackend<F, S, P, B>
implements SttpBackend<F, P> {
    private final HttpClient client;
    private final boolean closeClient;
    private final PartialFunction<Tuple2<B, String>, B> customEncodingHandler;
    private final MonadError<F> monad;

    public abstract package.Streams<S> streams();

    public abstract BodyToHttpClient<F, S> bodyToHttpClient();

    public abstract BodyFromHttpClient<F, S, B> bodyFromHttpClient();

    public <T, R> F convertRequest(RequestT<Object, T, R> request) {
        return (F)this.monad().suspend((Function0 & Serializable & scala.Serializable)() -> {
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(((Uri)request.uri()).toJavaUri());
            request.httpVersion().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                HttpVersion httpVersion = x0$1;
                if (HttpVersion.HTTP_1_1$.MODULE$.equals(httpVersion)) {
                    return builder.version(HttpClient.Version.HTTP_1_1);
                }
                if (HttpVersion.HTTP_2$.MODULE$.equals(httpVersion)) {
                    return builder.version(HttpClient.Version.HTTP_2);
                }
                return BoxedUnit.UNIT;
            });
            Option contentType = request.headers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.is(HeaderNames$.MODULE$.ContentType()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value());
            contentType.foreach((Function1 & Serializable & scala.Serializable)ct -> {
                RequestBody requestBody = request.body();
                if (requestBody instanceof MultipartBody) {
                    return BoxedUnit.UNIT;
                }
                return builder.header(HeaderNames$.MODULE$.ContentType(), (String)ct);
            });
            return syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> this.bodyToHttpClient().apply(request, builder, (Option<String>)contentType)).map((Function1 & Serializable & scala.Serializable)httpBody -> {
                builder.method(((Method)request.method()).method(), (HttpRequest.BodyPublisher)httpBody);
                ((IterableLike)request.headers().filterNot((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)HttpClientBackend.$anonfun$convertRequest$8(h)))).foreach((Function1 & Serializable & scala.Serializable)h -> builder.header(h.name(), h.value()));
                Duration timeout = request.options().readTimeout();
                if (timeout.isFinite()) {
                    return builder.timeout(java.time.Duration.ofMillis(timeout.toMillis())).build();
                }
                return builder.build();
            }, this.monad());
        });
    }

    private MonadError<F> monad() {
        return this.monad;
    }

    public <T, R> F readResponse(HttpResponse<?> res, Either<B, WebSocket<F>> resBody, RequestT<Object, T, R> request) {
        String method;
        Map headersMap = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(res.headers().map()).asScala();
        List headers = ((TraversableOnce)headersMap.keySet().flatMap((Function1 & Serializable & scala.Serializable)name -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)headersMap.apply(name)).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> Header$.MODULE$.apply(name, x$3), Buffer$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom())).toList();
        int code = StatusCode$.MODULE$.apply(res.statusCode());
        ResponseMetadata responseMetadata = ResponseMetadata$.MODULE$.apply(code, "", (Seq)headers);
        Option encoding = headers.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Header, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.is(HeaderNames$.MODULE$.ContentEncoding())) {
                    return (B1)A1.value();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Header x1) {
                Header header = x1;
                return header.is(HeaderNames$.MODULE$.ContentEncoding());
            }
        });
        String string = method = res.request().method();
        String string2 = Method$.MODULE$.HEAD();
        Either decodedResBody = (string == null ? string2 != null : !string.equals(string2)) ? resBody.left().map((Function1 & Serializable & scala.Serializable)is -> encoding.filterNot((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)HttpClientBackend.$anonfun$readResponse$4(code, request, e))).map((Function1 & Serializable & scala.Serializable)e -> $this.customEncodingHandler.applyOrElse((Object)new Tuple2(is, e), this.standardEncoding().tupled())).getOrElse((Function0 & Serializable & scala.Serializable)() -> is)) : resBody;
        F body = this.bodyFromHttpClient().apply(decodedResBody, request.response(), responseMetadata);
        return (F)this.responseMonad().map(body, (Function1 & Serializable & scala.Serializable)x$4 -> new Response<Object>(x$4, code, "", (Seq<Header>)headers, (List<Response<BoxedUnit>>)Nil$.MODULE$, request.onlyMetadata(Predef.$eq$colon$eq$.MODULE$.tpEquals())));
    }

    public abstract Function2<B, String, B> standardEncoding();

    @Override
    public F close() {
        if (this.closeClient) {
            return (F)this.responseMonad().eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client.executor().map(new Function<Executor, BoxedUnit>(null){

                public <V> Function<V, BoxedUnit> compose(Function<? super V, ? extends Executor> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Executor, V> andThen(Function<? super BoxedUnit, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public void apply(Executor t) {
                    Executor executor = t;
                    if (executor instanceof ThreadPoolExecutor) {
                        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                        threadPoolExecutor.shutdown();
                        return;
                    }
                }
            }));
        }
        return (F)this.responseMonad().unit((Object)BoxedUnit.UNIT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$convertRequest$8(Header h) {
        String string = h.name();
        String string2 = HeaderNames$.MODULE$.ContentLength();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = h.name();
        String string4 = HeaderNames$.MODULE$.ContentType();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$readResponse$4(int code$1, RequestT request$2, String e) {
        return StatusCode$.MODULE$.equals$extension(code$1, (Object)new StatusCode(StatusCode$.MODULE$.NoContent())) || request$2.autoDecompressionDisabled() || e.isEmpty();
    }

    public HttpClientBackend(HttpClient client, boolean closeClient, PartialFunction<Tuple2<B, String>, B> customEncodingHandler) {
        this.client = client;
        this.closeClient = closeClient;
        this.customEncodingHandler = customEncodingHandler;
        this.monad = this.responseMonad();
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private final SttpBackendOptions.ProxyAuth auth;

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.auth.username(), this.auth.password().toCharArray());
        }

        public ProxyAuthenticator(SttpBackendOptions.ProxyAuth auth) {
            this.auth = auth;
        }
    }
}

