/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.internal.httpclient;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sttp.capabilities.package;
import sttp.client3.ByteArrayBody;
import sttp.client3.ByteBufferBody;
import sttp.client3.FileBody;
import sttp.client3.InputStreamBody;
import sttp.client3.MultipartBody;
import sttp.client3.NoBody$;
import sttp.client3.RequestBody;
import sttp.client3.RequestT;
import sttp.client3.StreamBody;
import sttp.client3.StringBody;
import sttp.client3.internal.SttpFile;
import sttp.client3.internal.SttpToJavaConverters$;
import sttp.client3.internal.httpclient.MultiPartBodyPublisher;
import sttp.client3.internal.package$;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.Part;
import sttp.monad.MonadError;
import sttp.monad.syntax;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001\u0003\b\u0010!\u0003\r\taE\f\t\u000b}\u0001A\u0011A\u0011\t\u000f\u0015\u0002!\u0019!D\u0001M!)!\t\u0001D\u0002\u0007\")q\n\u0001C\u0001!\"9\u0011Q\u0003\u0001\u0007\u0002\u0005]\u0001bBA\u0014\u0001\u0011%\u0011\u0011\u0006\u0005\b\u0003O\u0002A\u0011BA5\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003K3a!a.\u0001\t\u0005e\u0006BCA^\u0013\t\u0005\t\u0015!\u0003\u0002>\"9\u0011\u0011Z\u0005\u0005\u0002\u0005-\u0007bBAi\u0013\u0011\u0005\u00131\u001b\u0005\b\u0003#LA\u0011IAn\u0005A\u0011u\u000eZ=U_\"#H\u000f]\"mS\u0016tGO\u0003\u0002\u0011#\u0005Q\u0001\u000e\u001e;qG2LWM\u001c;\u000b\u0005I\u0019\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Q)\u0012aB2mS\u0016tGo\r\u0006\u0002-\u0005!1\u000f\u001e;q+\rA\"*O\n\u0003\u0001e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0017A\u0002\u0013j]&$He\u0001\u0001\u0015\u0003\t\u0002\"AG\u0012\n\u0005\u0011Z\"\u0001B+oSR\fqa\u001d;sK\u0006l7/F\u0001(!\rACg\u000e\b\u0003SEr!AK\u0018\u000f\u0005-rS\"\u0001\u0017\u000b\u00055\u0002\u0013A\u0002\u001fs_>$h(C\u0001\u0017\u0013\t\u0001T#\u0001\u0007dCB\f'-\u001b7ji&,7/\u0003\u00023g\u00059\u0001/Y2lC\u001e,'B\u0001\u0019\u0016\u0013\t)dGA\u0004TiJ,\u0017-\\:\u000b\u0005I\u001a\u0004C\u0001\u001d:\u0019\u0001!QA\u000f\u0001C\u0002m\u0012\u0011aU\t\u0003y}\u0002\"AG\u001f\n\u0005yZ\"a\u0002(pi\"Lgn\u001a\t\u00035\u0001K!!Q\u000e\u0003\u0007\u0005s\u00170A\u0003n_:\fG-F\u0001E!\r)u)S\u0007\u0002\r*\u0011!)F\u0005\u0003\u0011\u001a\u0013!\"T8oC\u0012,%O]8s!\tA$\nB\u0003L\u0001\t\u0007AJA\u0001G+\tYT\nB\u0003O\u0015\n\u00071HA\u0001`\u0003\u0015\t\u0007\u000f\u001d7z+\r\t\u0016\u000f\u001e\u000b\u0005%\u001a4X\u0010E\u00029\u0015N\u0003\"\u0001V2\u000f\u0005U\u0003gB\u0001,^\u001d\t9&L\u0004\u0002,1&\t\u0011,\u0001\u0003kCZ\f\u0017BA.]\u0003\rqW\r\u001e\u0006\u00023&\u0011alX\u0001\u0005QR$\bO\u0003\u0002\\9&\u0011\u0011MY\u0001\f\u0011R$\bOU3rk\u0016\u001cHO\u0003\u0002_?&\u0011A-\u001a\u0002\u000e\u0005>$\u0017\u0010U;cY&\u001c\b.\u001a:\u000b\u0005\u0005\u0014\u0007\"B4\u0005\u0001\u0004A\u0017a\u0002:fcV,7\u000f\u001e\t\u0005S6\u00048O\u0004\u0002kY:\u0011!f[\u0005\u0003)UI!AM\n\n\u00059|'a\u0002*fcV,7\u000f\u001e\u0006\u0003eM\u0001\"\u0001O9\u0005\u000bI$!\u0019A\u001e\u0003\u0003Q\u0003\"\u0001\u000f;\u0005\u000bU$!\u0019A\u001e\u0003\u0003ICQa\u001e\u0003A\u0002a\fqAY;jY\u0012,'\u000f\u0005\u0002zw:\u0011!\u0010Y\u0007\u0002E&\u0011A0\u001a\u0002\b\u0005VLG\u000eZ3s\u0011\u0015qH\u00011\u0001\u0000\u0003-\u0019wN\u001c;f]R$\u0016\u0010]3\u0011\u000bi\t\t!!\u0002\n\u0007\u0005\r1D\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000f\tyA\u0004\u0003\u0002\n\u0005-\u0001CA\u0016\u001c\u0013\r\tiaG\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00111\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u000551$A\ttiJ,\u0017-\u001c+p!V\u0014G.[:iKJ$2AUA\r\u0011\u001d\tY\"\u0002a\u0001\u0003;\taa\u001d;sK\u0006l\u0007\u0003BA\u0010\u0003Gq1!!\t\u0003\u001b\u0005\u0001\u0011bAA\u0013i\ta!)\u001b8bef\u001cFO]3b[\u0006iQ.\u001e7uSB\f'\u000f\u001e\"pIf,B!a\u000b\u0002fQ!\u0011QFA\u001b!\u0011\ty#!\r\u000e\u0003=I1!a\r\u0010\u0005YiU\u000f\u001c;j!\u0006\u0014HOQ8esB+(\r\\5tQ\u0016\u0014\bbBA\u001c\r\u0001\u0007\u0011\u0011H\u0001\u0006a\u0006\u0014Ho\u001d\t\u0007\u0003w\t\u0019%!\u0013\u000f\t\u0005u\u0012\u0011\t\b\u0004W\u0005}\u0012\"\u0001\u000f\n\u0005IZ\u0012\u0002BA#\u0003\u000f\u00121aU3r\u0015\t\u00114\u0004\u0005\u0004\u0002L\u0005E\u0013QK\u0007\u0003\u0003\u001bR1!a\u0014\u0016\u0003\u0015iw\u000eZ3m\u0013\u0011\t\u0019&!\u0014\u0003\tA\u000b'\u000f\u001e\u0019\u0005\u0003/\n\t\u0007\u0005\u0004\u0002Z\u0005m\u0013qL\u0007\u0002'%\u0019\u0011QL\n\u0003\u0017I+\u0017/^3ti\n{G-\u001f\t\u0004q\u0005\u0005DaCA2\u0003k\t\t\u0011!A\u0003\u0002m\u00121a\u0018\u00132\t\u0015\u0011hA1\u0001<\u0003!\u0019X\u000f\u001d9mS\u0016\u0014H\u0003BA6\u00033\u0013b!!\u001c\u0002r\u0005udABA8\u000f\u0001\tYG\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9\bX\u0001\u0005Y\u0006tw-\u0003\u0003\u0002|\u0005U$AB(cU\u0016\u001cG\u000f\u0005\u0004\u0002\u0000\u0005%\u0015QR\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006Aa-\u001e8di&|gNC\u0002\u0002\br\u000bA!\u001e;jY&!\u00111RAA\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b\u0003BAH\u0003+k!!!%\u000b\u0007\u0005ME,\u0001\u0002j_&!\u0011qSAI\u0005-Ie\u000e];u'R\u0014X-Y7\t\u0011\u0005mu\u0001\"a\u0001\u0003;\u000b\u0011\u0001\u001e\t\u00065\u0005}\u0015QR\u0005\u0004\u0003C[\"\u0001\u0003\u001fcs:\fW.\u001a \u0002-]LG\u000f[&o_^t7i\u001c8uK:$H*\u001a8hi\"$b!a*\u0002*\u00065\u0006CA=d\u0011\u001d\tY\u000b\u0003a\u0001\u0003O\u000b\u0001\u0002Z3mK\u001e\fG/\u001a\u0005\b\u0003_C\u0001\u0019AAY\u0003\t\u0019G\u000eE\u0002\u001b\u0003gK1!!.\u001c\u0005\u0011auN\\4\u00037\tKH/\u001a\"vM\u001a,'OQ1dW\u0016$\u0017J\u001c9viN#(/Z1n'\rI\u0011QR\u0001\u0004EV4\u0007\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\rG,A\u0002oS>LA!a2\u0002B\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\rqJg.\u001b;?)\u0011\ti-a4\u0011\u0007\u0005\u0005\u0012\u0002C\u0004\u0002<.\u0001\r!!0\u0002\tI,\u0017\r\u001a\u000b\u0003\u0003+\u00042AGAl\u0013\r\tIn\u0007\u0002\u0004\u0013:$H\u0003CAk\u0003;\fi/!=\t\u000f\u0005}W\u00021\u0001\u0002b\u0006)!-\u001f;fgB)!$a9\u0002h&\u0019\u0011Q]\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0007i\tI/C\u0002\u0002ln\u0011AAQ=uK\"9\u0011q^\u0007A\u0002\u0005U\u0017aA8gM\"9\u00111_\u0007A\u0002\u0005U\u0017a\u00017f]\u0002")
public interface BodyToHttpClient<F, S> {
    public package.Streams<S> streams();

    public MonadError<F> monad();

    public static /* synthetic */ Object apply$(BodyToHttpClient $this, RequestT request, HttpRequest.Builder builder, Option contentType) {
        return $this.apply(request, builder, (Option<String>)contentType);
    }

    default public <T, R> F apply(RequestT<Object, T, R> request, HttpRequest.Builder builder, Option<String> contentType) {
        Object object;
        RequestBody<R> requestBody = request.body();
        if (NoBody$.MODULE$.equals(requestBody)) {
            object = syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.noBody()), this.monad());
        } else if (requestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)requestBody;
            String b2 = stringBody.s();
            object = syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofString(b2)), this.monad());
        } else if (requestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
            byte[] b3 = byteArrayBody.b();
            object = syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofByteArray(b3)), this.monad());
        } else if (requestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
            ByteBuffer b4 = byteBufferBody.b();
            if (b4.hasArray()) {
                object = syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofByteArray(b4.array(), 0, b4.limit())), this.monad());
            } else {
                byte[] a = new byte[b4.remaining()];
                b4.get(a);
                object = syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofByteArray(a)), this.monad());
            }
        } else if (requestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
            InputStream b5 = inputStreamBody.b();
            object = syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofInputStream(SttpToJavaConverters$.MODULE$.toJavaSupplier((Function0 & Serializable & scala.Serializable)() -> b5))), this.monad());
        } else if (requestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)requestBody;
            SttpFile f = fileBody.f();
            object = syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofFile(f.toFile().toPath())), this.monad());
        } else if (requestBody instanceof StreamBody) {
            StreamBody streamBody = (StreamBody)requestBody;
            Object s = streamBody.b();
            object = this.streamToPublisher(s);
        } else if (requestBody instanceof MultipartBody) {
            MultipartBody multipartBody = (MultipartBody)requestBody;
            scala.collection.immutable.Seq parts = multipartBody.parts();
            MultiPartBodyPublisher multipartBodyPublisher = this.multipartBody((Seq<Part<RequestBody<?>>>)parts);
            String baseContentType = (String)contentType.getOrElse((Function0 & Serializable & scala.Serializable)() -> "multipart/form-data");
            builder.header(HeaderNames$.MODULE$.ContentType(), new StringBuilder(11).append(baseContentType).append("; boundary=").append(multipartBodyPublisher.getBoundary()).toString());
            object = syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)multipartBodyPublisher.build()), this.monad());
        } else {
            throw new MatchError(requestBody);
        }
        Object body = object;
        Option<Object> option = request.contentLength();
        if (None$.MODULE$.equals(option)) {
            return (F)body;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            long cl = BoxesRunTime.unboxToLong((Object)some.value());
            return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> body).map((Function1 & Serializable & scala.Serializable)b -> this.withKnownContentLength((HttpRequest.BodyPublisher)b, cl), this.monad());
        }
        throw new MatchError(option);
    }

    public F streamToPublisher(Object var1);

    private <T> MultiPartBodyPublisher multipartBody(Seq<Part<RequestBody<?>>> parts) {
        MultiPartBodyPublisher multipartBuilder = new MultiPartBodyPublisher();
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Header header = Header$.MODULE$.apply(HeaderNames$.MODULE$.ContentDisposition(), p.contentDispositionHeaderValue());
            scala.collection.immutable.Seq allHeaders = (scala.collection.immutable.Seq)p.headers().$plus$colon((Object)header, Seq$.MODULE$.canBuildFrom());
            java.util.Map partHeaders = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)allHeaders.map((Function1 & Serializable & scala.Serializable)h -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)h.name()), (Object)h.value()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            boolean bl = false;
            StringBody stringBody = null;
            RequestBody requestBody = (RequestBody)p.body();
            if (NoBody$.MODULE$.equals(requestBody)) {
                return BoxedUnit.UNIT;
            }
            if (requestBody instanceof FileBody) {
                FileBody fileBody = (FileBody)requestBody;
                SttpFile f = fileBody.f();
                return multipartBuilder.addPart(p.name(), f.toFile().toPath(), (java.util.Map<String, String>)partHeaders);
            }
            if (requestBody instanceof StringBody) {
                bl = true;
                stringBody = (StringBody)requestBody;
                String b = stringBody.s();
                String e = stringBody.encoding();
                if (e.equalsIgnoreCase(package$.MODULE$.Utf8())) {
                    return multipartBuilder.addPart(p.name(), b, (java.util.Map<String, String>)partHeaders);
                }
            }
            if (bl) {
                String b = stringBody.s();
                String e = stringBody.encoding();
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> new ByteArrayInputStream(b.getBytes(e))), (java.util.Map<String, String>)partHeaders);
            }
            if (requestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
                byte[] b = byteArrayBody.b();
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> new ByteArrayInputStream(b)), (java.util.Map<String, String>)partHeaders);
            }
            if (requestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
                ByteBuffer b = byteBufferBody.b();
                if (b.isReadOnly()) {
                    return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> new ByteBufferBackedInputStream(this, b)), (java.util.Map<String, String>)partHeaders);
                }
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> new ByteArrayInputStream(b.array())), (java.util.Map<String, String>)partHeaders);
            }
            if (requestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
                InputStream b = inputStreamBody.b();
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> b), (java.util.Map<String, String>)partHeaders);
            }
            if (requestBody instanceof StreamBody) {
                throw new IllegalArgumentException("Streaming multipart bodies are not supported");
            }
            if (requestBody instanceof MultipartBody) {
                throw package$.MODULE$.throwNestedMultipartNotAllowed();
            }
            throw new MatchError((Object)requestBody);
        });
        return multipartBuilder;
    }

    private Supplier<InputStream> supplier(Function0<InputStream> t) {
        return new Supplier<InputStream>(null, t){
            private final Function0 t$1;

            public InputStream get() {
                return (InputStream)this.t$1.apply();
            }
            {
                this.t$1 = t$1;
            }
        };
    }

    private HttpRequest.BodyPublisher withKnownContentLength(HttpRequest.BodyPublisher delegate, long cl) {
        return new HttpRequest.BodyPublisher(null, cl, delegate){
            private final long cl$2;
            private final HttpRequest.BodyPublisher delegate$1;

            public long contentLength() {
                return this.cl$2;
            }

            public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
                this.delegate$1.subscribe(subscriber);
            }
            {
                this.cl$2 = cl$2;
                this.delegate$1 = delegate$1;
            }
        };
    }

    public static void $init$(BodyToHttpClient $this) {
    }

    private class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;
        public final /* synthetic */ BodyToHttpClient $outer;

        @Override
        public int read() {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            int len2 = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len2);
            return len2;
        }

        public /* synthetic */ BodyToHttpClient sttp$client3$internal$httpclient$BodyToHttpClient$ByteBufferBackedInputStream$$$outer() {
            return this.$outer;
        }

        public ByteBufferBackedInputStream(BodyToHttpClient $outer, ByteBuffer buf) {
            this.buf = buf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

