/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.logging;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sttp.client3.HttpError;
import sttp.client3.HttpError$;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.logging.DefaultLog$;
import sttp.client3.logging.Log;
import sttp.client3.logging.LogLevel;
import sttp.client3.logging.Logger;
import sttp.client3.logging.LoggingOptions;
import sttp.model.StatusCode;

@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u000f\u001f\u0001\u0015B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"Aq\t\u0001B\u0001B\u0003%A\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003E\u0011!I\u0005A!A!\u0002\u0013!\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011e\u0003!\u0011!Q\u0001\niC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tO\u0002\u0011\t\u0011)A\u00055\")\u0001\u000e\u0001C\u0001S\")A\u000f\u0001C\u0001k\"9\u0011Q\u0004\u0001\u0005\n\u0005}\u0001bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!a4\u0001\t\u0013\t\tnB\u0004\u0002VzA\t!a6\u0007\ruq\u0002\u0012AAm\u0011\u0019A'\u0003\"\u0001\u0002\\\"9\u0011Q\u001c\n\u0005\u0002\u0005}\u0007\"CAs%E\u0005I\u0011AAt\u0011%\u0011)AEI\u0001\n\u0003\u00119\u0001C\u0005\u0003\u0010I\t\n\u0011\"\u0001\u0003\u0012!I!\u0011\u0004\n\u0012\u0002\u0013\u0005!1\u0004\u0005\n\u0005G\u0011\u0012\u0013!C\u0001\u0005KA\u0011B!\r\u0013#\u0003%\tAa\r\t\u0013\t}\"#%A\u0005\u0002\t\u0005\u0003\"\u0003B'%E\u0005I\u0011\u0001B(\u0005)!UMZ1vYRdun\u001a\u0006\u0003?\u0001\nq\u0001\\8hO&twM\u0003\u0002\"E\u000591\r\\5f]R\u001c$\"A\u0012\u0002\tM$H\u000f]\u0002\u0001+\t13gE\u0002\u0001O5\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0007c\u0001\u00180c5\ta$\u0003\u00021=\t\u0019Aj\\4\u0011\u0005I\u001aD\u0002\u0001\u0003\u0006i\u0001\u0011\r!\u000e\u0002\u0002\rV\u0011a'P\t\u0003oi\u0002\"\u0001\u000b\u001d\n\u0005eJ#a\u0002(pi\"Lgn\u001a\t\u0003QmJ!\u0001P\u0015\u0003\u0007\u0005s\u0017\u0010B\u0003?g\t\u0007aGA\u0001`\u0003\u0019awnZ4feB\u0019a&Q\u0019\n\u0005\ts\"A\u0002'pO\u001e,'/A\fcK\u001a|'/Z\"ve2Len\u001d;fC\u0012|em\u00155poB\u0011\u0001&R\u0005\u0003\r&\u0012qAQ8pY\u0016\fg.\u0001\bm_\u001e\u0014V-];fgR\u0014u\u000eZ=\u0002#1|wMU3rk\u0016\u001cH\u000fS3bI\u0016\u00148/\u0001\nm_\u001e\u0014Vm\u001d9p]N,\u0007*Z1eKJ\u001c\u0018\u0001E:f]NLG/\u001b<f\u0011\u0016\fG-\u001a:t!\ra5K\u0016\b\u0003\u001bF\u0003\"AT\u0015\u000e\u0003=S!\u0001\u0015\u0013\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0016&\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u00131aU3u\u0015\t\u0011\u0016\u0006\u0005\u0002M/&\u0011\u0001,\u0016\u0002\u0007'R\u0014\u0018N\\4\u00023\t,gm\u001c:f%\u0016\fX/Z:u'\u0016tG\rT8h\u0019\u00164X\r\u001c\t\u0003]mK!\u0001\u0018\u0010\u0003\u00111{w\rT3wK2\f\u0001C]3ta>t7/\u001a'pO2+g/\u001a7\u0011\t!z\u0016MW\u0005\u0003A&\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005\t,W\"A2\u000b\u0005\u0011\u0014\u0013!B7pI\u0016d\u0017B\u00014d\u0005)\u0019F/\u0019;vg\u000e{G-Z\u0001\u001ae\u0016\u001c\bo\u001c8tK\u0016C8-\u001a9uS>tGj\\4MKZ,G.\u0001\u0004=S:LGO\u0010\u000b\u000bU.dWN\\8qcJ\u001c\bc\u0001\u0018\u0001c!)qH\u0003a\u0001\u0001\"91I\u0003I\u0001\u0002\u0004!\u0005bB$\u000b!\u0003\u0005\r\u0001\u0012\u0005\b\u0011*\u0001\n\u00111\u0001E\u0011\u001dI%\u0002%AA\u0002\u0011CqA\u0013\u0006\u0011\u0002\u0003\u00071\nC\u0004Z\u0015A\u0005\t\u0019\u0001.\t\u000fuS\u0001\u0013!a\u0001=\"9qM\u0003I\u0001\u0002\u0004Q\u0016!\u00052fM>\u0014XMU3rk\u0016\u001cHoU3oIR\u0011aO\u001f\t\u0004eM:\bC\u0001\u0015y\u0013\tI\u0018F\u0001\u0003V]&$\b\"B>\f\u0001\u0004a\u0018a\u0002:fcV,7\u000f\u001e\u0019\u0006{\u0006M\u0011\u0011\u0004\t\b}\u0006-\u0011\u0011CA\f\u001d\ry\u0018q\u0001\b\u0005\u0003\u0003\t)AD\u0002O\u0003\u0007I\u0011aI\u0005\u0003C\tJ1!!\u0003!\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0004\u0002\u0010\t9!+Z9vKN$(bAA\u0005AA\u0019!'a\u0005\u0005\u0015\u0005U!0!A\u0001\u0002\u000b\u0005aGA\u0002`Ia\u00022AMA\r\t)\tYB_A\u0001\u0002\u0003\u0015\tA\u000e\u0002\u0004?\u0012J\u0014A\u00022fM>\u0014X\rF\u0004w\u0003C\t\u0019$a\u000e\t\rmd\u0001\u0019AA\u0012a\u0019\t)#!\u000b\u00020A9a0a\u0003\u0002(\u00055\u0002c\u0001\u001a\u0002*\u0011Y\u00111FA\u0011\u0003\u0003\u0005\tQ!\u00017\u0005\u0011yF%\r\u0019\u0011\u0007I\ny\u0003B\u0006\u00022\u0005\u0005\u0012\u0011!A\u0001\u0006\u00031$\u0001B0%cEBa!!\u000e\r\u0001\u0004!\u0015aD0m_\u001e\u0014V-];fgR\u0014u\u000eZ=\t\r\u0005eB\u00021\u0001E\u0003IyFn\\4SKF,Xm\u001d;IK\u0006$WM]:\u0002\u0011I,7\u000f]8og\u0016$\u0012B^A \u0003#\n\u0019'!\u001c\t\rml\u0001\u0019AA!a\u0019\t\u0019%a\u0012\u0002NA9a0a\u0003\u0002F\u0005-\u0003c\u0001\u001a\u0002H\u0011Y\u0011\u0011JA \u0003\u0003\u0005\tQ!\u00017\u0005\u0011yF%\r\u001a\u0011\u0007I\ni\u0005B\u0006\u0002P\u0005}\u0012\u0011!A\u0001\u0006\u00031$\u0001B0%cMBq!a\u000f\u000e\u0001\u0004\t\u0019\u0006\r\u0003\u0002V\u0005}\u0003CBA,\u00033\ni&D\u0001!\u0013\r\tY\u0006\t\u0002\t%\u0016\u001c\bo\u001c8tKB\u0019!'a\u0018\u0005\u0017\u0005\u0005\u0014\u0011KA\u0001\u0002\u0003\u0015\tA\u000e\u0002\u0005?\u0012\nD\u0007C\u0004\u0002f5\u0001\r!a\u001a\u0002\u0019I,7\u000f]8og\u0016\u0014u\u000eZ=\u0011\t!\nIGV\u0005\u0004\u0003WJ#AB(qi&|g\u000eC\u0004\u0002p5\u0001\r!!\u001d\u0002\u000f\u0015d\u0017\r]:fIB)\u0001&!\u001b\u0002tA!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0007\u0005u\u0014&\u0001\u0006d_:\u001cWO\u001d:f]RLA!!!\u0002x\tAA)\u001e:bi&|g.\u0001\biC:$G.\u001a*fgB|gn]3\u0015\u001bY\f9)a#\u0002\u0018\u0006e\u0015QTAQ\u0011\u0019\tII\u0004a\u0001-\u0006I1\u000f[8x\u0005\u0006\u001c\u0018n\u0019\u0005\b\u0003wq\u0001\u0019AAGa\u0011\ty)a%\u0011\r\u0005]\u0013\u0011LAI!\r\u0011\u00141\u0013\u0003\f\u0003+\u000bY)!A\u0001\u0002\u000b\u0005aG\u0001\u0003`IE*\u0004bBA3\u001d\u0001\u0007\u0011q\r\u0005\u0007\u00037s\u0001\u0019\u0001#\u0002\u001f1|wMU3ta>t7/\u001a\"pIfDa!a(\u000f\u0001\u0004!\u0015aE0m_\u001e\u0014Vm\u001d9p]N,\u0007*Z1eKJ\u001c\bbBA8\u001d\u0001\u0007\u0011\u0011O\u0001\u0011e\u0016\fX/Z:u\u000bb\u001cW\r\u001d;j_:$rA^AT\u0003s\u000bY\f\u0003\u0004|\u001f\u0001\u0007\u0011\u0011\u0016\u0019\u0007\u0003W\u000by+!.\u0011\u000fy\fY!!,\u00024B\u0019!'a,\u0005\u0017\u0005E\u0016qUA\u0001\u0002\u0003\u0015\tA\u000e\u0002\u0005?\u0012\nd\u0007E\u00023\u0003k#1\"a.\u0002(\u0006\u0005\t\u0011!B\u0001m\t!q\fJ\u00198\u0011\u001d\tyg\u0004a\u0001\u0003cBq!!0\u0010\u0001\u0004\ty,A\u0001f!\u0011\t\t-!3\u000f\t\u0005\r\u0017q\u0019\b\u0004\u001d\u0006\u0015\u0017\"\u0001\u0016\n\u0007\u0005%\u0011&\u0003\u0003\u0002L\u00065'!C#yG\u0016\u0004H/[8o\u0015\r\tI!K\u0001\u0005i>|7\u000eF\u0002W\u0003'Dq!a\u001c\u0011\u0001\u0004\t\t(\u0001\u0006EK\u001a\fW\u000f\u001c;M_\u001e\u0004\"A\f\n\u0014\u0005I9CCAAl\u0003]!WMZ1vYR\u0014Vm\u001d9p]N,Gj\\4MKZ,G\u000eF\u0002[\u0003CDa!a9\u0015\u0001\u0004\t\u0017!A2\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0011\tI/a@\u0016\u0005\u0005-(f\u0001#\u0002n.\u0012\u0011q\u001e\t\u0005\u0003c\fY0\u0004\u0002\u0002t*!\u0011Q_A|\u0003%)hn\u00195fG.,GMC\u0002\u0002z&\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti0a=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u00045+\t\u0007!\u0011A\u000b\u0004m\t\rAA\u0002 \u0002\u0000\n\u0007a'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0005\u0003S\u0014I\u0001\u0002\u00045-\t\u0007!1B\u000b\u0004m\t5AA\u0002 \u0003\n\t\u0007a'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0005\u0003S\u0014\u0019\u0002\u0002\u00045/\t\u0007!QC\u000b\u0004m\t]AA\u0002 \u0003\u0014\t\u0007a'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0005\u0003S\u0014i\u0002\u0002\u000451\t\u0007!qD\u000b\u0004m\t\u0005BA\u0002 \u0003\u001e\t\u0007a'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0005\u0005O\u0011Y#\u0006\u0002\u0003*)\u001a1*!<\u0005\rQJ\"\u0019\u0001B\u0017+\r1$q\u0006\u0003\u0007}\t-\"\u0019\u0001\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\u0011\u0011)D!\u000f\u0016\u0005\t]\"f\u0001.\u0002n\u00121AG\u0007b\u0001\u0005w)2A\u000eB\u001f\t\u0019q$\u0011\bb\u0001m\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa*BAa\u0011\u0003HU\u0011!Q\t\u0016\u0004=\u00065HA\u0002\u001b\u001c\u0005\u0004\u0011I%F\u00027\u0005\u0017\"aA\u0010B$\u0005\u00041\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0003\u00036\tECA\u0002\u001b\u001d\u0005\u0004\u0011\u0019&F\u00027\u0005+\"aA\u0010B)\u0005\u00041\u0004")
public class DefaultLog<F>
implements Log<F> {
    private final Logger<F> logger;
    private final boolean beforeCurlInsteadOfShow;
    private final boolean logRequestBody;
    private final boolean logRequestHeaders;
    private final boolean logResponseHeaders;
    private final Set<String> sensitiveHeaders;
    private final LogLevel beforeRequestSendLogLevel;
    private final Function1<StatusCode, LogLevel> responseLogLevel;
    private final LogLevel responseExceptionLogLevel;

    public static <F> LogLevel $lessinit$greater$default$9() {
        return DefaultLog$.MODULE$.$lessinit$greater$default$9();
    }

    public static <F> Function1<StatusCode, LogLevel> $lessinit$greater$default$8() {
        return DefaultLog$.MODULE$.$lessinit$greater$default$8();
    }

    public static <F> LogLevel $lessinit$greater$default$7() {
        return DefaultLog$.MODULE$.$lessinit$greater$default$7();
    }

    public static <F> Set<String> $lessinit$greater$default$6() {
        return DefaultLog$.MODULE$.$lessinit$greater$default$6();
    }

    public static <F> boolean $lessinit$greater$default$5() {
        return DefaultLog$.MODULE$.$lessinit$greater$default$5();
    }

    public static <F> boolean $lessinit$greater$default$4() {
        return DefaultLog$.MODULE$.$lessinit$greater$default$4();
    }

    public static <F> boolean $lessinit$greater$default$3() {
        return DefaultLog$.MODULE$.$lessinit$greater$default$3();
    }

    public static <F> boolean $lessinit$greater$default$2() {
        return DefaultLog$.MODULE$.$lessinit$greater$default$2();
    }

    public static LogLevel defaultResponseLogLevel(int n) {
        return DefaultLog$.MODULE$.defaultResponseLogLevel(n);
    }

    @Override
    public F beforeRequestSend(RequestT<Object, ?, ?> request) {
        Option<LoggingOptions> option = request.loggingOptions();
        if (option instanceof Some) {
            Some some = (Some)option;
            LoggingOptions options = (LoggingOptions)some.value();
            return this.before(request, BoxesRunTime.unboxToBoolean((Object)options.logRequestBody().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.logRequestBody)), BoxesRunTime.unboxToBoolean((Object)options.logRequestHeaders().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.logRequestHeaders)));
        }
        if (None$.MODULE$.equals(option)) {
            return this.before(request, this.logRequestBody, this.logRequestHeaders);
        }
        throw new MatchError(option);
    }

    private F before(RequestT<Object, ?, ?> request, boolean _logRequestBody, boolean _logRequestHeaders) {
        return this.logger.apply(this.beforeRequestSendLogLevel, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Sending request: ").append((Object)($this.beforeCurlInsteadOfShow && _logRequestBody && _logRequestHeaders ? request.toCurl($this.sensitiveHeaders, Predef.$eq$colon$eq$.MODULE$.tpEquals()) : request.show(_logRequestBody, _logRequestHeaders, $this.sensitiveHeaders))).toString());
    }

    @Override
    public F response(RequestT<Object, ?, ?> request, Response<?> response, Option<String> responseBody, Option<Duration> elapsed) {
        Option<LoggingOptions> option = request.loggingOptions();
        if (option instanceof Some) {
            Some some = (Some)option;
            LoggingOptions options = (LoggingOptions)some.value();
            return this.handleResponse(request.showBasic(), response, responseBody, BoxesRunTime.unboxToBoolean((Object)options.logResponseBody().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> responseBody.isDefined())), BoxesRunTime.unboxToBoolean((Object)options.logResponseHeaders().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.logResponseHeaders)), elapsed);
        }
        if (None$.MODULE$.equals(option)) {
            return this.handleResponse(request.showBasic(), response, responseBody, responseBody.isDefined(), this.logResponseHeaders, elapsed);
        }
        throw new MatchError(option);
    }

    private F handleResponse(String showBasic, Response<?> response, Option<String> responseBody, boolean logResponseBody, boolean _logResponseHeaders, Option<Duration> elapsed) {
        return this.logger.apply((LogLevel)this.responseLogLevel.apply((Object)new StatusCode(response.code())), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String responseAsString = response.copy(responseBody.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), response.copy$default$2(), response.copy$default$3(), response.copy$default$4(), response.copy$default$5(), response.copy$default$6()).show(logResponseBody, _logResponseHeaders, $this.sensitiveHeaders);
            return new StringBuilder(21).append("Request: ").append(showBasic).append(this.took(elapsed)).append(", response: ").append(responseAsString).toString();
        });
    }

    @Override
    public F requestException(RequestT<Object, ?, ?> request, Option<Duration> elapsed, Exception e) {
        LogLevel logLevel;
        Some some;
        HttpError httpError;
        Option<HttpError<?>> option = HttpError$.MODULE$.find(e);
        if (option instanceof Some && (httpError = (HttpError)(some = (Some)option).value()) instanceof HttpError) {
            HttpError httpError2 = httpError;
            int statusCode = httpError2.statusCode();
            logLevel = (LogLevel)this.responseLogLevel.apply((Object)new StatusCode(statusCode));
        } else {
            logLevel = this.responseExceptionLogLevel;
        }
        LogLevel logLevel2 = logLevel;
        return this.logger.apply(logLevel2, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Exception when sending request: ").append(request.showBasic()).append(this.took(elapsed)).toString(), e);
    }

    private String took(Option<Duration> elapsed) {
        return (String)elapsed.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)e -> {
            double arg$macro$1 = (double)e.toMillis() / 1000.0;
            return new StringOps(", took: %.3fs").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
        });
    }

    public DefaultLog(Logger<F> logger, boolean beforeCurlInsteadOfShow, boolean logRequestBody, boolean logRequestHeaders, boolean logResponseHeaders, Set<String> sensitiveHeaders, LogLevel beforeRequestSendLogLevel, Function1<StatusCode, LogLevel> responseLogLevel, LogLevel responseExceptionLogLevel) {
        this.logger = logger;
        this.beforeCurlInsteadOfShow = beforeCurlInsteadOfShow;
        this.logRequestBody = logRequestBody;
        this.logRequestHeaders = logRequestHeaders;
        this.logResponseHeaders = logResponseHeaders;
        this.sensitiveHeaders = sensitiveHeaders;
        this.beforeRequestSendLogLevel = beforeRequestSendLogLevel;
        this.responseLogLevel = responseLogLevel;
        this.responseExceptionLogLevel = responseExceptionLogLevel;
    }
}

