/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.okhttp;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.WebSocket;
import okio.ByteString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import sttp.client3.internal.ws.SimpleQueue;
import sttp.client3.internal.ws.WebSocketEvent;
import sttp.client3.okhttp.SendMessageException;
import sttp.model.Header$;
import sttp.model.Headers;
import sttp.monad.MonadError;
import sttp.monad.syntax;
import sttp.monad.syntax$;
import sttp.ws.WebSocketClosed;
import sttp.ws.WebSocketFrame;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015b!\u0002\b\u0010\u0001=)\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011]\u0002!\u0011!Q\u0001\naB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"A1\u000b\u0001BC\u0002\u0013\rA\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003V\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u001dA\b!%A\u0005\u0002eDq!!\u0003\u0001\t\u0013\tY\u0001\u0003\u0006\u0002\u0012\u0001A)\u0019!C!\u0003'Aq!a\b\u0001\t\u0003\n\tCA\u0007XK\n\u001cvnY6fi&k\u0007\u000f\u001c\u0006\u0003!E\taa\\6iiR\u0004(B\u0001\n\u0014\u0003\u001d\u0019G.[3oiNR\u0011\u0001F\u0001\u0005gR$\b/\u0006\u0002\u0017KM\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\rq\u0012eI\u0007\u0002?)\u0011\u0001eE\u0001\u0003oNL!AI\u0010\u0003\u0013]+'mU8dW\u0016$\bC\u0001\u0013&\u0019\u0001!QA\n\u0001C\u0002!\u0012\u0011AR\u0002\u0001+\tI\u0003'\u0005\u0002+[A\u0011\u0001dK\u0005\u0003Ye\u0011qAT8uQ&tw\r\u0005\u0002\u0019]%\u0011q&\u0007\u0002\u0004\u0003:LH!B\u0019&\u0005\u0004I#\u0001B0%IE\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\b_.DG\u000f\u001e94\u0013\t\u0011C'A\u0003rk\u0016,X\r\u0005\u0003:{\rzT\"\u0001\u001e\u000b\u0005\u0001Z$B\u0001\u001f\u0012\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001 ;\u0005-\u0019\u0016.\u001c9mKF+X-^3\u0011\u0005e\u0002\u0015BA!;\u000599VMY*pG.,G/\u0012<f]R\fqaX5t\u001fB,g\u000e\u0005\u0002E\u001b6\tQI\u0003\u0002G\u000f\u00061\u0011\r^8nS\u000eT!\u0001S%\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002K\u0017\u0006!Q\u000f^5m\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT#\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003!y\u0006.Z1eKJ\u001c\bCA\u001aR\u0013\t\u0011FGA\u0004IK\u0006$WM]:\u0002\u000b5|g.\u00193\u0016\u0003U\u00032A\u0016-$\u001b\u00059&BA*\u0014\u0013\tIvK\u0001\u0006N_:\fG-\u0012:s_J\fa!\\8oC\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003^C\n\u001cG\r\u0006\u0002_AB\u0019q\fA\u0012\u000e\u0003=AQaU\u0004A\u0004UCQ\u0001I\u0004A\u0002IBQaN\u0004A\u0002aBQAQ\u0004A\u0002\rCQaT\u0004A\u0002A\u000bqA]3dK&4X\rF\u0001h!\r!S\u0005\u001b\t\u0003=%L!A[\u0010\u0003\u001d]+'mU8dW\u0016$hI]1nK\u0006!1/\u001a8e)\ri\u0017o\u001d\t\u0004I\u0015r\u0007C\u0001\rp\u0013\t\u0001\u0018D\u0001\u0003V]&$\b\"\u0002:\n\u0001\u0004A\u0017!\u00014\t\u000fQL\u0001\u0013!a\u0001k\u0006q\u0011n]\"p]RLg.^1uS>t\u0007C\u0001\rw\u0013\t9\u0018DA\u0004C_>dW-\u00198\u0002\u001dM,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\t!P\u000b\u0002vw.\nA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011!C;oG\",7m[3e\u0015\r\t\u0019!G\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0004}\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017\u0019\u0014x.\u001c\"p_2,\u0017M\u001c\u000b\u0004[\u00065\u0001BBA\b\u0017\u0001\u0007Q/\u0001\u0004sKN,H\u000e^\u0001\u000fkB<'/\u00193f\u0011\u0016\fG-\u001a:t+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYbE\u0001\u0006[>$W\r\\\u0005\u0004%\u0006e\u0011AB5t\u001fB,g\u000e\u0006\u0002\u0002$A\u0019A%J;")
public class WebSocketImpl<F>
implements sttp.ws.WebSocket<F> {
    private Headers upgradeHeaders;
    private final WebSocket ws;
    private final SimpleQueue<F, WebSocketEvent> queue;
    private final AtomicBoolean _isOpen;
    private okhttp3.Headers _headers;
    private final MonadError<F> monad;
    private volatile boolean bitmap$0;

    public F receiveDataFrame(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveDataFrame$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveDataFrame$default$1() {
        return sttp.ws.WebSocket.receiveDataFrame$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveTextFrame(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveTextFrame$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveTextFrame$default$1() {
        return sttp.ws.WebSocket.receiveTextFrame$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveBinaryFrame(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveBinaryFrame$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveBinaryFrame$default$1() {
        return sttp.ws.WebSocket.receiveBinaryFrame$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveText(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveText$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public boolean receiveText$default$1() {
        return sttp.ws.WebSocket.receiveText$default$1$((sttp.ws.WebSocket)this);
    }

    public F receiveBinary(boolean pongOnPing) {
        return (F)sttp.ws.WebSocket.receiveBinary$((sttp.ws.WebSocket)this, (boolean)pongOnPing);
    }

    public <T> F eitherClose(Function0<F> f) {
        return (F)sttp.ws.WebSocket.eitherClose$((sttp.ws.WebSocket)this, f);
    }

    public <T> F either(Function0<F> f) {
        return (F)sttp.ws.WebSocket.either$((sttp.ws.WebSocket)this, f);
    }

    public F sendText(String payload) {
        return (F)sttp.ws.WebSocket.sendText$((sttp.ws.WebSocket)this, (String)payload);
    }

    public F sendBinary(byte[] payload) {
        return (F)sttp.ws.WebSocket.sendBinary$((sttp.ws.WebSocket)this, (byte[])payload);
    }

    public F close() {
        return (F)sttp.ws.WebSocket.close$((sttp.ws.WebSocket)this);
    }

    public MonadError<F> monad() {
        return this.monad;
    }

    public F receive() {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> $this.queue.poll()).flatMap((Function1 & Serializable)x0$1 -> {
            void var2_11;
            boolean bl = false;
            WebSocketEvent.Error error = null;
            boolean bl2 = false;
            WebSocketEvent.Frame frame = null;
            WebSocketEvent webSocketEvent = x0$1;
            if (webSocketEvent instanceof WebSocketEvent.Open) {
                Object f = this.receive();
                return var2_11;
            }
            if (webSocketEvent instanceof WebSocketEvent.Error) {
                bl = true;
                error = (WebSocketEvent.Error)webSocketEvent;
                Throwable t = error.t();
                if (t instanceof Exception) {
                    Exception exception = (Exception)t;
                    $this.queue.offer((Object)error);
                    Object object = this.monad().error((Throwable)exception);
                    return var2_11;
                }
            }
            if (bl) {
                Throwable t = error.t();
                throw t;
            }
            if (webSocketEvent instanceof WebSocketEvent.Frame) {
                bl2 = true;
                frame = (WebSocketEvent.Frame)webSocketEvent;
                WebSocketFrame f = frame.f();
                if (f instanceof WebSocketFrame.Close) {
                    WebSocketFrame.Close close = (WebSocketFrame.Close)f;
                    $this.queue.offer((Object)new WebSocketEvent.Error((Throwable)new WebSocketClosed((Option)new Some((Object)close))));
                    Object object = this.monad().unit((Object)close);
                    return var2_11;
                }
            }
            if (!bl2) throw new MatchError((Object)webSocketEvent);
            WebSocketFrame f = frame.f();
            if (f == null) throw new MatchError((Object)webSocketEvent);
            WebSocketFrame webSocketFrame = f;
            Object object = this.monad().unit((Object)webSocketFrame);
            return var2_11;
        }, this.monad());
    }

    public F send(WebSocketFrame f, boolean isContinuation) {
        return (F)this.monad().flatten(this.monad().eval((Function0 & Serializable)() -> {
            Object object;
            WebSocketFrame webSocketFrame = f;
            if (webSocketFrame instanceof WebSocketFrame.Text) {
                WebSocketFrame.Text text = (WebSocketFrame.Text)webSocketFrame;
                String payload = text.payload();
                object = this.fromBoolean($this.ws.send(payload));
            } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
                WebSocketFrame.Binary binary = (WebSocketFrame.Binary)webSocketFrame;
                byte[] payload = binary.payload();
                object = this.fromBoolean($this.ws.send(new ByteString(payload)));
            } else if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close close = (WebSocketFrame.Close)webSocketFrame;
                int statusCode = close.statusCode();
                String reasonText = close.reasonText();
                boolean wasOpen = $this._isOpen.getAndSet(false);
                object = wasOpen ? this.fromBoolean($this.ws.close(statusCode, reasonText)) : syntax.MonadErrorValueOps$.MODULE$.unit$extension(syntax$.MODULE$.MonadErrorValueOps((Object)BoxedUnit.UNIT), this.monad());
            } else if (webSocketFrame instanceof WebSocketFrame.Ping) {
                object = this.monad().error((Throwable)new UnsupportedOperationException("Ping is handled by okhttp under the hood"));
            } else if (webSocketFrame instanceof WebSocketFrame.Pong) {
                object = this.monad().error((Throwable)new UnsupportedOperationException("Pong is handled by okhttp under the hood"));
            } else {
                throw new MatchError((Object)webSocketFrame);
            }
            return object;
        }));
    }

    public boolean send$default$2() {
        return false;
    }

    private F fromBoolean(boolean result) {
        return (F)(!result ? this.monad().error((Throwable)((Object)new SendMessageException())) : this.monad().unit((Object)BoxedUnit.UNIT));
    }

    private Headers upgradeHeaders$lzycompute() {
        WebSocketImpl webSocketImpl = this;
        synchronized (webSocketImpl) {
            if (!this.bitmap$0) {
                this.upgradeHeaders = new Headers((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this._headers.iterator()).asScala()).map((Function1 & Serializable)p -> Header$.MODULE$.apply((String)p.getFirst(), (String)p.getSecond())).toList());
                this.bitmap$0 = true;
            }
        }
        this._headers = null;
        return this.upgradeHeaders;
    }

    public Headers upgradeHeaders() {
        return !this.bitmap$0 ? this.upgradeHeaders$lzycompute() : this.upgradeHeaders;
    }

    public F isOpen() {
        return (F)this.monad().eval((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this._isOpen.get());
    }

    public WebSocketImpl(WebSocket ws, SimpleQueue<F, WebSocketEvent> queue, AtomicBoolean _isOpen, okhttp3.Headers _headers, MonadError<F> monad) {
        this.ws = ws;
        this.queue = queue;
        this._isOpen = _isOpen;
        this._headers = _headers;
        this.monad = monad;
        sttp.ws.WebSocket.$init$((sttp.ws.WebSocket)this);
    }
}

