/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solace.messaging.trace.propagation.Baggage;
import com.solace.messaging.trace.propagation.TraceContext;
import com.solace.messaging.trace.propagation.impl.TraceContextImpl;
import com.solacesystems.common.util.ByteArray;
import com.solacesystems.common.util.SolByteBuffer;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.impl.HeaderStore;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeaderStoreImplRW
implements HeaderStore {
    private static final Log Trace = LogFactory.getLog(HeaderStoreImplRW.class);
    private static final int AppMsgIdBit = 1;
    private static final int AppMsgTypeBit = 2;
    private static final int CorrelationIdBit = 4;
    private static final int ReplyToBit = 8;
    private static final int SendTimestampBit = 16;
    private static final int SenderIdBit = 32;
    private static final int SequenceNumberBit = 64;
    private static final int ExpirationBit = 128;
    private static final int HTTPContentTypeBit = 256;
    private static final int HTTPContentEncodingBit = 512;
    private static final int TracingData = 1024;
    private TLVBuffer mBuffer = new TLVBuffer(1024);
    private SolByteBuffer mByteBuffer = this.mBuffer.getSolByteBuffer();
    private SDTMap mPropMap;
    private byte[] mPreamble = new byte[2];
    private Boolean mStructured;
    private Byte mMsgType;
    private Boolean mIsResponse;
    private String mAppMsgId;
    private String mAppMsgType;
    private String mCorrelationId;
    private Destination mReplyTo;
    private Long mSendTimestamp;
    private String mSenderId;
    private Long mSequenceNumber;
    private Long mExpiration;
    private String mHTTPContentType;
    private String mHTTPContentEncoding;
    private boolean mPreambleSpecified;
    private int mPresenceBitField = 0;
    private boolean mChanged;
    private TraceContext creationContext;
    private Baggage baggage;

    public HeaderStoreImplRW() {
        this.reset(true);
    }

    @Override
    public ByteArray asByteArray() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolByteBuffer asByteBuffer() {
        try {
            if (!this.mPreambleSpecified && this.mPresenceBitField == 0 && this.mPropMap == null) {
                SolByteBuffer solByteBuffer = null;
                return solByteBuffer;
            }
            this.mBuffer.clear();
            this.mBuffer.writeTag((byte)11, (byte)3);
            this.mByteBuffer.writeBytes(TLVBuffer.EMPTY_SDT);
            this.mPreamble[0] = this.mStructured != false ? this.mMsgType : (byte)(this.mMsgType | 0x80);
            this.mPreamble[1] = this.mIsResponse != false ? -128 : 0;
            this.mBuffer.write(this.mPreamble);
            if (this.mPresenceBitField != 0 || this.mPropMap != null) {
                int containerIndex = this.mByteBuffer.getLength() + 1;
                int propIndex = -1;
                int userPropIndex = -1;
                this.mBuffer.writeTag((byte)10, (byte)3);
                this.mByteBuffer.writeBytes(TLVBuffer.EMPTY_SDT);
                if (this.mPresenceBitField != 0) {
                    this.mBuffer.write("h");
                    propIndex = this.mByteBuffer.getLength() + 1;
                    this.mBuffer.writeTag((byte)10, (byte)3);
                    this.mByteBuffer.writeBytes(TLVBuffer.EMPTY_SDT);
                    if (this.mAppMsgId != null) {
                        this.mBuffer.write("mi");
                        this.mBuffer.write(this.mAppMsgId);
                    }
                    if (this.mAppMsgType != null) {
                        this.mBuffer.write("mt");
                        this.mBuffer.write(this.mAppMsgType);
                    }
                    if (this.mCorrelationId != null) {
                        this.mBuffer.write("ci");
                        this.mBuffer.write(this.mCorrelationId);
                    }
                    if (this.mReplyTo != null) {
                        this.mBuffer.write("rt");
                        this.mBuffer.write(this.mReplyTo);
                    }
                    if (this.mSendTimestamp != null) {
                        this.mBuffer.write("ts");
                        this.mBuffer.write(this.mSendTimestamp);
                    }
                    if (this.mSenderId != null) {
                        this.mBuffer.write("si");
                        this.mBuffer.write(this.mSenderId);
                    }
                    if (this.mSequenceNumber != null) {
                        this.mBuffer.write("sn");
                        this.mBuffer.write(this.mSequenceNumber);
                    }
                    if (this.mExpiration != null) {
                        this.mBuffer.write("ex");
                        this.mBuffer.write(this.mExpiration);
                    }
                    if (this.mHTTPContentType != null) {
                        this.mBuffer.write("ct");
                        this.mBuffer.write(this.mHTTPContentType);
                    }
                    if (this.mHTTPContentEncoding != null) {
                        this.mBuffer.write("ce");
                        this.mBuffer.write(this.mHTTPContentEncoding);
                    }
                    if (this.creationContext != null) {
                        TraceContextImpl traceContext = (TraceContextImpl)this.creationContext;
                        try {
                            byte[] encodedTraceContext = traceContext.getEncodedTraceContext();
                            if (encodedTraceContext != null && encodedTraceContext != TraceContextImpl.INVALID_CONTEXT && encodedTraceContext.length > 0) {
                                this.mBuffer.write("ctx");
                                this.mBuffer.write(encodedTraceContext);
                            }
                        }
                        catch (Exception e) {
                            Trace.error((Object)"Invalid tracing context detected, will not be injected into a message", (Throwable)e);
                        }
                    }
                    if (this.baggage != null && this.baggage.getBaggage() != null) {
                        this.mBuffer.write("bag");
                        this.mBuffer.write(this.baggage.getBaggage());
                    }
                    this.mByteBuffer.writeUInt(propIndex, this.mByteBuffer.getLength() - propIndex + 1);
                }
                if (this.mPropMap != null) {
                    this.mBuffer.write("p");
                    userPropIndex = this.mByteBuffer.getLength() + 1;
                    ByteArray ba = ((MapImpl)this.mPropMap).asByteArray();
                    this.mByteBuffer.writeBytes(ba.getBuffer(), ba.getOffset(), ba.getLength());
                    this.mByteBuffer.writeUInt(userPropIndex, this.mByteBuffer.getLength() - userPropIndex + 1);
                }
                this.mByteBuffer.writeUInt(containerIndex, this.mByteBuffer.getLength() - containerIndex + 1);
            }
            this.mByteBuffer.writeUInt(1, this.mByteBuffer.getLength());
        }
        catch (Exception e) {
            if (Trace.isErrorEnabled()) {
                Trace.error((Object)"error writing headers", (Throwable)e);
            }
        }
        finally {
            this.mChanged = false;
        }
        return this.mByteBuffer;
    }

    @Override
    public String getAppMessageID() {
        return this.mAppMsgId;
    }

    @Override
    public String getAppMessageType() {
        return this.mAppMsgType;
    }

    @Override
    public String getCorrelationID() {
        return this.mCorrelationId;
    }

    @Override
    public SDTMap getPropertyMap() {
        return this.mPropMap;
    }

    @Override
    public Destination getReplyTo() {
        return this.mReplyTo;
    }

    @Override
    public Long getSendTimestamp() {
        return this.mSendTimestamp;
    }

    @Override
    public String getSenderID() {
        return this.mSenderId;
    }

    @Override
    public Long getSequenceNumber() {
        return this.mSequenceNumber;
    }

    @Override
    public Long getExpiration() {
        return this.mExpiration;
    }

    @Override
    public String getHTTPContentType() {
        return this.mHTTPContentType;
    }

    @Override
    public String getHTTPContentEncoding() {
        return this.mHTTPContentEncoding;
    }

    @Override
    public Byte getStructuredMsgType() {
        return this.mMsgType;
    }

    public boolean isChanged() {
        return this.mChanged;
    }

    @Override
    public Boolean isResponse() {
        return this.mIsResponse;
    }

    @Override
    public Boolean isStructured() {
        return this.mStructured;
    }

    @Override
    public TraceContext getTracingCreationContext() {
        return this.creationContext;
    }

    @Override
    public Baggage getTracingBaggage() {
        return this.baggage;
    }

    @Override
    public void reset(boolean resetMsgType) {
        this.mBuffer.clear();
        this.mIsResponse = Boolean.FALSE;
        this.mAppMsgId = null;
        this.mAppMsgType = null;
        this.mCorrelationId = null;
        this.mPropMap = null;
        this.mReplyTo = null;
        this.mSendTimestamp = null;
        this.mSenderId = null;
        this.mSequenceNumber = null;
        this.mExpiration = null;
        this.mHTTPContentType = null;
        this.mHTTPContentEncoding = null;
        this.mPreambleSpecified = false;
        this.mPresenceBitField = 0;
        this.mChanged = false;
        if (resetMsgType) {
            this.mStructured = Boolean.FALSE;
            this.mMsgType = 0;
        } else if (!this.mStructured.equals(Boolean.FALSE) || !this.mMsgType.equals((byte)0)) {
            this.setIsStructured(this.mStructured);
            this.setStructuredMsgType(this.mMsgType);
        }
    }

    @Override
    public void setAppMessageID(String msgId) {
        this.mAppMsgId = msgId;
        this.setPresence(1, msgId != null);
        this.mChanged = true;
    }

    @Override
    public void setAppMessageType(String appMsgType) {
        this.mAppMsgType = appMsgType;
        this.setPresence(2, appMsgType != null);
        this.mChanged = true;
    }

    @Override
    public void setCorrelationId(String id) {
        this.mCorrelationId = id;
        this.setPresence(4, id != null);
        this.mChanged = true;
    }

    @Override
    public void setIsResponse(boolean isResponse) {
        this.mIsResponse = isResponse;
        this.mPreambleSpecified = true;
        this.mChanged = true;
    }

    @Override
    public void setIsStructured(boolean structured) {
        this.mStructured = structured;
        this.mPreambleSpecified = true;
        this.mChanged = true;
    }

    @Override
    public void setPropertyMap(SDTMap props) {
        this.mPropMap = props;
        this.mChanged = true;
    }

    @Override
    public void setReplyTo(Destination destination) {
        this.mReplyTo = destination;
        this.setPresence(8, destination != null);
        this.mChanged = true;
    }

    @Override
    public void setSendTimestamp(Long sendTS) {
        this.mSendTimestamp = sendTS;
        this.setPresence(16, sendTS != null);
        this.mChanged = true;
    }

    @Override
    public void setSenderID(String senderID) {
        this.mSenderId = senderID;
        this.setPresence(32, senderID != null);
        this.mChanged = true;
    }

    @Override
    public void setSequenceNumber(long seqNum) {
        this.mSequenceNumber = seqNum;
        this.setPresence(64, true);
        this.mChanged = true;
    }

    @Override
    public void setExpiration(Long expiration) {
        boolean localChanged = false;
        if (this.mExpiration == null) {
            localChanged = expiration != null;
        } else {
            boolean bl = localChanged = !this.mExpiration.equals(expiration);
        }
        if (localChanged) {
            this.mChanged = true;
        }
        this.mExpiration = expiration;
        this.setPresence(128, expiration != null);
    }

    @Override
    public void setHTTPContentType(String contentType) {
        boolean localChanged = false;
        if (this.mHTTPContentType == null) {
            localChanged = contentType != null;
        } else {
            boolean bl = localChanged = !this.mHTTPContentType.equals(contentType);
        }
        if (localChanged) {
            this.mChanged = true;
        }
        this.mHTTPContentType = contentType;
        this.setPresence(256, contentType != null);
    }

    @Override
    public void setHTTPContentEncoding(String contentEncoding) {
        boolean localChanged = false;
        if (this.mHTTPContentEncoding == null) {
            localChanged = contentEncoding != null;
        } else {
            boolean bl = localChanged = !this.mHTTPContentEncoding.equals(contentEncoding);
        }
        if (localChanged) {
            this.mChanged = true;
        }
        this.mHTTPContentEncoding = contentEncoding;
        this.setPresence(512, contentEncoding != null);
    }

    @Override
    public void setStructuredMsgType(byte msgType) {
        this.mMsgType = msgType;
        this.mPreambleSpecified = true;
        this.mChanged = true;
    }

    @Override
    public void setTracingCreationContext(TraceContext creationContext) {
        this.creationContext = creationContext;
        this.setPresence(1024, creationContext != null);
        this.mChanged = true;
    }

    @Override
    public void setTracingBaggage(Baggage baggage) {
        this.baggage = baggage;
        this.setPresence(1024, baggage != null);
        this.mChanged = true;
    }

    private void setPresence(int bit, boolean on) {
        this.mPresenceBitField = on ? (this.mPresenceBitField |= bit) : (this.mPresenceBitField &= ~bit);
    }
}

