/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.StringUtil;
import com.solacesystems.jcsmp.impl.MessageDumpFieldProvider;
import java.util.Collection;

public class MessageDumpUtil {
    public static <E> String dump(Collection<MessageDumpFieldProvider<E>> fieldProviders, E msg, String separator, int colpadding, int flags) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        boolean need_separator = false;
        for (MessageDumpFieldProvider<E> mdfp : fieldProviders) {
            String detailValue;
            ++i;
            Object[] field_data = mdfp.getData(msg, flags);
            boolean isPresent = (Boolean)field_data[1];
            String key = (String)field_data[0];
            String value = String.valueOf(field_data[2]);
            String string = detailValue = field_data[3] != null ? String.valueOf(field_data[3]) : null;
            if (!isPresent) continue;
            if (need_separator) {
                sb.append(separator);
            }
            if (value == null || value.length() == 0) {
                sb.append(key);
            } else {
                sb.append(StringUtil.padRight(key + ":", colpadding));
                sb.append(value);
            }
            if (detailValue != null && (flags & 1) > 0) {
                sb.append("\n");
                if (!detailValue.startsWith("  ")) {
                    sb.append("  ");
                }
                sb.append(detailValue);
                if (!detailValue.endsWith("\n") && i < fieldProviders.size() - 1) {
                    sb.append("\n");
                }
            }
            need_separator = true;
        }
        return sb.toString();
    }

    public static <E> String dump(Collection<MessageDumpFieldProvider<E>> fieldProviders, E msg, int flags) {
        return MessageDumpUtil.dump(fieldProviders, msg, "\n", 40, flags) + "\n";
    }
}

