/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InetAddressUtil {
    private static final Pattern IPV4_DEFAULT_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_DEFAULT_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static final Log Trace = LogFactory.getLog(InetAddressUtil.class);
    private static List<InetAddress> allLocalInetAddress = null;

    public static String extractHostFromHostPort(String host) {
        String[] hostport = host.split(":");
        return hostport[0];
    }

    public static String getIP(String host) throws UnknownHostException {
        InetAddress[] all_IPs = InetAddress.getAllByName(host);
        if (all_IPs != null && all_IPs.length > 0) {
            for (int i = 0; i < all_IPs.length; ++i) {
                if (all_IPs[i].isLoopbackAddress() || all_IPs[i].isAnyLocalAddress()) continue;
                if (Trace.isDebugEnabled()) {
                    Trace.debug((Object)("resolve " + host + " to " + all_IPs[i].getHostAddress()));
                }
                return all_IPs[i].getHostAddress();
            }
        }
        return host;
    }

    public static synchronized String getLocalIP(String referenceIP) {
        InetAddress inetAddress;
        block16: {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)("getLocalIP with referenceIP=" + referenceIP));
            }
            if (allLocalInetAddress == null) {
                block15: {
                    allLocalInetAddress = new ArrayList<InetAddress>();
                    try {
                        String hostname = InetAddress.getLocalHost().getHostName();
                        InetAddress[] all_IPs = InetAddress.getAllByName(hostname);
                        if (all_IPs != null && all_IPs.length > 0) {
                            for (int i = 0; i < all_IPs.length; ++i) {
                                if (Trace.isDebugEnabled()) {
                                    Trace.debug((Object)("localhost IP[" + (i + 1) + "]=" + all_IPs[i].getHostAddress()));
                                }
                                allLocalInetAddress.add(all_IPs[i]);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.isWarnEnabled()) break block15;
                        Trace.warn((Object)"Error looking up local host configuration", (Throwable)e);
                    }
                }
                try {
                    Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
                    if (ifs != null) {
                        while (ifs.hasMoreElements()) {
                            NetworkInterface nif = ifs.nextElement();
                            Enumeration<InetAddress> addresses = nif.getInetAddresses();
                            if (addresses == null) continue;
                            while (addresses.hasMoreElements()) {
                                inetAddress = addresses.nextElement();
                                if (Trace.isDebugEnabled()) {
                                    Trace.debug((Object)("Network Interface[" + nif.getName() + "] IP=" + inetAddress.getHostAddress()));
                                }
                                allLocalInetAddress.add(inetAddress);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!Trace.isWarnEnabled()) break block16;
                    Trace.warn((Object)"Error looking up network interface", (Throwable)e);
                }
            }
        }
        String localIP = null;
        int matchLen = 0;
        for (int i = 0; i < allLocalInetAddress.size(); ++i) {
            inetAddress = allLocalInetAddress.get(i);
            if (inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress()) continue;
            String ip = inetAddress.getHostAddress();
            if (localIP == null) {
                localIP = ip;
                matchLen = InetAddressUtil.matchLength(referenceIP, ip);
                continue;
            }
            int l = InetAddressUtil.matchLength(referenceIP, ip);
            if (l <= matchLen) continue;
            matchLen = l;
            localIP = ip;
        }
        return localIP;
    }

    public static boolean isIPv4Address(String input) {
        return IPV4_DEFAULT_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6Address(String input) {
        return IPV6_DEFAULT_PATTERN.matcher(input).matches() || IPV6_COMPRESSED_PATTERN.matcher(input).matches();
    }

    private static int matchLength(String referenceIP, String ip) {
        int len;
        if (referenceIP == null || referenceIP.length() == 0) {
            return 0;
        }
        for (len = 0; len < referenceIP.length() && len < ip.length() && referenceIP.charAt(len) == ip.charAt(len); ++len) {
        }
        return len;
    }

    public static byte[] ipAddressToBytes(String ipAddress) {
        byte[] addrBytes = null;
        try {
            addrBytes = InetAddress.getByName(ipAddress).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return addrBytes;
    }
}

