/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.secure;

import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.secure.SecureProperties;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthSSLX509TrustManager
implements X509TrustManager {
    private X509TrustManager defaultTrustManager = null;
    private SecureProperties mSecureProps;
    private static final Log LOG = LogFactory.getLog(AuthSSLX509TrustManager.class);

    public AuthSSLX509TrustManager(X509TrustManager defaultTrustManager, SecureProperties secureProps) {
        if (defaultTrustManager == null) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("AuthSSLX509TrustManager.trustManagerMayNotBeNull"));
        }
        this.defaultTrustManager = defaultTrustManager;
        this.mSecureProps = secureProps;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (LOG.isDebugEnabled() && chain != null) {
            for (int c = 0; c < chain.length; ++c) {
                X509Certificate cert = chain[c];
                LOG.debug((Object)(" Client certificate " + (c + 1) + ":"));
                LOG.debug((Object)("  Subject DN: " + cert.getSubjectDN()));
                LOG.debug((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                LOG.debug((Object)("  Valid from: " + cert.getNotBefore()));
                LOG.debug((Object)("  Valid until: " + cert.getNotAfter()));
                LOG.debug((Object)("  Issuer: " + cert.getIssuerDN()));
            }
        }
        this.defaultTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (LOG.isDebugEnabled() && chain != null) {
            for (int c = 0; c < chain.length; ++c) {
                X509Certificate cert = chain[c];
                LOG.debug((Object)(" Server certificate " + (c + 1) + ":"));
                LOG.debug((Object)("  Subject DN: " + cert.getSubjectDN()));
                LOG.debug((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                LOG.debug((Object)("  Valid from: " + cert.getNotBefore()));
                LOG.debug((Object)("  Valid until: " + cert.getNotAfter()));
                LOG.debug((Object)("  Issuer: " + cert.getIssuerDN()));
            }
        }
        if (this.mSecureProps.validateCertificate()) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                List<X509Certificate> certList = Arrays.asList(chain);
                CertPath cp = cf.generateCertPath(certList);
                CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
                cpv.validate(cp, this.mSecureProps.getCertPathParameters());
            }
            catch (CertPathValidatorException e) {
                boolean ignoreThisThrow = false;
                for (Throwable t = e; t != null; t = t.getCause()) {
                    if (!(t instanceof CertificateExpiredException) && !(t instanceof CertificateNotYetValidException)) continue;
                    if (this.mSecureProps.validateCertificateDate()) {
                        throw (CertificateException)t;
                    }
                    ignoreThisThrow = true;
                    break;
                }
                if (!ignoreThisThrow) {
                    throw new CertificateException(e);
                }
            }
            catch (Exception e) {
                throw new CertificateException(e);
            }
            if (chain != null && chain.length > 0 && this.mSecureProps.getCommonNames() != null && this.mSecureProps.getCommonNames().length > 0) {
                this.validateCommonName(chain);
            }
        }
    }

    private void validateCommonName(X509Certificate[] chain) throws CertificateException {
        String[] commonNames = this.mSecureProps.getCommonNames();
        X509Certificate cert = chain[0];
        String cn = this.parseCN(cert.getSubjectX500Principal());
        if (cn != null) {
            for (int i = 0; i < commonNames.length; ++i) {
                String commonName = commonNames[i];
                if (!cn.equalsIgnoreCase(commonName)) continue;
                return;
            }
        }
        throw new CertificateException("Server not trusted - no common name match");
    }

    private String parseCN(X500Principal principal) {
        String[] rdns;
        String retStr = null;
        String name = principal.getName();
        if (name != null && (rdns = name.split(",")) != null) {
            for (int i = 0; i < rdns.length; ++i) {
                if (!rdns[i].startsWith("CN=") || rdns[i].length() <= 3) continue;
                return rdns[i].substring(3);
            }
        }
        return retStr;
    }
}

