/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solace.messaging.trace.propagation.impl.TraceContextImpl;
import com.solacesystems.common.HostInfo;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.Pair;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.impl.AbstractDestination;
import com.solacesystems.jcsmp.impl.InternalCapabilityType;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.JCSMPUtils;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.MessageDestinationAdapter;
import com.solacesystems.jcsmp.impl.P2pUtil;
import com.solacesystems.jcsmp.impl.TopicImpl;
import com.solacesystems.jcsmp.impl.client.ClientInfoProvider;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.ChannelOpStrategy;
import com.solacesystems.jcsmp.protocol.impl.RouterCapabilityParser;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.smf.AbstractTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.ClientCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFPubMsgHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfExtendedStreamTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.SmpHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeOauth2Parameters;
import com.solacesystems.jcsmp.protocol.smf.impl.AuthenticationSchemeParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.BinaryMetadataEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactoryClientCtrl;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactorySmf;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ChannelOpStrategyClient
extends ChannelOpStrategy {
    private static final Log Trace = LogFactory.getLog(ChannelOpStrategyClient.class);
    private static boolean peerSupportsVarLenExtParam = false;

    public ChannelOpStrategyClient(TcpClientChannel channel) {
        super(channel);
    }

    @Override
    public void performOpen(boolean isReconn) throws JCSMPException {
        Trace.debug((Object)String.format("[%s] Opening TcpClientChannel.", this.c_refs.sessionId));
        JCSMPProperties sessionProperties = this.c_refs.sessionProperties;
        String vpnName = sessionProperties.getStringProperty("vpn_name");
        vpnName = "".equals(vpnName) ? null : vpnName;
        ClientInfoProvider cinfo_provider = this.c_refs.session.getClientInfoProvider();
        boolean request_noLocal = sessionProperties.getBooleanProperty("NO_LOCAL");
        String sslDowngradeToProto = sessionProperties.getStringProperty("SSL_CONNECTION_DOWNGRADE_TO");
        JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)sessionProperties.getProperty("client_channel");
        int keeAliveInterval = channelProperties.getKeepAliveIntervalInMillis() / 1000;
        WireMessage msgReq = this.createClientCtrlMessage(0, sessionProperties.getStringProperty("application_description"), sessionProperties.getStringProperty("client_name"), cinfo_provider.getPlatform(), cinfo_provider.getSoftwareDate(), cinfo_provider.getSoftwareVersion(), cinfo_provider.getUserIdExtended(), vpnName, sessionProperties.getIntegerProperty("subscriber_local_priority"), sessionProperties.getIntegerProperty("subscriber_network_priority"), request_noLocal, sessionProperties.getStringProperty("AUTHENTICATION_SCHEME"), sessionProperties.getStringProperty("connection_type"), sslDowngradeToProto, keeAliveInterval);
        WireMessage response = this.channel.sendLoginRequestWaitForLoginResponse(msgReq, true);
        if (!(response.getHeaderBean() instanceof ClientCtrlHeaderBean)) {
            throw new JCSMPTransportException("Invalid ClientCtrl respons: no ClientCtrl header.");
        }
        ClientCtrlHeaderBean ccRespHeader = (ClientCtrlHeaderBean)response.getHeaderBean();
        AbstractTLVParameter param_cap = ccRespHeader.findFirstParameter(9);
        AbstractTLVParameter param_cap_ext = ccRespHeader.findFirstParameter(19);
        AbstractTLVParameter param_sversion = ccRespHeader.findFirstParameter(0);
        AbstractTLVParameter param_sdate = ccRespHeader.findFirstParameter(1);
        AbstractTLVParameter param_platform = ccRespHeader.findFirstParameter(2);
        AbstractTLVParameter param_physicalname = ccRespHeader.findFirstParameter(12);
        Pair<Map<CapabilityType, Object>, Map<InternalCapabilityType, Boolean>> caps_pair = RouterCapabilityParser.parseCapabilitiesFromHeader(param_cap, param_cap_ext, param_sversion, param_sdate, param_platform, param_physicalname, true);
        this.c_refs.session.putTransientData(JCSMPBasicSession.TransientData.CAP, caps_pair.getFirst(), false);
        this.c_refs.session.putTransientData(JCSMPBasicSession.TransientData.INTERNAL_CAP, caps_pair.getSecond(), false);
        peerSupportsVarLenExtParam = this.c_refs.session.isCapable(CapabilityType.VAR_LEN_EXT_PARAM);
        if (isReconn) {
            this.c_refs.session.checkAdCtrlVersion();
        }
        this.updateVpnVridInUse(ccRespHeader);
        if (request_noLocal) {
            Boolean cap_nolocal = (Boolean)caps_pair.getFirst().get((Object)CapabilityType.NO_LOCAL);
            AbstractTLVParameter param_nolocal = ccRespHeader.findFirstParameter(15);
            if (!cap_nolocal.booleanValue() || param_nolocal == null) {
                throw new InvalidOperationException("Connect failed: router does not support NoLocal option.");
            }
        }
        String loginResponse = String.format("[%s] Logged in. Router information:%n   %s%n", this.c_refs.sessionId, ccRespHeader.toString());
        Trace.debug((Object)loginResponse);
        if (this.c_refs.smfClient.isSecuredClient()) {
            if (sslDowngradeToProto.equals("PLAIN_TEXT")) {
                this.channel._smfClient.shutdownSSL();
            }
            if (this.c_refs.smfClient.isCompressionEnabled()) {
                if (this.c_refs.session.isCapable(CapabilityType.COMPRESSED_SSL)) {
                    this.channel._smfClient.enableCompression();
                } else {
                    throw new JCSMPErrorResponseException(403, "Compressed SSL Is Not Supported", "", this.channel.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
                }
            }
        }
        this.channel.start();
        this.updateP2pInboxInUse(ccRespHeader);
    }

    private void updateVpnVridInUse(ClientCtrlHeaderBean ccHdr) throws JCSMPException {
        AbstractTLVParameter rtrRespVpnNameParam = ccHdr.findFirstParameter(6);
        String respVpnName = rtrRespVpnNameParam == null ? null : TlvCoderUtil.nullTermUtf8ToString(rtrRespVpnNameParam.value);
        this.c_refs.sessionProperties.setProperty("vpn_name_in_use", respVpnName);
        AbstractTLVParameter rtrRespVridNameParam = ccHdr.findFirstParameter(10);
        if (rtrRespVridNameParam != null) {
            String respVridName = TlvCoderUtil.nullTermUtf8ToString(rtrRespVridNameParam.value);
            String existVridName = this.c_refs.sessionProperties.getStringProperty("VIRTUAL_ROUTER_NAME");
            this.c_refs.sessionProperties.setProperty("VIRTUAL_ROUTER_NAME", respVridName);
            this.checkVridChangeOnLogin(existVridName, respVridName);
        } else {
            this.c_refs.sessionProperties.setProperty("VIRTUAL_ROUTER_NAME", "00VRIDNAME00");
        }
    }

    @Override
    public void establishP2pSub() throws JCSMPException {
        if (this.c_refs.p2pTopicBase != null) {
            Topic inboxSub = P2pUtil.getP2pTopicSubscription(this.c_refs.p2pTopicBase);
            Trace.debug((Object)String.format("** Establishing topic sub [%s]", inboxSub));
            SmpHeaderBean smp_req = SmpHeaderBean.createAddSubscriptionReq((TopicImpl)inboxSub);
            SMFHeaderBean smfHeader = new SMFHeaderBean();
            smfHeader.setProtocol(15).setTtl(1).setSmfVersion(3);
            WireMessage wmsg = WireMessageFactory.createWith(smfHeader, smp_req);
            wmsg.setFriendlyName("SMP-EstablishP2pSub");
            WireMessage resp = this.channel.doSmfSubSingleShotRequest(wmsg, true, true, TcpChannel.WriteBlockPolicy.RESCHED_OK_BUT_NO_BLOCK_ON_STATE, this.channel.getConnCounterTag(), null);
            this.channel.checkSmpResponseOK(resp);
        }
    }

    @Override
    public void updateClientDescription(String clientDesc) throws JCSMPException {
        if (this.channel.connected()) {
            WireMessage msgReq = this.createClientCtrlMessage(1, clientDesc, null, null, null, null, null, null, -1, -1, false, null, null, null, -1);
            msgReq.setFriendlyName("CLIENTCTRL-Update");
            WireMessage response = this.channel.doSmfSharedRequest(msgReq, null);
            SMFHeaderBean response_smf = response.getSmfHeader();
            int resp_code = response_smf.getPm_respcode();
            String resp_string = response_smf.getPm_respstr();
            if (resp_code != 200) {
                if (Trace.isInfoEnabled()) {
                    Trace.info((Object)("Error Response (" + resp_code + ") - " + resp_string));
                }
                throw new JCSMPErrorResponseException(resp_code, resp_string, "", this.channel != null ? this.channel.getNetworkInfoString() : "", JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            }
            this.c_refs.sessionProperties.setProperty("application_description", clientDesc);
        } else {
            this.c_refs.sessionProperties.setProperty("application_description", clientDesc);
            this.channel.open(false);
        }
    }

    @Override
    public void updateClientName(String uniqueName, String defaultName) throws JCSMPException {
        if (uniqueName == null || "".equals(uniqueName)) {
            if (!defaultName.equals("")) {
                this.updateClientName(defaultName, defaultName);
            }
            return;
        }
        if (this.channel.connected()) {
            WireMessage msgReq = this.createClientCtrlMessage(1, null, uniqueName, null, null, null, null, null, -1, -1, false, null, null, null, -1);
            msgReq.setFriendlyName("CLIENTCTRL-Update");
            WireMessage response = this.channel.doSmfSharedRequest(msgReq, null);
            SMFHeaderBean response_smf = response.getSmfHeader();
            int resp_code = response_smf.getPm_respcode();
            String resp_string = response_smf.getPm_respstr();
            if (resp_code != 200) {
                if (Trace.isInfoEnabled()) {
                    Trace.info((Object)("Error Response (" + resp_code + ") - " + resp_string));
                }
                throw new JCSMPErrorResponseException(resp_code, resp_string, "", this.channel != null ? this.channel.getNetworkInfoString() : "", JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            }
            this.c_refs.sessionProperties.setProperty("client_name", uniqueName);
            ClientCtrlHeaderBean ccRespHeader = (ClientCtrlHeaderBean)response.getHeaderBean();
            Topic oldP2pTopicSub = P2pUtil.getP2pTopicSubscription(this.c_refs.p2pTopicBase);
            this.updateP2pInboxInUse(ccRespHeader);
            Topic newP2pTopicSub = P2pUtil.getP2pTopicSubscription(this.c_refs.p2pTopicBase);
            SmpHeaderBean remove_req = SmpHeaderBean.createRemoveSubscriptionReq((TopicImpl)oldP2pTopicSub);
            SmpHeaderBean add_req = SmpHeaderBean.createAddSubscriptionReq((TopicImpl)newP2pTopicSub);
            try {
                this.channel.doSmpRequest(remove_req, true);
            }
            catch (JCSMPErrorResponseException jCSMPErrorResponseException) {
                // empty catch block
            }
            this.channel.doSmpRequest(add_req, true);
        } else {
            this.c_refs.sessionProperties.setProperty("client_name", uniqueName);
            this.channel.open(false);
        }
    }

    @Override
    public void updateAuthenticationParameters(AuthenticationSchemeParameters newAuthParams) throws JCSMPException {
        if (newAuthParams instanceof AuthenticationSchemeOauth2Parameters) {
            AuthenticationSchemeOauth2Parameters oauth2Parameters = (AuthenticationSchemeOauth2Parameters)newAuthParams;
            String oauthAccessToken = oauth2Parameters.getOauthAccessToken();
            String oidcIdToken = oauth2Parameters.getOidcIdToken();
            if (oauthAccessToken != null) {
                this.c_refs.sessionProperties.setProperty("OAUTH2_ACCESS_TOKEN", oauthAccessToken);
            }
            if (oidcIdToken != null) {
                this.c_refs.sessionProperties.setProperty("OIDC_ID_TOKEN", oidcIdToken);
            }
            this.channel._smfClient.updateAuthenticationParameters(newAuthParams);
        }
    }

    protected void updateP2pInboxInUse(ClientCtrlHeaderBean ccHdr) throws JCSMPException {
        AbstractTLVParameter rtrRespP2pParam = ccHdr.findFirstParameter(8);
        this.c_refs.p2pTopicBase = rtrRespP2pParam != null ? TlvCoderUtil.nullTermUtf8ToString(rtrRespP2pParam.value) : P2pUtil.getGeneratedP2pTopicBase(this.c_refs.sessionProperties.getStringProperty("client_name"), this.c_refs.smfClient.getRemoteHost(), null);
        Topic newP2pTopic = P2pUtil.getP2pInboxTopic(this.c_refs.p2pTopicBase);
        Trace.debug((Object)String.format("** Got CLIENTCTRL, updating P2PINBOX to [%s]", newP2pTopic));
        this.c_refs.sessionProperties.setProperty("p2pinbox_in_use", newP2pTopic);
        this.c_refs.sessionProperties.setProperty("P2PTOPICDESCRIPTION", this.c_refs.p2pTopicBase);
    }

    private WireMessage createClientCtrlMessage(int msgType, String clientDescription, String clientName, String platform, String softwareDate, String softwareVersion, String userId, String msgVpnName, int dtoLocalPriority, int dtoNetworkPriority, boolean noLocal, String authenticationScheme, String connectionType, String sslSwitchToProto, int keeAliveInterval) {
        SMFHeaderBean smfHeader = new SMFHeaderBean().setProtocol(12).setTtl(1).setSmfVersion(3);
        ClientCtrlHeaderBean ccHeader = new ClientCtrlHeaderBean();
        ccHeader.setMsgType(msgType);
        TlvParameterFactoryClientCtrl pfac = TlvParameterFactoryClientCtrl.instance();
        if (clientDescription != null) {
            ccHeader.addParam(pfac.getClientDescription(clientDescription));
        }
        if (clientName != null && !clientName.equals("")) {
            ccHeader.addParam(pfac.getClientName(clientName));
        }
        if (platform != null) {
            ccHeader.addParam(pfac.getPlatform(platform));
        }
        if (softwareDate != null) {
            ccHeader.addParam(pfac.getSoftwareDate(softwareDate));
        }
        if (softwareVersion != null) {
            ccHeader.addParam(pfac.getSoftwareVersion(softwareVersion));
        }
        if (userId != null) {
            ccHeader.addParam(pfac.getUserId(userId));
        }
        if (msgVpnName != null) {
            ccHeader.addParam(pfac.getMsgVpnName(msgVpnName));
        }
        if (dtoLocalPriority > 0 && dtoNetworkPriority > 0) {
            ccHeader.addParam(pfac.getDeliverToOnePriority(dtoLocalPriority, dtoNetworkPriority));
        }
        if (noLocal) {
            ccHeader.addParam(pfac.getNoLocal());
        }
        if (connectionType != null) {
            if (connectionType.equals("CONNECTION_TYPE_BASIC")) {
                ccHeader.addParam(pfac.getConnectionType(TlvParameterFactoryClientCtrl.ConnectionType.Basic));
            } else if (connectionType.equals("CONNECTION_TYPE_XA")) {
                ccHeader.addParam(pfac.getConnectionType(TlvParameterFactoryClientCtrl.ConnectionType.XA));
            }
        }
        if (authenticationScheme != null && msgType == 0) {
            if (authenticationScheme.equals("AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE")) {
                ccHeader.addParam(pfac.getAuthenticationScheme(1));
            } else if (authenticationScheme.equals("AUTHENTICATION_SCHEME_GSS_KRB")) {
                ccHeader.addParam(pfac.getAuthenticationScheme(2));
                ccHeader.addParam(pfac.getRequiresRelease7_0());
            } else if (authenticationScheme.equals("AUTHENTICATION_SCHEME_OAUTH2")) {
                ccHeader.addParam(pfac.getAuthenticationScheme(10));
            }
        }
        if (msgType == 0 && this.c_refs.smfClient.isSecuredClient()) {
            if (sslSwitchToProto.equals("PLAIN_TEXT")) {
                if (this.c_refs.smfClient.isCompressionEnabled()) {
                    ccHeader.addParam(pfac.getSSLDowngradeProtocol(1));
                } else {
                    ccHeader.addParam(pfac.getSSLDowngradeProtocol(0));
                }
            } else if (this.c_refs.channelProperties.getCompressionLevel() > 0) {
                ccHeader.addParam(pfac.getSSLDowngradeProtocol(2));
            }
        }
        ccHeader.addParam(pfac.getClientCapabilities());
        if (keeAliveInterval != -1) {
            ccHeader.addParam(pfac.getKeepAliveInterval(keeAliveInterval));
        }
        return WireMessageFactory.createWith(smfHeader, ccHeader);
    }

    @Override
    public void buildSendMsgHeader(JCSMPXMLMessage message, Destination destination, long msgId_64bit, long flowId, long publisherId, boolean newMsg) throws InvalidOperationException {
        ChannelOpStrategyClient.buildSMFTrMsgHeader(message, destination, msgId_64bit, flowId, publisherId, newMsg, this.c_refs.sessionProperties.getIntegerProperty("PAYLOAD_COMPRESSION_LEVEL"));
    }

    public static void buildSMFTrMsgHeader(JCSMPXMLMessage message, Destination dest, long msgId_64bit, long flowId, long publisherId, boolean newMsg, int payloadCompressionLevel) throws InvalidOperationException {
        byte[] userdata;
        TlvParameterFactorySmf pfac = TlvParameterFactorySmf.instance();
        SMFPubMsgHeaderBean smfHeader = message.getEncPubMsgHeader();
        smfHeader.reset();
        smfHeader.setUserCosValue(message.getCos().value());
        smfHeader.setSmfProtocol(13);
        smfHeader.setDto(message.getDeliverToOne() ? 1 : 0);
        smfHeader.setDmqEligible(message.isDMQEligible() ? 1 : 0);
        smfHeader.setElidingEligible(message.isElidingEligible() ? 1 : 0);
        int messageTotalLength = message.isPayloadCompressed(payloadCompressionLevel) ? message.getCompressedAttachmentContentLength() : message.getAttachmentContentLength();
        pfac.addTrTopicName(smfHeader, MessageDestinationAdapter.getTrmTopicRepresentation((AbstractDestination)dest));
        if (JCSMPUtils.isAdMessage(message)) {
            smfHeader.setAdf(1);
            if (message.getDeliveryMode() == DeliveryMode.PERSISTENT) {
                pfac.addDeliveryMode(smfHeader, 1);
            } else {
                pfac.addDeliveryMode(smfHeader, 0);
            }
            pfac.addAssuredMsgId(smfHeader, msgId_64bit);
            pfac.addAssuredPrevMsgId(smfHeader, message.getPrevMessageId());
            if (!newMsg) {
                pfac.addAssuredRedeliveredFlag(smfHeader);
            }
            if (flowId != -1L) {
                pfac.addAssuredFlowId(smfHeader, flowId);
            }
            if (publisherId != -1L) {
                pfac.addAssuredPublisherId(smfHeader, publisherId);
            }
            if (message.isAckImmediately()) {
                pfac.addAckImmediately(smfHeader);
            }
        }
        int trm_offset = MessageDestinationAdapter.getTrmDestOffset((AbstractDestination)dest);
        int trm_length = MessageDestinationAdapter.getTrmDestLength((AbstractDestination)dest);
        if (dest instanceof Topic) {
            pfac.addTopicNameOffset(smfHeader, trm_offset, trm_length);
        } else if (dest instanceof Queue) {
            pfac.addQueueNameOffset(smfHeader, trm_offset, trm_length);
        }
        if (message.getPriority() != -1) {
            pfac.addMessagePriorty(smfHeader, message.getPriority());
        }
        if (message.getTimeToLive() > 0L) {
            pfac.addAssuredTtl(smfHeader, message.getTimeToLive());
        }
        if (message.transportContext() != null) {
            TraceContextImpl transportContext = (TraceContextImpl)message.transportContext();
            try {
                byte[] encodedTraceContext = transportContext.getEncodedTraceContext();
                if (encodedTraceContext != null && encodedTraceContext != TraceContextImpl.INVALID_CONTEXT && encodedTraceContext.length > 0) {
                    if (peerSupportsVarLenExtParam) {
                        SmfExtendedStreamTLVParameter p = new SmfExtendedStreamTLVParameter(0);
                        p.addTwoByteLengthParameter(0, 54, encodedTraceContext);
                        smfHeader.addParam(p);
                    } else {
                        Trace.warn((Object)"Discarding tracing information as peer doesn't support tracing");
                    }
                }
            }
            catch (Exception e) {
                Trace.error((Object)"Invalid tracing context detected, will not be injected into a message", (Throwable)e);
            }
        }
        if ((userdata = message.getUserData()) != null) {
            pfac.addUserdata(smfHeader, userdata);
        }
        if (message.hasMetadata() || message.hasContent() || message.hasAttachment() || message.hasBinaryMetadataAny()) {
            int metadataLength = message.getMetadataContentLength();
            messageTotalLength += metadataLength;
            int xmlLength = message.getContentLength();
            messageTotalLength += xmlLength;
            int binMetaEncodedLength = 0;
            if (message.hasBinaryMetadataAny()) {
                binMetaEncodedLength = BinaryMetadataEncoder.getBinaryMetaEncodedLength(message.getBinaryMetadataCB());
            }
            messageTotalLength += binMetaEncodedLength;
            int metadataLen = metadataLength > 0 ? metadataLength : -1;
            int contentLen = message.hasContent() ? message.getContentLength() : -1;
            int attLen = -1;
            if (message.hasAttachment()) {
                attLen = message.isPayloadCompressed(payloadCompressionLevel) ? message.getCompressedAttachmentContentLength() : message.getAttachmentContentLength();
            }
            int binMetaLen = binMetaEncodedLength > 0 ? binMetaEncodedLength : -1;
            pfac.addMessageContentSummary(smfHeader, metadataLen, contentLen, attLen, binMetaLen);
        }
        smfHeader.setMsgLen(messageTotalLength);
    }

    @Override
    public void checkSendDestination(Destination destination) {
    }

    @Override
    public List<HostInfo> getModeAwareHostList() {
        return this.c_refs.hostList;
    }
}

