/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jms.SolConnection;
import com.solacesystems.jms.SolQueueSession;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSProperties;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Topic;

public class SolQueueConnection
extends SolConnection
implements QueueConnection {
    private final LogWrapper log = new LogWrapper(SolQueueConnection.class);

    public SolQueueConnection(JMSProperties properties, boolean connectionTypeXA, String username, String password) throws JMSException {
        super(properties, connectionTypeXA, username, password);
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolQueueConnection created.");
        }
    }

    public SolQueueConnection(JMSProperties properties, boolean connectionTypeXA) throws JMSException {
        super(properties, connectionTypeXA);
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolQueueConnection created.");
        }
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("createConnectionConsumer() called.  Queue: " + (queue == null ? "null" : queue.getQueueName()) + "   Message selector: " + messageSelector);
        }
        return super.createConnectionConsumer((Destination)queue, messageSelector, sessionPool, maxMessages);
    }

    public synchronized QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        Validator.checkTransactedAndAckMode(transacted ? SessionTransactionType.LocalTransaction : SessionTransactionType.NoTransaction, acknowledgeMode, this.mConnectionProps.getPropertyBean().getDirectTransport());
        Validator.checkTransactedAndLargeMessaging(transacted ? SessionTransactionType.LocalTransaction : SessionTransactionType.NoTransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.mHasBeenAccessed = true;
        SolQueueSession newSession = new SolQueueSession(this, transacted, acknowledgeMode, this.mState);
        this.mSessions.add(newSession);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createQueueSession() called.  Transacted: " + transacted + " acknowledgeMode: " + acknowledgeMode);
        }
        return newSession;
    }

    @Override
    public synchronized ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.illegalstate", "createDurableConnectionConsumer()"), "soljms.error.illegalstate");
    }
}

