/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.message;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.common.util.SolByteBuffer;
import com.solacesystems.jcsmp.SDTEOFException;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTFormatException;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.StreamMessage;
import com.solacesystems.jcsmp.impl.sdt.SDTStreamIF;
import com.solacesystems.jcsmp.impl.sdt.StreamImpl;
import com.solacesystems.jcsmp.impl.sdt.StreamTLVBuffer;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;
import com.solacesystems.jms.encoding.StreamFormatter;
import com.solacesystems.jms.message.SolMessage;
import com.solacesystems.jms.message.StreamMessageIF;
import jakarta.jms.JMSException;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SolStreamMessage
extends SolMessage
implements StreamMessageIF {
    private static final long serialVersionUID = -3616046995548100609L;
    private transient SDTStreamIF mStream;
    private transient ByteArray mByteArray = null;
    private transient int mByteArrayIndex = 0;

    public SolStreamMessage() {
    }

    public SolStreamMessage(StreamMessage message) {
        super(message);
    }

    @Override
    public SDTStream getStream() {
        this.load();
        return this.mStream;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        if (this.mStream != null) {
            this.mStream.clear();
        }
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading(false);
        try {
            return this.mStream.readBoolean();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
        catch (NullPointerException e) {
            this.mStream.reset();
            throw e;
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading(false);
        try {
            return this.mStream.readByte();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
        catch (NullPointerException e) {
            this.mStream.reset();
            throw e;
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading(false);
        try {
            return this.mStream.readShort();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
        catch (NullPointerException e) {
            this.mStream.reset();
            throw e;
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading(false);
        try {
            return this.mStream.readCharacter().charValue();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
        catch (NullPointerException e) {
            this.mStream.reset();
            throw e;
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading(false);
        try {
            return this.mStream.readInteger();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
        catch (NullPointerException e) {
            this.mStream.reset();
            throw e;
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading(false);
        try {
            return this.mStream.readLong();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
        catch (NullPointerException e) {
            this.mStream.reset();
            throw e;
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading(false);
        try {
            return this.mStream.readFloat().floatValue();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
        catch (NullPointerException e) {
            this.mStream.reset();
            throw e;
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading(false);
        try {
            return this.mStream.readDouble();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
        catch (NullPointerException e) {
            this.mStream.reset();
            throw e;
        }
    }

    public String readString() throws JMSException {
        this.initializeReading(false);
        try {
            return this.mStream.readString();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.initializeReading(true);
        if (value == null) {
            throw new NullPointerException("passed value cannot be null");
        }
        if (value.length == 0) {
            return 0;
        }
        if (this.mByteArray == null) {
            try {
                this.mByteArray = this.mStream.readByteArray();
                if (this.mByteArray == null) {
                    return -1;
                }
                if (this.mByteArray.getLength() == 0) {
                    return 0;
                }
                this.mByteArrayIndex = this.mByteArray.getOffset();
            }
            catch (SDTException e) {
                throw this.handleException(e);
            }
        }
        if (this.mByteArrayIndex >= this.mByteArray.getOffset() + this.mByteArray.getLength()) {
            this.mByteArray = null;
            return -1;
        }
        int bytesCopied = 0;
        while (bytesCopied < value.length && this.mByteArrayIndex < this.mByteArray.getOffset() + this.mByteArray.getLength()) {
            value[bytesCopied++] = this.mByteArray.getBuffer()[this.mByteArrayIndex++];
        }
        if (bytesCopied < value.length) {
            this.mByteArray = null;
        }
        return bytesCopied;
    }

    public Object readObject() throws JMSException {
        this.initializeReading(false);
        try {
            Object obj = this.mStream.read();
            if (obj instanceof ByteArray) {
                return ((ByteArray)obj).asBytes();
            }
            return obj;
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        this.mStream.writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        this.mStream.writeByte(value);
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        this.mStream.writeShort(value);
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        this.mStream.writeCharacter(Character.valueOf(value));
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        this.mStream.writeInteger(value);
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        this.mStream.writeLong(value);
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        this.mStream.writeFloat(Float.valueOf(value));
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        this.mStream.writeDouble(value);
    }

    public void writeString(String value) throws JMSException {
        this.initializeWriting();
        this.mStream.writeString(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.initializeWriting();
        this.mStream.writeBytes(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        this.mStream.writeBytes(value, offset, length);
    }

    public void writeObject(Object value) throws JMSException {
        this.initializeWriting();
        if (value == null || value instanceof String || value instanceof Character || value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof byte[]) {
            this.mStream.writeObject(value);
            return;
        }
        throw new MessageFormatException("Unsupported message type " + value.getClass().getName());
    }

    public void reset() throws JMSException {
        if (this.mBodyMode == SolMessage.MessageBodyMode.WriteMode || this.mBodyMode == SolMessage.MessageBodyMode.ReadLoadedMode) {
            if (this.mStream != null) {
                this.mStream.rewind();
            }
            this.mBodyMode = SolMessage.MessageBodyMode.ReadLoadedMode;
        }
    }

    private void initializeWriting() throws MessageNotWriteableException {
        if (this.mBodyMode != SolMessage.MessageBodyMode.WriteMode) {
            throw new MessageNotWriteableException("This message is in read-only mode");
        }
        if (this.mStream == null) {
            this.mStream = new StreamImpl();
            this.mStream.setFormatter(StreamFormatter.OnlyInstance);
        }
    }

    private void initializeReading(boolean isReadingBytes) throws JMSException {
        if (this.mBodyMode == SolMessage.MessageBodyMode.WriteMode) {
            throw new MessageNotReadableException("This message is in write-only mode");
        }
        this.load();
        if (this.mStream == null) {
            throw new MessageEOFException("reached end of data");
        }
        if (!isReadingBytes && this.mByteArray != null) {
            throw new MessageFormatException("Attempt to read next field while byte array read is outstanding");
        }
        this.mStream.mark();
    }

    private void load() {
        if (this.mBodyMode == SolMessage.MessageBodyMode.ReadUnloadedMode) {
            this.mStream = (SDTStreamIF)((StreamMessage)this.mMessage).getStream();
            if (this.mStream != null) {
                this.mStream.setFormatter(StreamFormatter.OnlyInstance);
            }
            this.mBodyMode = SolMessage.MessageBodyMode.ReadLoadedMode;
        }
    }

    private JMSException handleException(SDTException e) {
        Throwable jmsEx;
        if (e instanceof SDTFormatException) {
            this.mStream.reset();
            jmsEx = new MessageFormatException(e.getMessage());
        } else {
            jmsEx = e instanceof SDTEOFException ? new MessageEOFException("reached end of data") : new JMSException("internal error");
        }
        jmsEx.setLinkedException((Exception)e);
        return jmsEx;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.load();
        out.defaultWriteObject();
        if (this.mStream != null) {
            TLVBuffer buffer = new TLVBuffer(100);
            ((StreamImpl)this.mStream).serialize(buffer);
            SolByteBuffer solBuffer = buffer.getSolByteBuffer();
            ByteArray ba = new ByteArray(solBuffer.getBackingArray(), solBuffer.getBackingArrayOffset(), solBuffer.getLength());
            out.write(ba.getBuffer(), ba.getOffset(), ba.getLength());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in.available() == 0) {
            this.mStream = null;
        } else {
            byte[] data = this.toByteArray(in);
            StreamTLVBuffer streamTLVBuf = new StreamTLVBuffer(data);
            this.mStream = new StreamImpl(streamTLVBuf);
        }
    }
}

