/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.event.MessageCallback;
import com.solacesystems.solclientj.core.handle.Handle;
import com.solacesystems.solclientj.core.handle.MessageHandle;
import com.solacesystems.solclientj.core.handle.MessageSupport;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.AbstractBaseHandleImpl;
import com.solacesystems.solclientj.core.impl.MessageHandleImpl;
import com.solacesystems.solclientj.core.impl.util.ExceptionGuard;
import com.solacesystems.solclientj.core.impl.util.SolLogger;
import com.solacesystems.solclientj.core.resource.MutableTopic;
import com.solacesystems.solclientj.core.resource.Subscription;
import com.solacesystems.solclientj.core.resource.Topic;
import java.nio.ByteBuffer;

public abstract class AbstractMessageSupportBaseHandleImpl
extends AbstractBaseHandleImpl
implements Handle,
MessageSupport {
    protected SolLogger LOGGER = SolLogger.getLogger(this.getClass().getName());
    private MessageCallback messageCallback;
    private int takeMessage = 0;
    private long lastRxMessagePointer = 0L;
    private MessageHandleImpl lastMessageHandle = new MessageHandleImpl(this.lastRxMessagePointer);
    private static String takeRxMessage = "takeRxMessage";

    public AbstractMessageSupportBaseHandleImpl() {
        super(0L);
    }

    public AbstractMessageSupportBaseHandleImpl(long value) {
        super(value);
    }

    protected void registerMessageCallback(MessageCallback messageCallback) {
        if (messageCallback == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullMessageCallback"));
        }
        this.messageCallback = messageCallback;
    }

    protected void unregisterMessageCallback() {
        this.messageCallback = null;
    }

    public MessageCallback getMessageCallback() {
        return this.messageCallback;
    }

    @Override
    public MessageHandle getRxMessage() {
        return this.lastMessageHandle;
    }

    @Override
    public void takeRxMessage(MessageHandle in_out_messageHandle) throws SolclientException {
        ExceptionGuard.assertUsableUnboundHandle(takeRxMessage, in_out_messageHandle, "Common.NullMessageHandle");
        MessageHandleImpl messageHandleImpl = (MessageHandleImpl)in_out_messageHandle;
        messageHandleImpl.setPointerValue(this.lastRxMessagePointer);
        this.customMessageHandling(messageHandleImpl);
        this.takeMessage = 1;
    }

    protected void customMessageHandling(MessageHandleImpl messageHandle) {
    }

    public int onMessage(long msgPointer) {
        this.takeMessage = 0;
        this.lastRxMessagePointer = msgPointer;
        this.lastMessageHandle.setPointerValue(this.lastRxMessagePointer);
        this.customMessageHandling(this.lastMessageHandle);
        if (this.messageCallback != null) {
            if (this.isBound()) {
                this.messageCallback.onMessage(this);
            } else if (this.LOGGER.isCriticalEnabled()) {
                this.LOGGER.critical("Unbound " + this.getClass().getName() + " during onMessage(" + msgPointer + "), will give ccmp returnCode:" + this.takeMessage);
            }
        } else if (this.LOGGER.isCriticalEnabled()) {
            this.LOGGER.critical("MessageCallback is NULL " + this.getClass().getName() + " during onMessage(" + msgPointer + "), will give ccmp returnCode:" + this.takeMessage);
        }
        return this.takeMessage;
    }

    protected String getTopicName(Subscription subscription) {
        if (subscription != null && subscription instanceof Topic) {
            return ((Topic)subscription).getName();
        }
        throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullSubcription"));
    }

    protected ByteBuffer getTopicNameBuffer(Subscription subscription) {
        if (subscription != null && subscription instanceof MutableTopic) {
            return ((MutableTopic)subscription).getNameBuffer();
        }
        throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullSubcription"));
    }
}

