/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.i18n;

import com.solacesystems.solclientj.core.impl.util.SolLogger;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class GenericResourceBundleSupport {
    private static final SolLogger LOGGER = SolLogger.getLogger(GenericResourceBundleSupport.class.getName());
    protected ResourceBundle m_bundle;
    protected ClassLoader m_classLoader;
    protected String m_baseName;
    public static final String LOCAL_LANGUAGE_CMDARG = "Bundle.Locale.language";
    public static final String LOCAL_COUNTRY_CMDARG = "Bundle.Locale.country";

    public GenericResourceBundleSupport(String baseName, ClassLoader classloader) throws MissingResourceException {
        this.m_classLoader = classloader;
        this.initialize(baseName, classloader, this.getSpecifiedLocale());
    }

    private void initialize(String basename, ClassLoader classloader, Locale locale) {
        block2: {
            this.m_baseName = basename;
            try {
                this.m_bundle = ResourceBundle.getBundle(basename, locale, classloader);
            }
            catch (MissingResourceException exception) {
                String message = "-----Missing resource bundle-----\n Ensure that the bundle exists in a directory, .jar or .zip in the class path.\n Base Name: " + this.m_baseName;
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error(message, exception);
            }
        }
    }

    private Locale getSpecifiedLocale() {
        Locale locale = Locale.US;
        try {
            String country = System.getProperty(LOCAL_COUNTRY_CMDARG);
            String language = System.getProperty(LOCAL_LANGUAGE_CMDARG);
            if (country != null && language != null) {
                locale = new Locale(language, country);
                return locale;
            }
            return locale;
        }
        catch (Exception e) {
            return locale;
        }
    }
}

