/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.event.CacheSessionEvent;
import com.solacesystems.solclientj.core.event.CacheSessionEventCallback;
import com.solacesystems.solclientj.core.handle.CacheSessionHandle;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.AbstractBaseHandleImpl;
import com.solacesystems.solclientj.core.impl.CacheSessionEventImpl;
import com.solacesystems.solclientj.core.impl.ccsmp.CCSMPServices;
import com.solacesystems.solclientj.core.impl.util.ExceptionGuard;
import com.solacesystems.solclientj.core.impl.util.SolLogger;
import com.solacesystems.solclientj.core.resource.MutableTopic;
import com.solacesystems.solclientj.core.resource.Topic;
import java.nio.ByteBuffer;

public final class CacheSessionHandleImpl
extends AbstractBaseHandleImpl
implements CacheSessionHandle {
    private static final SolLogger LOGGER = SolLogger.getLogger(CacheSessionHandleImpl.class.getName());
    private static final CCSMPServices ccsmp_services = CCSMPServices.onlyInstance();
    private CacheSessionEventCallback cacheSessionEventCallback;
    private CacheSessionEvent lastCacheSessionEvent;

    public CacheSessionHandleImpl() {
        super(0L);
    }

    public CacheSessionHandleImpl(long value) {
        super(value);
    }

    protected void registerCacheSessionCallback(CacheSessionEventCallback cacheSessionEventCallback) {
        if (cacheSessionEventCallback == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.CacheSessionEventCallback"));
        }
        this.cacheSessionEventCallback = cacheSessionEventCallback;
    }

    @Override
    public void destroy() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNICacheSession().solClient_cacheSession_destroy(this.getPointerValue()), "solClient_cacheSession_destroy");
        this.setPointerValue(0L);
    }

    @Override
    public int cancelCacheRequests() throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNICacheSession().solClient_cacheSession_cancelCacheRequests(this.getPointerValue()), "solClient_cacheSession_cancelCacheRequests");
    }

    @Override
    public int sendCacheRequest(long requestId, Topic topic, int cacheRequestFlags, int liveDataAction, int subscribeFlags) throws SolclientException {
        if (topic instanceof MutableTopic) {
            return ExceptionGuard.assertReturnCode(ccsmp_services.getJNICacheSession().solClient_cacheSession_sendCacheRequest(this.getPointerValue(), ((MutableTopic)topic).getNameBuffer(), requestId, cacheRequestFlags | liveDataAction, subscribeFlags, false), "solClient_cacheSession_sendCacheRequest_MutableTopic");
        }
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNICacheSession().solClient_cacheSession_sendCacheRequest(this.getPointerValue(), topic.getName(), requestId, cacheRequestFlags | liveDataAction, subscribeFlags), "solClient_cacheSession_sendCacheRequest");
    }

    @Override
    public int sendCacheRequest(long requestId, ByteBuffer topic, int cacheRequestFlags, int liveDataAction, int subscribeFlags) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNICacheSession().solClient_cacheSession_sendCacheRequest(this.getPointerValue(), topic, requestId, cacheRequestFlags | liveDataAction, subscribeFlags, true), "solClient_cacheSession_sendCacheRequest_ByteBuffer");
    }

    public void onEvent(int cacheEvent, int returnCode, int subCode, long requestId) {
        if (this.cacheSessionEventCallback == null) {
            LOGGER.error("CacheSessionHandle.onEvent:" + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.CacheSessionEventCallback"));
        }
        if (this.lastCacheSessionEvent == null) {
            this.lastCacheSessionEvent = new CacheSessionEventImpl(cacheEvent, requestId, returnCode, subCode);
        } else {
            ((CacheSessionEventImpl)this.lastCacheSessionEvent).setEnumCacheRequestEventCode(cacheEvent);
            ((CacheSessionEventImpl)this.lastCacheSessionEvent).setRequestId(requestId);
            ((CacheSessionEventImpl)this.lastCacheSessionEvent).setReturnCode(returnCode);
            ((CacheSessionEventImpl)this.lastCacheSessionEvent).setSubCode(subCode);
        }
        if (this.cacheSessionEventCallback != null) {
            this.cacheSessionEventCallback.onCacheSessionEvent(this);
        }
    }

    @Override
    public CacheSessionEvent getCacheSessionEvent() {
        return this.lastCacheSessionEvent;
    }

    @Override
    public void takeCacheSessionEvent(CacheSessionEvent cacheSessionEvent) {
        if (cacheSessionEvent == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullCacheSessionEvent"));
        }
        if (!(cacheSessionEvent instanceof CacheSessionEventImpl)) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.InvalidCacheSessionEventImpl"));
        }
        CacheSessionEventImpl cacheSessionEventImpl = (CacheSessionEventImpl)cacheSessionEvent;
        cacheSessionEventImpl.copy(this.lastCacheSessionEvent);
    }
}

